/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Find.FindTool;
import UI_Window.KWindow.HTMLWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DocumentUtils;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class DelayedFinder
extends Thread {
    private String regexp;
    private boolean useHtmlWindow = true;

    public DelayedFinder(String regexp) {
        this(regexp, true);
    }

    public DelayedFinder(String regexp, boolean useHtmlWindow) {
        this.regexp = regexp;
        this.useHtmlWindow = useHtmlWindow;
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindTool findTool = FindTool.init();
                boolean found = findTool.doFind(0, true, DelayedFinder.this.regexp);
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:HTMLWindow.DelayedFinder.run() found >" + DelayedFinder.this.regexp + "< = " + found);
                }
                if (found) {
                    int begin = BBxt.getSelectionStart();
                    int end = BBxt.getSelectionEnd();
                    JEditorPane pane = null;
                    pane = DelayedFinder.this.useHtmlWindow ? HTMLWindow.editorPane : BBxt.getTextPane();
                    int[] lineOffset = DocumentUtils.getElementOffsets(pane.getDocument(), begin);
                    int begincopy = begin;
                    if (lineOffset != null) {
                        begincopy = lineOffset[1] - 5;
                    }
                    try {
                        if (begin < 0) {
                            begin = 0;
                        }
                        Rectangle rect = pane.modelToView(begincopy);
                        Point pnt = new Point(0, rect.y);
                        KTextWindow window = BBxt.getTextWindow((KTextPane)pane);
                        JScrollPane scroller = window.getScrollPane();
                        JViewport port = scroller.getViewport();
                        port.setViewPosition(pnt);
                        BBxt.setSelection(begin, end);
                    }
                    catch (Exception e) {
                        Cutter.setLog("    Exception:DelayedFinder.run()\n       " + e.toString());
                    }
                }
                if (DelayedFinder.this.useHtmlWindow) {
                    Cutter.htmlWindow.setDelayedFind(null);
                }
            }
        });
    }
}

