/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import UI_Desktop.Cutter;
import UI_Script.SyntaxListener;
import UI_Window.KWindow.KTextWindow;
import java.io.FileReader;
import java.io.LineNumberReader;
import javax.swing.ProgressMonitor;

class FileLoader
extends Thread {
    private static int OUTBLOCK_SIZE = 5120;
    private static int INBLOCK_SIZE = 51200;
    private static int BUFFERED_READ_SIZE = 51200;
    private KTextWindow window;
    public ProgressMonitor pm = null;
    StringBuffer strbuffer = new StringBuffer(204800);

    public FileLoader(KTextWindow window) {
        super("FileLoader Thread");
        this.window = window;
        this.pm = new ProgressMonitor(window, "Progress", "reading file", 0, (int)window.getFile().length());
        this.pm.setMillisToDecideToPopup(100);
        this.pm.setMillisToPopup(100);
    }

    @Override
    public void run() {
        long runbegin = System.currentTimeMillis();
        this.strbuffer.setLength(0);
        try {
            String str;
            if (this.window.getFile() == null) {
                Cutter.setLog("    Error:FileLoader.run() - window file is null");
                return;
            }
            FileReader in = new FileReader(this.window.getFile());
            LineNumberReader lnr = new LineNumberReader(in);
            int linecount = 0;
            while ((str = lnr.readLine()) != null) {
                this.strbuffer.append(str).append('\n');
                if (++linecount % 1000 != 0) continue;
                this.pm.setProgress(this.strbuffer.length());
                Thread.currentThread();
                Thread.sleep(20L);
            }
            lnr.close();
            in.close();
            in = null;
            lnr = null;
            this.pm.close();
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:FileLoader.run()\n" + e.toString());
            this.window.resumeState();
            return;
        }
        this.pm.setNote("formatting text");
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception: FileLoader.run() " + ex.toString());
            this.pm.close();
            return;
        }
        if (this.strbuffer.length() > SyntaxListener.userMaxColoredLength) {
            Cutter.setLog("    Debug:FileLoader.run() - assigning text plain style");
            this.window.getTextPane().setText(this.strbuffer.toString());
            this.strbuffer = null;
        } else {
            this.window.getTextPane().setText(this.strbuffer.toString());
        }
        this.strbuffer = null;
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        this.window.loadingFinished(this.window.getFile());
    }
}

