/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KLabel;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTextField.NewlineListener;
import UI_Components.KTextField.STFListener;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Text.KTextPane.KCaret;
import UI_Tools.Find.FindTool;
import UI_Tools.KTools;
import UI_Tools.TabWindowsTool.TabWindowsTool;
import UI_Window.KWindow.DelayedFinder;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.BrowserUtils;
import Utilities.MenuUtils;
import Utilities.RegExpUtils;
import Utilities.ResourceUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.Segment;
import javax.swing.undo.UndoManager;

public class HTMLWindow
extends KAbstractWindow
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private DefaultMetalTheme metal = new DefaultMetalTheme();
    private Color lite = this.metal.getPrimaryControl();
    private Color dark = this.metal.getPrimaryControlDarkShadow();
    private Color gray = this.metal.getMenuBackground();
    static FindTool findTool = FindTool.init();
    public static final String TITLE = "Cutter Browser";
    public static HTMLEditorPane editorPane = null;
    private static Container contentPane;
    private ButtonedURLPanel urlPanel;
    private FindPanel findPanel = new FindPanel();
    private KCaret caret;
    private static HTMLWindow instance;
    public JScrollPane scrollPane;
    private DelayedFinder delayedFinder = null;

    private void ___LOWER__FIND__PANEL__METHODS________() {
    }

    private void ___UPPER__PANEL__METHODS________() {
    }

    public static HTMLWindow getInstance() {
        if (instance == null) {
            instance = new HTMLWindow();
        }
        return instance;
    }

    private HTMLWindow() {
        super(TITLE, true, true, true, true, KAbstractDesktop.WINDOW_LAYER);
        editorPane = new HTMLEditorPane();
        editorPane.setEditable(false);
        editorPane.addNewlineListener(this.findPanel);
        this.caret = new KCaret();
        editorPane.setSelectionColor(new Color(1.0f, 1.0f, 0.0f));
        this.caret.setBlinkRate(((DefaultCaret)editorPane.getCaret()).getBlinkRate());
        editorPane.setCaret(this.caret);
        this.caret.selectionColor = editorPane.getSelectionColor();
        this.caret.defocusedSelectionColor = editorPane.getSelectionColor();
        this.caret.color = editorPane.getCaretColor();
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String currentURL = HTMLWindow.this.urlPanel.urlField.getText();
                    try {
                        editorPane.setPage(e.getURL());
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(Cutter.desktop, "Cannot load web page:\n\"" + e.getURL().toString() + "\"", "Broken Link Error", 0);
                        try {
                            HTMLWindow.this.setPage(currentURL, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    HTMLWindow.this.urlPanel.setURL(e.getURL().toString());
                }
            }
        });
        editorPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String name = e.getPropertyName();
                Object value = e.getNewValue();
                if (name.equals("page")) {
                    String str = (String)((JEditorPane)e.getSource()).getDocument().getProperty("title");
                    HTMLWindow.this.setTitle(str);
                }
            }
        });
        this.addPropertyChangeListener(this);
        contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        editorPane.setMargin(new Insets(0, 5, 0, 5));
        this.urlPanel = new ButtonedURLPanel("URL");
        this.scrollPane = new JScrollPane(editorPane);
        contentPane.add((Component)this.urlPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 0, 0)));
        contentPane.add((Component)this.scrollPane, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        contentPane.add((Component)this.findPanel, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
    }

    @Override
    public void setClosePolicy() {
        this.setDefaultCloseOperation(0);
    }

    public void setFindField(String str) {
        this.findPanel.findfield.setText(str);
        editorPane.setSelectionStart(0);
        editorPane.setSelectionEnd(0);
    }

    public static String getCurrentURL() {
        HTMLWindow instance = HTMLWindow.getInstance();
        return instance.urlPanel.urlField.getText();
    }

    public static String getUrlTail() {
        String str = HTMLWindow.getCurrentURL().trim();
        if (str.length() == 0) {
            return null;
        }
        String[] tokens = TextUtils.tokenize(str, "/");
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        str = tokens[tokens.length - 1];
        int offset = str.indexOf(35);
        if (offset == -1) {
            return TextUtils.removeExtension(str);
        }
        return TextUtils.removeExtension(str.substring(0, offset));
    }

    public void _setPage(String urlStr) throws Exception {
        this.setPage(urlStr, null);
    }

    public synchronized String setPage(String urlStr, ActionEvent evt) throws Exception {
        if (urlStr.startsWith("https://renderman.pixar.com")) {
            Cutter.setLog("    Info:HTMLWindow.setPage() - switching to external browser for URL \"" + urlStr + "\"");
            BrowserUtils.open(urlStr, true);
            return "external_browser";
        }
        Cutter.setLog("    Info: HTMLWindow.setPage() URL string input >" + urlStr + "<");
        BBxt.setCursor(Cursor.getPredefinedCursor(2));
        if (urlStr.startsWith("http://renderman.pixar.com")) {
            Cutter.setLog("    Info:HTMLWindow.setPage() - switching to external browser for URL \"" + urlStr + "\"");
            BrowserUtils.open(urlStr, true);
            return "external_browser";
        }
        if (evt != null && (MenuUtils.isAltCntrMetaKeyDown(evt) || MenuUtils.isShiftKeyDown(evt))) {
            Cutter.setLog("    Info:HTMLWindow.setPage() - switching to external browser for URL \"" + urlStr + "\"");
            BrowserUtils.open(urlStr, true);
            return "external_browser";
        }
        try {
            EditorKit kit = editorPane.getEditorKit();
            editorPane.setText("loading");
            editorPane.setEditorKit(kit);
            editorPane.setPage(urlStr);
            if (!TabWindowsTool.isActive()) {
                this.toFront();
            }
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
        this.urlPanel.setURL(urlStr);
        return "internal_browser";
    }

    public void setContent(String content) throws Exception {
        EditorKit kit = editorPane.getEditorKit();
        editorPane.setText("loading");
        editorPane.setEditorKit(kit);
        editorPane.setText(content);
        this.urlPanel.setURL("");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        HTMLWindow frame = (HTMLWindow)e.getSource();
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        if (name.equals("title")) {
            if (TabWindowsTool.isActive()) {
                TabWindowsTool.clickButton(TITLE);
            }
            frame.setTitle((String)editorPane.getDocument().getProperty("title"));
            if (this.delayedFinder != null) {
                this.delayedFinder.start();
            }
        }
        if (name.equals("selected") && (Boolean)value == Boolean.TRUE) {
            editorPane.requestFocus();
            KTools.updateUI("");
        }
    }

    public synchronized void setDelayedFind(DelayedFinder df) {
        this.delayedFinder = df;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        Object oldvalue = e.getOldValue();
        KAbstractWindow frame = (KAbstractWindow)e.getSource();
        if (name.equals("closed")) {
            this.setVisible(false);
            throw new PropertyVetoException("window will become hidden", e);
        }
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        this.setVisible(false);
        super.internalFrameClosing(e);
        KAbstractWindow next = super.getNextWindow();
        if (next != null && next.isVisible() && !next.isIcon()) {
            KAbstractDesktop.toFront(next);
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    public void saveURLs() {
        this.urlPanel.urlField.saveSelf();
        this.findPanel.findfield.saveSelf();
    }

    @Override
    public boolean saveFile(int mode) {
        return true;
    }

    public UndoManager getUndoManager() {
        return null;
    }

    @Override
    public boolean addToHistory() {
        return false;
    }

    static {
        instance = null;
    }

    private class ButtonedURLPanel
    extends JPanel
    implements ActionListener {
        private KSerialTextField urlField = new KSerialTextField("HTMLWindowURLField");
        private JButton back;
        private JButton load;
        private JButton foreward;
        private final String BACK = "back";
        private final String LOAD = "load";
        private final String FOREWARD = "foreward";
        private Vector<String> listOfURLs = new Vector();
        private int index = -1;
        private KSerialTextField findfield = new KSerialTextField("HTMLWindowFind", "find", 8);

        public ButtonedURLPanel(String title) {
            this.setLayout(new GridBagLayout());
            this.setBackground(HTMLWindow.this.gray);
            this.urlField.setFont(new Font("SansSerif", 0, 9));
            this.urlField.setMargin(new Insets(2, 2, 3, 2));
            this.urlField.addActionListener(this);
            this.urlField.setActionCommand("load");
            this.urlField.addSTFListener(new STFListener(){

                @Override
                public void textChanged() {
                    ActionEvent ae = new ActionEvent(this, 0, "load");
                    ButtonedURLPanel.this.actionPerformed(ae);
                }
            });
            this.load = new JButton("URL");
            this.load.setFont(Cutter.defaultFont.font);
            this.load.setBackground(HTMLWindow.this.lite);
            this.load.setMargin(new Insets(0, 0, 0, 0));
            this.load.addActionListener(this);
            this.load.setActionCommand("load");
            this.back = new JButton(ResourceUtils.getIconResource("/resources/html/back.gif"));
            this.back.setBackground(HTMLWindow.this.lite);
            this.back.setDisabledIcon(ResourceUtils.getIconResource("/resources/html/back_disabled.gif"));
            this.back.setMargin(new Insets(2, 0, 2, 0));
            this.back.addActionListener(this);
            this.back.setActionCommand("back");
            this.back.setEnabled(false);
            this.foreward = new JButton(ResourceUtils.getIconResource("/resources/html/foreward.gif"));
            this.foreward.setBackground(HTMLWindow.this.lite);
            this.foreward.setDisabledIcon(ResourceUtils.getIconResource("/resources/html/foreward_disabled.gif"));
            this.foreward.setMargin(new Insets(2, 0, 2, 0));
            this.foreward.addActionListener(this);
            this.foreward.setActionCommand("foreward");
            this.foreward.setEnabled(false);
            this.add((Component)this.back, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(4, 2, 4, 0)));
            this.add((Component)this.load, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(4, 0, 4, 0)));
            this.add((Component)this.foreward, new GBC(2, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(4, 0, 4, 0)));
            this.add((Component)this.urlField, new GBC(3, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(4, 0, 4, 4)));
        }

        public void setURL(String url) {
            url = url.replace('\\', '/');
            url = this.checkForClosingSlash(url);
            this.addToListOfURLs(url);
            this.urlField.setText(url);
            this.urlField.setCaretPosition(0);
            if (this.index + 1 > this.listOfURLs.size() - 1) {
                this.foreward.setEnabled(false);
            } else {
                this.foreward.setEnabled(true);
            }
            if (this.index - 1 < 0) {
                this.back.setEnabled(false);
            } else {
                this.back.setEnabled(true);
            }
        }

        private String checkForClosingSlash(String url) {
            String[] list;
            if (!url.endsWith("/") && (list = TextUtils.tokenize(url, "/")) != null && list.length > 0 && TextUtils.countOccurancesOf(list[list.length - 1], '.') == 0) {
                url = url + '/';
            }
            return url;
        }

        private void addToListOfURLs(String url) {
            for (int n = 0; n < this.listOfURLs.size(); ++n) {
                if (!this.listOfURLs.elementAt(n).equals(url)) continue;
                this.index = n;
                return;
            }
            this.listOfURLs.addElement(url);
            this.index = this.listOfURLs.size() - 1;
        }

        private String getNextURL() {
            if (this.index + 1 > this.listOfURLs.size() - 1) {
                return null;
            }
            return this.listOfURLs.elementAt(++this.index);
        }

        private String getBackURL() {
            if (this.index - 1 < 0) {
                return null;
            }
            return this.listOfURLs.elementAt(--this.index);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String url = null;
            if (e.getActionCommand().equals("foreward")) {
                url = this.getNextURL();
            } else if (e.getActionCommand().equals("load")) {
                url = this.urlField.getText();
                url = this.checkForClosingSlash(url);
            } else if (e.getActionCommand().equals("back")) {
                url = this.getBackURL();
            }
            if (url == null) {
                return;
            }
            EditorKit kit = editorPane.getEditorKit();
            editorPane.setText("loading");
            editorPane.setEditorKit(kit);
            try {
                editorPane.setPage(url);
            }
            catch (IOException ex) {
                Cutter.setLog("couldn't load " + url + " exception = " + ex);
                JOptionPane.showMessageDialog(Cutter.desktop, "Cannot load web page:\n\"" + url + "\"", "Broken Link Error", 0);
                return;
            }
            this.setURL(url);
        }
    }

    private class FindPanel
    extends JPanel
    implements NewlineListener {
        private KSerialTextField findfield = new KSerialTextField("HTMLWindowFind", "find", 20);
        private KLabel findLabel = new KLabel("Find");
        private KLabel topLabel = new KLabel("[top]");

        public FindPanel() {
            this.setLayout(new GridBagLayout());
            this.setBackground(HTMLWindow.this.gray);
            this.findfield.lineEditorDeactivatesDesktop(false);
            this.findfield.setEnabled(true);
            this.findfield.usesModelDialog = true;
            this.findfield.addNewlineListener(this);
            this.findfield.setMinimumSize(this.findfield.getPreferredSize());
            this.findfield.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(final DocumentEvent e) {
                    int startAt = editorPane.getSelectionStart();
                    FindPanel.this.find(startAt);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int len = FindPanel.this.findfield.getText().length();
                            int off = e.getOffset();
                            FindPanel.this.findfield.setSelectionStart(off + e.getLength());
                            FindPanel.this.findfield.setSelectionEnd(off + e.getLength());
                            FindPanel.this.findfield.requestFocus();
                        }
                    });
                }

                @Override
                public void removeUpdate(final DocumentEvent e) {
                    int startAt = editorPane.getSelectionStart();
                    FindPanel.this.find(startAt);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FindPanel.this.findfield.setSelectionStart(e.getOffset());
                            FindPanel.this.findfield.setSelectionEnd(e.getOffset());
                            FindPanel.this.findfield.requestFocus();
                        }
                    });
                }
            });
            this.findLabel.setBold(false);
            this.findLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        int startAt = editorPane.getSelectionEnd();
                        FindPanel.this.find(startAt);
                    }
                }
            });
            this.topLabel.setBold(false);
            this.topLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        JViewport port = HTMLWindow.this.scrollPane.getViewport();
                        if (port == null) {
                            return;
                        }
                        port.setViewPosition(new Point(0, 0));
                        editorPane.setSelectionStart(0);
                        editorPane.setSelectionEnd(0);
                    }
                }
            });
            this.findfield.setMinimumSize(this.findfield.getPreferredSize());
            this.add((Component)this.findLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(1, 5, 1, 0)));
            this.add((Component)this.findfield, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(1, 5, 1, 0)));
            this.add((Component)this.topLabel, new GBC(2, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(1, 15, 1, 0)));
        }

        @Override
        public void newlineHappened() {
            final int currBegin = this.findfield.getSelectionStart();
            final int currEnd = this.findfield.getSelectionEnd();
            int startAt = editorPane.getSelectionEnd();
            this.find(startAt);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindPanel.this.findfield.setSelectionStart(currBegin);
                    FindPanel.this.findfield.setSelectionEnd(currEnd);
                    FindPanel.this.findfield.requestFocus();
                }
            });
        }

        private int find(int startAt) {
            String str = this.findfield.getText();
            if (str.trim().length() == 0) {
                return 0;
            }
            Segment seg = BBxt.getWindowText(startAt, -1);
            if (seg == null) {
                Cutter.setLog("    Error: HTMLWindow.FindPanel.find() - cannot get the segement beginning at offset " + startAt);
                return -1;
            }
            RegExpUtils re = new RegExpUtils();
            String regexp = re.encodeAsRE(str, true, false);
            if (!re.checkPattern(regexp)) {
                return -1;
            }
            String[] parts = null;
            int diff = 0;
            try {
                parts = seg.toString().split(regexp, 2);
                if (parts != null && parts.length > 1) {
                    int part0Length = parts[0].length();
                    int part1Length = parts[1].length();
                    diff = seg.count - (part0Length + part1Length);
                    int beginOffset = parts[0].length();
                    int absBegin = beginOffset + startAt;
                    int absEnd = absBegin + diff;
                    editorPane.setSelectionStart(absBegin);
                    editorPane.setSelectionEnd(absEnd);
                    return absEnd;
                }
            }
            catch (Exception e) {
                Cutter.setLog("    Exception:HTMLWindow.FindPanel.find()\n          " + e.toString());
            }
            return 0;
        }
    }

    public class HTMLEditorPane
    extends JEditorPane {
        private Vector<NewlineListener> listOfNewlineListeners = new Vector();

        public KAbstractWindow getFrame() {
            return HTMLWindow.this;
        }

        @Override
        public void read(InputStream in, Object desc) throws IOException {
            try {
                super.read(in, desc);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:HTMLWindow.HTMLEditorPane.read()\n        " + ex.toString());
            }
        }

        @Override
        protected void processComponentKeyEvent(KeyEvent e) {
            if (e.getID() == 401 && e.getKeyCode() == 10) {
                this.notifyNewlineListeners();
            }
            super.processComponentKeyEvent(e);
        }

        private void notifyNewlineListeners() {
            for (int n = 0; n < this.listOfNewlineListeners.size(); ++n) {
                NewlineListener l = this.listOfNewlineListeners.elementAt(n);
                l.newlineHappened();
            }
        }

        public void addNewlineListener(NewlineListener l) {
            this.listOfNewlineListeners.addElement(l);
        }

        public void removeNewlineListener(NewlineListener l) {
            this.listOfNewlineListeners.removeElement(l);
        }

        @Override
        public Dimension getPreferredSize() {
            try {
                return super.getPreferredSize();
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:HTMLWindow.getPreferredSize()\n       " + ex.toString());
                return new Dimension(400, 400);
            }
        }
    }
}

