/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import ClientServer.ClientServer.client.PortEvent;
import History.HistoryListener;
import History.KAbstractHistory;
import History.KTextHistoryDB;
import Preferences.Preferences;
import Session.SessionManager;
import UI_BBXT.BBxt;
import UI_Components.Dialog.SaveFileDialog;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.KTools;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextHistoryWindow;
import UI_Window.KWindow.KTextWindow;
import UI_Window.Panels.WindowInfoPanel.LineNumberingPanel;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DesktopManager;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class KAbstractTextWindow
extends KAbstractWindow
implements PropertyChangeListener,
VetoableChangeListener,
Printable {
    public static boolean _finalize = true;
    public static final int DEFAULT = 0;
    public static final int WINDOWS = 1;
    public static final int UNIX = 2;
    public static final int MACINTOSH = 3;
    private TouchListener touchListener = new TouchListener();
    public int textOutputOSType = 0;
    protected String extension = ".rib";
    public KTextPane textpane = null;
    private int tabSize = 4;
    private boolean ignorePropertyChanges = false;
    public boolean wasExecutibleWhenOpened = false;
    protected KTextHistoryWindow historyWindow = null;
    protected Rectangle historyWindowRect = null;
    public KTextHistoryDB historyDB = null;
    public boolean canBeRecycled = true;
    public File lastSaveAsCopy = null;
    private Vector m_lines;
    public static final int TAB_SIZE = 4;

    public KTextPane getTextPane() {
        return this.textpane;
    }

    protected void setIsOpen() {
        this.isClosed = false;
    }

    public KAbstractTextWindow(File f, boolean r, boolean c, boolean m, boolean i) {
        this(f, r, c, m, i, KAbstractDesktop.WINDOW_LAYER);
    }

    public KAbstractTextWindow(File f, boolean r, boolean c, boolean m, boolean i, Integer layer) {
        super(f, r, c, m, i, layer);
    }

    public KAbstractTextWindow(String t, boolean r, boolean c, boolean m, boolean i) {
        this(t, r, c, m, i, KAbstractDesktop.WINDOW_LAYER);
    }

    public KAbstractTextWindow(String t, boolean r, boolean c, boolean m, boolean i, Integer layer) {
        super(t, r, c, m, i, layer);
    }

    public KAbstractTextWindow() {
    }

    public void commonInit() {
        this.textpane = new KTextPane(this);
        this.textpane.addDocumentListener(this.touchListener);
        this.addPropertyChangeListener(this);
        this.setVisible(false);
    }

    @Override
    protected void addWindowAppearanceListener() {
        super.addWindowAppearanceListener();
    }

    protected void suspendTouchListener() {
        this.textpane.removeDocumentListener(this.touchListener);
    }

    protected void resumeTouchListener() {
        this.textpane.addDocumentListener(this.touchListener);
    }

    protected void suspendPropertyChangeListener() {
        this.ignorePropertyChanges = true;
    }

    protected void resumePropertyChangeListener() {
        this.ignorePropertyChanges = false;
    }

    protected void removeTouchListener() {
        if (this.textpane != null) {
            this.textpane.removeDocumentListener(this.touchListener);
        }
        this.touchListener = null;
        String title = this.getTitle();
        if (title.endsWith("*") && title.length() >= 2) {
            title = title.substring(0, title.length() - 1);
            this.setTitle(title);
        }
        this.isTouched = false;
    }

    @Override
    public void setSleep(boolean f) {
        super.setSleep(f);
        if (this.doSleep && this.textpane != null) {
            this.textpane.setEnabled(false);
        } else {
            this.textpane.setEnabled(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.ignorePropertyChanges) {
            return;
        }
        int bb = this.textpane.getSelectionStart();
        int ee = this.textpane.getSelectionEnd();
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        Object oldvalue = e.getOldValue();
        if (name.equals("title") && TextUtils.remove(value.toString(), '*').equals(oldvalue.toString())) {
            return;
        }
        if (name.equals("closed")) {
            KTools.updateUI(TextUtils.remove(this.getTitle(), '*'));
        } else if (name.equals("title")) {
            if (!((String)value).equals(oldvalue)) {
                KTools.updateUI(TextUtils.remove(this.getTitle(), '*'));
            }
        } else if (name.equals("selected") && (Boolean)value == Boolean.TRUE) {
            this.getTextPane().requestFocus();
            this.getTextPane().grabFocus();
            String copy = TextUtils.remove(this.getTitle(), '*');
            KTools.updateUI(copy);
            KTools.updateUI(BBxt.getWindowFile());
        } else if (!name.equals("closed") || (Boolean)value == Boolean.TRUE) {
            // empty if block
        }
        this.textpane.setSelectionStart(bb);
        this.textpane.setSelectionEnd(ee);
    }

    public JTextComponent getEditor() {
        return this.textpane;
    }

    public void selectAll() {
        this.textpane.setSelectionStart(0);
        this.textpane.setSelectionEnd(this.textpane.getDocument().getLength());
    }

    public int[] getSelection() {
        int[] out = new int[]{this.textpane.getSelectionStart(), this.textpane.getSelectionEnd()};
        return out;
    }

    public void setSelection(int from, int to) {
        this.textpane.setSelectionStart(from);
        this.textpane.setSelectionEnd(to);
        this.textpane.requestFocus();
    }

    public String getCurrentText() {
        int bb = this.textpane.getSelectionStart();
        int ee = this.textpane.getSelectionEnd();
        try {
            if (bb == ee) {
                return this.getEditor().getText();
            }
            return this.getEditor().getSelectedText();
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception: KAbstractTextWindow.getCurrentText() " + ex.toString());
            return null;
        }
    }

    public boolean deleteAllText() {
        if (this.textpane == null) {
            return false;
        }
        if (this.textpane.getDocument() == null) {
            return false;
        }
        try {
            this.textpane.getDocument().remove(0, this.textpane.getDocument().getLength());
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: KAbstractTextWindow.deleteAll() " + e);
            return false;
        }
        return true;
    }

    public boolean selection() {
        if (this.textpane == null) {
            return false;
        }
        String s = this.textpane.getSelectedText();
        return s != null && s.length() > 0;
    }

    @Override
    public void setClosePolicy() {
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.getSaveable()) {
            String path;
            if (this.getFile() != null && (path = this.getPathToHistoryZip(this.getFile())) != null && !FileUtils.exists(path)) {
                this.addToHistory();
            }
            if (this.getFile() != null && this.hasHistory()) {
                this.saveHistory();
            }
        }
        if (this.getFile() != null) {
            SessionManager.getInstance().closed(this.getFile().getPath());
        }
        super.internalFrameClosing(e);
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        Thread thread = new Thread("KAbstractTextWindow close thread"){

            @Override
            public void run() {
                KAbstractTextWindow.this.disposeHistory();
            }
        };
        thread.start();
        super.internalFrameClosed(e);
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
        if (this.getFile() != null) {
            SessionManager.getInstance().opened(this.getFile().getPath());
        }
    }

    @Override
    public boolean saveFile(int mode) {
        File oldFile;
        block60: {
            JPanel p;
            if (this.getFile() != null && mode == 1 && !this.getTouched()) {
                return false;
            }
            if (this instanceof KTextWindow && (p = ((KTextWindow)this).getLineNumberingPanel()) instanceof LineNumberingPanel) {
                ((LineNumberingPanel)p).resume(true);
            }
            String fileName = TextUtils.remove(this.getTitle(), '*');
            fileName = this.removeNonEditablePostfix(fileName);
            File tempfile = null;
            oldFile = this.getFile();
            if (this.getFile() == null && mode == 2) {
                mode = 1;
            }
            if (this.getFile() == null || mode == 2 || mode == 3 || mode == 4) {
                String name;
                String sftitle = "Save";
                switch (mode) {
                    case 1: {
                        sftitle = "Save";
                        break;
                    }
                    case 2: {
                        sftitle = "Save As";
                        break;
                    }
                    case 3: {
                        sftitle = "Save Copy";
                        break;
                    }
                    case 4: {
                        sftitle = "Save Copy As Template";
                    }
                }
                SaveFileDialog saveFileDialog = SaveFileDialog.getInstance(Cutter.desktop, sftitle);
                if (this.prevFile == null) {
                    this.prevFile = FileUtils.getPWDFile();
                }
                if (mode == 3) {
                    String date = "";
                    date = date + TextUtils.getDateTime(1) + "_";
                    date = date + TextUtils.getDateTime(2) + "_";
                    date = date + TextUtils.getDateTime(5) + "_";
                    date = date + TextUtils.getDateTime(12) + "_";
                    date = date + TextUtils.getDateTime(13);
                    this.lastSaveAsCopy = new File(date + fileName);
                    saveFileDialog.setSelectedFile(this.lastSaveAsCopy);
                } else if (mode == 4) {
                    name = TextUtils.remove(this.getTitle(), '*');
                    int index = name.indexOf(".");
                    if (index != -1 && index > 0) {
                        String ext = name.substring(index);
                        ScriptHandler handler = ScriptRegistry.getHandlerForExtension(ext);
                        if (handler != null) {
                            name = handler.getPreferredSaveFileName();
                        }
                        if (name == null) {
                            name = TextUtils.remove(this.getTitle(), '*');
                        }
                    }
                    saveFileDialog.setSelectedFile(new File(this.prevFile, name));
                } else if (this.getFile() == null) {
                    name = this.getTitle();
                    if (name == null || name.length() == 0) {
                        saveFileDialog.setSelectedFile(new File(saveFileDialog.getPrevFile(), "untitled.txt"));
                    } else {
                        String ext;
                        ScriptHandler handler;
                        name = TextUtils.remove(this.getTitle(), '*');
                        int index = name.indexOf(".");
                        if (index != -1 && index > 0 && (handler = ScriptRegistry.getHandlerForExtension(ext = name.substring(index))) != null) {
                            name = handler.getPreferredSaveFileName();
                        }
                        if (name == null) {
                            name = TextUtils.remove(this.getTitle(), '*');
                        }
                        saveFileDialog.setSelectedFile(new File(saveFileDialog.getPrevFile(), name));
                    }
                } else {
                    saveFileDialog.setSelectedFile(this.getFile());
                }
                int response = -2;
                switch (mode) {
                    case 4: {
                        response = saveFileDialog.showSelf("Save Copy As Template");
                        break;
                    }
                    case 3: {
                        response = saveFileDialog.showSelf("Save A Copy As");
                        break;
                    }
                    case 2: {
                        response = saveFileDialog.showSelf("Save As");
                        break;
                    }
                    default: {
                        response = saveFileDialog.showSelf("Save");
                    }
                }
                if (response == -2) {
                    return false;
                }
                if (response == 0) {
                    if (mode == 3 || mode == 4) {
                        this.lastSaveAsCopy = tempfile = saveFileDialog.getSelectedFile();
                        if (tempfile == null) {
                            return false;
                        }
                    } else {
                        this.addToHistory();
                        if (mode == 2) {
                            this.saveHistory();
                        }
                        this.setFile(saveFileDialog.getSelectedFile());
                        if (oldFile != null && mode == 2) {
                            this.disposeHistory();
                            this.initHistory();
                            this.addToHistory();
                        }
                        this.setTouched(false);
                        if (this.getFile() == null) {
                            Cutter.setLog("    Error: KAbstractTextWindow getFile() is null");
                            return false;
                        }
                        this.setTitle(this.getFile().getName());
                    }
                }
                if (response == 1) {
                    return false;
                }
            }
            try {
                if (mode == 1 || mode == 2) {
                    if (!this.getFile().exists()) {
                        this.prevFile = this.getFile();
                        String name = this.getFile().toString();
                        if (name.endsWith(this.extension)) {
                            name = name.substring(0, name.length() - this.extension.length()) + this.extension;
                        }
                        this.saveTextToFile(name, true);
                        this.setTitle("");
                    } else {
                        this.getFile().delete();
                        this.saveTextToFile(this.getFile().toString());
                        this.prevFile = this.getFile();
                    }
                    this.setTouched(false);
                    this.setTitle("");
                    if (mode == 2 && this.hasHistory()) {
                        this.saveHistory();
                    }
                    KDesktop.saveItem.setEnabled(false);
                    break block60;
                }
                if (mode == 3 || mode == 4) {
                    if (!tempfile.exists()) {
                        this.saveTextToFile(tempfile);
                    } else {
                        tempfile.delete();
                        this.saveTextToFile(tempfile.toString());
                    }
                    this.prevFile = tempfile;
                    break block60;
                }
                return false;
            }
            catch (FileNotFoundException e) {
                JOptionPane.showInternalMessageDialog(this, "Failed to open \"" + fileName + "\" for writing.", "Error", 0);
                Toolkit.getDefaultToolkit().beep();
                return false;
            }
            catch (IOException e) {
                JOptionPane.showInternalMessageDialog(this, "Failed to write to \"" + fileName + "\".", "Error", 0);
                Toolkit.getDefaultToolkit().beep();
                return false;
            }
        }
        if (this.getFile() != null && mode != 3 && mode != 4) {
            this.setTitle(this.getFile().getName());
        }
        if (this.getFile() != null && oldFile != null && !this.getFile().equals(oldFile)) {
            this.textpane.updateSyntaxListener(this.getFile().getName());
            this.getTextPane().resumeSyntaxColoration();
            this.removeNonEditablePostfix();
            this.textpane.setEditable(true);
        } else if (oldFile == null && this.getFile() != null) {
            this.textpane.updateSyntaxListener(this.getFile().getName());
            this.getTextPane().resumeSyntaxColoration();
        }
        this.textpane.resumeSyntaxColoration();
        this.textpane.parseAll();
        ScriptRegistry.loadCache(this);
        if (this.getFile() != null) {
            this.addToHistory();
        }
        if (mode == 1) {
            if (this.getFile() != null) {
                SessionManager.getInstance().saved(this.getFile().getPath());
            }
        } else if (mode == 2 && this.getFile() != null) {
            if (oldFile != null) {
                SessionManager.getInstance().closed(oldFile.getPath());
            }
            SessionManager.getInstance().opened(this.getFile().getPath());
            if (oldFile != null) {
                SessionManager.getInstance().parent(this.getFile().getPath(), oldFile.getPath());
            }
        }
        return true;
    }

    public String getText() {
        String lastChar;
        if (this.textpane == null) {
            return "";
        }
        Document document = this.textpane.getDocument();
        try {
            lastChar = document.getText(document.getLength() - 1, 1);
        }
        catch (BadLocationException e) {
            return this.getEditor().getText();
        }
        if (lastChar == null || lastChar.length() == 0) {
            return this.getEditor().getText();
        }
        if (!lastChar.equals("\n")) {
            try {
                document.insertString(document.getLength(), "\n", null);
            }
            catch (BadLocationException ex) {
                return this.getEditor().getText();
            }
        }
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException ex) {
            return this.getEditor().getText();
        }
    }

    public void setText(String str) {
        if (str != null && this.textpane != null) {
            this.textpane.setText(str);
        }
    }

    public void appendText(String str) {
        this.textpane.appendText(str);
    }

    public void prependText(String str) {
        this.textpane.prependText(str);
    }

    public void setTabSize(int size) {
        this.tabSize = size;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setFontSize(int size) {
    }

    public void setFontStyle(int size) {
    }

    public void setFontName(String name) {
    }

    public String getAllText() {
        if (this.textpane == null) {
            return null;
        }
        Document document = this.textpane.getDocument();
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Exception: KAbstractTextWindow.getText()" + ex);
            return null;
        }
    }

    protected void saveTextToFile(File file) throws IOException {
        this.saveTextToFile(file.toString(), false);
    }

    protected void saveTextToFile(String fullpathname) throws IOException {
        this.saveTextToFile(fullpathname, false);
    }

    protected void saveTextToFile(String filename, boolean append) throws IOException {
        ScriptHandler handler = ScriptRegistry.getHandlerForFile(new File(filename));
        if (handler != null) {
            handler.doPreSaveOperation(this);
        }
        BufferedWriter fw = new BufferedWriter(new FileWriter(filename, append));
        StringBuffer buffer = new StringBuffer(this.getText());
        StringBuffer out = new StringBuffer();
        try {
            for (int n = 0; n < buffer.length(); ++n) {
                if (buffer.charAt(n) == '\n') {
                    if (this.textOutputOSType == 0) {
                        fw.newLine();
                        continue;
                    }
                    if (this.textOutputOSType == 2) {
                        fw.write(10);
                        continue;
                    }
                    if (this.textOutputOSType == 3) {
                        fw.write(13);
                        continue;
                    }
                    if (this.textOutputOSType != 1) continue;
                    fw.write("\r\n");
                    continue;
                }
                fw.write(buffer.charAt(n));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        fw.flush();
        fw.close();
        if (handler != null) {
            handler.doPostSaveOperation(this);
        }
        if (this.wasExecutibleWhenOpened) {
            this.restoreExecutiblePermissions();
        }
    }

    protected void restoreExecutiblePermissions() {
        final File file = this.getFile();
        if (file != null && file.exists()) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        file.setExecutable(true, false);
                        Cutter.setLog("    Debug:KAbstractTextWindow.restoreExecutiblePermissions() - setting execute permissions for:\n        \"" + file.getPath() + "\"");
                    }
                });
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KAbstractTextWindow.restoreExecutiblePermissions().run()");
                Cutter.setLog("       " + ex.toString());
            }
        }
    }

    protected void addDocumentListener(DocumentListener l) {
        this.textpane.addDocumentListener(l);
    }

    protected void removeDocumentListener(DocumentListener l) {
        this.textpane.removeDocumentListener(l);
    }

    public void initHistory() {
        if (this.historyDB == null) {
            this.historyDB = KTextHistoryDB.getInstance(this);
        }
        if (this.historyDB == null) {
            Cutter.setLog("    Info:KAbstractTextWindow.initHistory() cannot get history data base");
        }
    }

    public void disposeHistory() {
        if (this.historyWindow != null) {
            this.historyWindow.preDispose();
            try {
                this.historyWindow.setClosed(true);
            }
            catch (PropertyVetoException ee) {
                Cutter.setLog("    Error: KAbstracTexttWindow.disposeHistoryWindow()" + ee.toString());
            }
            KTextHistoryWindow.Factory.add(this.historyWindow);
        }
        this.historyWindow = null;
        if (this.historyDB != null) {
            this.historyDB.preDispose();
            KTextHistoryDB.put(this.historyDB);
            this.historyDB = null;
        }
    }

    @Override
    public boolean addToHistory() {
        String str = Preferences.get(Preferences.DOCUMENT_HISTORY_ACTIVE);
        if (this.historyDB == null) {
            this.initHistory();
        }
        if (str.equals("false") || this.historyDB == null) {
            return false;
        }
        this.historyDB.add(this.getAllText());
        return true;
    }

    public void viewHistory() {
        if (!this.hasHistory()) {
            Cutter.setLog("KAbstractTextWindow.viewHistory() - hasHistory() returned false");
            return;
        }
        if (this.historyWindow == null) {
            this.historyWindow = KTextHistoryWindow.Factory.get(this);
            String[] textItem = this.getNextHistory();
            this.historyWindow.deleteAllText();
            this.historyWindow.setText(textItem == null || textItem.length == 0 || textItem[0] == null ? "No history available" : textItem[0]);
            this.historyWindow.setVersion();
            this.historyWindow.setSelection(0, 0);
        }
        if (this.historyWindowRect != null) {
            DesktopManager manager = KAbstractDesktop.getDesktopManager();
            manager.resizeFrame(this.historyWindow, this.historyWindowRect.x, this.historyWindowRect.y, this.historyWindowRect.width, this.historyWindowRect.height);
        }
        this.historyWindow.setVisible(true);
        KAbstractDesktop.toFront(this.historyWindow);
    }

    @Override
    public boolean hasHistory() {
        return this.historyDB == null ? false : this.historyDB.isAvailable();
    }

    public void addHistoryListener(HistoryListener l) {
        if (this.historyDB != null) {
            this.historyDB.addListener(l);
            this.historyDB.notifyListeners();
        }
    }

    public void removeHistoryListener(HistoryListener l) {
        if (this.historyDB != null) {
            this.historyDB.removeListener(l);
        }
    }

    public String[] getHistoryAt(int index) {
        return this.historyDB == null ? null : this.historyDB.getItemAt(index);
    }

    public String[] getPrevHistory() {
        return this.historyDB == null ? null : this.historyDB.getPrev();
    }

    public String[] getNextHistory() {
        return this.historyDB == null ? null : this.historyDB.getNext();
    }

    public int getHistoryByteSize() {
        return this.historyDB == null ? 0 : this.historyDB.getByteSize();
    }

    public int getHistorySize() {
        return this.historyDB == null ? 0 : this.historyDB.getSize();
    }

    public int getHistoryMarker() {
        return this.historyDB == null ? 0 : this.historyDB.getMarker();
    }

    public void setMaxHistoryBytes(int size) {
        if (this.historyDB != null) {
            this.historyDB.trimToByteSize(size);
        }
    }

    public int getMaxHistoryBytes() {
        return this.historyDB == null ? 0 : this.historyDB.getMaxBytes();
    }

    public int getMaxHistoryCount() {
        return this.historyDB == null ? 0 : this.historyDB.getMaxCount();
    }

    public void setMaxHistoryCount(int size) {
        if (this.historyDB != null) {
            this.historyDB.setMaxCount(size);
        }
    }

    public void clearHistory() {
        if (this.historyDB != null) {
            this.historyDB.clear();
        }
    }

    public void trimHistory(int bytesize) {
        if (this.hasHistory()) {
            this.historyDB.trimToByteSize(bytesize);
        }
    }

    public String getHistoryCatalog() {
        return this.historyDB == null ? null : this.historyDB.getCatalog(this);
    }

    public boolean removeHistoryFromTo(String from, String to) {
        return this.historyDB == null ? false : this.historyDB.removeFromTo(from, to);
    }

    @Override
    public void saveHistory(File file) {
        if (file == null) {
            return;
        }
        if (this.historyDB != null) {
            this.historyDB.save(this);
        }
    }

    public void saveHistory() {
        if (this.historyDB != null) {
            this.historyDB.save(this);
        } else {
            Cutter.setLog("KAbstractTextWindow.saveHistory() Cannot save - historyDB is null");
        }
    }

    public void saveHistoryTo(File anotherZipFile) {
        if (this.historyDB != null) {
            this.historyDB.saveTo(this, anotherZipFile);
        } else {
            Cutter.setLog("KAbstractTextWindow.saveHistory() Cannot save - historyDB is null");
        }
    }

    public String getPathToHistoryZip(File src) {
        return KAbstractHistory.getHistoryFileNameFrom(src);
    }

    @Override
    public void setHistoryWindowRect(Rectangle rect) {
        if (rect == null) {
            return;
        }
        if (this.historyWindow == null) {
            this.historyWindowRect = rect;
        } else {
            DesktopManager manager = KAbstractDesktop.getDesktopManager();
            manager.resizeFrame(this.historyWindow, rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public Rectangle getHistoryWindowRect() {
        return this.historyWindow == null ? null : this.historyWindow.getBounds();
    }

    public boolean getHistoryWindowVisibility() {
        return this.historyWindow.isVisible();
    }

    public void resolveHistoryZipClash(File docFile) {
        if (docFile == null) {
            return;
        }
        String path = this.getPathToHistoryZip(docFile);
        if (path != null && FileUtils.exists(path)) {
            new File(path).delete();
            this.disposeHistory();
            this.initHistory();
        }
    }

    @Override
    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int linesPerPage;
        int numLines;
        int numPages;
        Graphics2D g2 = (Graphics2D)pg;
        g2.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int wPage = (int)pageFormat.getImageableWidth();
        int hPage = (int)pageFormat.getImageableHeight();
        g2.setClip(0, 0, wPage, hPage);
        g2.setColor(this.textpane.getBackground());
        g2.fillRect(0, 0, wPage, hPage);
        g2.setColor(this.textpane.getForeground());
        Font font = this.textpane.getFont();
        g2.setFont(font);
        FontMetrics fm = g2.getFontMetrics();
        int hLine = fm.getHeight();
        if (this.m_lines == null) {
            this.m_lines = this.getLines(fm, wPage);
        }
        if (pageIndex >= (numPages = (int)Math.ceil((double)(numLines = this.m_lines.size()) / (double)(linesPerPage = Math.max(hPage / hLine, 1))))) {
            this.m_lines = null;
            return 1;
        }
        int x = 0;
        int y = fm.getAscent();
        for (int lineIndex = linesPerPage * pageIndex; lineIndex < this.m_lines.size() && y < hPage; y += hLine, ++lineIndex) {
            String str = (String)this.m_lines.get(lineIndex);
            g2.drawString(str, x, y);
        }
        return 0;
    }

    protected Vector getLines(FontMetrics fm, int wPage) {
        Vector<String> v = new Vector<String>();
        String text = this.getAllText();
        String prevToken = "";
        StringTokenizer st = new StringTokenizer(text, "\n", true);
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.equals("\n") && prevToken.equals("\n")) {
                v.add("");
            }
            prevToken = line;
            if (line.equals("\n")) continue;
            StringTokenizer st2 = new StringTokenizer(line, " \t", true);
            String line2 = "";
            while (st2.hasMoreTokens()) {
                int lineLength;
                String token = st2.nextToken();
                if (token.equals("\t")) {
                    int numSpaces = 4 - line2.length() % 4;
                    token = "";
                    for (int k = 0; k < numSpaces; ++k) {
                        token = token + " ";
                    }
                }
                if ((lineLength = fm.stringWidth(line2 + token)) > wPage && line2.length() > 0) {
                    v.add(line2);
                    line2 = token.trim();
                    continue;
                }
                line2 = line2 + token;
            }
            v.add(line2);
        }
        return v;
    }

    @Override
    public void portMessage(PortEvent event) {
    }

    static {
        try {
            Field[] fields = new Field[]{KAbstractTextWindow.class.getDeclaredField("_finalize")};
            Cutter.addDebug(KAbstractTextWindow.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: KAbstractTextWindow.static - " + ex.toString());
        }
    }

    private class TouchListener
    implements DocumentListener {
        private TouchListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            KAbstractTextWindow.this.setTouched(true);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            KAbstractTextWindow.this.setTouched(true);
        }
    }
}

