/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import ClientServer.ClientServer.client.Client;
import ClientServer.ClientServer.client.KClient;
import ClientServer.ClientServer.client.PortEvent;
import ClientServer.ClientServer.client.PortListener;
import ClientServer.ClientServer.server.KServer;
import Preferences.PreferencesReadWriter;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.ExtendedDesktopPane;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Net.TCPListener.TCPListener;
import UI_Window.KWindow.HTMLWindow;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.lang.reflect.Field;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public abstract class KAbstractWindow
extends JInternalFrame
implements InternalFrameListener,
VetoableChangeListener,
PreferencesReadWriter,
PortListener {
    public static boolean _finalize = true;
    private static final long serialVersionUID = 1L;
    public static final int SAVE_NORMAL = 1;
    public static final int SAVE_AS = 2;
    public static final int SAVE_COPY = 3;
    public static final int SAVE_AS_TEMPLATE = 4;
    public static final String NON_EDITABLE_POSTFIX_STR = " [NOT EDITABLE]";
    protected Container contentPane = null;
    private File file = null;
    public File prevFile = new File(System.getProperty("user.dir"));
    protected WindowMenuItem windowMenuItem = null;
    protected boolean isTouched = false;
    private KAbstractWindow next = null;
    protected boolean doSleep = false;
    protected boolean titleLock = false;
    private boolean appearsSelected = true;
    protected KServer broadcaster = null;
    protected int broadcastMode = 2;
    protected boolean canBroadcast = false;
    protected TCPListener tcpListener = null;
    public static String CANNOT_CONNECT_TO_CLIENT;
    protected KClient cutterClient = null;
    protected Client mayaClient = null;
    protected Client houdiniClient = null;
    protected boolean saveable = true;
    private JPopupMenu iconFilePathPopup = new JPopupMenu();
    private JMenuItem iconFilePathItem = new JMenuItem();
    static final String uiClassID = "KInternalFrameUI";

    public boolean isMayaClient() {
        return this.mayaClient != null;
    }

    public boolean isHoudiniClient() {
        return this.houdiniClient != null;
    }

    public boolean isCutterClient() {
        return this.cutterClient != null;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public KAbstractWindow(File f, boolean r, boolean c, boolean m, boolean i, Integer layer) {
        super(f.getName(), r, c, m, i);
        this.file = f;
        this.commonInit(layer);
        this.addWindowAppearanceListener();
    }

    public KAbstractWindow(String t, boolean r, boolean c, boolean m, boolean i, Integer layer) {
        super(t, r, c, m, i);
        this.commonInit(layer);
        this.addWindowAppearanceListener();
    }

    public KAbstractWindow() {
    }

    protected void commonInit(Integer layer) {
        this.contentPane = this.getContentPane();
        this.setClosePolicy();
        this.setVisible(false);
        String title = this.getTitle();
        if (title != null && title.length() > 0 && this.getLayer() == KDesktop.WINDOW_LAYER.intValue()) {
            this.windowMenuItem = new WindowMenuItem();
            this.windowMenuItem.setWindow(this);
            KDesktop.addWindowMenuItem(this.windowMenuItem);
        }
        KDesktop.desktopPane.addCascaded(this, layer);
        this.addVetoableChangeListener(this);
        this.addInternalFrameListener(this);
        this.iconFilePathItem.setBackground(Cutter.PALE_YELLOW);
        this.iconFilePathPopup.add(this.iconFilePathItem);
        final JInternalFrame.JDesktopIcon icon = this.getDesktopIcon();
        DesktopIconUI iconTitle = icon.getUI();
        icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                KAbstractWindow.this.popupFullpath(icon, e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                KAbstractWindow.this.iconFilePathPopup.setVisible(false);
            }
        });
    }

    private void popupFullpath(JInternalFrame.JDesktopIcon icon, MouseEvent e) {
        String fullpath;
        String string = fullpath = this.getFile() == null ? null : this.getFile().getPath();
        if (fullpath == null) {
            return;
        }
        this.iconFilePathItem.setText(fullpath);
        if (this.iconFilePathPopup != null) {
            this.iconFilePathPopup.setRequestFocusEnabled(false);
            try {
                this.iconFilePathPopup.show(icon, e.getX(), e.getY() - 25);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KAbstractWindow.popupFullpath()\n      " + ex.toString());
            }
        }
    }

    @Override
    public void setSelected(boolean state) {
        try {
            super.setSelected(state);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addWindowAppearanceListener() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String name = e.getPropertyName();
                Object value = e.getNewValue();
                Object oldvalue = e.getOldValue();
                if (name.equals("selected")) {
                    if (oldvalue.equals(value)) {
                        return;
                    }
                    Icon icon = KAbstractWindow.this.getFrameIcon();
                    JComponent comp = ((BasicInternalFrameUI)KAbstractWindow.this.getUI()).getNorthPane();
                    if (comp == null) {
                        KAbstractWindow.this.appearsSelected = false;
                        return;
                    }
                    Component[] c = comp.getComponents();
                    if (c != null) {
                        for (int n = 0; n < c.length; ++n) {
                            ((JComponent)c[n]).setVisible((Boolean)value);
                        }
                    }
                    KAbstractWindow.this.appearsSelected = true;
                } else {
                    KAbstractWindow.this.appearsSelected = false;
                }
            }
        });
    }

    public boolean appearanceIsSelected() {
        return this.appearsSelected;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean doRepaint = false;
        int trueY = Math.abs(y);
        if (y < 0) {
            doRepaint = true;
            y = 0;
        }
        this.reshape(x, y, width, height);
        if (doRepaint) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KAbstractDesktop.desktopPane.repaint(0L, 0, 0, 1000, 1000);
                }
            });
        }
    }

    @Override
    public void setTitle(String label) {
        if (label == null || label.trim().length() == 0) {
            return;
        }
        String t = this.getTitle();
        if (t == null) {
            return;
        }
        if (label.equals(this.getTitle())) {
            return;
        }
        KDesktop.removeWindowMenuItem(this.windowMenuItem);
        if (label != null && !this.titleLock) {
            try {
                super.setTitle(label);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KAbstractWindow.setTitle() - " + label + "\n" + ex.toString());
            }
            this.windowMenuItem.setWindow(this);
        }
        KDesktop.addWindowMenuItem(this.windowMenuItem);
    }

    public void lockTitle(boolean flag) {
        this.titleLock = flag;
    }

    public boolean getTouched() {
        return this.isTouched;
    }

    public void setTouched(boolean state) {
        if (this.isTouched && state) {
            if (this.getTitle().endsWith("*")) {
                return;
            }
            this.setTitle(this.addAstrixTo(this.getTitle()));
            return;
        }
        if (!this.isTouched && !state) {
            return;
        }
        if (!this.isTouched && state) {
            this.setTitle(this.addAstrixTo(this.getTitle()));
            this.isTouched = true;
        } else if (this.isTouched && !state) {
            this.setTitle(TextUtils.remove(this.getTitle(), '*'));
            this.isTouched = false;
        }
    }

    private String addAstrixTo(String str) {
        if (TextUtils.contains(str, '*')) {
            str = str.replaceAll("\\*", "");
        }
        str = str + "*";
        return str;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        if (file != null) {
            this.setTitle(file.getName());
        }
    }

    public synchronized void setSaveable(boolean flag) {
        this.removeNonEditablePostfix();
        if (!flag) {
            this.setTitle(TextUtils.remove(this.getTitle(), '*'));
            this.setTitle(this.getTitle() + NON_EDITABLE_POSTFIX_STR);
        }
        this.saveable = flag;
    }

    public boolean getSaveable() {
        return this.saveable;
    }

    protected synchronized void removeNonEditablePostfix() {
        String title = this.getTitle().replaceAll("( \\[NOT EDITABLE\\])", "");
        this.setTitle(title);
    }

    protected String removeNonEditablePostfix(String str) {
        return str.replaceAll("( \\[NOT EDITABLE\\])", "");
    }

    public String getRawTitle() {
        String title = this.getTitle().replaceAll("( \\[NOT EDITABLE\\])", "");
        return title.replaceAll("\\*", "").trim();
    }

    public int confirmSave(String prompt) {
        int response = JOptionPane.showConfirmDialog(KDesktop.desktopPane, prompt + " \"" + TextUtils.remove(this.getTitle(), '*') + "\"");
        switch (response) {
            case 0: {
                this.saveFile();
                break;
            }
            case 1: {
                break;
            }
        }
        return response;
    }

    public boolean saveFile() {
        return this.saveFile(1);
    }

    public void setSleep(boolean f) {
        this.doSleep = f;
    }

    @Override
    public void writeToPrefs() {
    }

    @Override
    public void readFromPrefs() {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        Object oldvalue = e.getOldValue();
        KAbstractWindow frame = (KAbstractWindow)e.getSource();
        if (name.equals("closed") && (Boolean)value == Boolean.TRUE && this.isTouched) {
            if (this.isTouched && this.saveable) {
                int response = JOptionPane.showConfirmDialog(KDesktop.desktopPane, "Save Document \"" + TextUtils.remove(this.getTitle(), '*') + "\"");
                switch (response) {
                    case 0: {
                        this.saveFile();
                        break;
                    }
                    case 1: {
                        this.isTouched = false;
                        return;
                    }
                    case -1: 
                    case 2: {
                        throw new PropertyVetoException("Cancelled by user", e);
                    }
                }
            }
            if (this.mayaClient != null) {
                this.mayaClient = null;
            }
            if (this.cutterClient != null) {
                this.cutterClient = null;
            }
            if (this.houdiniClient != null) {
                this.houdiniClient = null;
            }
        }
        if (this.doSleep && name.equals("selected") && (Boolean)value == Boolean.TRUE) {
            throw new PropertyVetoException("Model Mode is Active", e);
        }
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (e.getSource() instanceof KAbstractWindow) {
            KAbstractWindow src = (KAbstractWindow)e.getSource();
            ExtendedDesktopPane desktopPane = KDesktop.desktopPane;
            int index = src.isSelected() ? 1 : 0;
            this.next = KDesktop.getWindowAtIndex(JDesktopPane.getLayer(src), index);
            if (this.next instanceof HTMLWindow) {
                this.next = KDesktop.getWindowAtIndex(JDesktopPane.getLayer(src), ++index);
            }
            KDesktop.updateRecentMenu();
        } else {
            Cutter.setLog("    Error: KAbstractWindow.internalFrameClosing(). e.getSource has returned an object");
            Cutter.setLog("    of a class called " + e.getSource().getClass().getName() + ". It was expecting an object of class KAbstractWindow");
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        this.writeToPrefs();
        if (this.next != null && this.next.isVisible() && !this.next.isIcon()) {
            KDesktop.toFront(this.next);
        }
        if (this.windowMenuItem != null) {
            KDesktop.removeWindowMenuItem(this.windowMenuItem);
        }
        this.file = null;
        this.prevFile = null;
        this.next = null;
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
    }

    protected KAbstractWindow getNextWindow() {
        return this.next;
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
        KAbstractWindow window = KDesktop.getWindowAtIndex(ExtendedDesktopPane.getLayer(this), 0);
        if (!window.isVisible()) {
            return;
        }
        KDesktop.toFront(window);
    }

    public JComponent getTitlePanel() {
        return ((BasicInternalFrameUI)this.getUI()).getNorthPane();
    }

    public void iconifySelf() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        KAbstractWindow.this.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            });
            this.setIcon(true);
        }
        catch (PropertyVetoException ex) {
            Cutter.setLog("    Exception: KAbstractWindow.iconifySelf() - " + ex.toString());
        }
    }

    public void deIconifySelf() {
        try {
            this.setIcon(false);
        }
        catch (PropertyVetoException ex) {
            Cutter.setLog("    Exception: KAbstractWindow.deIconifySelf() - " + ex.toString());
        }
    }

    public void resizeFrameTo(Rectangle rect) {
        DesktopManager manager = KDesktop.getDesktopManager();
        manager.resizeFrame(this, rect.x, rect.y, rect.width, rect.height);
    }

    public boolean addCutterClient(String serverIP, int portID, String localIP) {
        try {
            this.cutterClient = new KClient(serverIP, portID, localIP, this);
        }
        catch (Exception e) {
            Cutter.setLog("    KAbstractWindow.addCutterClient(): " + e);
            Cutter.setLog("        serverIP:" + serverIP);
            Cutter.setLog("        portID:" + portID + "");
            Cutter.setLog("        localIP:" + localIP);
            this.cutterClient = null;
            return false;
        }
        this.cutterClient.start();
        this.cutterClient.requestData();
        return true;
    }

    public void removeCutterClient() {
        if (this.cutterClient != null) {
            this.cutterClient.close();
        }
        this.cutterClient = null;
    }

    public String addMayaClient(String serverIP, int portID) {
        Client c = Client.getOpenPort(serverIP, portID);
        if (c != null) {
            Cutter.setLog("    Info:KAbstractWindow.addMayaClient(" + serverIP + ", " + portID + ").\n          Will use the port that is already open.");
            this.mayaClient = c;
            return "";
        }
        try {
            Cutter.setLog("    Info:KAbstractWindow.addMayaClient(" + serverIP + ", " + portID + ").\n          Will open a new port.");
            this.mayaClient = new Client("localhost", portID);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:KAbstractWindow.addMayaClient() - " + e);
            this.mayaClient = null;
            return e.toString();
        }
        if (this.mayaClient != null) {
            this.mayaClient.start();
            return "";
        }
        return CANNOT_CONNECT_TO_CLIENT;
    }

    public void removeMayaClient() {
        if (this.mayaClient != null) {
            this.mayaClient.close();
        }
        this.mayaClient = null;
        Cutter.setLog("    Info:KAbstractWindow.removeMayaClient table size is " + Client.tableSize());
    }

    public String addHoudiniClient(String serverIP, int portID) {
        try {
            this.houdiniClient = new Client(serverIP, portID);
            this.houdiniClient.isHoudini = true;
        }
        catch (Exception e) {
            this.houdiniClient = null;
            return e.toString();
        }
        if (this.houdiniClient != null) {
            this.houdiniClient.start();
            return "";
        }
        return CANNOT_CONNECT_TO_CLIENT;
    }

    public void removeHoudiniClient() {
        if (this.houdiniClient != null) {
            this.houdiniClient.close();
        }
        this.houdiniClient = null;
    }

    public void sendMelToMayaClient(String selection) {
    }

    public void sendMelToMayaClient() {
    }

    public void sendPythonToMayaClient(String cmd) {
    }

    public Client getMayaClient() {
        return this.mayaClient;
    }

    public void sendToHoudiniClient(String selection) {
    }

    public void sendToHoudiniClient() {
    }

    @Override
    public void portMessage(PortEvent event) {
    }

    public Rectangle getHistoryWindowRect() {
        return null;
    }

    public void setHistoryWindowRect(Rectangle rect) {
    }

    public abstract void setClosePolicy();

    public abstract boolean saveFile(int var1);

    public boolean addToHistory() {
        return false;
    }

    public void saveHistory(File file) {
    }

    public boolean hasHistory() {
        return false;
    }

    static {
        try {
            Field[] fields = new Field[]{KAbstractWindow.class.getDeclaredField("_finalize")};
            Cutter.addDebug(KAbstractWindow.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: KAbstractWindow.static - " + ex.toString());
        }
        CANNOT_CONNECT_TO_CLIENT = "Cannot connect to client";
    }

    public class WindowMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private KAbstractWindow window;

        public WindowMenuItem() {
            super(KAbstractWindow.this.getTitle());
            this.window = null;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean doForce = true;
                    KDesktop.toFront(WindowMenuItem.this.window, doForce);
                }
            });
        }

        private void setWindow(KAbstractWindow window) {
            if (window == null) {
                return;
            }
            this.window = window;
            String t = window.getTitle();
            t = KAbstractWindow.this.removeNonEditablePostfix(t);
            this.setText(t);
        }

        public KAbstractWindow getAbstractWindow() {
            return this.window;
        }

        public boolean equals(KAbstractWindow w) {
            return this.window == w;
        }
    }
}

