/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import ClientServer.ClientServer.client.PortEvent;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KTextField.KEscapeEncodedField;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Window.KWindow.KAbstractWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DesktopManager;
import javax.swing.JLayeredPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameEvent;
import javax.swing.undo.UndoManager;

public class KLineEditorWindow
extends KAbstractWindow
implements Serializable {
    public static boolean isInUse = false;
    public static int prevHeight = -1;
    public static int prevWidth = -1;
    private static State state = null;
    private static int MIN_WINDOW_HEIGHT;
    private static int MAX_WINDOW_HEIGHT;
    private static int MIN_CONTENT_HEIGHT;
    private static int MAX_CONTENT_HEIGHT;
    public JTextField textfield = null;
    public KTextField srcfield = null;
    private KTitledPanel panel;
    private int initialContentPaneHeight = -1;
    private int initialFontSize;
    private Color originalBackcolor;
    public boolean doDeactivateDesktop = true;
    public boolean desktopHasBeenDeactivated = false;
    static final String uiClassID = "KLineEditorWindowUI";
    private Action closeWindowAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            block3: {
                Dimension desk = KAbstractDesktop.getDesktopSize();
                int width = KLineEditorWindow.this.getWidth();
                boolean tooBig = false;
                if (width > desk.width) {
                    tooBig = true;
                    width = desk.width - 20;
                    KLineEditorWindow.this.reshape(10, KLineEditorWindow.this.getY(), width, KLineEditorWindow.this.getHeight());
                }
                try {
                    KLineEditorWindow.this.setClosed(true);
                }
                catch (PropertyVetoException ee) {
                    if (!Cutter.input.debug) break block3;
                    Cutter.setLog("    Debug:KLineEditorWindow.CloseDocAction() exception");
                    Cutter.setLog("          " + ee.toString());
                }
            }
        }
    };
    int defaultHeight;
    boolean virgin = true;

    public KLineEditorWindow(KTextField srcfield) {
        this(srcfield, true);
    }

    public KLineEditorWindow(KTextField srcfield, boolean shouldDeactivateDesktop) {
        super("Line Editor", true, true, false, false, JLayeredPane.MODAL_LAYER);
        this.doSleep = false;
        this.doDeactivateDesktop = shouldDeactivateDesktop;
        this.srcfield = srcfield;
        isInUse = true;
        String panelLabel = "";
        if (srcfield.modelDialogPanelText != null) {
            panelLabel = srcfield.modelDialogPanelText.trim();
        }
        panelLabel = panelLabel == null || panelLabel.length() == 0 ? "" : " " + panelLabel + " ";
        this.panel = new KTitledPanel(panelLabel);
        this.textfield = new JTextField(srcfield.getSelectedText());
        this.textfield.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 1 && KLineEditorWindow.this.textfield.getBackground().equals(KEscapeEncodedField.VERIFICATION_FAILURE_COLOR)) {
                    KLineEditorWindow.this.textfield.setBackground(Color.white);
                }
            }
        });
        Font font = BBxt.getFont();
        if (font.getSize() < 10) {
            font = new Font(font.getName(), font.getStyle(), 10);
        } else if (font.getSize() > 48) {
            font = new Font(font.getName(), font.getStyle(), 48);
        }
        this.textfield.setFont(font);
        this.initialFontSize = this.textfield.getFont().getSize();
        int count = this.getColumnCount(this.textfield.getFont());
        this.textfield.setColumns(count + 4);
        this.textfield.setBackground(Cutter.PALE_YELLOW);
        Insets in = this.textfield.getMargin();
        int bottom = 0;
        this.textfield.setMargin(new Insets(in.top, in.left, bottom, in.right));
        this.panel.setHelpPanelVisibility(false);
        this.panel.add(this.textfield, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(-2, 3, 5, 3)));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        contentPane.add((Component)this.panel, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(3, 3, 3, 3)));
        this.pack();
        this.setVisible(true);
        if (state != null) {
            this.initialContentPaneHeight = KLineEditorWindow.state.initialContentPaneHeight;
            this.initialFontSize = KLineEditorWindow.state.initialFontSize;
            this.reshape(KLineEditorWindow.state.x, KLineEditorWindow.state.y, KLineEditorWindow.state.width, KLineEditorWindow.state.height);
            this.reshape(KLineEditorWindow.state.x, KLineEditorWindow.state.y, KLineEditorWindow.state.width, KLineEditorWindow.state.height);
        } else {
            this.initialContentPaneHeight = contentPane.getHeight();
        }
        if (this.doDeactivateDesktop) {
            KAbstractDesktop.deactivateAllWindows();
            KAbstractDesktop.deactivateAllPalettes();
            KDesktop.disableAllMenuItems();
            this.desktopHasBeenDeactivated = true;
        }
        srcfield.setEnabled(true);
        srcfield.setEditable(false);
        this.originalBackcolor = srcfield.getBackground();
        srcfield.setBackground(Cutter.PALE_YELLOW);
        this.setEscKeyStroke();
    }

    private void setEscKeyStroke() {
        this.getRootPane().registerKeyboardAction(this.closeWindowAction, "", KeyStroke.getKeyStroke(27, 0), 2);
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        int delta = this.getHeight() - this.contentPane.getHeight();
        MIN_WINDOW_HEIGHT = MIN_CONTENT_HEIGHT + delta;
        MAX_WINDOW_HEIGHT = MAX_CONTENT_HEIGHT + delta;
        if (height > MAX_WINDOW_HEIGHT) {
            this.reshape(x, y, width, MAX_WINDOW_HEIGHT);
            return;
        }
        if (height < MIN_WINDOW_HEIGHT) {
            this.reshape(x, y, width, MIN_WINDOW_HEIGHT);
            return;
        }
        if (this.virgin) {
            super.reshape(x, y, width, height);
            this.virgin = false;
            this.defaultHeight = height;
            DesktopManager manager = KAbstractDesktop.desktopPane.getDesktopManager();
            Dimension deskSize = KAbstractDesktop.desktopPane.getSize();
            this.setPosition(manager, deskSize, width, height);
        } else {
            int currentHeight = this.contentPane.getHeight();
            int fsize = this.initialFontSize + (currentHeight - this.initialContentPaneHeight);
            if (this.textfield != null && this.initialContentPaneHeight != -1) {
                Font f = this.textfield.getFont();
                this.textfield.setFont(new Font(f.getName(), f.getStyle(), fsize));
                int bottom = 0;
                Insets in = this.textfield.getMargin();
                this.textfield.setMargin(new Insets(in.top, in.left, bottom, in.right));
            }
            super.reshape(x, y, width, height);
        }
    }

    private int getColumnCount(Font font) {
        String selectedText;
        FontMetrics fm = this.getFontMetrics(font);
        int count = 10;
        String string = selectedText = this.srcfield == null ? "abcdefghi" : this.srcfield.getSelectedText();
        if (selectedText.trim().length() < "abcdefghi".length()) {
            selectedText = "abcdefghi";
        }
        count = fm == null ? 10 : fm.stringWidth(selectedText) / fm.stringWidth("W");
        return count;
    }

    private void ___LOOK_AND_FEEL________() {
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected void setPosition(DesktopManager manager, Dimension desk, int width, int height) {
        int vOffset = desk.height / 4;
        manager.setBoundsForFrame(this, desk.width / 2 - width / 2, desk.height / 2 - height / 2 - vOffset, width, height);
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
        Dimension desk = KAbstractDesktop.getDesktopSize();
        int width = this.getWidth();
        boolean tooBig = false;
        if (width > desk.width) {
            tooBig = true;
            width = desk.width - 20;
            this.reshape(10, this.getY(), width, this.getHeight());
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        super.internalFrameClosed(e);
        KAbstractDesktop.activateAllWindows();
        KAbstractDesktop.activateAllPalettes();
        KDesktop.enableAllMenuItems();
        if (this.srcfield != null) {
            this.srcfield.setEditable(true);
            this.srcfield.setBackground(this.originalBackcolor);
            if (this.textfield.getText().length() > 0) {
                this.srcfield.setTextFromLineEditor(this.textfield.getText());
            }
        }
        isInUse = false;
        this.srcfield.popupLineEditor = null;
        this.srcfield.requestFocus();
        this.srcfield.selectAll();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (this.srcfield == null) {
            return;
        }
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        KAbstractWindow frame = (KAbstractWindow)e.getSource();
        if (name.equals("closed") && (Boolean)value == Boolean.TRUE) {
            if (this.srcfield.verify(this.textfield.getText())) {
                this.textfield.setBackground(Color.white);
                return;
            }
            this.textfield.setBackground(KEscapeEncodedField.VERIFICATION_FAILURE_COLOR);
            throw new PropertyVetoException("Text is unacceptable", e);
        }
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        state = new State();
        KLineEditorWindow.state.x = this.getX();
        KLineEditorWindow.state.y = this.getY();
        KLineEditorWindow.state.initialContentPaneHeight = this.initialContentPaneHeight;
        KLineEditorWindow.state.initialFontSize = this.initialFontSize;
        KLineEditorWindow.state.height = this.getHeight();
        KLineEditorWindow.state.width = this.getWidth();
    }

    @Override
    public void setFile(File file) {
    }

    @Override
    public boolean saveFile(int mode) {
        return true;
    }

    public UndoManager getUndoManager() {
        return null;
    }

    @Override
    public void setClosePolicy() {
        this.setDefaultCloseOperation(2);
    }

    @Override
    public boolean addToHistory() {
        return false;
    }

    @Override
    public void portMessage(PortEvent event) {
    }

    static {
        MIN_CONTENT_HEIGHT = 34;
        MAX_CONTENT_HEIGHT = 200;
    }

    public class State {
        public int x;
        public int y;
        public int width;
        public int height;
        public int initialContentPaneHeight;
        public int initialFontSize;
    }
}

