/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Tools.KTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.DesktopManager;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class KScaleableTextWindow
extends KTools {
    private static final long serialVersionUID = 1L;
    static Hashtable<String, Font> LUT = new Hashtable();
    static int MIN_LINE_HT = 5;
    static int MAX_LINE_HT = 60;
    private static KScaleableTextWindow instance = null;
    public JTextArea textArea = new JTextArea();
    private int maxContentHeight = 600;
    private int initialLineHeight = -1;
    private int minContentHeight = -1;
    private Font font = null;
    private int initialFontSize = -1;
    private Font activeFont = null;
    private int numLines = -1;
    static boolean isInit = true;
    int defaultHeight;
    boolean virgin = true;

    static void makeLUT(Font font) {
        for (int n = MIN_LINE_HT; n <= MAX_LINE_HT; ++n) {
            Font f = new Font(font.getName(), font.getStyle(), n);
            FontMetrics metrics = new KScaleableTextWindow().getFontMetrics(f);
            LUT.put("" + metrics.getHeight(), new Font(f.getName(), f.getStyle(), n));
        }
    }

    public static KScaleableTextWindow getInstance() {
        if (instance == null) {
            instance = new KScaleableTextWindow();
        }
        if (!instance.isVisible()) {
            instance.showSelf();
        }
        return instance;
    }

    private KScaleableTextWindow() {
        super("Help Info", true);
        this.contentPane.add((Component)this.textArea, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        KScaleableTextWindow.makeLUT(this.textArea.getFont());
        this.font = this.textArea.getFont();
        FontMetrics fm = this.getFontMetrics(this.font);
        this.initialLineHeight = fm.getHeight();
        this.initialFontSize = this.textArea.getFont().getSize();
        this.setTitle(this.title);
        this.setVisible(false);
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(5, 5, 5, 5));
        this.textArea.setBackground(Cutter.PALE_YELLOW);
        this.pack();
        this.setInitialPosition();
    }

    public void setText(String str) {
        this.numLines = this.countLines(str);
        this.minContentHeight = this.initialLineHeight * this.numLines;
        this.textArea.setText(str);
        this.textArea.setFont(this.font);
        this.pack();
        if (isInit) {
            DesktopManager manager = KAbstractDesktop.desktopPane.getDesktopManager();
            Dimension deskSize = KAbstractDesktop.desktopPane.getSize();
            this.setPosition(manager, deskSize, this.getWidth(), this.getHeight());
            isInit = false;
        }
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        if (this.numLines == -1) {
            super.reshape(x, y, width, height);
            return;
        }
        int delta = this.getHeight() - this.contentPane.getHeight();
        if (height >= this.maxContentHeight + delta) {
            super.reshape(x, y, width, this.maxContentHeight + delta + 5);
            return;
        }
        if (height <= this.minContentHeight + delta) {
            this.textArea.setFont(this.font);
            this.activeFont = this.font;
            super.reshape(x, y, width, this.minContentHeight + delta + 5);
            return;
        }
        int h = this.contentPane.getHeight() / this.numLines;
        Font f = LUT.get("" + h);
        if (f == null) {
            super.reshape(x, y, width, height);
            return;
        }
        if (f.getSize() < this.initialFontSize) {
            f = new Font(f.getName(), f.getStyle(), this.initialFontSize);
        }
        this.activeFont = f;
        this.textArea.setFont(f);
        super.reshape(x, y, width, height);
    }

    protected void setPosition(DesktopManager manager, Dimension desk, int width, int height) {
        int vOffset = desk.height / 4;
        manager.setBoundsForFrame(this, desk.width / 2 - width / 2, desk.height / 2 - height / 2 - vOffset, width, height);
    }

    public int countLines(String str) {
        int count = 0;
        for (int n = 0; n < str.length(); ++n) {
            if (str.charAt(n) != '\n') continue;
            ++count;
        }
        return ++count;
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void toolSelectionHappened() {
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    public class State {
        public int x;
        public int y;
        public int width;
        public int height;
        public int initialContentPaneHeight;
        public int initialFontSize;
    }
}

