/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import History.HistoryListener;
import UI_Components.GBC;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Dialogs.EditHistoryDialog;
import UI_Dialogs.PrefsHistoryDialog;
import UI_Dialogs.ViewHistoryCatalogDialog;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.Panels.HistoryInfoPanel.HistoryInfoPanel;
import UI_Window.Panels.WindowInfoPanel.LineFieldPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.InternalFrameEvent;

public class KTextHistoryWindow
extends KAbstractTextWindow
implements HistoryListener {
    private static final long serialVersionUID = 1L;
    public static final String HISTORY_PREFIX = "History: ";
    private OptionsMenu optionsMenu = null;
    public JPanel leftMarginPanel = new JPanel();
    private JPanel lowerPanel = new JPanel();
    private LineFieldPanel lineFieldPanel = null;
    private KAbstractTextWindow owner = null;
    private HistoryInfoPanel historyInfoPanel;

    private KTextHistoryWindow(KAbstractTextWindow owner) {
        super(HISTORY_PREFIX + owner.getTitle(), true, true, true, true);
        this.owner = owner;
        super.commonInit();
        this.initGUI();
    }

    public String getOwnersText() {
        return this.owner.getAllText();
    }

    public String getOwnersTitle() {
        return this.owner.getTitle();
    }

    public KAbstractTextWindow getOwnersWindow() {
        return this.owner;
    }

    public File getOwnersFile() {
        return this.owner.getFile();
    }

    private void initGUI() {
        this.lineFieldPanel = new LineFieldPanel(this);
        this.historyInfoPanel = new HistoryInfoPanel(this.owner, this);
        this.getTextPane().addCaretListener(this.lineFieldPanel);
        JScrollPane scroller = new JScrollPane();
        JViewport port = scroller.getViewport();
        this.getTextPane().setBorder(BorderFactory.createEmptyBorder());
        this.getTextPane().setEditable(false);
        port.add(this.getTextPane());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", this.historyInfoPanel);
        this.lowerPanel.setBorder(BorderFactory.createEmptyBorder());
        this.lowerPanel.setLayout(new GridBagLayout());
        this.lowerPanel.add((Component)scroller, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        this.lowerPanel.add((Component)this.lineFieldPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 11, new Insets(0, 0, 0, 0)));
        this.getContentPane().add("Center", this.lowerPanel);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.optionsMenu = new OptionsMenu();
        menuBar.add(this.optionsMenu);
        this.removeTouchListener();
        this.lockTitle(true);
        this.setSaveable(false);
        KDesktop.removeWindowMenuItem(this.windowMenuItem);
        this.getTextPane().setBackground(new Color(215, 215, 215));
        this.setVisible(true);
    }

    @Override
    public void historyEvent() {
        this.setVersion();
        this.setEditFields();
    }

    public void setVersion() {
        String text = "" + (this.owner.getHistoryMarker() + 1) + " of " + this.owner.getHistorySize() + " [at " + this.owner.getHistoryAt(this.owner.getHistoryMarker())[1] + "]";
        this.historyInfoPanel.setVersion(text);
    }

    public void setEditFields() {
        this.historyInfoPanel.setEditFields(1, this.owner.getHistoryMarker() + 1);
    }

    public void doFocus() {
    }

    @Override
    public void writeToPrefs() {
    }

    @Override
    public void readFromPrefs() {
    }

    @Override
    public void setClosePolicy() {
        this.setDefaultCloseOperation(0);
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        this.setVisible(false);
        KAbstractWindow next = KAbstractDesktop.getWindowAtIndex(JLayeredPane.getLayer(this), 1);
        KAbstractDesktop.toFront(next);
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        super.internalFrameClosed(e);
    }

    public void preDispose() {
        this.owner = null;
    }

    public class OptionsMenu
    extends JMenu {
        private JMenuItem editHistorylItem;
        private JMenuItem viewCatelogItem;
        private JMenuItem prefHistorylItem;

        public OptionsMenu() {
            super("Options");
            this.editHistorylItem = new JMenuItem("Remove History...");
            this.viewCatelogItem = new JMenuItem("Get Info");
            this.prefHistorylItem = new JMenuItem("Preferences...");
            ActionListener editAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditHistoryDialog edit = new EditHistoryDialog(KTextHistoryWindow.this.owner, KTextHistoryWindow.this);
                    edit.showSelf();
                }
            };
            this.editHistorylItem.addActionListener(editAction);
            this.editHistorylItem.setEnabled(true);
            this.add(this.editHistorylItem);
            ActionListener viewHistoryAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ViewHistoryCatalogDialog view = new ViewHistoryCatalogDialog(KTextHistoryWindow.this.owner.getHistoryCatalog());
                    view.showSelf();
                }
            };
            this.viewCatelogItem.addActionListener(viewHistoryAction);
            this.viewCatelogItem.setEnabled(true);
            this.add(this.viewCatelogItem);
            this.addSeparator();
            ActionListener prefAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrefsHistoryDialog edit = new PrefsHistoryDialog(KTextHistoryWindow.this.owner, KTextHistoryWindow.this);
                    edit.showSelf();
                }
            };
            this.prefHistorylItem.addActionListener(prefAction);
            this.prefHistorylItem.setEnabled(true);
            this.add(this.prefHistorylItem);
        }
    }

    public class ForewardAction
    extends AbstractAction {
        public ForewardAction() {
            super("back");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] history = KTextHistoryWindow.this.owner.getNextHistory();
            if (history == null) {
                return;
            }
            KTextHistoryWindow.this.deleteAllText();
            KTextHistoryWindow.this.setText(history[0]);
            KTextHistoryWindow.this.historyInfoPanel.setVersion("" + history[2] + " of " + history[3] + " [at " + history[1] + "]");
            KTextHistoryWindow.this.setSelection(0, 0);
        }
    }

    public class BackAction
    extends AbstractAction {
        public BackAction() {
            super("back");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] history = KTextHistoryWindow.this.owner.getPrevHistory();
            KTextHistoryWindow.this.deleteAllText();
            KTextHistoryWindow.this.setText(history[0]);
            KTextHistoryWindow.this.historyInfoPanel.setVersion(history[2] + " of " + history[3] + " [at " + history[1] + "]");
            KTextHistoryWindow.this.setSelection(0, 0);
        }
    }

    public static class Factory {
        private static Vector<KTextHistoryWindow> freelist = new Vector();

        public static boolean add(KTextHistoryWindow w) {
            if (freelist.contains(w)) {
                return false;
            }
            w.deleteAllText();
            freelist.addElement(w);
            return true;
        }

        public static KTextHistoryWindow get(KAbstractTextWindow owner) {
            if (freelist.size() > 0) {
                KTextHistoryWindow window = freelist.remove(0);
                window.owner = owner;
                window.setTitle(KTextHistoryWindow.HISTORY_PREFIX + owner.getTitle());
                KAbstractDesktop.desktopPane.addCascaded(window, KAbstractDesktop.WINDOW_LAYER);
                window.setVisible(false);
                window.setSelected(true);
                window.setIsOpen();
                return window;
            }
            return new KTextHistoryWindow(owner);
        }
    }
}

