/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import ClientServer.ClientServer.client.PortEvent;
import ClientServer.ClientServer.server.KServer;
import History.HistoryListener;
import History.KTextHistoryDB;
import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Net.TCPListener.TCPListener;
import UI_Script.CommandPort.HoudiniCommandPort;
import UI_Script.CommandPort.MayaCommandPort;
import UI_Script.Help.KCompletionManager;
import UI_Script.ScriptRegistry;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KDocument;
import UI_Text.KTextPane.KScrollPaneLayout;
import UI_Text.KTextPane.KTextPane;
import UI_Text.KTextPane.KTextUndoManager;
import UI_Text.KeyMaps.KKeyMaps;
import UI_Window.KWindow.FileLoader;
import UI_Window.KWindow.FileLoaderListener;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KWindowGlassPane;
import UI_Window.Panels.WindowInfoPanel.LineFieldPanel;
import UI_Window.Panels.WindowInfoPanel.LineNumberingPanel;
import UI_Window.Panels.WindowInfoPanel.WindowInfoPanel;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.MemoryUtils;
import Utilities.TextUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class KTextWindow
extends KAbstractTextWindow
implements FileLoaderListener {
    private static final long serialVersionUID = 1L;
    public JPanel leftMarginPanel = new JPanel();
    public WindowInfoPanel upperPanel;
    private JPanel lowerPanel = new JPanel();
    public JPanel noWrapPanel;
    public LineFieldPanel lineFieldPanel = null;
    public String prevTitle = "";
    public String prevSyntaxListener = "";
    private LineNumberingPanel lineNumberingPanel = null;
    private boolean initialLineNumberingVisibility = false;
    private String spanStrToBeAppliedAt_resumeState = null;
    private KWindowGlassPane glass;
    private boolean lineMarginIsVisible = false;
    public static boolean _finalize = true;
    private static boolean useWindowFactory;
    public static Hashtable<File, FileLoaderListener> tableOfLoadingListeners;
    public static int selectionBeginToBeAppliedAt_resumeState;
    public static int selectionEndToBeAppliedAt_resumeState;
    private JScrollPane scroller = new JScrollPane();
    public JViewport scrollerPort = this.scroller.getViewport();
    private KScrollPaneLayout scrollPaneLayout = new KScrollPaneLayout();
    private DocumentListener broadcastDocListener = null;

    @Override
    public void addHistoryListener(HistoryListener l) {
        if (this.historyDB != null) {
            this.historyDB.addListener(l);
        }
    }

    @Override
    public void removeHistoryListener(HistoryListener l) {
        if (this.historyDB != null) {
            this.historyDB.removeListener(l);
        }
    }

    public JPanel getLowerPanel() {
        return this.lowerPanel;
    }

    public JPanel getLineNumberingPanel() {
        return this.lineNumberingPanel;
    }

    public void setMarkedStyle(int line) {
        this.lineNumberingPanel.setMarkedStyle(line);
    }

    public static boolean okToOpenFile(File f) {
        if (f != null && f.isDirectory()) {
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "Cannot open the directory\n    " + f.getName() + "\n\n", "File Chooser Error", 0);
            return false;
        }
        MemoryUtils mu = new MemoryUtils();
        if (mu.memoryAvailable() < 10240L) {
            Object[] options = new String[]{"Cancel", "Continue"};
            boolean CANCEL = false;
            boolean CONTINUE = true;
            int result = JOptionPane.showOptionDialog(KAbstractDesktop.desktopPane, "Cutter can safely open documents up to 0.75MB\nin size. The document you are about to be open\n      \"" + f.getName() + "\"\nexceeds this size and may cause Cutter to crash.\nBefore attempting to open this file it would best\nto save the other documents.", "Potential Crash Warning", -1, 2, null, options, options[0]);
            switch (result) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public static KTextWindow addWindow(File f, boolean r, boolean c, boolean m, boolean i) {
        if (!KTextWindow.okToOpenFile(f)) {
            return null;
        }
        KTextWindow window = WindowFactory.get(f, true, true, true, true);
        if (window.getTextPane() != null) {
            window.getTextPane().requestFocus();
        }
        ScriptRegistry.loadCache(window);
        return window;
    }

    public static void addWindow(String t, String text, boolean r, boolean c, boolean m, boolean i) {
        KTextWindow window = WindowFactory.get(t, text, true, true, true, true);
        ScriptRegistry.loadCache(window);
    }

    public static KTextWindow[] addWindow(String title) {
        return KTextWindow.addWindow(true, title, null);
    }

    public static KTextWindow[] addWindow(String title, KFileFilter filter) {
        return KTextWindow.addWindow(true, title, null);
    }

    public static KTextWindow[] addWindow(KFileFilter filter) {
        return KTextWindow.addWindow(true, null, filter);
    }

    public static KTextWindow[] addWindow(boolean vis, String title) {
        return KTextWindow.addWindow(vis, title, null);
    }

    public static KTextWindow[] addWindow(boolean vis, String title, KFileFilter filter) {
        KTextWindow[] frames = null;
        if (title == null) {
            File[] files = KAbstractDesktop.openFileChooser(filter);
            if (files != null && files.length != 0) {
                frames = new KTextWindow[files.length];
                for (int n = 0; n < files.length; ++n) {
                    if (KTextWindow.okToOpenFile(files[n])) {
                        frames[n] = WindowFactory.get(files[n], true, true, true, true);
                        ScriptRegistry.loadCache(frames[n]);
                        if (frames[n].getTextPane() == null) continue;
                        frames[n].getTextPane().requestFocus();
                        continue;
                    }
                    frames[n] = null;
                }
                return frames;
            }
            return null;
        }
        frames = new KTextWindow[]{WindowFactory.get(title, true, true, true, true)};
        if (vis) {
            frames[0].setVisible(true);
            frames[0].setSelected(true);
            frames[0].getEditor().requestFocus();
        }
        String str = Preferences.get(Preferences.DOCUMENT_LINENUMBERING_ACTIVE);
        frames[0].showLineNumbering(str.equals("true"));
        frames[0].lineNumberingPanel.resume(false);
        return frames;
    }

    public static KTextWindow[] addWindows(File[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        KTextWindow[] frames = new KTextWindow[files.length];
        for (int n = 0; n < files.length; ++n) {
            if (KAbstractDesktop.windowExists(files[n])) continue;
            frames[n] = KTextWindow.okToOpenFile(files[n]) ? WindowFactory.get(files[n], true, true, true, true) : null;
            if (frames[n].getTextPane() == null) continue;
            frames[n].getTextPane().requestFocus();
        }
        return frames;
    }

    protected void initFocus() {
        this.getTextPane().setSelectionStart(0);
        this.getTextPane().setSelectionEnd(0);
    }

    private void readTextFromFile(KTextWindow window) {
        File file = window.getFile();
        this.wasExecutibleWhenOpened = file != null && file.exists() ? file.canExecute() : false;
        window.setVisible(true);
        FileLoader fileloader = new FileLoader(window == null ? this : window);
        this.textpane.undoManagerSuspendListening();
        fileloader.start();
    }

    @Override
    public void loadingFinished(File f) {
        this.resumeState();
        FileLoaderListener lis = KTextWindow.getFileListener(f);
        if (lis == null) {
            return;
        }
        if (lis == this) {
            return;
        }
        lis.loadingFinished(f);
        if (this.textpane != null) {
            this.textpane.grabFocus();
        }
    }

    public static synchronized void addFileListener(File f, FileLoaderListener l) {
        if (f == null) {
            return;
        }
        tableOfLoadingListeners.put(f, l);
    }

    private static synchronized FileLoaderListener getFileListener(File f) {
        if (f == null) {
            return null;
        }
        return tableOfLoadingListeners.get(f);
    }

    public static synchronized void removeFileListener(File f) {
        tableOfLoadingListeners.remove(f);
    }

    public void resumeState() {
        this.resumeTouchListener();
        this.resumePropertyChangeListener();
        this.getTextPane().undoManagerResumeListening();
        SyntaxListener syn = this.getTextPane().getSyntaxListener();
        syn.initStyles(this.getTextPane());
        this.getTextPane().resumeSyntaxColoration();
        this.setIsOpen();
        this.setTouched(false);
        this.getTextPane().invalidate();
        this.getTextPane().requestFocus();
        this.getTextPane().setEditable(true);
        this.getTextPane().requestFocus();
        this.getTextPane().parseAll();
        if (this.spanStrToBeAppliedAt_resumeState != null && this.spanStrToBeAppliedAt_resumeState.trim().length() > 0) {
            if (this.lineNumberingPanel != null) {
                this.lineNumberingPanel.initEditsFromString(this.spanStrToBeAppliedAt_resumeState);
            }
            this.spanStrToBeAppliedAt_resumeState = null;
        }
        if (selectionBeginToBeAppliedAt_resumeState > 0 && selectionEndToBeAppliedAt_resumeState > 0) {
            this.textpane.setSelectionStart(selectionBeginToBeAppliedAt_resumeState);
            this.textpane.setSelectionEnd(selectionEndToBeAppliedAt_resumeState);
            selectionEndToBeAppliedAt_resumeState = -1;
            selectionBeginToBeAppliedAt_resumeState = -1;
        }
        final String str = Preferences.get(Preferences.DOCUMENT_LINENUMBERING_ACTIVE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if ((str.equals("true") || KTextWindow.this.initialLineNumberingVisibility) && Cutter.input.debug) {
                    KTextWindow.this.showLineNumbering(true);
                    KTextWindow.this.lineNumberingPanel.resume(true);
                } else {
                    KTextWindow.this.showLineNumbering(false);
                    KTextWindow.this.lineNumberingPanel.resume(true);
                }
            }
        });
    }

    private KTextWindow(File f, boolean r, boolean c, boolean m, boolean i) {
        super(f, r, c, m, i);
        super.commonInit();
        this.initGUI();
        this.setPaperColor();
        this.setVisible(true);
        this.suspendTouchListener();
        this.suspendPropertyChangeListener();
        this.textpane.undoManagerSuspendListening();
        this.getTextPane().suspendSyntaxColoration();
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KTextWindow.this.readTextFromFile(KTextWindow.this);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public KTextWindow(String t, boolean r, boolean c, boolean m, boolean i) {
        super(t, r, c, m, i);
        super.commonInit();
        this.initGUI();
        this.setPaperColor();
        this.setVisible(true);
        this.setTouched(true);
        this.getTextPane().grabFocus();
    }

    private KTextWindow(String t, String text, boolean r, boolean c, boolean m, boolean i) {
        super(t, r, c, m, i);
        super.commonInit();
        this.initGUI();
        this.setPaperColor();
        this.getTextPane().updateSyntaxListener(t);
        this.getTextPane().suspendSyntaxColoration();
        this.getTextPane().undoManagerSuspendListening();
        this.setText(text);
        this.getTextPane().undoManagerResumeListening();
        this.getTextPane().resumeSyntaxColoration();
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KTextWindow.this.getTextPane().parseAll();
                    KTextWindow.this.setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getTextPane().grabFocus();
    }

    public KTextWindow(File zipfile) {
        super("untitled", true, true, true, true);
        super.commonInit();
        this.initGUI();
        this.setPaperColor();
        this.historyDB = new KTextHistoryDB();
        this.historyDB.restore(zipfile);
        String[] text = this.historyDB.getLastItem();
        String name = TextUtils.removeExtension(zipfile.getName());
        String ext = FileUtils.getExtension(name);
        name = ext != null ? "restored_" + name : "restored_" + name + ".txt";
        this.setTitle(name);
        this.getTextPane().updateSyntaxListener(name);
        this.getTextPane().suspendSyntaxColoration();
        this.textpane.undoManagerSuspendListening();
        if (text != null && text[0] != null) {
            this.setText(text[0]);
        }
        this.getTextPane().undoManagerResumeListening();
        this.getTextPane().resumeSyntaxColoration();
        this.setTouched(true);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KTextWindow.this.getTextPane().parseAll();
                    KTextWindow.this.setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getTextPane().grabFocus();
    }

    public JScrollPane getScrollPane() {
        return this.scroller;
    }

    public void suspendScrollPaneLayoutManager() {
        this.scrollPaneLayout.suspend();
    }

    public void resumeScrollPaneLayoutManager() {
        this.scrollPaneLayout.resume();
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getTextPane().setBorder(BorderFactory.createEmptyBorder());
        this.upperPanel = new WindowInfoPanel(this, this.title);
        this.getContentPane().add("North", this.upperPanel);
        this.lineFieldPanel = new LineFieldPanel(this);
        this.getTextPane().addCaretListener(this.lineFieldPanel);
        this.noWrapPanel = new JPanel(new BorderLayout());
        this.noWrapPanel.add(this.getTextPane());
        this.scrollerPort.add(this.noWrapPanel);
        this.lineNumberingPanel = new LineNumberingPanel(this.textpane, this.scroller);
        this.lineNumberingPanel.resume(true);
        this.scroller.setRowHeaderView(this.lineNumberingPanel);
        int unitval = this.scroller.getVerticalScrollBar().getUnitIncrement(1);
        this.scroller.getVerticalScrollBar().setUnitIncrement(8);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(8);
        this.lowerPanel.setBorder(BorderFactory.createEmptyBorder());
        this.lowerPanel.setLayout(new GridBagLayout());
        this.lowerPanel.add((Component)this.scroller, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        this.lowerPanel.add((Component)this.lineFieldPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
        this.getContentPane().add("Center", this.lowerPanel);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String name = e.getPropertyName();
                Object value = e.getNewValue();
                Object oldvalue = e.getOldValue();
                if (KTextWindow.this.getFile() == null) {
                    KTextWindow.this.uiSetPath("unsaved");
                } else {
                    KTextWindow.this.uiSetPath(KTextWindow.this.getFile().getPath());
                }
                if (name.equals("selected") && (Boolean)value == Boolean.TRUE) {
                    if (KTextWindow.this.getFile() != null && KTextWindow.this.upperPanel != null) {
                        KTextWindow.this.uiSetPath(KTextWindow.this.getFile().getPath());
                    }
                    if (KTextWindow.this.getFile() == null && KTextWindow.this.upperPanel != null) {
                        KTextWindow.this.uiSetPath("unsaved");
                    }
                    File file = KTextWindow.this.getFile();
                    String copy = "";
                    if (file != null) {
                        copy = TextUtils.remove(file.getPath(), '*');
                    }
                    if (copy.endsWith("mel") && KTextWindow.this.upperPanel.mayaMode) {
                        KTextWindow.this.upperPanel.setPeerButton("Send MEL");
                    } else {
                        KTextWindow.this.upperPanel.setPeerButton("Send");
                    }
                    KTextWindow.this.lineFieldPanel.historyEvent();
                }
            }
        });
        this.glass = new KWindowGlassPane(this.textpane);
        this.getRootPane().getGlassPane().setVisible(true);
        this.getRootPane().setGlassPane(this.glass);
        String str = Preferences.get(Preferences.DOCUMENT_LINENUMBERING_ACTIVE);
        this.showLineNumbering(str.equals("true"));
        this.lineNumberingPanel.resume(true);
    }

    public void setMarginWidth(int width) {
        this.lineFieldPanel.setMarginWidthField(width);
        this.glass.updateLine();
    }

    public void showLineNumbering(boolean flag) {
        this.lineNumberingPanel.setVisible(flag);
        this.validate();
        this.glass.updateLine();
    }

    public void showLineMargin() {
        this.lineMarginIsVisible = true;
        this.glass.showLine();
    }

    public void hideLineMargin() {
        this.lineMarginIsVisible = false;
        this.glass.hideLine();
    }

    public boolean lineMarginIsVisible() {
        return this.lineMarginIsVisible;
    }

    public void updateLineMargin() {
        if (this.glass != null) {
            this.validate();
            this.glass.updateLine();
        }
    }

    public void setMarkedLineSpans(String spanStr) {
        this.spanStrToBeAppliedAt_resumeState = spanStr;
    }

    public String getMarkedLineSpans() {
        if (this.lineNumberingPanel == null) {
            return null;
        }
        return this.lineNumberingPanel.dynamicEditsToString();
    }

    public void initLineNumberingVisibility(boolean flag) {
        this.initialLineNumberingVisibility = flag;
    }

    public boolean lineNumberingIsVisible() {
        if (this.lineNumberingPanel == null) {
            return false;
        }
        return this.lineNumberingPanel.isVisible();
    }

    @Override
    public void setTitle(String label) {
        if (this.getFile() != null) {
            this.uiSetPath(this.getFile().getPath());
        }
        super.setTitle(label);
    }

    @Override
    public boolean isEnabled() {
        return this.upperPanel == null ? false : this.upperPanel.isEnabled();
    }

    @Override
    protected void addWindowAppearanceListener() {
        super.addWindowAppearanceListener();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String name = e.getPropertyName();
                Object value = e.getNewValue();
                if (name.equals("selected")) {
                    if (KTextWindow.this.scroller != null) {
                        KTextWindow.this.scroller.getHorizontalScrollBar().setEnabled((Boolean)value);
                        KTextWindow.this.scroller.getVerticalScrollBar().setEnabled((Boolean)value);
                    }
                    if (KTextWindow.this.upperPanel != null) {
                        KTextWindow.this.upperPanel.setEnabled((Boolean)value);
                        KTextWindow.this.upperPanel.netPanel.setEnabled((Boolean)value);
                    }
                    if (KTextWindow.this.lineFieldPanel != null) {
                        KTextWindow.this.lineFieldPanel.setEnabled((Boolean)value);
                    }
                    ((BasicInternalFrameUI)KTextWindow.this.getUI()).getNorthPane().setEnabled((Boolean)value);
                    KTextWindow.this.setSelected((Boolean)value);
                    if (!((Boolean)value).booleanValue()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                KTextWindow.this.getTextPane().getKCaret().isFirstClick = true;
                                KTextWindow.this.getTextPane().getKCaret().paintDefocusedSelection();
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void writeToPrefs() {
        if (this.upperPanel != null) {
            this.upperPanel.saveSelf();
        }
    }

    @Override
    public void readFromPrefs() {
    }

    private void uiSetPath(String p) {
        if (this.upperPanel != null) {
            this.upperPanel.setPath(p);
        }
    }

    @Override
    public void setFontSize(int size) {
        if (this.upperPanel == null) {
            return;
        }
        this.upperPanel.setFontSize(size);
    }

    public void setFontStyle(String style) {
        if (this.upperPanel == null) {
            return;
        }
        this.upperPanel.setFontStyle(style);
    }

    @Override
    public void setFontName(String name) {
        if (this.getTextPane() == null) {
            return;
        }
        Font f = this.getTextPane().getFont();
        this.getTextPane().setFont(new Font(name, f.getStyle(), f.getSize()));
    }

    private void setSyntaxColors() {
        KTextPane textpane = this.getTextPane();
        SyntaxListener listener = null;
        if (textpane != null) {
            listener = textpane.getSyntaxListener();
        }
        if (listener != null) {
            listener.initStyles(textpane);
        }
    }

    public void setPaperColor() {
        String str = Preferences.get(Preferences.DOCUMENT_BACKGROUND_COLOR);
        Color outcolor = Color.white;
        if (str == null || str.trim().length() == 0) {
            this.getTextPane().setBackground(outcolor);
            return;
        }
        String[] comp = TextUtils.tokenize(str);
        if (comp == null) {
            this.getTextPane().setBackground(outcolor);
            return;
        }
        try {
            int r = Integer.parseInt(comp[0]);
            int g = Integer.parseInt(comp[1]);
            int b = Integer.parseInt(comp[2]);
            outcolor = new Color(r, g, b);
        }
        catch (Exception e) {
            Cutter.setLog("    Warning: KAbstractTextWindow.setBackground() - cannot get the users background\n                 color from prefs. The prefs string was \"" + str + "\"\n                 will use the default white color.");
            outcolor = Color.white;
        }
        this.getTextPane().setBackground(outcolor);
    }

    public void setCaretColors() {
        this.getTextPane().initCaretsDefaultColors();
    }

    public void setFontAttributes() {
        String prefSize = Preferences.get(Preferences.TEXT_FONT_SIZE);
        this.upperPanel.setFontSize(prefSize);
        String prefStyle = Preferences.get(Preferences.TEXT_FONT_WEIGHT);
        this.upperPanel.setFontStyle(prefStyle);
    }

    public boolean startBroadcasting(int portID) {
        try {
            this.broadcaster = new KServer(portID, this);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:KTextWindow.startBroadcasting()\n" + e.toString());
            this.broadcaster = null;
            return false;
        }
        if (this.broadcaster.canListenForClients) {
            this.broadcaster.start();
            this.canBroadcast = true;
        }
        this.broadcastDocListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                if (KTextWindow.this.broadcaster == null || !KTextWindow.this.broadcaster.canListenForClients) {
                    return;
                }
                String str = KTextWindow.this.getTextPane().getText();
                this.setSyntax(str);
                KTextWindow.this.broadcaster.sendTextToAll(str, KTextWindow.this.getTextPane().getSyntaxListenerClassName(KTextWindow.this.getTextPane()));
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                if (KTextWindow.this.broadcaster == null || !KTextWindow.this.broadcaster.canListenForClients) {
                    return;
                }
                String str = KTextWindow.this.getTextPane().getText();
                this.setSyntax(str);
                KTextWindow.this.broadcaster.sendTextToAll(str, KTextWindow.this.getTextPane().getSyntaxListenerClassName(KTextWindow.this.getTextPane()));
            }

            private void setSyntax(String str) {
            }
        };
        return true;
    }

    public void setBroadcastMode(int mode) {
        if (mode == 1) {
            this.addDocumentListener(this.broadcastDocListener);
        } else {
            this.removeDocumentListener(this.broadcastDocListener);
        }
        this.broadcastMode = mode;
    }

    public void stopBroadcasting() {
        if (this.broadcaster == null) {
            return;
        }
        this.broadcaster.stopAll();
        this.broadcaster.shutdown();
        this.broadcaster.canListenForClients = false;
        this.broadcaster = null;
        this.canBroadcast = false;
        if (this.broadcastMode == 1) {
            this.removeDocumentListener(this.broadcastDocListener);
        }
    }

    @Override
    public void sendMelToMayaClient() {
        int length = this.getTextPane().getSelectionEnd() - this.getTextPane().getSelectionStart();
        if (length == 0) {
            String allText = this.getText();
            this.sendMelToMayaClient(allText);
            return;
        }
        String selection = null;
        try {
            selection = this.getTextPane().getDocument().getText(this.getTextPane().getSelectionStart(), length);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: KTextWindow.sendToMayaClient() " + e);
            return;
        }
        if (selection != null) {
            this.sendMelToMayaClient(selection);
        }
    }

    @Override
    public void sendMelToMayaClient(String str) {
        MayaCommandPort maya = new MayaCommandPort(this, this.mayaClient);
        maya.sendStr(str);
    }

    @Override
    public void sendPythonToMayaClient(String str) {
        if (this.mayaClient != null) {
            this.mayaClient.sendPythonString(str);
        }
    }

    @Override
    public void sendToHoudiniClient() {
        int length = this.getTextPane().getSelectionEnd() - this.getTextPane().getSelectionStart();
        if (length == 0) {
            String allText = this.getText();
            this.sendToHoudiniClient(allText);
            return;
        }
        String selection = null;
        try {
            selection = this.getTextPane().getDocument().getText(this.getTextPane().getSelectionStart(), length);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: KTextWindow.sendToHoudiniClient() " + e);
            return;
        }
        if (selection != null) {
            this.sendToHoudiniClient(selection);
        }
    }

    @Override
    public void sendToHoudiniClient(String str) {
        HoudiniCommandPort houdini = new HoudiniCommandPort(this, this.houdiniClient);
        houdini.sendStr(str);
    }

    public void sendAllText() {
        if (this.broadcaster == null || !this.broadcaster.canListenForClients) {
            return;
        }
        Date startdate = new Date();
        long start = startdate.getTime();
        int num = this.broadcaster.sendTextToAll(this.getTextPane().getText(), this.getTextPane().getSyntaxListenerClassName(this.getTextPane()));
        Date enddate = new Date();
        long end = enddate.getTime();
        Cutter.setLog("    Info:KTextWindow.sendAllText() Sent " + this.getTextPane().getText().length() + " bytes to " + num + " clients in " + (end - start) + " milliseconds");
    }

    public void getText(StringBuffer dest) {
        dest.append(this.getText());
    }

    @Override
    public void portMessage(final PortEvent event) {
        if (event == null) {
            Cutter.setLog("KTextWindow.portMessage() received null event");
            return;
        }
        String peerSender = event.sender;
        String peerAddress = event.address;
        final String str = (String)event.data;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Cutter.input.debug) {
                    Cutter.setLog("    debug: KTextWindow.portMessage() event.syntaxType >" + event.syntaxType + "<");
                    Cutter.setLog("    debug: KTextWindow.portMessage() getTextPane().getSyntaxListenerClassName() >" + KTextWindow.this.getTextPane().getSyntaxListenerClassName(KTextWindow.this.getTextPane()) + "<");
                }
                if (KTextWindow.this.getTextPane().getSyntaxListenerClassName(KTextWindow.this.getTextPane()).equals(event.syntaxType)) {
                    if (Cutter.input.debug) {
                        Cutter.setLog("    debug: KTextWindow.portMessage() current syntaxListener is good - no change required");
                    }
                } else if (KTextWindow.this.getTextPane().getSyntaxListenerClassName(KTextWindow.this.getTextPane()).equals("KDefaultListener")) {
                    if (Cutter.input.debug) {
                        Cutter.setLog("    debug: KTextWindow.portMessage() current syntaxListener is KDefaultListener - no change required");
                    }
                } else {
                    if (Cutter.input.debug) {
                        Cutter.setLog("    debug: KTextWindow.portMessage() - assigning new syntaxListener");
                    }
                    try {
                        String ext = (String)Class.forName(event.syntaxType).getDeclaredField("fileExtension").get(null);
                        KTextWindow.this.setTitle(TextUtils.remove(KTextWindow.this.getTitle(), '*') + ext + '*');
                        KTextWindow.this.getTextPane().updateSyntaxListener(KTextWindow.this.getTitle());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                KTextWindow.this.setText(str);
            }
        });
    }

    public boolean startTCPListener(int portID) {
        try {
            this.tcpListener = new TCPListener(portID, this);
            this.tcpListener.start();
        }
        catch (IOException e) {
            this.tcpListener = null;
            Cutter.setLog("    Exception: KTextWindow.startTCPListener()\n" + e.toString());
            return false;
        }
        return true;
    }

    public void stopTCPListener() {
        if (this.tcpListener == null) {
            return;
        }
        this.tcpListener.stopAll();
        this.tcpListener.doStop();
        this.tcpListener = null;
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
        super.internalFrameOpened(e);
        this.initHistory();
        this.addHistoryListener(this.lineFieldPanel);
        if (this.lineFieldPanel != null) {
            this.lineFieldPanel.historyEvent();
            KTextPane ktp = this.getTextPane();
            if (ktp != null) {
                int line;
                int start = ktp.getSelectionStart();
                if (start <= 0) {
                    start = 1;
                }
                if ((line = BBxt.getLineNumberAtOffset(start)) <= 0) {
                    line = 1;
                }
                this.lineFieldPanel.setLineNumber(line);
            }
        }
        if (this.textpane != null) {
            this.textpane.requestFocus();
        }
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        super.internalFrameClosing(e);
        this.upperPanel.restoreToDefaults();
        KDesktop.lastFileClosed = this.getFile();
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        super.internalFrameClosed(e);
    }

    static {
        try {
            Field[] fields = new Field[]{KTextWindow.class.getDeclaredField("_finalize")};
            Cutter.addDebug(KTextWindow.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: KTextWindow.static - " + ex.toString());
        }
        useWindowFactory = true;
        tableOfLoadingListeners = new Hashtable();
        selectionBeginToBeAppliedAt_resumeState = -1;
        selectionEndToBeAppliedAt_resumeState = -1;
    }

    private static class WindowFactory {
        private static Vector<KTextWindow> freelist = new Vector();

        private WindowFactory() {
        }

        private static synchronized void activate(KTextWindow w) {
            w.resumeTouchListener();
            w.resumePropertyChangeListener();
            Document d = w.getTextPane().getDocument();
            if (d instanceof KDocument) {
                KDocument kd = (KDocument)d;
                KTextPane kt = w.getTextPane();
                KTextUndoManager undoManager = kd.addNewUndoManager(kt);
                undoManager.setDocument(kd);
            }
            w.getTextPane().resumeSyntaxColoration();
            if (EnvUtils.isLinuxEnvironment() && w.getTextPane() != null) {
                KKeyMaps.setDefaults(w.getTextPane());
            }
            w.getTextPane().hiliter.initHiliteColor();
            w.getTextPane().hiliter.initTokenizer(w.getTextPane().getSyntaxListener().tok);
            w.getTextPane().wordHiliter.initHiliteColor();
            w.getTextPane().wordHiliter.initTokenizer(w.getTextPane().getSyntaxListener().tok);
        }

        private static void printWindowInfo(KTextWindow window) {
            if (!Cutter.input.debug) {
                return;
            }
            Cutter.setLog("    Debug: KTextWindow.get(File or String)");
            Cutter.setLog("             [prevTitle = " + window.prevTitle + "]");
            Cutter.setLog("             [isTouched = " + window.isTouched + "]");
            Cutter.setLog("             [prevSyntax = " + window.prevSyntaxListener + "]");
            Cutter.setLog("             isEditable = " + window.getTextPane().isEditable());
        }

        private static synchronized boolean __add(KTextWindow w) {
            EventListener item;
            int n;
            System.gc();
            if (freelist.contains(w)) {
                Cutter.setLog("    Info:KTextWindow.add() - window already in freelist");
                return false;
            }
            w.prevTitle = w.getTitle();
            w.prevSyntaxListener = w.getTextPane().getSyntaxListenerClassName(w.getTextPane());
            w.prevFile = null;
            w.setFile(null);
            w.isTouched = false;
            w.lockTitle(false);
            w.wasExecutibleWhenOpened = false;
            w.textpane.undoManagerSuspendListening();
            MemoryUtils mu = new MemoryUtils();
            if (mu.memoryAvailable() < 2048L) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Runtime.getRuntime().gc();
                        }
                    });
                }
                catch (Exception ex) {
                    Cutter.setLog("    Warning:KTextWindow.add(KTextWindow) - insufficient memory to add window to freelist");
                }
                return false;
            }
            w.lineNumberingPanel.setDefaults();
            w.spanStrToBeAppliedAt_resumeState = null;
            w.suspendTouchListener();
            w.deleteAllText();
            if (w.canBeRecycled) {
                freelist.addElement(w);
            }
            w.suspendPropertyChangeListener();
            w.getTextPane().suspendSyntaxColoration();
            w.getTextPane().setEnabled(true);
            w.getTextPane().removeAllHelperPopUpTriggerListeners();
            w.getTextPane().replaceSpacesWithTabsOffered = false;
            w.getTextPane().doReplaceSpacesWithTabs = false;
            MouseListener[] mice = w.getTextPane().getMouseListeners();
            CaretListener[] cars = w.getTextPane().getCaretListeners();
            Vector<MouseListener> miceList = new Vector<MouseListener>();
            Vector<MouseListener> carsList = new Vector<MouseListener>();
            for (n = 0; n < mice.length; ++n) {
                item = mice[n];
                if (!(item instanceof KCompletionManager)) continue;
                miceList.add((MouseListener)item);
            }
            for (n = 0; n < miceList.size(); ++n) {
                w.getTextPane().removeMouseListener((MouseListener)miceList.elementAt(n));
            }
            for (n = 0; n < cars.length; ++n) {
                item = cars[n];
                if (!(item instanceof KCompletionManager)) continue;
                carsList.add((MouseListener)item);
            }
            for (n = 0; n < miceList.size(); ++n) {
                w.getTextPane().removeCaretListener((CaretListener)carsList.elementAt(n));
            }
            return true;
        }

        private static synchronized KTextWindow get(File f, boolean r, boolean c, boolean m, boolean i) {
            if (freelist.size() > 0) {
                KTextWindow window = freelist.remove(0);
                WindowFactory.printWindowInfo(window);
                window.setFile(f);
                KAbstractDesktop.desktopPane.addCascaded(window, KAbstractDesktop.WINDOW_LAYER);
                window.initHistory();
                window.addHistoryListener(window.lineFieldPanel);
                window.setPaperColor();
                window.setCaretColors();
                window.setSyntaxColors();
                window.getTextPane().updateSyntaxListener(f.getName());
                window.getTextPane().suspendSyntaxColoration();
                Document d = window.getTextPane().getDocument();
                if (d instanceof KDocument) {
                    KDocument kd = (KDocument)d;
                    KTextPane kt = window.getTextPane();
                    KTextUndoManager undoManager = kd.addNewUndoManager(kt);
                    undoManager.setDocument(kd);
                    kd.undoManagerSuspendListening();
                }
                window.resumePropertyChangeListener();
                window.setFontAttributes();
                window.readTextFromFile(window);
                window.getTextPane().setSelectionStart(0);
                window.getTextPane().setSelectionEnd(0);
                window.getTextPane().hiliter.initHiliteColor();
                window.getTextPane().hiliter.initTokenizer(window.getTextPane().getSyntaxListener().tok);
                return window;
            }
            return new KTextWindow(f, true, true, true, true);
        }

        private static synchronized KTextWindow get(String t, boolean r, boolean c, boolean m, boolean i) {
            if (freelist.size() > 0) {
                KTextWindow window = freelist.remove(0);
                WindowFactory.printWindowInfo(window);
                window.setTitle(t);
                KAbstractDesktop.desktopPane.addCascaded(window, KAbstractDesktop.WINDOW_LAYER);
                window.initHistory();
                window.getTextPane().updateSyntaxListener(t);
                WindowFactory.activate(window);
                window.setVisible(true);
                window.setSelected(true);
                window.setIsOpen();
                window.setTouched(true);
                window.getTextPane().setEditable(true);
                window.setPaperColor();
                window.setCaretColors();
                window.setSyntaxColors();
                window.setFontAttributes();
                window.getTextPane().grabFocus();
                return window;
            }
            return new KTextWindow(t, true, true, true, true);
        }

        private static synchronized KTextWindow get(String t, String text, boolean r, boolean c, boolean m, boolean i) {
            if (freelist.size() > 0) {
                KTextWindow window = freelist.remove(0);
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KTextWindow.get(title, text, bool, bool, bool)");
                    Cutter.setLog("             [prevTitle = " + window.prevTitle + "]");
                    Cutter.setLog("             [prevSyntax = " + window.prevSyntaxListener + "]");
                }
                window.setTitle(t);
                KAbstractDesktop.desktopPane.addCascaded(window, KAbstractDesktop.WINDOW_LAYER);
                WindowFactory.activate(window);
                window.setVisible(true);
                window.setSelected(true);
                window.setIsOpen();
                window.getTextPane().updateSyntaxListener(t);
                window.getTextPane().setEditable(true);
                window.setPaperColor();
                window.setCaretColors();
                window.setSyntaxColors();
                window.setFontAttributes();
                window.setText(text);
                Document d = window.getTextPane().getDocument();
                if (d instanceof KDocument) {
                    KDocument kd = (KDocument)d;
                    KTextPane kt = window.getTextPane();
                    KTextUndoManager undoManager = kd.addNewUndoManager(kt);
                    undoManager.setDocument(kd);
                    kd.undoManagerSuspendListening();
                }
                window.setSelection(0, 0);
                window.lineNumberingPanel.resume(false);
                return window;
            }
            return new KTextWindow(t, text, true, true, true, true);
        }
    }
}

