/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import UI_Desktop.Cutter;
import UI_Script.SyntaxListener;
import UI_Text.Style.KStyleContext;
import UI_Window.KWindow.KTextWindow;
import java.io.FileReader;
import java.io.LineNumberReader;
import javax.swing.text.BadLocationException;

class KTextWindowFileLoader
extends Thread {
    private static int OUTBLOCK_SIZE = 5120;
    private static int INBLOCK_SIZE = 51200;
    private static int BUFFERED_READ_SIZE = 51200;
    private static int WARNING_FILE_SIZE = 1024000;
    private KTextWindow window;

    public KTextWindowFileLoader(KTextWindow window) {
        super("FileLoader Thread");
        this.setPriority(4);
        this.window = window;
    }

    @Override
    public void run() {
        StringBuffer output = new StringBuffer(2048000);
        try {
            String str;
            if (this.window.getFile() == null) {
                Cutter.setLog("KTextWindowFileLoader.run() - file == null");
                return;
            }
            FileReader in = new FileReader(this.window.getFile());
            LineNumberReader lnr = new LineNumberReader(in);
            int linecount = 0;
            while ((str = lnr.readLine()) != null) {
                output.append(str).append('\n');
                if (++linecount % 1000 != 0) continue;
                KTextWindowFileLoader.sleep(10L);
            }
            lnr.close();
            in.close();
            in = null;
            lnr = null;
        }
        catch (Exception e) {
            Cutter.setLog("Error in KTextWindowFileLoader = " + e.toString());
            return;
        }
        if (output.length() > SyntaxListener.userMaxColoredLength) {
            KStyleContext sc = new KStyleContext();
            try {
                this.window.getTextPane().getStyledDocument().insertString(0, output.toString(), sc.plainStyle);
            }
            catch (BadLocationException e) {
                Cutter.setLog("    Exception: KTextWindowFileLoader.run()\n" + e.toString());
                return;
            }
        } else {
            this.window.getTextPane().setText(output.toString());
        }
        this.window.getTextPane().updateSyntaxListener(this.window.getFile().getName());
        this.window.resumeTouchListener();
        this.window.resumePropertyChangeListener();
        this.window.getTextPane().undoManagerResumeListening();
        this.window.getTextPane().resumeSyntaxColoration();
        this.window.setTouched(false);
        this.window.getTextPane().setSelectionStart(0);
        this.window.getTextPane().setSelectionEnd(0);
        this.window.getTextPane().requestFocus();
        this.window.getTextPane().setEditable(true);
        this.window.getTextPane().parseAll();
        this.window.setVisible(true);
        this.window.getTextPane().grabFocus();
        this.window.setIsOpen();
        this.window = null;
    }
}

