/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import Preferences.Preferences;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.NumberUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class KWindowGlassPane
extends JComponent {
    private boolean showLine = false;
    private int x;
    private int y;
    private int depth;
    private int marginwidth;
    private int marginWidth = 100;
    private String marginStr = "";
    private KTextPane textpane;
    private JPanel numberingPanel;
    private JPanel lowerPanel;
    private JPanel noWrapPanel;
    private JViewport scrollerPort;
    private Color lineColor = new Color(240, 140, 80);

    public KWindowGlassPane(KTextPane textpane) {
        this.setEnabled(true);
        this.setOpaque(false);
        this.setVisible(true);
        this.textpane = textpane;
        KAbstractTextWindow ktw = textpane.getFrame();
        this.numberingPanel = ((KTextWindow)ktw).getLineNumberingPanel();
        this.lowerPanel = ((KTextWindow)ktw).getLowerPanel();
        this.noWrapPanel = ((KTextWindow)ktw).noWrapPanel;
        this.scrollerPort = ((KTextWindow)ktw).scrollerPort;
    }

    public void showLine() {
        this.showLine = true;
        this.updateLine();
        this.repaint();
    }

    public void hideLine() {
        this.showLine = false;
        this.repaint();
    }

    public void updateLine() {
        this.x = this.numberingPanel.getWidth();
        this.y = this.lowerPanel.getBounds().y;
        this.depth = this.textpane.getBounds().height;
        this.lineColor = Preferences.getColor(Preferences.DOCUMENT_RIGHT_MARGIN_COLOR);
        String str = Preferences.get(Preferences.DOCUMENT_RIGHT_MARGIN_WIDTH);
        this.marginWidth = NumberUtils.strToInt(str, 100);
        StringBuffer b = new StringBuffer();
        for (int n = 0; n < this.marginWidth + 1; ++n) {
            b.append('A');
        }
        this.marginStr = b.toString();
        FontMetrics metrics = this.noWrapPanel.getFontMetrics(this.textpane.getFont());
        this.marginwidth = SwingUtilities.computeStringWidth(metrics, this.marginStr);
        this.repaint();
    }

    public int getMarginWidth() {
        return this.marginwidth;
    }

    @Override
    public void paint(Graphics g) {
        if (this.showLine) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.lineColor);
            g2.drawLine(this.marginwidth + this.x, this.y, this.marginwidth + this.x, this.scrollerPort.getBounds().height + this.y);
        }
    }
}

