/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.KWindow;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Script.Syntax;
import UI_Window.KWindow.KAbstractTextWindow;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.DesktopManager;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class LogFrame
extends KAbstractTextWindow {
    private static final long serialVersionUID = 1L;
    public static final String LOGNAME = "Log";
    private JPanel buttonPanel = new JPanel();
    private JPanel lowerPanel = new JPanel();
    public static DebugMenu debugMenu = new DebugMenu();
    private static JMenuBar menuBar = new JMenuBar();
    private static JTextArea textpane;
    private MemoryUseageTextField memory = new MemoryUseageTextField();
    static final String uiClassID = "ToolsUI";
    private boolean visible = true;
    private static int maxChars;

    public static ActionListener getExistingSyntaxAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int begin = BBxt.getSelectionStart();
                int end = BBxt.getSelectionEnd();
                Syntax syntax = BBxt.getExistingSyntaxAt(begin, end);
                Cutter.setLog("SYNTAX === [" + begin + "  " + end + "] ===========");
                Cutter.setLog(syntax.toString());
            }
        };
    }

    public LogFrame(String preText) {
        super(LOGNAME, true, true, false, true, KAbstractDesktop.LOG_LAYER);
        KDesktop.removeWindowMenuItem(this.windowMenuItem);
        textpane = new JTextArea();
        String fontname = Cutter.defaultTextPaneFontName;
        textpane.setFont(new Font(fontname, 0, 14));
        textpane.setMargin(new Insets(2, 5, 2, 1));
        textpane.setSelectionColor(Color.YELLOW);
        this.addVetoableChangeListener(this);
        this.initGUI();
        this.setVisible(false);
        textpane.setEditable(false);
        textpane.setTabSize(4);
        this.setText("    Launched at: " + TextUtils.getDateTime());
        this.setText(preText);
        textpane.setSelectionStart(0);
        textpane.setSelectionEnd(0);
        DesktopManager manager = KAbstractDesktop.getDesktopManager();
        Dimension desk = KAbstractDesktop.desktopPane.getSize();
        Rectangle bounds = this.getBounds(null);
        manager.setBoundsForFrame(this, desk.width / 2, 0, desk.width / 3, desk.height / 3);
        int[] pos = this.getPreferredPosition();
        manager.setBoundsForFrame(this, pos[0], pos[1], pos[2], pos[3]);
    }

    @Override
    public void setClosePolicy() {
        this.setDefaultCloseOperation(2);
    }

    public void initGUI() {
        this.setFrameIconAppearance();
        JScrollPane scroller = new JScrollPane();
        JViewport port = scroller.getViewport();
        port.add(textpane);
        JButton clearButton = new JButton("Clear");
        clearButton.setMargin(new Insets(0, 5, 0, 5));
        clearButton.setRequestFocusEnabled(false);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogFrame.this.clearText();
            }
        });
        this.lowerPanel.setBorder(BorderFactory.createEmptyBorder());
        this.lowerPanel.setLayout(new GridBagLayout());
        this.lowerPanel.add((Component)clearButton, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(2, 20, 2, 0)));
        this.lowerPanel.add((Component)this.memory, new GBC(1, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(2, 20, 2, 0)));
        this.lowerPanel.add((Component)scroller, new GBC(0, 1, 2, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        this.getContentPane().add("Center", this.lowerPanel);
    }

    private void ___LOOK_AND_FEEL________() {
    }

    private void ___WINDOW_APPEARANCE__METHODS________() {
    }

    private void setFrameIconAppearance() {
        this.setFrameIcon(null);
    }

    public void saveState() {
        Rectangle rect = this.getBounds();
        Preferences.write(Preferences.WINDOW_LOG_POSITION, rect.x + " " + rect.y + " " + rect.width + " " + rect.height);
        String visible = this.isVisible() ? "open" : "closed";
        Preferences.write(Preferences.WINDOW_LOG, visible);
    }

    protected int[] getPreferredPosition() {
        Dimension desk = KAbstractDesktop.desktopPane.getSize();
        Dimension toolsize = this.getSize();
        int x = desk.width / 2;
        int y = 0;
        int w = toolsize.width;
        int h = toolsize.height;
        String str = Preferences.get(Preferences.WINDOW_LOG_POSITION);
        if (str == null || str.trim().length() == 0) {
            int[] out = new int[]{x, y, w, h};
            return out;
        }
        String[] pos = TextUtils.tokenize(str);
        if (pos.length == 4) {
            try {
                x = Integer.parseInt(pos[0]);
                y = Integer.parseInt(pos[1]);
                w = Integer.parseInt(pos[2]);
                h = Integer.parseInt(pos[3]);
            }
            catch (NumberFormatException e) {
                Cutter.setLog("    Error:LogFrame.getPreferredPosition() preferences string >" + e + "<");
                Cutter.setLog("    Exception = " + e);
            }
        }
        int[] out = new int[]{x, y, w, h};
        return out;
    }

    public void setVisibility(JMenuItem menuItem) {
        this.setVisible(this.visible);
        if (!this.visible && this.isIcon()) {
            KAbstractDesktop.desktopPane.getDesktopManager().deiconifyFrame(this);
        }
        if (this.isVisible()) {
            menuItem.setText("Hide Current Log");
        } else {
            menuItem.setText("Show Current Log");
        }
        this.visible = !this.visible;
    }

    public void setText(String[] strs) {
        for (int n = 0; n < strs.length; ++n) {
            this.setText(strs[n]);
        }
    }

    public static void setMaxChars(int max) {
        maxChars = max;
    }

    @Override
    public void setText(String str) {
        Document document = textpane.getDocument();
        if (document.getLength() > maxChars) {
            this.clearText();
        }
        try {
            document.insertString(document.getLength(), str + '\n', null);
        }
        catch (BadLocationException ex) {
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public void appendText(String str) {
        Document document = textpane.getDocument();
        if (document.getLength() > maxChars) {
            this.clearText();
        }
        try {
            document.insertString(document.getLength(), str, null);
        }
        catch (BadLocationException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void clearText() {
        Document document = textpane.getDocument();
        try {
            document.remove(0, document.getLength());
        }
        catch (BadLocationException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void save() {
        try {
            File outFile = new File(FileUtils.getPWDFile(), this.getTitle());
            FileWriter fw = new FileWriter(outFile);
            fw.write(textpane.getText());
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("FileSaver IOException = " + e);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        if (name.equals("selected") && (Boolean)value == Boolean.TRUE) {
            this.moveToFront();
            throw new PropertyVetoException("selected", e);
        }
        if (name.equals("closed")) {
            this.setVisibility(KDesktop.logItem);
            throw new PropertyVetoException("log hidden", e);
        }
    }

    @Override
    public boolean isClosable() {
        return this.closable;
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void saveHistory() {
    }

    @Override
    public boolean removeHistoryFromTo(String from, String to) {
        return false;
    }

    static {
        maxChars = 4024000;
    }

    private static class MemoryUseageTextField
    extends JPanel {
        private Runtime runtime = Runtime.getRuntime();
        private JLabel freeLabel = new JLabel("Free Memory:");
        private JLabel freeValue;
        private JLabel totalLabel = new JLabel("Total:");
        private JLabel totalValue;

        public MemoryUseageTextField() {
            this.initGUI();
            Timer timer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    freeValue.setText(runtime.freeMemory() / 1024L + "");
                    totalValue.setText(runtime.totalMemory() / 1024L + "");
                }
            });
            timer.setRepeats(true);
            timer.start();
        }

        private void initGUI() {
            this.freeValue = new JLabel("" + this.runtime.freeMemory() / 1024L, 2);
            this.totalValue = new JLabel("" + this.runtime.totalMemory() / 1024L, 2);
            this.freeLabel.setFont(Cutter.defaultFont.font);
            this.freeValue.setFont(Cutter.defaultFont.font);
            this.totalLabel.setFont(Cutter.defaultFont.font);
            this.totalValue.setFont(Cutter.defaultFont.font);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.freeLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 10, 0, 5)));
            this.add((Component)this.freeValue, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
            this.add((Component)this.totalLabel, new GBC(2, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 20, 0, 5)));
            this.add((Component)this.totalValue, new GBC(3, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        }
    }

    public static class DebugMenu
    extends JMenu {
        public void add(Class cls, Field[] field) {
            block5: {
                try {
                    String name = cls.getName();
                    if (field.length > 1) {
                        JMenu menu = new JMenu(name);
                        for (int n = 0; n < field.length; ++n) {
                            this.addMenuItem(menu, field[n], field[n].getName(), field[n].getBoolean(null));
                        }
                        this.add(menu);
                    } else {
                        this.addMenuItem(null, field[0], cls.getName() + "." + field[0].getName(), field[0].getBoolean(null));
                    }
                }
                catch (Exception ex) {
                    if (!Cutter.input.debug) break block5;
                    Cutter.setLog("    Exception:LogFrame.DebugMenu.add() - " + ex.toString());
                }
            }
        }

        private DebugMenu() {
            super("Debug");
        }

        private void addMenuItem(final Method method, final String title, boolean selected) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(title, selected);
            this.add(item);
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Object[] args = new Object[]{((JMenuItem)e.getSource()).isSelected()};
                        method.invoke(null, args);
                    }
                    catch (Exception ex) {
                        Cutter.setLog("Error LogFrame.menuItem - " + title + "  " + ex.toString());
                    }
                }
            };
            item.addActionListener(action);
        }

        private void addMenuItem(JMenu menu, final Field field, final String title, boolean selected) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(title, selected);
            if (menu == null) {
                this.add(item);
            } else {
                menu.add(item);
            }
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        field.setBoolean(null, ((JMenuItem)e.getSource()).isSelected());
                    }
                    catch (Exception ex) {
                        Cutter.setLog("Error LogFrame.menuItem - " + title + "  " + ex.toString());
                    }
                }
            };
            item.addActionListener(action);
        }
    }
}

