/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.Panels.HistoryInfoPanel;

import UI_Components.GBC;
import UI_Components.KTextField.KIntTextField;
import UI_Components.KTextField.KTextField;
import UI_Desktop.Cutter;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KTextHistoryWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.ResourceUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class HistoryInfoPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private KAbstractTextWindow parent;
    private KTextHistoryWindow child;
    private VersionPanel versionPanel = new VersionPanel("Version ");
    private NavigationPanel navigationPanel = new NavigationPanel();
    private final String FOREWARD = "foreward";
    private final String BACK = "back";
    private int index = 0;

    public HistoryInfoPanel(KAbstractTextWindow parent, KTextHistoryWindow child) {
        super(new GridBagLayout());
        this.parent = parent;
        this.child = child;
        this.index = parent.getHistorySize() - 1;
        this.add((Component)this.navigationPanel, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 5, 1, 0)));
        this.add((Component)this.versionPanel, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 11, new Insets(1, 10, 1, 0)));
    }

    public void setVersion(String text) {
        this.versionPanel.setVersion("Version " + text);
    }

    public void setEditFields(int from, int to) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String[] history;
        int n = this.index = e.getActionCommand().equals("foreward") ? (this.index = this.index + 1) : (this.index = this.index - 1);
        if (this.index > this.parent.getHistorySize() - 1) {
            this.index = 0;
        }
        if (this.index < 0) {
            this.index = this.parent.getHistorySize() - 1;
        }
        if ((history = this.parent.getHistoryAt(this.index)) == null) {
            return;
        }
        this.child.deleteAllText();
        this.child.setText(history[0]);
        this.setVersion("" + (this.index + 1) + " of " + history[3] + " [at " + history[1] + "]");
        this.child.setSelection(0, 0);
    }

    private class VersionPanel
    extends JPanel {
        private JLabel label;

        public VersionPanel(String text) {
            super(new GridBagLayout());
            this.label = new JLabel(text);
            this.label.setFont(Cutter.defaultFont.font);
            this.label.setMinimumSize(this.label.getPreferredSize());
            this.add((Component)this.label, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 11, new Insets(0, 0, 0, 3)));
        }

        public void setVersion(String text) {
            this.label.setText(text);
        }
    }

    public class NavigationPanel
    extends JPanel {
        private JButton back;
        private JButton foreward;
        private JButton gotoButton;
        private KIntTextField gotoInput;
        private DefaultMetalTheme metal;

        public NavigationPanel() {
            super(new GridBagLayout());
            this.gotoButton = new JButton("go to");
            this.gotoInput = new KIntTextField("1", 4);
            this.metal = new DefaultMetalTheme();
            this.initButttons();
            this.add((Component)this.back, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 0, 1, 0)));
            this.add((Component)this.foreward, new GBC(2, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 2, 1, 0)));
            this.add((Component)this.gotoButton, new GBC(3, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 10, 1, 0)));
            this.add((Component)this.gotoInput, new GBC(4, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 11, new Insets(1, 2, 1, 0)));
            this.gotoInput.setBackground(new Color(230, 230, 230));
            Insets in = this.gotoInput.getMargin();
            this.gotoInput.setMargin(new Insets(in.top + 1, in.left, in.bottom + 1, in.right));
            this.gotoButton.setMargin(new Insets(-1, 4, 1, 4));
            this.gotoButton.setBackground(this.metal.getPrimaryControl());
            this.gotoButton.setForeground(new Color(79, 79, 118));
            this.gotoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] history;
                    Integer integer = NavigationPanel.this.gotoInput.getInt();
                    if (integer == null) {
                        return;
                    }
                    int value = integer;
                    if (value < 1) {
                        value = 1;
                        NavigationPanel.this.gotoInput.setText("" + value);
                    }
                    if (value > HistoryInfoPanel.this.parent.getHistorySize()) {
                        value = HistoryInfoPanel.this.parent.getHistorySize();
                        NavigationPanel.this.gotoInput.setText("" + value);
                    }
                    if ((history = HistoryInfoPanel.this.parent.getHistoryAt(value - 1)) == null) {
                        return;
                    }
                    HistoryInfoPanel.this.index = value - 1;
                    HistoryInfoPanel.this.child.deleteAllText();
                    HistoryInfoPanel.this.child.setText(history[0]);
                    HistoryInfoPanel.this.setVersion("" + value + " of " + history[3] + " [at " + history[1] + "]");
                    HistoryInfoPanel.this.child.setSelection(0, 0);
                }
            });
        }

        private void initButttons() {
            this.back = new JButton(ResourceUtils.getIconResource("/resources/html/back.gif"));
            this.back.setBackground(this.metal.getPrimaryControl());
            this.back.setDisabledIcon(ResourceUtils.getIconResource("/resources/html/back_disabled.gif"));
            this.back.setMargin(new Insets(1, 0, 2, 0));
            this.back.setEnabled(true);
            this.back.setActionCommand("back");
            this.back.addActionListener(HistoryInfoPanel.this);
            this.foreward = new JButton(ResourceUtils.getIconResource("/resources/html/foreward.gif"));
            this.foreward.setBackground(this.metal.getPrimaryControl());
            this.foreward.setDisabledIcon(ResourceUtils.getIconResource("/resources/html/foreward_disabled.gif"));
            this.foreward.setMargin(new Insets(1, 0, 2, 0));
            this.foreward.setEnabled(true);
            this.foreward.setActionCommand("foreward");
            this.foreward.addActionListener(HistoryInfoPanel.this);
        }
    }

    public class EditListPanel
    extends JPanel {
        private JButton removeButton;
        private JLabel fromLabel;
        private JLabel toLabel;
        private KTextField fromField;
        private KTextField toField;
        private KTextWindow parent;
        private KTextHistoryWindow child;

        public EditListPanel(final KTextWindow parent, final KTextHistoryWindow child) {
            super(new GridBagLayout());
            this.removeButton = new JButton("Remove");
            this.fromLabel = new JLabel("From ");
            this.toLabel = new JLabel(" to ");
            this.fromField = new KTextField(3);
            this.toField = new KTextField(3);
            this.parent = parent;
            this.child = child;
            this.removeButton.setMargin(new Insets(0, 2, 0, 2));
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (parent.removeHistoryFromTo(EditListPanel.this.fromField.getText(), EditListPanel.this.toField.getText())) {
                        String[] history = parent.getHistoryAt(parent.getHistoryMarker());
                        child.deleteAllText();
                        child.setText(history[0]);
                        child.setSelection(0, 0);
                    }
                }
            });
            this.fromField.setMargin(new Insets(1, 0, 1, 0));
            this.toField.setMargin(new Insets(1, 0, 1, 0));
            this.fromField.setMinimumSize(this.fromField.getPreferredSize());
            this.toField.setMinimumSize(this.toField.getPreferredSize());
            this.fromLabel.setFont(Cutter.defaultFont.font);
            this.toLabel.setFont(Cutter.defaultFont.font);
            this.fromLabel.setMinimumSize(this.fromLabel.getPreferredSize());
            this.toLabel.setMinimumSize(this.toLabel.getPreferredSize());
            this.add((Component)this.removeButton, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 10, 1, 0)));
            this.add((Component)this.fromLabel, new GBC(2, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 8, 1, 0)));
            this.add((Component)this.fromField, new GBC(3, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 0, 1, 0)));
            this.add((Component)this.toLabel, new GBC(4, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 2, 1, 0)));
            this.add((Component)this.toField, new GBC(5, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 11, new Insets(1, 2, 1, 0)));
        }

        public void setFrom(int n) {
            this.fromField.setText("" + n);
        }

        public void setTo(int n) {
            this.toField.setText("" + n);
        }
    }
}

