/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.Panels.WindowInfoPanel;

import UI_BBXT.BBxt;
import UI_Components.ToolTip.MultiLineToolTip;
import UI_Desktop.Cutter;
import UI_Script.ScriptParser.ProcDBItem;
import UI_Script.ScriptParser.ScriptParser;
import UI_Script.ScriptParser.ScriptStructure;
import Utilities.FileUtils;
import Utilities.ResourceUtils;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class KProcsButton
extends JToggleButton {
    public static final String SEPARATOR = "::";
    private static final long serialVersionUID = 1L;
    public static int MAX_SUBMENU_DISPLAY_LENGTH = 30;
    public static int MAX_SUBMENUS = 60;
    private static int MAX_SUBMENU_FILE_SIZE = 512000;
    private static Font menuFont = null;
    static String info;
    private MultiLineToolTip tooltip = null;
    private KProcsMenu pu = new KProcsMenu();
    private ImageIcon upIcon = ResourceUtils.getIconResource("/resources/procsUP.gif");
    private ImageIcon downIcon = ResourceUtils.getIconResource("/resources/procsDOWN.gif");
    private boolean displayProcsInOtherFiles = false;

    public KProcsButton() {
        this.setIcon(this.upIcon);
        this.setToolTipText(info);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isShiftDown() || e.isControlDown() || e.isAltDown()) {
                    KProcsButton.this.displayProcsInOtherFiles = true;
                } else {
                    KProcsButton.this.displayProcsInOtherFiles = false;
                }
            }
        });
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ((JToggleButton)e.getSource()).setIcon(KProcsButton.this.downIcon);
                    KProcsButton.this.pu.show(KProcsButton.this, 10, 10);
                } else {
                    ((JToggleButton)e.getSource()).setIcon(KProcsButton.this.upIcon);
                }
            }
        });
    }

    @Override
    public void setToolTipText(String tipText) {
        super.setToolTipText(tipText);
        tipText = TextUtils.format(tipText, MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH);
        this.tooltip = new MultiLineToolTip(tipText);
    }

    @Override
    public JToolTip createToolTip() {
        return this.tooltip;
    }

    static {
        Font fb = (Font)UIManager.get("Button.font");
        menuFont = new Font(fb.getName(), 1, 11);
        info = ResourceUtils.getInfoString("KProcsMenu.KProcsButton.info");
    }

    public class KProcsMenu
    extends JPopupMenu
    implements PopupMenuListener {
        private String text;
        private String ext;
        private ScriptParser sp;
        private ProcDBItem db;
        private ScriptStructure struct;

        public KProcsMenu() {
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            super.removeAll();
            KProcsButton.this.doClick();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            super.removeAll();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.text = BBxt.getWindowText();
            this.ext = BBxt.getWindowExtension();
            if (this.ext == null || this.ext.length() < 2) {
                return;
            }
            try {
                this.sp = new ScriptParser(this.text, this.ext.substring(1));
            }
            catch (Exception ee) {
                Cutter.setLog("KProcsMenu.menuSelected() - Cannot get ScriptParser\n" + ee.toString());
                return;
            }
            this.struct = this.sp.getStructure();
            if (this.struct == null || this.struct.procDB == null || this.struct.procDB.size() == 0) {
                JMenuItem mi = new JMenuItem("no procedures");
                mi.setEnabled(false);
                this.add(mi);
            }
            JComponent currentMenu = this;
            Vector<File> listOfOtherFileProcs = new Vector<File>();
            if (KProcsButton.this.displayProcsInOtherFiles) {
                File file = BBxt.getFrontWindowFile();
                String tooManyWarning = null;
                if (file != null) {
                    File srcDir = file.getParentFile();
                    String[] docs = FileUtils.getListOfFileNames(srcDir, this.ext);
                    File[] files = new File[docs.length];
                    String name = TextUtils.remove(BBxt.getWindowTitle(), '*');
                    int numSubMenus = files.length;
                    if (numSubMenus > MAX_SUBMENUS) {
                        tooManyWarning = numSubMenus - MAX_SUBMENUS + " items not displayed";
                        numSubMenus = MAX_SUBMENUS;
                    }
                    for (int n = 0; n < numSubMenus; ++n) {
                        if (docs[n].equals(name)) continue;
                        listOfOtherFileProcs.addElement(new File(srcDir, docs[n]));
                    }
                }
                if (listOfOtherFileProcs.size() > MAX_SUBMENU_DISPLAY_LENGTH) {
                    for (int n = 0; n < listOfOtherFileProcs.size(); ++n) {
                        if (n % MAX_SUBMENU_DISPLAY_LENGTH == 0) {
                            JMenu temp = new JMenu("more...");
                            currentMenu.add(temp);
                            currentMenu = temp;
                        }
                        File f = (File)listOfOtherFileProcs.elementAt(n);
                        KProcsSubMenu sub = new KProcsSubMenu(f);
                        currentMenu.add(sub);
                    }
                    this.addSeparator();
                    listOfOtherFileProcs = null;
                }
                if (tooManyWarning != null) {
                    this.add(new JMenuItem(tooManyWarning));
                }
            }
            KProcsSubMenu more = null;
            int cursorOffset = BBxt.getSelectionStart();
            int itemCount = 0;
            for (int n = 0; n < this.struct.procDB.size(); ++n) {
                this.db = this.struct.procDB.elementAt(n);
                if (this.db == null) continue;
                if (++itemCount > 0 && itemCount % 30 == 0) {
                    more = new KProcsSubMenu(null);
                    more.setText("more...");
                    this.add(more);
                }
                JMenuItem mi = cursorOffset > 0 && cursorOffset >= this.db.procOffset[0] && cursorOffset <= this.db.procOffset[1] ? this.db.getHiliteProcItem(null, false) : this.db.getHiliteProcItem(null, true);
                if (more != null) {
                    more.add(mi);
                    continue;
                }
                this.add(mi);
            }
            this.addSeparator();
            JMenuItem mi = new JMenuItem("Add Line Markers");
            mi.setFont(ProcDBItem.plainFont);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int n = 0; n < ((KProcsMenu)KProcsMenu.this).struct.procDB.size(); ++n) {
                        KProcsMenu.this.db = ((KProcsMenu)KProcsMenu.this).struct.procDB.elementAt(n);
                        int line = BBxt.getLineNumberAtOffset(((KProcsMenu)KProcsMenu.this).db.procNameOffset[0]);
                        BBxt.setMarkedStyle(line + 1);
                    }
                    if (!BBxt.lineNumberingIsVisible() && ((KProcsMenu)KProcsMenu.this).struct.procDB.size() > 0) {
                        BBxt.showLineNumbering(true);
                    }
                }
            });
            this.add(mi);
            if (listOfOtherFileProcs != null) {
                this.addSeparator();
                for (int n = 0; n < listOfOtherFileProcs.size(); ++n) {
                    if (n != 0 && n % 30 == 0) {
                        JMenu temp = new JMenu("more...");
                        currentMenu.add(temp);
                        currentMenu = temp;
                    }
                    File f = (File)listOfOtherFileProcs.elementAt(n);
                    KProcsSubMenu sub = new KProcsSubMenu(f);
                    currentMenu.add(sub);
                }
            }
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x, y);
            MenuElement[] element = this.getSubElements();
            for (int n = 0; n < element.length; ++n) {
                JMenuItem item = (JMenuItem)element[n];
                Graphics g = item.getGraphics();
                item.paint(g);
            }
        }

        private class KProcsSubMenu
        extends JMenu {
            private ScriptStructure struct;

            public KProcsSubMenu(File file) {
                if (menuFont != null) {
                    this.setFont(menuFont);
                }
                if (file == null) {
                    return;
                }
                if (file.length() > (long)MAX_SUBMENU_FILE_SIZE) {
                    this.setEnabled(false);
                    this.setText(file.getName() + " - too large to parse");
                    return;
                }
                this.setText(file.getName());
                KProcsMenu.this.text = FileUtils.read(file);
                try {
                    KProcsMenu.this.sp = new ScriptParser(KProcsMenu.this.text, KProcsMenu.this.ext.substring(1));
                }
                catch (Exception ex) {
                    this.setEnabled(false);
                    return;
                }
                this.struct = KProcsMenu.this.sp.getStructure();
                if (this.struct == null || this.struct.procDB == null || this.struct.procDB.size() == 0) {
                    this.setEnabled(false);
                } else {
                    JMenu more = null;
                    for (int i = 0; i < this.struct.procDB.size(); ++i) {
                        KProcsMenu.this.db = this.struct.procDB.elementAt(i);
                        if (KProcsMenu.this.db == null) continue;
                        if (i > 0 && i % 20 == 0) {
                            more = new KProcsSubMenu(null);
                            more.setText("more...");
                            this.add(more);
                        }
                        if (more != null) {
                            more.add(KProcsMenu.this.db.getHiliteProcItem(file, true));
                            continue;
                        }
                        this.add(KProcsMenu.this.db.getHiliteProcItem(file, true));
                    }
                }
            }

            @Override
            public void doClick() {
                KProcsButton.this.doClick();
            }
        }
    }
}

