/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.Panels.WindowInfoPanel;

import History.HistoryListener;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Tools.FindLineTool.FindLineTool;
import UI_Tools.Preferences.PrefsTool;
import UI_Tools.TabSpacesTool.TabSpacesTool;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DocumentUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Segment;

public class LineFieldPanel
extends JPanel
implements CaretListener,
HistoryListener {
    private static int FONT_SIZE = 12;
    private static Color blue = new Color(0, 0, 150);
    private KAbstractTextWindow window;
    private int lineCount = 1;
    private int charCount = 0;
    private int caretOffset = 0;
    private char deleteChar = '\u0000';
    private char insertChar = '\u0000';
    private String styleName = "";
    private Segment segment = null;
    private JPanel westPanel = new JPanel();
    private JLabel linelabel = new JLabel("  Line:  ");
    private JLabel linevalue = new JLabel("");
    private JPanel eastPanel = new JPanel();
    private JLabel tabLabel = new JLabel("Tab Size:");
    private JLabel tabValue = new JLabel("4");
    private JLabel marginLabel = new JLabel("Right Margin Guide:");
    private JLabel marginValue = new JLabel("100");
    private JLabel historyLabel = new JLabel("History: ");
    private JLabel historyValue = new JLabel(" ");

    @Override
    public void setEnabled(boolean flag) {
        this.linelabel.setEnabled(flag);
        this.historyLabel.setEnabled(flag);
        this.linevalue.setEnabled(flag);
        this.tabLabel.setEnabled(flag);
    }

    public LineFieldPanel(final KAbstractTextWindow window) {
        this.window = window;
        String fontName = Cutter.defaultFont.name;
        this.linelabel.setFont(new Font(fontName, 0, FONT_SIZE));
        this.linelabel.setForeground(blue);
        this.linevalue.setFont(new Font(fontName, 0, FONT_SIZE));
        this.linevalue.setForeground(Color.darkGray);
        this.westPanel.setLayout(new GridBagLayout());
        this.westPanel.add((Component)this.linelabel, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 0)));
        this.westPanel.add((Component)this.linevalue, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 0)));
        this.historyLabel.setForeground(blue);
        this.historyLabel.setFont(new Font(fontName, 0, FONT_SIZE));
        this.historyValue.setForeground(Color.darkGray);
        this.historyValue.setFont(new Font(fontName, 0, FONT_SIZE));
        this.marginLabel.setFont(new Font(fontName, 0, FONT_SIZE));
        this.marginLabel.setForeground(blue);
        this.marginValue.setFont(new Font(fontName, 0, FONT_SIZE));
        this.marginValue.setForeground(Color.darkGray);
        this.marginValue.setText("" + BBxt.getMarginWidth());
        this.eastPanel.setLayout(new GridBagLayout());
        this.eastPanel.add((Component)this.marginLabel, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 5)));
        this.eastPanel.add((Component)this.marginValue, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 20)));
        this.eastPanel.add((Component)this.tabLabel, new GBC(2, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 5)));
        this.eastPanel.add((Component)this.tabValue, new GBC(3, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 20)));
        this.eastPanel.add((Component)this.historyLabel, new GBC(4, 0, 1, 1, 0.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 0, 2)));
        this.eastPanel.add((Component)this.historyValue, new GBC(5, 0, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 0, 20)));
        this.tabLabel.setFont(new Font(fontName, 0, FONT_SIZE));
        this.tabLabel.setForeground(blue);
        this.tabValue.setForeground(Color.darkGray);
        this.tabValue.setText("" + BBxt.getTabSize());
        this.tabValue.setFont(new Font(fontName, 0, FONT_SIZE));
        this.setLayout(new BorderLayout());
        this.add("West", this.westPanel);
        this.add("East", this.eastPanel);
        this.marginLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (window instanceof KTextWindow) {
                    if (((KTextWindow)window).lineMarginIsVisible()) {
                        ((KTextWindow)window).hideLineMargin();
                    } else {
                        ((KTextWindow)window).showLineMargin();
                    }
                }
            }
        });
        this.marginValue.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (window instanceof KTextWindow) {
                    PrefsTool.openTabPanel("UI Prefs", "General");
                }
            }
        });
        this.linelabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LineFieldPanel.this.raiseFindLineTool();
            }
        });
        this.linevalue.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LineFieldPanel.this.raiseFindLineTool();
            }
        });
        this.tabLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LineFieldPanel.this.raiseSetTabSpacesTool();
            }
        });
        this.tabValue.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LineFieldPanel.this.raiseSetTabSpacesTool();
            }
        });
        this.historyLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PrefsTool.openTabPanel("UI Prefs", "History");
            }
        });
        this.historyValue.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BBxt.openHistoryWindow();
            }
        });
    }

    public void setMarginWidthField(int size) {
        this.marginValue.setText("" + size);
    }

    public void setTabSizeField(int size) {
        this.tabValue.setText("" + size);
    }

    private void raiseFindLineTool() {
        FindLineTool flt = FindLineTool.init();
        flt.showSelf();
    }

    private void raiseSetTabSpacesTool() {
        TabSpacesTool fst = TabSpacesTool.init();
        fst.showSelf();
    }

    @Override
    public void historyEvent() {
        if (this.window.getHistorySize() == 0) {
            this.historyValue.setText("none");
            return;
        }
        StringBuffer buff = new StringBuffer();
        int num = this.window.getHistorySize();
        if (num > 1) {
            buff.append(this.window.getHistorySize());
            buff.append(" items");
        } else {
            buff.append(" 1 item");
        }
        this.historyValue.setText(buff.toString());
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.linevalue.setText(this.getCaretData(e.getDot()));
    }

    public void setLineNumber(int line) {
        if (line <= 0) {
            line = 1;
        }
        this.linevalue.setText(Integer.toString(line));
    }

    public String getCaretData(int offset) {
        this.lineCount = 1;
        this.charCount = 0;
        this.caretOffset = offset;
        if (this.caretOffset > this.window.getTextPane().getDocument().getLength()) {
            return "";
        }
        this.segment = DocumentUtils.getSegment(this.window.getTextPane().getDocument(), 0, offset);
        this.charCount = this.segment.count;
        for (int n = 0; n < this.segment.count; ++n) {
            if (this.segment.array[n + this.segment.offset] != '\n') continue;
            ++this.lineCount;
        }
        return this.lineCount + " [" + this.charCount + "]";
    }
}

