/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.Panels.WindowInfoPanel;

import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DocumentUtils;
import Utilities.DynamicEdit;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class LineNumberingPanel
extends JPanel
implements DocumentListener,
MouseListener {
    public static int MAX_CHARS_ON_MENU = 60;
    private HostInfo hostInfo = new HostInfo();
    public NumberPane numberPane = null;
    public Vector<DynamicEdit> listOfMarkers = new Vector();
    private JScrollPane scrollPane = null;
    private boolean docListening = false;
    private KTextPane textpane;

    public void setDefaults() {
        this.docListening = false;
        this.setVisible(false);
        this.numberPane.setText("");
        this.hostInfo.numLines = 0;
    }

    public LineNumberingPanel(KTextPane textPane, JScrollPane scroller) {
        this.scrollPane = scroller;
        this.textpane = textPane;
        this.hostInfo.textpane = textPane;
        this.hostInfo.document = textPane.getDocument();
        this.hostInfo.font = textPane.getFont();
        this.hostInfo.fontSize = textPane.getFont().getSize();
        this.hostInfo.numLines = this.countTextDocLines();
        this.numberPane = new NumberPane();
        this.numberPane.initStyles(this.hostInfo.font);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.numberPane, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        textPane.addDocumentListener(this);
        this.numberPane.addMouseListener(this);
        this.setMinimumSize(new Dimension(40, 100));
        this.numberPane.setVisible(false);
        super.setVisible(false);
        textPane.addCaretListener(this.numberPane);
    }

    public void resume(boolean draw) {
        this.docListening = true;
        this.checkFontSize();
        this.checkLineCount();
    }

    public void suspend() {
        this.docListening = false;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (e.toString().length() > 2) {
            return;
        }
        if (!this.docListening) {
            return;
        }
        this.checkFontSize();
        this.checkLineCount();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.docListening) {
            return;
        }
        this.checkFontSize();
        this.checkLineCount();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.docListening) {
            return;
        }
        this.checkFontSize();
        this.checkLineCount();
    }

    private synchronized void checkLineCount() {
        StyledDocument numberDoc = this.numberPane.getStyledDocument();
        StringBuffer buf = new StringBuffer();
        int textDocLines = this.countTextDocLines();
        int numbDocLines = this.countNumbDocLines();
        this.hostInfo.numLines = textDocLines;
        try {
            if (numbDocLines > textDocLines) {
                int end = DocumentUtils.getOffsetsOfLine(numberDoc, textDocLines + 1)[2];
                int len = numberDoc.getLength() - end;
                numberDoc.remove(end, len);
            } else {
                for (int n = numbDocLines + 1; n <= textDocLines + 1; ++n) {
                    buf.append(n).append("\n");
                }
                this.numberPane.getDocument().insertString(numberDoc.getLength(), buf.toString(), this.numberPane.styles.plainStyle);
            }
        }
        catch (Exception ble) {
            Cutter.setLog("    Exception:LineNumberingPanel.checkLineCount() - " + ble.toString());
        }
        this.numberPane.setPlainStyle(-1, -1);
        this.validateMarkers();
        Enumeration<DynamicEdit> e = this.listOfMarkers.elements();
        while (e.hasMoreElements()) {
            DynamicEdit span = e.nextElement();
            int offset = span.getBegin() == 0 ? span.getEnd() - 1 : span.getBegin();
            int[] lines = DocumentUtils.getLineNumberAt(this.hostInfo.document, offset);
            if (lines == null) {
                Cutter.setLog("    Error:LineNumberingPanel.cannot find line at " + span.getBegin());
                continue;
            }
            int[] offsets = DocumentUtils.getOffsetsOfLine(numberDoc, lines[0]);
            this.numberPane.setMarkedStyle(offsets[1], offsets[2]);
        }
    }

    private void checkFontSize() {
        if (this.hostInfo.fontSize == this.hostInfo.textpane.getFont().getSize()) {
            return;
        }
        this.hostInfo.fontSize = this.hostInfo.textpane.getFont().getSize();
        StyleConstants.setFontSize(this.numberPane.styles.baseStyle, this.hostInfo.fontSize);
    }

    private int countNumbDocLines() {
        return this.countDocLines(this.numberPane.getDocument());
    }

    private int countTextDocLines() {
        return this.countDocLines(this.hostInfo.document);
    }

    private int countDocLines(Document doc) {
        Segment segment = DocumentUtils.getSegment(doc, 0, doc.getLength());
        int line = 0;
        for (int n = 0; n < segment.length(); ++n) {
            if (segment.array[segment.offset + n] != '\n') continue;
            ++line;
        }
        return line;
    }

    public String getStyleNameAtOffset(int offset) {
        StyledDocument doc = this.numberPane.getStyledDocument();
        return doc.getCharacterElement(offset).getAttributes().getAttribute(AttributeSet.NameAttribute).toString();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.handlePopupTrigger(e);
            return;
        }
        if (e.getClickCount() == 2) {
            int offset = this.numberPane.viewToModel(new Point(e.getX(), e.getY()));
            Element elem = DocumentUtils.getParagraphElement(this.numberPane.getStyledDocument(), offset);
            int[] lines = DocumentUtils.getLineNumberAt(this.numberPane.getStyledDocument(), offset);
            if (lines == null) {
                Cutter.setLog("    Error:LineNumberingPanel.mouseReleased() - DocumentUtils.getLineNumberAt returned null at offset = " + offset);
                return;
            }
            int line = lines[0];
            int start = elem.getStartOffset();
            int end = elem.getEndOffset();
            int len = this.numberPane.getDocument().getLength();
            if (this.getStyleNameAtOffset(offset).equals("plain")) {
                if (this.addDynamicEdit(line)) {
                    this.numberPane.setMarkedStyle(start, end);
                }
            } else {
                this.numberPane.setPlainStyle(start, end);
                this.removeDynamicEdit(line);
            }
        }
    }

    public void setMarkedStyle(int line) {
        this.numberPane.setMarkedStyle(line);
        this.addDynamicEdit(line);
    }

    private boolean addDynamicEdit(int line) {
        int[] offsets = BBxt.getOffsetsOfLine(line);
        if (offsets == null) {
            Cutter.setLog("addDynamicEdit");
            return false;
        }
        int begin = offsets[1];
        int end = offsets[2];
        try {
            DynamicEdit span = new DynamicEdit(this.hostInfo.document, begin, end);
            this.listOfMarkers.addElement(span);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Exception:LineNumberingPanel.addDynamicEdit() " + e);
            return false;
        }
        return true;
    }

    private boolean removeDynamicEdit(int line) {
        int[] offsets = DocumentUtils.getOffsetsOfLine(this.hostInfo.document, line);
        if (offsets == null) {
            Cutter.setLog("removeDynamicEdit offsets are null at line " + line);
            return false;
        }
        int begin = offsets[1];
        int end = offsets[2];
        Enumeration<DynamicEdit> e = this.listOfMarkers.elements();
        while (e.hasMoreElements()) {
            DynamicEdit span = e.nextElement();
            if (end != span.getEnd() || begin != span.getBegin()) continue;
            this.listOfMarkers.removeElement(span);
        }
        return true;
    }

    private int validateMarkers() {
        int len = this.hostInfo.document.getLength();
        if (len > 0) {
            --len;
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int n = 0; n < LineNumberingPanel.this.listOfMarkers.size(); ++n) {
                        LineNumberingPanel.this.validateDynamicEdit(LineNumberingPanel.this.listOfMarkers.elementAt(n));
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        Hashtable<DynamicEdit, DynamicEdit> table = new Hashtable<DynamicEdit, DynamicEdit>();
        for (int n = 0; n < this.listOfMarkers.size(); ++n) {
            DynamicEdit span = this.listOfMarkers.elementAt(n);
            table.put(span, span);
        }
        Enumeration e = table.elements();
        int numDeleted = 0;
        while (e.hasMoreElements()) {
            DynamicEdit span = (DynamicEdit)e.nextElement();
            if (span.getBegin() == span.getEnd()) {
                this.listOfMarkers.removeElement(span);
                ++numDeleted;
            }
            if (span.getBegin() <= span.getEnd()) continue;
            if (Cutter.input.debug) {
                Cutter.setLog("validateMarkers - reversed span: span.getBegin() " + span.getBegin() + " span.getEnd() " + span.getEnd());
            }
            this.listOfMarkers.removeElement(span);
            ++numDeleted;
        }
        return numDeleted;
    }

    private boolean validateDynamicEdit(DynamicEdit span) {
        int offset = span.getBegin() == 0 ? span.getEnd() - 1 : span.getBegin();
        int[] lines = DocumentUtils.getLineNumberAt(this.hostInfo.document, offset);
        if (lines == null) {
            Cutter.setLog("    Error:validateDynamicEdit() - cannot find line at offset " + offset);
            return false;
        }
        int linenum = lines[0];
        int[] offsets = DocumentUtils.getOffsetsOfLine(this.hostInfo.document, linenum);
        if (offsets == null) {
            return false;
        }
        if (offsets[1] != span.getBegin() || offsets[2] != span.getEnd()) {
            this.listOfMarkers.removeElement(span);
            this.addDynamicEdit(lines[0]);
            return false;
        }
        return true;
    }

    private Vector getSortedMarkers() {
        Vector<DynamicEdit> copy = new Vector<DynamicEdit>();
        for (int n = 0; n < this.listOfMarkers.size(); ++n) {
            copy.addElement(this.listOfMarkers.elementAt(n));
        }
        Vector<DynamicEdit> out = new Vector<DynamicEdit>();
        DynamicEdit de = this.getLowestLineNumber(copy);
        while (de != null) {
            out.addElement(de);
            copy.remove(de);
            if (copy.size() == 0) {
                return out;
            }
            de = this.getLowestLineNumber(copy);
        }
        return null;
    }

    private DynamicEdit getLowestLineNumber(Vector input) {
        if (input == null || input.size() == 0) {
            return null;
        }
        int lowLine = 1000000;
        int lowIndex = -1;
        for (int n = 0; n < input.size(); ++n) {
            int line;
            DynamicEdit span = (DynamicEdit)input.elementAt(n);
            int[] lines = DocumentUtils.getLineNumberAt(this.hostInfo.document, span.getBegin());
            if (lines == null || (line = lines[0]) >= lowLine) continue;
            lowLine = line;
            lowIndex = n;
        }
        if (lowIndex == -1) {
            return null;
        }
        return (DynamicEdit)input.elementAt(lowIndex);
    }

    private void handlePopupTrigger(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        if (this.listOfMarkers.size() > 0) {
            Vector sorted = this.getSortedMarkers();
            for (int j = 0; j < sorted.size(); ++j) {
                DynamicEdit span = (DynamicEdit)sorted.elementAt(j);
                NumberMenuItem nmi = new NumberMenuItem(span);
                popup.add(nmi);
            }
            popup.add(new JSeparator());
        }
        JMenuItem item = new JMenuItem("Remove All Markers");
        if (this.listOfMarkers.size() == 0) {
            item.setEnabled(false);
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineNumberingPanel.this.listOfMarkers.removeAllElements();
                ((LineNumberingPanel)LineNumberingPanel.this).hostInfo.numLines = 0;
                LineNumberingPanel.this.numberPane.setPlainStyle(-1, -1);
            }
        });
        popup.add(item);
        item = new JMenuItem("Hide Line Numbers");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KAbstractTextWindow ktw = LineNumberingPanel.this.textpane.getFrame();
                if (ktw instanceof KTextWindow) {
                    ((KTextWindow)ktw).showLineNumbering(false);
                }
            }
        });
        popup.add(item);
        popup.pack();
        if (popup != null) {
            popup.setRequestFocusEnabled(false);
            try {
                popup.show(this.numberPane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:SloHelp.popupOnlineHelp()\n      " + ex.toString());
            }
        }
    }

    public void initEditsFromString(String str) {
        this.listOfMarkers.removeAllElements();
        try {
            this.numberPane.getDocument().insertString(0, "", this.numberPane.styles.plainStyle);
        }
        catch (BadLocationException ble) {
            Cutter.setLog("    Exception:LineNumberingPanel.initEditsFromString() - " + ble.toString());
        }
        if (str == null || str.trim().length() == 0) {
            return;
        }
        int len = this.hostInfo.document.getLength();
        if (len > 0) {
            --len;
        }
        String[] spans = TextUtils.tokenize(str, ':');
        try {
            for (int n = 0; n < spans.length; ++n) {
                String[] s = TextUtils.tokenize(spans[n], ',');
                if (s == null || s.length != 2) continue;
                int begin = Integer.parseInt(s[0]);
                int end = Integer.parseInt(s[1]);
                if (begin > len || end > len) continue;
                DynamicEdit span = new DynamicEdit(this.hostInfo.document, begin, end);
                this.listOfMarkers.addElement(span);
            }
            this.hostInfo.numLines = 0;
        }
        catch (NumberFormatException ee) {
            Cutter.setLog("    Exception:LineNumberingPanel.initEditsFromString() " + ee);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Exception:LineNumberingPanel.initEditsFromString() " + e);
        }
    }

    public String dynamicEditsToString() {
        if (this.listOfMarkers == null || this.listOfMarkers.isEmpty()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < this.listOfMarkers.size(); ++n) {
            DynamicEdit span = this.listOfMarkers.elementAt(n);
            buf.append(span.getBegin()).append(',').append(span.getEnd()).append(':');
        }
        String out = buf.toString();
        if (out.length() > 0) {
            if (out.endsWith(":")) {
                out = out.substring(0, out.length() - 1);
            }
            return out;
        }
        return null;
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        this.numberPane.setVisible(flag);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.numberPane.isVisible();
    }

    public class HostInfo {
        KTextPane textpane;
        Document document;
        Font font = null;
        int fontSize = 0;
        int numLines = 0;
    }

    public class NumberPane
    extends JTextPane
    implements CaretListener {
        public NumberStyles styles;
        NumberDocument document;
        int prevMark;
        int prevDot;

        public NumberPane() {
            this.styles = new NumberStyles();
            this.document = new NumberDocument(this.styles);
            this.prevMark = 0;
            this.prevDot = 0;
            this.setStyledDocument(this.document);
            this.setBackground(new Color(215, 215, 215));
            this.setEditable(false);
            this.setSelectionColor(new Color(215, 215, 215));
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.BLACK));
            this.setRequestFocusEnabled(false);
        }

        public void initStyles(Font f) {
            this.setFont(f);
            this.styles.init(this);
            this.document.setLogicalStyle(0, this.styles.plainStyle);
        }

        public void setPlainStyle(int start, int end) {
            if (start == -1 && end == -1) {
                this.document.setCharacterAttributes(0, this.document.getLength(), this.styles.plainStyle, true);
            } else {
                this.document.setCharacterAttributes(start, end - start, this.styles.plainStyle, true);
            }
        }

        public void setCursorPlainStyle(int start, int end) {
            this.document.setCharacterAttributes(start, end - start, this.styles.cursorPlainStyle, true);
        }

        public void setMarkedStyle(int start, int end) {
            this.document.setCharacterAttributes(start, end - start, this.styles.markedStyle, true);
        }

        public void setMarkedStyle(int line) {
            int[] off = DocumentUtils.getOffsetsOfLine(LineNumberingPanel.this.numberPane.getStyledDocument(), line);
            if (off != null) {
                this.setMarkedStyle(off[1], off[2]);
            }
        }

        public void setPlainStyle(int line) {
            int[] off = DocumentUtils.getOffsetsOfLine(LineNumberingPanel.this.numberPane.getStyledDocument(), line);
            if (off != null) {
                this.setPlainStyle(off[1], off[2]);
            }
        }

        public void setCursorMarkedStyle(int start, int end) {
            this.document.setCharacterAttributes(start, end - start, this.styles.cursorMarkedStyle, true);
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            int[] data = this.isMarked(this.prevMark);
            if (data != null) {
                if (data[0] == 1) {
                    this.setMarkedStyle(data[1], data[2]);
                } else {
                    this.setPlainStyle(data[1], data[2]);
                }
            }
            if ((data = this.isMarked(e.getMark())) != null) {
                if (data[0] == 1) {
                    this.setCursorMarkedStyle(data[1], data[2]);
                } else {
                    this.setCursorPlainStyle(data[1], data[2]);
                }
            }
            this.prevMark = e.getMark();
            this.prevDot = e.getDot();
        }

        private int[] isMarked(int cursorPos) {
            int[] d = DocumentUtils.getLineNumberAt(((LineNumberingPanel)LineNumberingPanel.this).hostInfo.document, cursorPos);
            if (d == null) {
                return null;
            }
            int ismarked = 0;
            int begin = d[1];
            int end = d[2];
            for (int n = 0; n < LineNumberingPanel.this.listOfMarkers.size(); ++n) {
                DynamicEdit span = LineNumberingPanel.this.listOfMarkers.elementAt(n);
                if (d[1] < span.getBegin() || d[2] > span.getEnd()) continue;
                ismarked = 1;
            }
            if ((d = DocumentUtils.getOffsetsOfLine(this.document, d[0])) == null) {
                return null;
            }
            return new int[]{ismarked, d[1], d[2]};
        }
    }

    public class NumberStyles
    extends StyleContext {
        public static final String PLAIN = "plain";
        public static final String CURSOR_PLAIN = "cursorplain";
        public static final String MARKED = "marked";
        public static final String CURSOR_MARKED = "cursormarked";
        public Style baseStyle = this.getStyle("default");
        public Style plainStyle = this.addStyle("plain", this.baseStyle);
        public Style cursorPlainStyle;
        public Style markedStyle = this.addStyle("marked", this.baseStyle);
        public Style cursorMarkedStyle;

        public NumberStyles() {
            this.cursorPlainStyle = this.addStyle(CURSOR_PLAIN, this.baseStyle);
            this.cursorMarkedStyle = this.addStyle(CURSOR_MARKED, this.baseStyle);
        }

        public void init(NumberPane pane) {
            StyleConstants.setAlignment(pane.styles.baseStyle, 2);
            StyleConstants.setRightIndent(pane.styles.baseStyle, 4.0f);
            StyleConstants.setLeftIndent(pane.styles.baseStyle, 5.0f);
            StyleConstants.setForeground(pane.styles.plainStyle, new Color(80, 80, 80));
            StyleConstants.setForeground(pane.styles.markedStyle, new Color(0, 0, 0));
            StyleConstants.setBackground(pane.styles.markedStyle, new Color(255, 255, 0));
            StyleConstants.setForeground(pane.styles.cursorPlainStyle, new Color(0, 0, 0));
            StyleConstants.setUnderline(pane.styles.cursorPlainStyle, true);
            StyleConstants.setForeground(pane.styles.cursorMarkedStyle, new Color(80, 80, 80));
            StyleConstants.setBackground(pane.styles.cursorMarkedStyle, new Color(255, 255, 0));
            StyleConstants.setUnderline(pane.styles.cursorMarkedStyle, true);
        }
    }

    private class NumberMenuItem
    extends JMenuItem {
        public int line = -1;
        private int begin = -1;
        private int end = -1;

        public NumberMenuItem(DynamicEdit span) {
            this.begin = span.getBegin();
            this.end = span.getEnd();
            int[] lines = DocumentUtils.getLineNumberAt(((LineNumberingPanel)LineNumberingPanel.this).hostInfo.document, span.getBegin());
            if (lines == null) {
                return;
            }
            this.line = lines[0];
            String text = span.getText().trim();
            text = text.length() > MAX_CHARS_ON_MENU ? text.substring(0, MAX_CHARS_ON_MENU) : text;
            this.setText(this.line + ":   " + text);
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (NumberMenuItem.this.begin != -1 && NumberMenuItem.this.end != -1) {
                        BBxt.setSelection(NumberMenuItem.this.begin, NumberMenuItem.this.end - 1);
                    }
                }
            };
            this.addActionListener(action);
        }
    }

    public class NumberDocument
    extends DefaultStyledDocument {
        public NumberDocument(NumberStyles styles) {
            super(styles);
        }
    }
}

