/*
 * Decompiled with CFR 0.152.
 */
package UI_Window.Panels.WindowInfoPanel;

import ClientServer.ClientServer.client.Client;
import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KCheckBox;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledComboBox;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import UI_Window.Panels.WindowInfoPanel.FontStyleButton;
import UI_Window.Panels.WindowInfoPanel.KProcsButton;
import Utilities.EnvUtils;
import Utilities.ResourceUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class WindowInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel defaultPanel = new JPanel();
    private FontSizePanel fontSizePanel;
    public FontStyleButton fontStyleButton;
    private KProcsButton procsButton = new KProcsButton();
    private PathField pathField = new PathField();
    public NetButton netButton = new NetButton();
    public boolean netPanelIsActive = false;
    public NetworkPanel netPanel = new NetworkPanel();
    private static int portID = 1024;
    private Color textColor = Color.darkGray;
    private boolean init = true;
    public KTextWindow window = null;
    static final int DEFAULT_IP_WIDTH = 8;
    static final int DEFAULT_PORT_WIDTH = 4;
    public static boolean _sendToMaya = false;
    public boolean mayaMode = false;
    public boolean houdiniMode = false;
    public boolean cutterServerMode = false;
    public boolean cutterClientMode = false;
    public boolean fatalServerMode = false;
    public boolean tcpListeningMode = false;

    public WindowInfoPanel(final KTextWindow window, String pathname) {
        final KTextPane textpane = window.getTextPane();
        this.window = window;
        this.fontSizePanel = new FontSizePanel();
        this.fontStyleButton = new FontStyleButton(window);
        this.fontStyleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WindowInfoPanel.this.fontStyleButton.isSelected()) {
                    ((JToggleButton)e.getSource()).setIcon(WindowInfoPanel.this.fontStyleButton.boldIcon);
                    textpane.setFont(new Font(textpane.getFont().getName(), 1, textpane.getFont().getSize()));
                } else {
                    ((JToggleButton)e.getSource()).setIcon(WindowInfoPanel.this.fontStyleButton.plainIcon);
                    textpane.setFont(new Font(textpane.getFont().getName(), 0, textpane.getFont().getSize()));
                }
                window.updateLineMargin();
            }
        });
        this.setLayout(new BorderLayout());
        this.add("North", this.makeDefaultPanel(pathname));
    }

    private JPanel makeDefaultPanel(String pathname) {
        JPanel defaultPanel = new JPanel(new GridBagLayout());
        this.netButton.setMargin(new Insets(-1, 0, 0, 0));
        defaultPanel.add((Component)this.fontSizePanel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, -3, 17, 0, new Insets(2, 8, 2, 0)));
        defaultPanel.add((Component)this.fontStyleButton, new GBC(1, 0, 1, 1, 0.0, 0.0, -20, -1, 17, 0, new Insets(2, 2, 2, 0)));
        defaultPanel.add((Component)this.procsButton, new GBC(2, 0, 1, 1, 0.0, 0.0, -20, -1, 17, 0, new Insets(2, 2, 2, 2)));
        defaultPanel.add((Component)this.pathField, new GBC(3, 0, 1, 1, 1.0, 0.0, -1, 0, 17, 2, new Insets(2, 4, 2, 4)));
        defaultPanel.add((Component)this.netButton, new GBC(4, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(2, 0, 2, 4)));
        defaultPanel.add((Component)this.netPanel, new GBC(0, 1, 6, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(2, 4, 2, 0)));
        this.netPanel.setVisible(false);
        this.pathField.setText(pathname);
        return defaultPanel;
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.fontSizePanel.combo.setEnabled(flag);
        this.fontStyleButton.setEnabled(flag);
        this.procsButton.setEnabled(flag);
        this.netButton.setEnabled(flag);
    }

    public void setPath(String name) {
        if (!this.pathField.getText().equals(name)) {
            this.pathField.setText(name);
        }
    }

    public void setPeerButton(String name) {
        if (!this.netPanel.getPeerButton().equals(name)) {
            this.netPanel.setPeerButton(name);
        }
    }

    public void showNetPanel() {
        this.netPanel.setVisible(true);
    }

    public void hideNetPanel() {
        this.netPanel.setVisible(false);
    }

    public void setFontSize(int size) {
        this.fontSizePanel.setSize(size);
    }

    public void setFontSize(String str) {
        this.fontSizePanel.setSize(str);
    }

    public void setFontStyle(String style) {
        this.fontStyleButton.setStyle(style);
    }

    public void saveSelf() {
        this.netPanel.saveSelf();
    }

    public void restoreToDefaults() {
        if (this.netButton.isSelected()) {
            this.netButton.doClick();
        }
        if (this.fontStyleButton.isSelected()) {
            this.fontStyleButton.setSelected(false);
        }
        this.netPanel.restoreToDefaults();
        this.mayaMode = false;
        this.houdiniMode = false;
        this.cutterServerMode = false;
        this.cutterClientMode = false;
        this.fatalServerMode = false;
    }

    static {
        try {
            Field[] fieldArray = new Field[]{WindowInfoPanel.class.getDeclaredField("_sendToMaya")};
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: WindowInfoPanel.static - " + ex.toString());
        }
    }

    public class PathField
    extends KTextField {
        public PathField() {
            super("unsaved");
            this.setForeground(WindowInfoPanel.this.textColor);
            this.setSelectionColor(new Color(1.0f, 1.0f, 0.0f));
            this.setEditable(false);
            this.setFont(new Font(Cutter.defaultFont.name, 0, Cutter.defaultFont.size + 2));
            this.setMargin(new Insets(0, 0, 0, 0));
            if (!EnvUtils.isWinEnvironment()) {
                JPopupMenu popup = new JPopupMenu();
                this.add(popup);
                this.setComponentPopupMenu(popup);
                JMenuItem item = new JMenuItem("Make Executable");
                popup.add(item);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (WindowInfoPanel.this.window != null) {
                            WindowInfoPanel.this.window.wasExecutibleWhenOpened = true;
                        }
                        if (WindowInfoPanel.this.window.getFile() != null) {
                            WindowInfoPanel.this.window.setTouched(true);
                            WindowInfoPanel.this.window.saveFile();
                        }
                    }
                });
            }
        }

        @Override
        public void setText(String input) {
            super.setText(input.replace('\\', '/'));
        }
    }

    public class NetButton
    extends JToggleButton {
        private ImageIcon clientUPIcon = ResourceUtils.getIconResource("/resources/net.gif");

        private NetButton() {
            this.setIcon(this.clientUPIcon);
            this.setRequestFocusEnabled(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NetButton.this.isSelected()) {
                        WindowInfoPanel.this.netPanelIsActive = true;
                        WindowInfoPanel.this.showNetPanel();
                    } else {
                        WindowInfoPanel.this.netPanelIsActive = false;
                        WindowInfoPanel.this.hideNetPanel();
                    }
                }
            });
        }
    }

    public class NetworkPanel
    extends JPanel {
        public KTitledComboBox popup;
        public CutterClientPanel cutrClientPanel;
        public CutterServerPanel cutrServerPanel;
        public MayaPeerPanel mayaPeerPanel;
        public HoudiniPeerPanel houdiniPeerPanel;
        public TCPListenerPanel tcpListenerPanel;
        public KTitledPanel activePanel;

        public NetworkPanel() {
            super(new GridBagLayout());
            this.popup = new KTitledComboBox("Mode ", 2, 0, -4);
            this.cutrClientPanel = new CutterClientPanel();
            this.cutrServerPanel = new CutterServerPanel();
            this.mayaPeerPanel = new MayaPeerPanel();
            this.houdiniPeerPanel = new HoudiniPeerPanel();
            this.tcpListenerPanel = new TCPListenerPanel();
            this.activePanel = null;
            this.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.popup.addItem("Maya");
            this.popup.addItem("Houdini");
            this.popup.addItem("Cutter Client");
            this.popup.addItem("Cutter Server");
            this.popup.addItem("Ttp Listener");
            this.activePanel = this.mayaPeerPanel;
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String text = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    NetworkPanel.this.cutrServerPanel.setVisible(false);
                    NetworkPanel.this.cutrClientPanel.setVisible(false);
                    NetworkPanel.this.mayaPeerPanel.setVisible(false);
                    NetworkPanel.this.houdiniPeerPanel.setVisible(false);
                    NetworkPanel.this.tcpListenerPanel.setVisible(false);
                    NetworkPanel.this.remove(NetworkPanel.this.cutrServerPanel);
                    NetworkPanel.this.remove(NetworkPanel.this.cutrClientPanel);
                    NetworkPanel.this.remove(NetworkPanel.this.mayaPeerPanel);
                    NetworkPanel.this.remove(NetworkPanel.this.houdiniPeerPanel);
                    NetworkPanel.this.remove(NetworkPanel.this.tcpListenerPanel);
                    if (text.equals("Cutter Server")) {
                        NetworkPanel.this.add((Component)NetworkPanel.this.cutrServerPanel, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(2, 5, 2, 0)));
                        NetworkPanel.this.cutrServerPanel.setVisible(true);
                        if (WindowInfoPanel.this.cutterClientMode) {
                            Cutter.setLog("setting server panel to disabled");
                            NetworkPanel.this.cutrServerPanel.setEnabled(false);
                        } else {
                            NetworkPanel.this.cutrServerPanel.setEnabled(true);
                            NetworkPanel.this.activePanel = NetworkPanel.this.cutrServerPanel;
                        }
                    } else if (text.equals("Cutter Client")) {
                        NetworkPanel.this.add((Component)NetworkPanel.this.cutrClientPanel, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(2, 5, 2, 0)));
                        NetworkPanel.this.cutrClientPanel.setVisible(true);
                        if (WindowInfoPanel.this.cutterServerMode) {
                            Cutter.setLog("setting client panel to disabled");
                            NetworkPanel.this.cutrClientPanel.setEnabled(false);
                        } else {
                            NetworkPanel.this.cutrClientPanel.setEnabled(true);
                            NetworkPanel.this.activePanel = NetworkPanel.this.cutrClientPanel;
                        }
                    } else if (text.equals("Maya")) {
                        NetworkPanel.this.add((Component)NetworkPanel.this.mayaPeerPanel, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(2, 5, 2, 0)));
                        NetworkPanel.this.mayaPeerPanel.setVisible(true);
                        NetworkPanel.this.activePanel = NetworkPanel.this.mayaPeerPanel;
                    } else if (text.equals("Houdini")) {
                        NetworkPanel.this.add((Component)NetworkPanel.this.houdiniPeerPanel, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(2, 5, 2, 0)));
                        NetworkPanel.this.houdiniPeerPanel.setVisible(true);
                        NetworkPanel.this.activePanel = NetworkPanel.this.houdiniPeerPanel;
                    } else if (text.equals("Ttp Listener")) {
                        NetworkPanel.this.add((Component)NetworkPanel.this.tcpListenerPanel, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(2, 5, 2, 0)));
                        NetworkPanel.this.tcpListenerPanel.setVisible(true);
                        NetworkPanel.this.activePanel = NetworkPanel.this.tcpListenerPanel;
                    }
                    NetworkPanel.this.houdiniPeerPanel.setEnabled(!WindowInfoPanel.this.mayaMode);
                    NetworkPanel.this.mayaPeerPanel.setEnabled(!WindowInfoPanel.this.houdiniMode);
                    NetworkPanel.this.tcpListenerPanel.setEnabled(!WindowInfoPanel.this.cutterServerMode && !WindowInfoPanel.this.cutterClientMode);
                    NetworkPanel.this.cutrClientPanel.setEnabled(!WindowInfoPanel.this.tcpListeningMode);
                    NetworkPanel.this.cutrServerPanel.setEnabled(!WindowInfoPanel.this.tcpListeningMode);
                }
            };
            this.popup.addActionListener(action);
            this.add((Component)this.popup, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 5, 0, 3)));
            this.add((Component)this.mayaPeerPanel, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(2, 5, 2, 0)));
            this.mayaPeerPanel.setVisible(true);
        }

        private void setPeerButton(String name) {
            this.mayaPeerPanel.sendButton.setText(name);
        }

        private String getPeerButton() {
            return this.mayaPeerPanel.sendButton.getText();
        }

        public void saveSelf() {
            this.cutrClientPanel.saveSelf();
            this.mayaPeerPanel.saveSelf();
            this.houdiniPeerPanel.saveSelf();
            this.tcpListenerPanel.saveSelf();
        }

        public void restoreToDefaults() {
            this.cutrClientPanel.restoreToDefaults();
            this.mayaPeerPanel.restoreToDefaults();
            this.cutrServerPanel.restoreToDefaults();
            this.houdiniPeerPanel.restoreToDefaults();
            WindowInfoPanel.this.netButton.setSelected(false);
            WindowInfoPanel.this.netPanelIsActive = false;
            WindowInfoPanel.this.netPanel.setVisible(false);
        }

        public void setIPFor(String name, String ip) {
            if (name.equals("maya")) {
                this.mayaPeerPanel.setIP(ip);
            } else if (name.equals("houdini")) {
                this.houdiniPeerPanel.setIP(ip);
            } else if (name.equals("client")) {
                this.cutrClientPanel.setIP(ip);
            } else if (name.equals("server")) {
                this.cutrServerPanel.setIP(ip);
            } else if (name.equals("tcp listener")) {
                this.tcpListenerPanel.setIP(ip);
            }
        }

        public void setPortFor(String name, String port) {
            if (name.equals("maya")) {
                this.mayaPeerPanel.setPort(port);
            } else if (name.equals("houdini")) {
                this.houdiniPeerPanel.setPort(port);
            } else if (name.equals("client")) {
                this.cutrClientPanel.setPort(port);
            } else if (name.equals("server")) {
                this.cutrServerPanel.setPort(port);
            } else if (name.equals("tcp listener")) {
                this.tcpListenerPanel.setPort(port);
            }
        }

        public void setActiveFor(String name, boolean b) {
            if (name.equals("maya")) {
                this.mayaPeerPanel.setActive(b);
            } else if (name.equals("houdini")) {
                this.houdiniPeerPanel.setActive(b);
            } else if (name.equals("client")) {
                this.cutrClientPanel.setActive(b);
            } else if (name.equals("server")) {
                this.cutrServerPanel.setActive(b);
            } else if (name.equals("tcp listener")) {
                this.tcpListenerPanel.setActive(b);
            }
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.popup.setEnabled(flag);
            if (this.activePanel != null) {
                this.activePanel.setEnabled(flag);
            }
        }
    }

    public class FontSizePanel
    extends JPanel {
        private Color textColor = Color.darkGray;
        private String[] sizes = new String[]{"9", "10", "11", "12", "14", "16", "18", "20", "22", "26", "30"};
        private String prefSize = Preferences.get(Preferences.TEXT_FONT_SIZE);
        private int[] selectionOffsets = null;
        private JComboBox<String> combo;

        public FontSizePanel() {
            this.setLayout(new GridBagLayout());
            this.combo = new JComboBox<String>(this.sizes);
            this.combo.setMaximumRowCount(this.sizes.length);
            this.combo.setFont(Cutter.defaultFont.font);
            this.combo.setPreferredSize(new Dimension(45, 20));
            this.combo.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String str = FontSizePanel.this.combo.getSelectedItem().toString();
                    int size = Integer.parseInt(str);
                    KTextPane tp = WindowInfoPanel.this.window.getTextPane();
                    Font font = new Font(tp.getFont().getName(), tp.getFont().getStyle(), size);
                    tp.setFont(font);
                    WindowInfoPanel.this.window.updateLineMargin();
                }
            });
            this.combo.setSelectedIndex(3);
            this.add(this.combo, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 0)));
            if (this.prefSize != null || this.prefSize.trim().length() > 0) {
                this.prefSize = this.prefSize.trim();
                for (int n = 0; n < this.sizes.length; ++n) {
                    if (!this.sizes[n].equals(this.prefSize)) continue;
                    this.combo.setSelectedIndex(n);
                    break;
                }
            }
        }

        public void setSize(int size) {
            String sizeStr = "" + size;
            this.setSize(sizeStr);
        }

        public void setSize(String str) {
            for (int n = 0; n < this.sizes.length; ++n) {
                if (!this.sizes[n].equals(str)) continue;
                try {
                    int size = Integer.parseInt(str);
                    this.combo.setSelectedIndex(n);
                    WindowInfoPanel.this.window.getTextPane().setFontSize(size);
                    continue;
                }
                catch (NumberFormatException e) {
                    Cutter.setLog("    Exception:FontSizePanel.setSize(String)\n    " + e.toString());
                }
            }
        }

        @Override
        public void setEnabled(boolean flag) {
            this.combo.setEnabled(flag);
        }
    }

    public class TCPListenerPanel
    extends KTitledPanel {
        public LabelField portField;
        private JLabel onOffLabel;
        public KCheckBox onOffBox;
        public JButton clearTextButton;

        private TCPListenerPanel() {
            super("WindowInfoPanel.TCPListenerPanel.info", new Insets(-6, -4, -5, -3), new Insets(-6, 0, 0, 5));
            this.portField = new LabelField("WindowInfoTctPort", "Listen on Port : ", "4444", 4);
            this.onOffLabel = new JLabel("Connect");
            this.onOffBox = new KCheckBox();
            this.clearTextButton = new JButton("Clear Text");
            Font f = this.portField.label.getFont();
            this.portField.label.setFont(new Font(f.getName(), 0, f.getSize()));
            this.add(this.portField, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 3)));
            this.add(this.onOffLabel, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 5, 2, -2)));
            this.add(this.onOffBox, new GBC(2, 0, 1, 1, 0.0, 1.0, 0, -2, 17, 0, new Insets(0, 2, 0, 10)));
            this.add(this.clearTextButton, new GBC(3, 0, 1, 1, 0.0, 1.0, 0, -4, 17, 0, new Insets(0, 2, 0, 10)));
            this.add(new JPanel(), new GBC(4, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 5, 0, 0)));
            this.onOffLabel.setFont(new Font(Cutter.defaultFont.name, 1, Cutter.defaultFont.size + 2));
            this.clearTextButton.setRequestFocusEnabled(false);
            this.clearTextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowInfoPanel.this.window.setText("");
                }
            });
            this.onOffBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        int portID = Integer.parseInt(TCPListenerPanel.this.portField.field.getText());
                        if (!WindowInfoPanel.this.window.startTCPListener(portID)) {
                            Cutter.setLog("    Error: WindowInfoPanel.TCPListenerPanel.itemStateChanged()\n           Cannot start TCPListener");
                            ((JCheckBox)e.getSource()).setSelected(false);
                            return;
                        }
                        WindowInfoPanel.this.tcpListeningMode = true;
                    } else {
                        WindowInfoPanel.this.window.stopTCPListener();
                        WindowInfoPanel.this.tcpListeningMode = false;
                    }
                }
            });
        }

        public void saveSelf() {
            this.portField.saveSelf();
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.portField.setEnabled(flag);
            this.onOffBox.setEnabled(flag);
            this.clearTextButton.setEnabled(flag);
        }

        public void restoreToDefaults() {
            if (this.onOffBox.isSelected()) {
                this.onOffBox.doClick();
            }
        }

        public void setIP(String ip) {
        }

        public void setPort(String port) {
            this.portField.field.setText(port);
        }

        public void setActive(boolean b) {
            this.onOffBox.setSelected(b);
        }
    }

    public class HoudiniPeerPanel
    extends KTitledPanel {
        private LabelField peerIP;
        private LabelField peerPort;
        private JLabel onOffLabel;
        private KCheckBox onOffBox;
        public JButton sendButton;
        private boolean connectionError;

        private HoudiniPeerPanel() {
            super("WindowInfoPanel.HoudiniPeerPanel.info", new Insets(-6, -4, -5, -3), new Insets(-6, 0, 0, 5));
            this.peerIP = new LabelField("WindowInfoHoudiniIP", "IP ", "localhost", 8);
            this.peerPort = new LabelField("WindowInfoHoudiniPort", ":", "3333", 4);
            this.onOffLabel = new JLabel("Connect");
            this.onOffBox = new KCheckBox();
            this.sendButton = new JButton("Send");
            this.connectionError = false;
            this.add(this.peerIP, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 2)));
            this.add(this.peerPort, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 3)));
            this.add(this.onOffLabel, new GBC(2, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 5, 2, -2)));
            this.add(this.onOffBox, new GBC(3, 0, 1, 1, 0.0, 1.0, 0, -2, 17, 0, new Insets(0, 2, 0, 3)));
            this.add(this.sendButton, new GBC(4, 0, 1, 1, 0.0, 1.0, 0, -4, 17, 0, new Insets(0, 2, 0, 10)));
            this.add(new JPanel(), new GBC(5, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
            this.peerIP.field.setHorizontalAlignment(4);
            this.onOffLabel.setFont(new Font(Cutter.defaultFont.name, 1, Cutter.defaultFont.size + 2));
            this.sendButton.setRequestFocusEnabled(false);
            this.sendButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowInfoPanel.this.window.addToHistory();
                    WindowInfoPanel.this.window.sendToHoudiniClient();
                    WindowInfoPanel.this.window.saveFile();
                }
            });
            this.onOffBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        int portID;
                        String serverIP = ((HoudiniPeerPanel)HoudiniPeerPanel.this).peerIP.field.getText().trim();
                        String msg = WindowInfoPanel.this.window.addHoudiniClient(serverIP, (portID = Integer.parseInt(((HoudiniPeerPanel)HoudiniPeerPanel.this).peerPort.field.getText().trim())) + 10000);
                        if (msg.trim().length() != 0) {
                            if (msg.equals(KAbstractWindow.CANNOT_CONNECT_TO_CLIENT)) {
                                JOptionPane.showMessageDialog(KDesktop.desktopPane, "Houdini is not responding. Ensure the following HCommand\nhas been entered into Houdini's text port window:\n     openport " + HoudiniPeerPanel.this.peerPort.getField(), "Cannot Connect to Houdini", 0);
                            } else {
                                JOptionPane.showMessageDialog(KDesktop.desktopPane, msg, "Connection Exception", 0);
                            }
                            HoudiniPeerPanel.this.connectionError = true;
                            ((JCheckBox)e.getSource()).setSelected(false);
                            return;
                        }
                        WindowInfoPanel.this.houdiniMode = true;
                        HoudiniPeerPanel.this.connectionError = false;
                    } else {
                        WindowInfoPanel.this.houdiniMode = false;
                        WindowInfoPanel.this.window.removeHoudiniClient();
                        if (!HoudiniPeerPanel.this.connectionError) {
                            JOptionPane.showMessageDialog(KDesktop.desktopPane, "For security reasons if you are closing a connection\nto a Houdini session you should close the open port", "Closing Connection to Houdini", 1);
                        }
                    }
                }
            });
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.peerIP.setEnabled(flag);
            this.peerPort.setEnabled(flag);
            this.onOffBox.setEnabled(flag);
            this.sendButton.setEnabled(flag);
        }

        public void saveSelf() {
            this.peerIP.saveSelf();
            this.peerPort.saveSelf();
        }

        public void restoreToDefaults() {
            if (this.onOffBox.isSelected()) {
                this.onOffBox.doClick();
            }
            WindowInfoPanel.this.houdiniMode = false;
        }

        public void setIP(String ip) {
            this.peerIP.field.setText(ip);
        }

        public void setPort(String ip) {
            this.peerPort.field.setText(ip);
        }

        public void setActive(boolean b) {
            this.onOffBox.setSelected(b);
        }
    }

    private class MayaPeerPanel
    extends KTitledPanel {
        private LabelField peerIP;
        private LabelField peerPort;
        private JLabel onOffLabel;
        private KCheckBox onOffBox;
        private JButton sendButton;
        private boolean connectionError;

        private MayaPeerPanel() {
            super("WindowInfoPanel.MayaPeerPanel.info", new Insets(-6, -4, -5, -3), new Insets(-6, 0, 0, 5));
            this.peerIP = new LabelField("WindowInfoMayaIP", "IP ", "localhost", 8);
            this.peerPort = new LabelField("WindowInfoMayaPort", ":", "2222", 4);
            this.onOffLabel = new JLabel("Connect");
            this.onOffBox = new KCheckBox();
            this.sendButton = new JButton("Send");
            this.connectionError = false;
            this.add(this.peerIP, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 2)));
            this.add(this.peerPort, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 3)));
            this.add(this.onOffLabel, new GBC(2, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 5, 2, -2)));
            this.add(this.onOffBox, new GBC(3, 0, 1, 1, 0.0, 1.0, 0, -2, 17, 0, new Insets(0, 2, 0, 3)));
            this.add(this.sendButton, new GBC(4, 0, 1, 1, 0.0, 1.0, 0, -4, 17, 0, new Insets(0, 2, 0, 5)));
            this.add(new JPanel(), new GBC(5, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 5, 0, 0)));
            this.onOffLabel.setFont(new Font(Cutter.defaultFont.name, 1, Cutter.defaultFont.size + 2));
            this.peerIP.field.setHorizontalAlignment(4);
            this.sendButton.setRequestFocusEnabled(false);
            this.sendButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowInfoPanel.this.window.saveFile();
                    BBxt.execute();
                }
            });
            this.onOffBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        String serverIP = ((MayaPeerPanel)MayaPeerPanel.this).peerIP.field.getText();
                        String localIP = Client.getLocalIP();
                        int portID = Integer.parseInt(((MayaPeerPanel)MayaPeerPanel.this).peerPort.field.getText());
                        String msg = WindowInfoPanel.this.window.addMayaClient(serverIP, portID);
                        if (msg.trim().length() != 0) {
                            if (msg.equals(KAbstractWindow.CANNOT_CONNECT_TO_CLIENT)) {
                                JOptionPane.showMessageDialog(KDesktop.desktopPane, "Maya is not responding. Ensure the following MEL command\nhas been entered into Maya's script window:\n     commandPort -n \":" + MayaPeerPanel.this.peerPort.getField() + "\";", "Cannot Connect to Maya", 0);
                            } else {
                                JOptionPane.showMessageDialog(KDesktop.desktopPane, msg, "Connection Exception", 0);
                            }
                            MayaPeerPanel.this.connectionError = true;
                            ((JCheckBox)e.getSource()).setSelected(false);
                            return;
                        }
                        WindowInfoPanel.this.mayaMode = true;
                        MayaPeerPanel.this.connectionError = false;
                    } else {
                        WindowInfoPanel.this.mayaMode = false;
                        WindowInfoPanel.this.window.removeMayaClient();
                    }
                }
            });
        }

        public void saveSelf() {
            this.peerIP.saveSelf();
            this.peerPort.saveSelf();
        }

        public void restoreToDefaults() {
            if (this.onOffBox.isSelected()) {
                this.onOffBox.doClick();
            }
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.peerIP.setEnabled(flag);
            this.peerPort.setEnabled(flag);
            this.onOffBox.setEnabled(flag);
            this.sendButton.setEnabled(flag);
        }

        public void setIP(String ip) {
            this.peerIP.field.setText(ip);
        }

        public void setPort(String ip) {
            this.peerPort.field.setText(ip);
        }

        public void setActive(boolean b) {
            this.onOffBox.setSelected(b);
        }
    }

    private class CutterServerPanel
    extends KTitledPanel {
        private LabelField serverPort;
        private JLabel onOffLabel;
        private KCheckBox onOffBox;

        private CutterServerPanel() {
            super("WindowInfoPanel.CutterServerPanel.info", new Insets(-6, -4, -5, -3), new Insets(-6, 0, 0, 5));
            this.serverPort = new LabelField("WindowInfoServerPort", "Port: ", "1024", 4);
            this.onOffLabel = new JLabel("Broadcast");
            this.onOffBox = new KCheckBox();
            this.add(this.serverPort, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 3)));
            this.add(this.onOffLabel, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 5, 2, -2)));
            this.add(this.onOffBox, new GBC(2, 0, 1, 1, 0.0, 1.0, 0, -2, 17, 0, new Insets(0, 2, 0, 10)));
            this.add(new JPanel(), new GBC(3, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
            this.onOffLabel.setFont(new Font(Cutter.defaultFont.name, 1, Cutter.defaultFont.size + 2));
            this.onOffBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        int portID = Integer.parseInt(((CutterServerPanel)CutterServerPanel.this).serverPort.field.getText());
                        if (WindowInfoPanel.this.fatalServerMode) {
                            Cutter.setLog("    Error:WindowInfoPanel.itemStateChanged() - fatalServerMode = " + WindowInfoPanel.this.fatalServerMode);
                            ((JCheckBox)e.getSource()).setSelected(false);
                            return;
                        }
                        if (!WindowInfoPanel.this.window.startBroadcasting(portID)) {
                            ((JCheckBox)e.getSource()).setSelected(false);
                            WindowInfoPanel.this.cutterServerMode = false;
                            ((CutterServerPanel)CutterServerPanel.this).serverPort.field.setForeground(Color.red);
                            return;
                        }
                        ((CutterServerPanel)CutterServerPanel.this).serverPort.field.setForeground(Color.black);
                        WindowInfoPanel.this.window.setBroadcastMode(1);
                        WindowInfoPanel.this.cutterServerMode = true;
                    } else {
                        WindowInfoPanel.this.cutterServerMode = false;
                        WindowInfoPanel.this.window.stopBroadcasting();
                    }
                }
            });
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.serverPort.setEnabled(flag);
            this.onOffBox.setEnabled(flag);
        }

        public void saveSelf() {
            this.serverPort.saveSelf();
        }

        public void restoreToDefaults() {
            if (this.onOffBox.isSelected()) {
                this.onOffBox.doClick();
            }
        }

        public void setIP(String ip) {
        }

        public void setPort(String ip) {
            this.serverPort.field.setText(ip);
        }

        public void setActive(boolean b) {
            this.onOffBox.setSelected(b);
        }
    }

    public class CutterClientPanel
    extends KTitledPanel {
        private LabelField clientIP;
        private LabelField clientPort;
        private JLabel onOffLabel;
        public KCheckBox onOffBox;
        private Component lostFocusComp;

        private CutterClientPanel() {
            super("WindowInfoPanel.CutterClientPanel.info", new Insets(-6, -4, -5, -3), new Insets(-6, 0, 0, 5));
            this.clientIP = new LabelField("WindowInfoClientIP", "IP ", "10.7.223.21", 8);
            this.clientPort = new LabelField("WindowInfoClientPort", ":", "1024", 4);
            this.onOffLabel = new JLabel("Connect");
            this.onOffBox = new KCheckBox();
            this.lostFocusComp = null;
            this.add(this.clientIP, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 3)));
            this.add(this.clientPort, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 3)));
            this.add(this.onOffLabel, new GBC(2, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 5, 2, -2)));
            this.add(this.onOffBox, new GBC(3, 0, 1, 1, 0.0, 1.0, 0, -2, 17, 0, new Insets(0, 2, 0, 10)));
            this.add(new JPanel(), new GBC(4, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
            this.onOffLabel.setFont(new Font(Cutter.defaultFont.name, 1, Cutter.defaultFont.size + 2));
            this.clientIP.field.setHorizontalAlignment(4);
            this.onOffBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (WindowInfoPanel.this.fatalServerMode) {
                            ((JCheckBox)e.getSource()).setSelected(false);
                            WindowInfoPanel.this.window.getTextPane().setEditable(true);
                            return;
                        }
                        StringBuffer buff = new StringBuffer();
                        WindowInfoPanel.this.window.getText(buff);
                        if (buff.length() > 0) {
                            Object[] options = new String[]{"Connect", "Cancel"};
                            int result = JOptionPane.showOptionDialog(null, "The result of connecting to a Cutter server will be\nto delete your existing text.\n", "Deleting Existing Text Warning", -1, 3, null, options, options[1]);
                            switch (result) {
                                case 1: {
                                    ((JCheckBox)e.getSource()).setSelected(false);
                                    WindowInfoPanel.this.window.getTextPane().setEditable(true);
                                    return;
                                }
                            }
                        }
                        String serverIP = ((CutterClientPanel)CutterClientPanel.this).clientIP.field.getText();
                        String localIP = Client.getLocalIP();
                        int portID = Integer.parseInt(((CutterClientPanel)CutterClientPanel.this).clientPort.field.getText());
                        if (!WindowInfoPanel.this.window.addCutterClient(serverIP, portID, localIP)) {
                            JOptionPane.showMessageDialog(KDesktop.desktopPane, "Cutter located at the computer with the IP address,\n     " + serverIP + "\nis either not acting as a server, or is not broadcasting\non port\n     " + portID, "Cannot Find Server Error", 0);
                            ((JCheckBox)e.getSource()).setSelected(false);
                            WindowInfoPanel.this.window.getTextPane().setEditable(true);
                            return;
                        }
                        WindowInfoPanel.this.cutterClientMode = true;
                        WindowInfoPanel.this.window.getTextPane().setEditable(false);
                        Preferences.write(Preferences.CUTTER_CLIENT_ADDRESS, serverIP);
                    } else {
                        WindowInfoPanel.this.cutterClientMode = false;
                        WindowInfoPanel.this.window.removeCutterClient();
                        WindowInfoPanel.this.window.getTextPane().setEditable(true);
                    }
                }
            });
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.clientIP.setEnabled(flag);
            this.clientPort.setEnabled(flag);
            this.onOffBox.setEnabled(flag);
        }

        public void saveSelf() {
            this.clientIP.saveSelf();
            this.clientPort.saveSelf();
        }

        public void restoreToDefaults() {
            if (this.onOffBox.isSelected()) {
                this.onOffBox.doClick();
            }
        }

        public void setIP(String ip) {
            this.clientIP.field.setText(ip);
        }

        public void setPort(String ip) {
            this.clientPort.field.setText(ip);
        }

        public void setActive(boolean b) {
            this.onOffBox.setSelected(b);
        }
    }

    public class LabelField
    extends JPanel {
        public KSerialTextField field;
        public JLabel label;

        private LabelField(String cerealName, String labelStr, String defaultFieldStr, int fieldWidth) {
            super(new GridBagLayout());
            this.label = new JLabel();
            this.label.setText(labelStr);
            this.field = new KSerialTextField(cerealName, defaultFieldStr, fieldWidth);
            this.field.usesModelDialog = true;
            this.field.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LabelField.this.field.setForeground(Color.black);
                }
            });
            if (this.field.getText().equals("")) {
                this.field.setText(defaultFieldStr);
            }
            if (fieldWidth != -1) {
                this.field.setColumns(fieldWidth);
            }
            this.label.setForeground(WindowInfoPanel.this.textColor);
            this.field.setForeground(WindowInfoPanel.this.textColor);
            int right = 0;
            if (labelStr.equals(":")) {
                right = 2;
                this.label.setFont(new Font(Cutter.defaultFont.name, 1, Cutter.defaultFont.size));
            } else {
                this.label.setFont(Cutter.defaultFont.font);
            }
            this.field.setFont(new Font(Cutter.defaultFont.name, 0, Cutter.defaultFont.size));
            FontMetrics metrics = this.getFontMetrics(this.field.getFont());
            String Wstr = "";
            for (int n = 0; n < fieldWidth; ++n) {
                Wstr = Wstr + "W";
            }
            int fieldTextWidth = SwingUtilities.computeStringWidth(metrics, this.field.getText());
            int minWidth = SwingUtilities.computeStringWidth(metrics, Wstr);
            int w = minWidth > fieldTextWidth ? minWidth : fieldTextWidth;
            this.field.setMinimumSize(new Dimension(w + 10, 19));
            this.field.setPreferredSize(new Dimension(w + 10, 19));
            this.add((Component)this.label, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 0, 0, right)));
            this.add((Component)this.field, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 0)));
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.label.setEnabled(flag);
            this.field.setEnabled(flag);
        }

        public void saveSelf() {
            this.field.saveSelf();
        }

        public String getField() {
            return this.field.getText();
        }
    }
}

