/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Args.ArgNodeidData;
import UI_Script.Args.ArgsRegAction;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.EnumUtils;
import Utilities.FileUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class ArgsUtils {
    public static String lastLoadExtensionFormat = null;

    public static Vector<ArgNodeidData> getDuplicateNodeids(ArgNodeidData deskArgData, Vector<ArgNodeidData> instances) {
        Vector<ArgNodeidData> listOfDups = new Vector<ArgNodeidData>();
        for (int n = 0; n < instances.size(); ++n) {
            ArgNodeidData nd1 = instances.elementAt(n);
            for (int i = 0; i < instances.size(); ++i) {
                ArgNodeidData nd = instances.elementAt(i);
                if (i == n) continue;
                if (nd.sameAs(nd1)) {
                    nd.dupfile = nd1.argfile;
                    listOfDups.add(nd);
                }
                if (deskArgData == null || !nd.sameAs(deskArgData)) continue;
                deskArgData.dupfile = nd1.argfile;
            }
        }
        return listOfDups;
    }

    public static Vector<File> getListOfArgFiles(File f) {
        int n;
        lastLoadExtensionFormat = null;
        KAbstractWindow window = KAbstractDesktop.getWindowWithFile(f);
        Vector<String> listOfArgNames = new Vector<String>();
        Vector<File> listOfArgsFiles = new Vector<File>();
        Enumeration<String> e = FileUtils.readLines(f.getPath());
        if (e == null) {
            return listOfArgsFiles;
        }
        String[] lines = EnumUtils.toStringArray(e);
        if (lines == null || lines.length == 0) {
            return listOfArgsFiles;
        }
        for (n = 0; n < lines.length; ++n) {
            int sqIndex;
            int quoteIndex;
            String[] tokens;
            String line = lines[n].trim();
            line = TextUtils.trimTrailingChar(line, ']');
            line = line.trim();
            line = TextUtils.trimTrailingChar(line, '\"');
            if (!(line = line.trim()).startsWith("LoadExtension") || (tokens = TextUtils.tokenize(line)).length <= 2 || !tokens[1].equalsIgnoreCase("args")) continue;
            String reversedline = TextUtils.reverse(line);
            int slashIndex = reversedline.indexOf(47) == -1 ? 100000 : reversedline.indexOf(47);
            int n2 = quoteIndex = reversedline.indexOf(34) == -1 ? 100000 : reversedline.indexOf(34);
            if (slashIndex == quoteIndex) continue;
            int index = quoteIndex < slashIndex ? quoteIndex : slashIndex;
            String filename = reversedline.substring(0, index);
            listOfArgNames.add(TextUtils.reverse(filename));
            if (!tokens[2].startsWith("[") || !lines[n].trim().endsWith("]") || (sqIndex = line.indexOf(91)) <= -1) continue;
            String substr = line.substring(sqIndex);
            lastLoadExtensionFormat = substr.replace(TextUtils.reverse(filename), "__ARG_NAME__\"]");
        }
        if (listOfArgNames.size() == 0) {
            Cutter.setLog("    Info: ArgsUtils.getListOfArgFiles() - No LoadExtension args in .ini file.");
            return listOfArgsFiles;
        }
        ArgsRegAction.userArgsDir = Preferences.get(Preferences.PATH_USER_ARGS);
        for (n = 0; n < listOfArgNames.size(); ++n) {
            File file = new File(ArgsRegAction.userArgsDir, (String)listOfArgNames.elementAt(n));
            listOfArgsFiles.add(file);
        }
        return listOfArgsFiles;
    }

    public static Vector<File> listOfBadArgFiles(Vector<File> listOfArgsFiles) {
        Vector<File> outlist = new Vector<File>();
        if (listOfArgsFiles == null) {
            return outlist;
        }
        for (int n = 0; n < listOfArgsFiles.size(); ++n) {
            File argFile = listOfArgsFiles.elementAt(n);
            if (!argFile.exists()) {
                outlist.add(argFile);
                continue;
            }
            ArgNodeidData argData = ArgNodeidData.getInstance(argFile);
            if (argData == null) {
                outlist.add(argFile);
                return outlist;
            }
            if (argData.argfile == null) {
                return outlist;
            }
            if (argData.argfile.exists()) continue;
            outlist.add(argFile);
        }
        return outlist;
    }

    public static Vector<File> getFilesWithNodeidLessThan(int minValue, Vector<ArgNodeidData> listOfArgsData) {
        Vector<File> outlist = new Vector<File>();
        for (int n = 0; n < listOfArgsData.size(); ++n) {
            if (listOfArgsData.elementAt((int)n).nodeidInt >= minValue) continue;
            outlist.add(listOfArgsData.elementAt((int)n).argfile);
        }
        return outlist.size() == 0 ? null : outlist;
    }

    public static String getNodeidValue(KTextPane textpane) {
        if (textpane == null) {
            return null;
        }
        String text = textpane.getText();
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        return ArgsUtils.getNodeidValue(text);
    }

    public static String getNodeidValue(File file) {
        if (file == null || !file.exists()) {
            Cutter.setLog("    Debug: ArgsUtils.getNodeidValue(File) - input file is null");
            return null;
        }
        String text = FileUtils.read(file);
        return ArgsUtils.getNodeidValue(text);
    }

    private static String getNodeidValue(String text) {
        if (text == null || text.trim().length() == 0) {
            Cutter.setLog("    Debug: ArgsUtils.getNodeidValue(String) - input text is null");
            return null;
        }
        String[] lines = TextUtils.tokenize(text, "\n");
        for (int n = 0; n < lines.length; ++n) {
            String[] tokens;
            String line = lines[n].trim();
            if (!line.startsWith("<rfmdata") || (tokens = TextUtils.tokenize(line, '=')) == null || tokens.length < 2 || !tokens[0].trim().endsWith("nodeid")) continue;
            if ((tokens = TextUtils.tokenize(tokens[1], '\"')) == null || tokens.length < 1) {
                return null;
            }
            try {
                int num = NumberUtils.strToInt(tokens[0]);
                return "" + num;
            }
            catch (NumberFormatException er) {
                return "-1";
            }
        }
        return null;
    }

    public static File getRfM_iniFile() {
        String iniPath = Preferences.get(Preferences.PATH_USER_RFM_INI);
        if (iniPath == null || iniPath.trim().length() == 0) {
            return null;
        }
        File iniFile = new File(iniPath);
        if (!iniFile.getName().equals("RenderMan_for_Maya.ini")) {
            iniFile = new File(iniFile.getParent(), "RenderMan_for_Maya.ini");
        }
        return !iniFile.exists() ? null : iniFile;
    }
}

