/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Preferences.Preferences;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.DelayedFinder;
import UI_Window.KWindow.HTMLWindow;
import Utilities.EnvUtils;
import Utilities.TextUtils;
import java.io.File;
import javax.swing.SwingUtilities;
import kernal.Tokenizers.Tokenizer;

public class BrowserUtils {
    public static final String USING_INTERNAL_BROWSER = "internal_browser";
    public static final String USING_EXTERNAL_BROWSER = "external_browser";
    private static int preferredSlashCount = -1;

    public static void open(File file) {
        BrowserUtils.open(file, true);
    }

    public static void open(File file, final boolean wantsExternalBrowser) {
        Cutter.setLog("    Debug:BrowserUtils.open(File) file >" + file.getPath() + "<");
        String str = file.getPath().replace('\\', '/');
        final String url = TextUtils.replace(str, ' ', "%20");
        if (preferredSlashCount != -1 && !BBxt.fileURL(url, preferredSlashCount)) {
            Cutter.setLog("    BrowserUtils.open() - cannot load \"" + url + "\" using " + preferredSlashCount + " leading forward slashes!");
            return;
        }
        Thread thread = new Thread("Browser thread"){

            @Override
            public void run() {
                BrowserUtils.open(url, wantsExternalBrowser);
            }
        };
        thread.start();
    }

    public static void open(String urlStr) {
        BrowserUtils.open(urlStr, true);
    }

    public static synchronized void open(String urlStr, boolean wantsExternalBrowser) {
        String[] items;
        if (urlStr == null) {
            Cutter.setLog("    Error: BrowserUtils.open(String) - URL is null");
            return;
        }
        Cutter.setLog("    Debug: BrowserUtils.open() - wantsExternalBrowser = " + wantsExternalBrowser);
        boolean isFirefox = false;
        if (Preferences.get(Preferences.WEB_BROWSER_PREFERRED).equalsIgnoreCase("firefox")) {
            isFirefox = true;
        }
        if (wantsExternalBrowser) {
            Tokenizer tok;
            int colonOffset;
            if (EnvUtils.isOSXEnvironment() && urlStr.startsWith("file")) {
                colonOffset = urlStr.indexOf(58);
                tok = new Tokenizer();
                tok.setBuffer(urlStr);
                if (tok.charSearch("localhost", true) == null && colonOffset != -1) {
                    urlStr = TextUtils.trimLeadingChar(urlStr.substring(colonOffset + 1), '/');
                    urlStr = "file:///" + urlStr;
                }
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:BrowserUtils.open(String) OSX and URL begins with \"file\" >" + urlStr + "<");
                }
            } else if (EnvUtils.isWinEnvironment() && urlStr.startsWith("file") && !isFirefox) {
                colonOffset = urlStr.indexOf(58);
                tok = new Tokenizer();
                tok.setBuffer(urlStr);
                if (tok.charSearch("localhost", true) == null && colonOffset != -1) {
                    urlStr = urlStr.substring(colonOffset);
                }
                int beginAt = 0;
                for (int n = 0; n < urlStr.length(); ++n) {
                    if (!Character.isLetterOrDigit(urlStr.charAt(n))) continue;
                    beginAt = n;
                    break;
                }
                urlStr = urlStr.substring(beginAt);
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:BrowserUtils.open(String) WIN, not firefox and URL begins with \"file\" >" + urlStr + "<");
                }
            } else if (urlStr.startsWith("file") && !isFirefox) {
                colonOffset = urlStr.indexOf(58);
                tok = new Tokenizer();
                tok.setBuffer(urlStr);
                if (tok.charSearch("localhost", true) == null && colonOffset != -1) {
                    urlStr = TextUtils.trimLeadingChar(urlStr.substring(colonOffset + 1), '/');
                    urlStr = "file:///" + urlStr;
                }
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:BrowserUtils.open(String) not firefox and URL begins with \"file\" >" + urlStr + "<");
                }
            } else if (EnvUtils.isLinuxEnvironment() && urlStr.startsWith("file")) {
                colonOffset = urlStr.indexOf(58);
                tok = new Tokenizer();
                tok.setBuffer(urlStr);
                if (tok.charSearch("localhost", true) == null && colonOffset != -1) {
                    urlStr = TextUtils.trimLeadingChar(urlStr.substring(colonOffset + 1), '/');
                    urlStr = "file:///" + urlStr;
                }
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:BrowserUtils.open(String) LINUX and URL begins with \"file\" >" + urlStr + "<");
                }
            }
        }
        if (!wantsExternalBrowser) {
            try {
                Cutter.setLog("    Degug: BrowserUtils.open() - using external browser");
                Cutter.htmlWindow.setPage(urlStr, null);
                return;
            }
            catch (Exception e) {
                Cutter.setLog("    Exception: BrowserUtils.open() cannot load url \"" + urlStr + "\"");
                return;
            }
        }
        String browser = Preferences.get(Preferences.WEB_BROWSER_PREFERRED);
        urlStr = urlStr.replaceAll("(%20)", " ");
        if (EnvUtils.isWinEnvironment()) {
            items = new String[]{"cmd", "/C", "start", browser, urlStr};
            ProcessManager fp = new ProcessManager();
            fp.launch(items, null, false, null, true);
        } else {
            if (EnvUtils.isOSXEnvironment()) {
                items = new String[]{"open", "-a", browser, urlStr.replaceAll(" ", "%20")};
                ProcessManager fp = new ProcessManager();
                fp.launch(items, null, false, null, true);
                return;
            }
            if (EnvUtils.isLinuxEnvironment()) {
                items = new String[]{browser, urlStr};
                ProcessManager fp = new ProcessManager();
                fp.launch(items, null, false, null, true);
            }
        }
    }

    public static void openAndSearchFor(final String url, final String target) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HTMLWindow.editorPane.getDocument().putProperty("title", "Cutter Browser");
                Cutter.htmlWindow.setTitle("loading");
                KAbstractDesktop.toFront(Cutter.htmlWindow, true);
                try {
                    String regexp = "\\n" + target + "\\s*\\([^)]+\\)";
                    DelayedFinder df = new DelayedFinder(regexp);
                    Cutter.htmlWindow.setDelayedFind(df);
                    if (url != null) {
                        Cutter.htmlWindow.setPage(url, null);
                    }
                    Cutter.htmlWindow.setVisible(true);
                }
                catch (Exception ex) {
                    Cutter.setLog("    Exception:PythonHelp.showDocFor()\n" + ex.toString());
                }
            }
        });
    }
}

