/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class BufferedImageUtils {
    BufferedImage image;
    double width;
    double height;

    public BufferedImageUtils(BufferedImage bi) {
        this.image = bi;
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
    }

    public void setBufferedImage(BufferedImage bi) {
        this.image = bi;
    }

    public BufferedImage rotate(double angle) {
        BufferedImage temp;
        boolean rotate180 = false;
        if (Math.abs(Math.abs(angle) - Math.PI) > 1.0E-4) {
            temp = new BufferedImage((int)this.height, (int)this.width, 1);
        } else {
            rotate180 = true;
            temp = new BufferedImage((int)this.width, (int)this.height, 1);
        }
        AffineTransform t = AffineTransform.getRotateInstance(angle, this.width / 2.0, this.height / 2.0);
        if (this.width != this.height && !rotate180) {
            double ratio = (this.width - this.height) / 2.0;
            double d = ratio = angle > -Math.PI ? -ratio : ratio;
            if (ratio >= 0.0) {
                t.translate(ratio, ratio);
            } else {
                t.translate(ratio, ratio);
            }
        }
        AffineTransformOp op = new AffineTransformOp(t, 1);
        op.filter(this.image, temp);
        return temp;
    }
}

