/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import Utilities.VectorUtils;
import java.awt.Component;
import java.awt.Container;
import java.util.Vector;
import javax.swing.JTabbedPane;

public class ComponentUtils {
    private String className;
    private Vector<Component> listOfComps = new Vector();
    private Class targetClass = null;

    public ComponentUtils(Component comp, String className) {
        if (className == null || className.trim().length() == 0) {
            this.className = null;
        } else {
            this.className = className;
            try {
                this.targetClass = Class.forName(className);
            }
            catch (Exception ex) {
                Cutter.setLog("    Error:ComponentUtils(Component,String) " + ex.toString());
                Thread.currentThread();
                Thread.dumpStack();
            }
        }
        this.getComponentOfType(comp);
    }

    public Component[] getAll() {
        return VectorUtils.toComponentArray(this.listOfComps);
    }

    private void getComponentOfType(Component c) {
        if (c == null) {
            return;
        }
        if (this.targetClass != null && this.targetClass.isInstance(c)) {
            this.listOfComps.addElement(c);
        } else if (this.className != null && c.getClass().getName().endsWith(this.className)) {
            this.listOfComps.addElement(c);
        }
        if (c instanceof JTabbedPane) {
            int count = ((JTabbedPane)c).getTabCount();
            for (int n = 0; n < count; ++n) {
                Component comp = ((JTabbedPane)c).getComponentAt(n);
                this.getComponentOfType(comp);
            }
        } else if (c instanceof Container) {
            int count = ((Container)c).getComponentCount();
            if (count == 0 && (this.className == null || c.getClass().getName().endsWith(this.className))) {
                this.listOfComps.addElement(c);
            } else {
                for (int n = 0; n < count; ++n) {
                    Component comp = ((Container)c).getComponent(n);
                    this.getComponentOfType(comp);
                }
            }
        } else {
            this.listOfComps.addElement(c);
        }
    }

    public static Component getParentOfClass(Component comp, String classname) {
        Container c;
        Class<?> cls;
        if (comp == null || classname == null || classname.trim().length() == 0) {
            return null;
        }
        Component temp = comp;
        try {
            cls = Class.forName(classname);
        }
        catch (Exception ex) {
            return null;
        }
        while ((c = temp.getParent()) != null) {
            if (cls.isInstance(c)) {
                return c;
            }
            temp = c;
        }
        return null;
    }

    public static boolean isSubComponentOf(Component parent, Component item) {
        if (parent == null) {
            Cutter.setLog("    Warning:ComponentUtils.isSubComponentOf() parent comp is null");
            return false;
        }
        if (item == null) {
            Cutter.setLog("    Warning:ComponentUtils.isSubComponentOf() item comp is null");
            return false;
        }
        ComponentUtils util = new ComponentUtils(parent, "");
        Component[] comps = util.getAll();
        for (int n = 0; n < comps.length; ++n) {
            if (comps[n] != item) continue;
            return true;
        }
        return false;
    }

    public static Component getComponentWithFocus(Component parent) {
        if (parent == null) {
            Cutter.setLog("    Warning:ComponentUtils.getComponentWithFocus() parent comp is null");
            return null;
        }
        ComponentUtils util = new ComponentUtils(parent, "");
        Component[] comps = util.getAll();
        for (int n = 0; n < comps.length; ++n) {
            if (!comps[n].isFocusOwner()) continue;
            return comps[n];
        }
        return null;
    }
}

