/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Utilities.TextUtils;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtils {
    public static String[] getDateTime() {
        String[] out = new String[3];
        Calendar calendar = Calendar.getInstance();
        String date = calendar.get(2) + 1 + "." + calendar.get(5) + "." + calendar.get(1);
        String time = calendar.get(10) + ":" + calendar.get(12) + ":" + calendar.get(13);
        out[0] = date;
        out[1] = time;
        out[2] = calendar.get(9) == 0 ? "AM" : "PM";
        return out;
    }

    public static String getDateTime(long milli) {
        Date date = new Date(milli);
        return date.toString();
    }

    public static long getTimeInMillis() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTimeInMillis();
    }

    public static String getDateStamp() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer date = new StringBuffer();
        date.append(calendar.get(10) + ".");
        date.append(calendar.get(12) + ":");
        date.append(calendar.get(13));
        if (calendar.get(9) == 0) {
            date.append("am");
        } else {
            date.append("pm");
        }
        date.append(" ");
        date.append(calendar.get(2) + 1 + ".");
        date.append(calendar.get(5) + ".");
        date.append(calendar.get(1));
        return date.toString();
    }

    public static String getMonthOfYear(int num) {
        switch (num) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        return "Invalid Input >" + num + "<";
    }

    public static String getDayOfWeek(String yearMonthDay) {
        String[] tok = TextUtils.tokenize(yearMonthDay, '.');
        if (tok.length != 3) {
            return null;
        }
        int year = Integer.parseInt(tok[0]);
        int month = Integer.parseInt(tok[1]);
        int day = Integer.parseInt(tok[2]);
        return DateTimeUtils.getDayOfWeek(year, month, day);
    }

    public static String getDayOfWeek(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(8, day);
        int d = calendar.get(7);
        switch (d) {
            case 1: {
                return "Sunday";
            }
            case 2: {
                return "Monday";
            }
            case 3: {
                return "Tuesday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Thursday";
            }
            case 6: {
                return "Friday";
            }
            case 7: {
                return "Saturday";
            }
        }
        return "";
    }

    public static String getThSt(int day) {
        switch (day) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
        }
        return "th";
    }

    public static String dateToText(String input) {
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        String[] tok = TextUtils.tokenize(input, ".");
        if (tok == null || tok.length != 3) {
            return null;
        }
        String month = DateTimeUtils.getMonthOfYear(Integer.parseInt(tok[0]));
        String day = tok[1];
        String postfix = DateTimeUtils.getThSt(Integer.parseInt(tok[1]));
        String year = tok[2];
        return day + postfix + " " + month + " " + year;
    }

    public static String timeToText(String input) {
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        String[] tok = TextUtils.tokenize(input, ":");
        if (tok == null || tok.length != 3) {
            return null;
        }
        return tok[0] + "hr " + tok[1] + "min " + tok[2] + "sec";
    }
}

