/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.RegExpUtils;
import Utilities.TextUtils;
import java.io.File;

public class DevkitUtils {
    public static int NOT_DEVKIT = -1;
    public static final int OSL = 0;
    public static final int PATTERN = 1;
    public static final int BXDF = 2;
    public static final int DISPLACEMENT = 3;
    public static final int LIGHT_FILTER = 4;
    public static final int SAMPLE_FILTER = 5;
    public static final int DISPLAY_FILTER = 6;
    public static final int INTEGRATOR = 7;
    public static final int PROJECTION = 8;
    public static final int RIF = 9;
    public static final int PROCEDURAL = 10;
    public static final int IMPLICIT = 11;
    public static final int VOLUME_EXE = 12;
    public static final int BRICK_EXE = 13;

    public static String getDevkitHelpFullName(File file) {
        int devkitType = DevkitUtils.getDevkitScriptType(file);
        switch (devkitType) {
            case 1: {
                return "UI_Script.PixarDev.RixPlugins.RixPatternHelp";
            }
            case 2: {
                return "UI_Script.PixarDev.RixPlugins.RixPatternHelp";
            }
            case 3: {
                return "UI_Script.PixarDev.RixPlugins.RixPatternHelp";
            }
            case 4: {
                return "UI_Script.PixarDev.RixPlugins.RixPatternHelp";
            }
            case 5: {
                return "UI_Script.PixarDev.RixPlugins.RixPatternHelp";
            }
            case 6: {
                return "UI_Script.PixarDev.RixPlugins.RixPatternHelp";
            }
            case 7: {
                return "UI_Script.PixarDev.RixPlugins.RixPatternHelp";
            }
            case 8: {
                return "UI_Script.PixarDev.RixPlugins.RixPatternHelp";
            }
            case 9: {
                return "UI_Script.PixarDev.RifPlugin.RifPluginHelp";
            }
            case 10: {
                return "UI_Script.PixarDev.ProceduralPrimitive.ProceduralPrimitiveHelp";
            }
            case 11: {
                return "UI_Script.PixarDev.ImplicitPlugin.ImplicitPluginHelp";
            }
            case 12: {
                return "UI_Script.PixarDev.RixPlugins.RixPatternHelp";
            }
            case 13: {
                return "UI_Script.PixarDev.BrickMap.BrickMapHelp";
            }
        }
        return "UI_Script.PixarDev.RixPlugins.RixPatternHelp";
    }

    public static String devkitTypeToString(int devkitType) {
        switch (devkitType) {
            case 0: {
                return "OSL";
            }
            case 1: {
                return "PATTERN";
            }
            case 2: {
                return "BXDF";
            }
            case 3: {
                return "DISPLACEMENT";
            }
            case 4: {
                return "LIGHT_FILTER";
            }
            case 5: {
                return "SAMPLE_FILTER";
            }
            case 6: {
                return "DISPLAY_FILTER";
            }
            case 7: {
                return "INTEGRATOR";
            }
            case 8: {
                return "PROJECTION";
            }
            case 9: {
                return "RIF";
            }
            case 10: {
                Cutter.setLog("    Debug:DevkitUtils.devkitTypeToString() - return PROCEDURAL");
                return "PROCEDURAL";
            }
            case 11: {
                return "IMPLICIT";
            }
            case 12: {
                return "VOLUME_EXE";
            }
            case 13: {
                return "BRICK_EXE";
            }
        }
        return "NOT_DEVKIT";
    }

    public static String getDsoExeOutPath(File src) {
        int devkitType = DevkitUtils.getDevkitScriptType(src);
        String srcParentDir = src.getParent();
        String outName = TextUtils.removeExtension(src.getName());
        String outExt = DevkitUtils.getBuildExt(devkitType);
        String outPath = DevkitUtils.getBuildDirPath(devkitType);
        outName = outName + outExt;
        if (outPath.length() == 0) {
            outPath = srcParentDir;
        } else {
            File tmp = new File(outPath);
            if (!tmp.exists()) {
                outPath = srcParentDir;
            }
        }
        File f = new File(outPath, outName);
        String s = f.getPath();
        return new File(outPath, outName).getPath();
    }

    public static String getBuildExt(int scriptType) {
        if (scriptType == 12 || scriptType == 13) {
            return ".exe";
        }
        return EnvUtils.isWinEnvironment() ? ".dll" : ".so";
    }

    public static String getBuildDirPath(int scriptType) {
        String path = "";
        switch (scriptType) {
            case 0: {
                path = Preferences.get(Preferences.PATH_USER_OSL_SHADERS).trim();
                break;
            }
            case 1: {
                path = Preferences.get(Preferences.PATH_USER_PLUGINS).trim();
                break;
            }
            case 2: {
                path = Preferences.get(Preferences.PIXAR_DEVKIT_BXDF_BUILD_PATH).trim();
                break;
            }
            case 3: {
                path = Preferences.get(Preferences.PIXAR_DEVKIT_DISP_BUILD_PATH).trim();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                path = Preferences.get(Preferences.PIXAR_DEVKIT_FILTERS_BUILD_PATH).trim();
                break;
            }
            case 7: {
                path = Preferences.get(Preferences.PIXAR_DEVKIT_INTG_BUILD_PATH).trim();
                break;
            }
            case 8: {
                path = Preferences.get(Preferences.PIXAR_DEVKIT_PROJ_BUILD_PATH).trim();
                break;
            }
            case 9: {
                path = Preferences.get(Preferences.PIXAR_DEVKIT_RIF_BUILD_PATH).trim();
                break;
            }
            case 10: {
                path = Preferences.get(Preferences.PIXAR_DEVKIT_PROCEDURAL_BUILD_PATH).trim();
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                path = Preferences.get(Preferences.PIXAR_DEVKIT_EXE_BUILD_PATH).trim();
            }
        }
        if (path.trim().length() == 0) {
            path = Preferences.get(Preferences.PATH_USER_PLUGINS);
        }
        if ((path = TextUtils.replace_USER_HOME(path)).startsWith(".")) {
            path = FileUtils.relativeToFull(FileUtils.getPWD(), path);
        }
        return path;
    }

    public static String getDupDirectory(int scriptType) {
        switch (scriptType) {
            case 0: {
                String boolStr = Preferences.get(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION);
                if (!boolStr.equals("true")) break;
                return Preferences.get(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION_PATH);
            }
            case 1: {
                String boolStr = Preferences.get(Preferences.TOOL_RENDERMAN_PATTERN_DUPLICATION);
                if (!boolStr.equals("true")) break;
                return Preferences.get(Preferences.TOOL_RENDERMAN_PATTERN_DUPLICATION_PATH);
            }
            case 2: {
                String boolStr = Preferences.get(Preferences.TOOL_RENDERMAN_BXDF_DUPLICATION);
                if (!boolStr.equals("true")) break;
                return Preferences.get(Preferences.TOOL_RENDERMAN_BXDF_DUPLICATION_PATH);
            }
            case 3: {
                String boolStr = Preferences.get(Preferences.TOOL_RENDERMAN_DISP_DUPLICATION);
                if (!boolStr.equals("true")) break;
                return Preferences.get(Preferences.TOOL_RENDERMAN_DISP_DUPLICATION_PATH);
            }
            case 4: 
            case 5: 
            case 6: {
                String boolStr = Preferences.get(Preferences.TOOL_RENDERMAN_FILTERS_DUPLICATION);
                if (!boolStr.equals("true")) break;
                return Preferences.get(Preferences.TOOL_RENDERMAN_FILTERS_DUPLICATION_PATH);
            }
            case 7: {
                String boolStr = Preferences.get(Preferences.TOOL_RENDERMAN_INTG_DUPLICATION);
                if (!boolStr.equals("true")) break;
                return Preferences.get(Preferences.TOOL_RENDERMAN_INTG_DUPLICATION_PATH);
            }
            case 8: {
                String boolStr = Preferences.get(Preferences.TOOL_RENDERMAN_PROJ_DUPLICATION);
                if (!boolStr.equals("true")) break;
                return Preferences.get(Preferences.TOOL_RENDERMAN_PROJ_DUPLICATION_PATH);
            }
            case 9: {
                String boolStr = Preferences.get(Preferences.TOOL_RENDERMAN_RIF_DUPLICATION);
                if (!boolStr.equals("true")) break;
                return Preferences.get(Preferences.TOOL_RENDERMAN_RIF_DUPLICATION_PATH);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                String boolStr = Preferences.get(Preferences.TOOL_RENDERMAN_EXE_DUPLICATION);
                if (!boolStr.equals("true")) break;
                return Preferences.get(Preferences.TOOL_RENDERMAN_EXE_DUPLICATION_PATH);
            }
        }
        return null;
    }

    public static int getDevkitScriptType(File file) {
        if (file == null || !file.exists()) {
            return NOT_DEVKIT;
        }
        String path = file.getPath();
        if (path == null) {
            return NOT_DEVKIT;
        }
        String ext = FileUtils.getExtension(path);
        if (ext == null || ext.trim().length() == 0) {
            return NOT_DEVKIT;
        }
        String srcText = FileUtils.read(path);
        if (srcText == null || srcText.trim().length() == 0) {
            return NOT_DEVKIT;
        }
        if (RegExpUtils.split(srcText, "(\\s*class\\s*\\w+\\s*:\\s*public\\s*RixBxdf)") != null) {
            return 2;
        }
        if (RegExpUtils.split(srcText, "(\\s*class\\s*\\w+\\s*:\\s*public\\s*RixPattern)") != null) {
            return 1;
        }
        if (RegExpUtils.split(srcText, "(\\s*class\\s*\\w+\\s*:\\s*public\\s*RixDisplacement)") != null) {
            return 3;
        }
        if (RegExpUtils.split(srcText, "(\\s*class\\s*\\w+\\s*:\\s*public\\s*RixLightFilter)") != null) {
            return 4;
        }
        if (RegExpUtils.split(srcText, "(\\s*class\\s*\\w+\\s*:\\s*public\\s*RixSampleFilter)") != null) {
            return 5;
        }
        if (RegExpUtils.split(srcText, "(\\s*class\\s*\\w+\\s*:\\s*public\\s*RixDisplayFilter)") != null) {
            return 6;
        }
        if (RegExpUtils.split(srcText, "(\\s*class\\s*\\w+\\s*:\\s*public\\s*RixIntegrator)") != null) {
            return 7;
        }
        if (RegExpUtils.split(srcText, "(\\s*class\\s*\\w+\\s*:\\s*public\\s*RixProjection)") != null) {
            return 8;
        }
        if (RegExpUtils.split(srcText, "(\\s*class\\s*\\w+\\s*:\\s*public\\s*RifPlugin)") != null) {
            return 9;
        }
        if (RegExpUtils.split(srcText, "(\\s*virtual\\s*void\\s*GenerateSample\\s*[(]\\s*RixBXTransportTrait)") != null) {
            return 2;
        }
        if (RegExpUtils.split(srcText, "(\\s*int\\s*\\w*\\s*::\\s*ComputeOutputParams\\s*[(]\\s*RixShadingContext)") != null) {
            return 1;
        }
        if (RegExpUtils.split(srcText, "(\\s*bool\\s*\\w*\\s*::\\s*GetDisplacement\\s*[(]\\s*RtPoint3)") != null) {
            return 3;
        }
        if (RegExpUtils.split(srcText, "(\\s*void\\s*\\w*\\s*::\\s*Filter\\s*[(]\\s*RixLightFilterContext)") != null) {
            return 4;
        }
        if (RegExpUtils.split(srcText, "(\\s*void\\s*\\w*\\s*::\\s*Filter\\s*[(]\\s*RixSampleFilterContext)") != null) {
            return 5;
        }
        if (RegExpUtils.split(srcText, "(\\s*void\\s*\\w*\\s*::\\s*Filter\\s*[(]\\s*RixDisplayFilterContext)") != null) {
            return 6;
        }
        if (RegExpUtils.split(srcText, "(\\s*void\\s*\\w*\\s*::\\s*Integrate\\s*[(]\\s*RtInt)") != null) {
            return 7;
        }
        if (RegExpUtils.split(srcText, "(\\s*void\\s*\\w*\\s*::\\s*Project\\s*[(]\\s*RixProjectionContext)") != null) {
            return 8;
        }
        if (RegExpUtils.split(srcText, "(\\s*RifPlugin\\s+[*]\\s*RifPluginManufacture\\s*[(]\\s*int)") != null) {
            return 9;
        }
        if (RegExpUtils.split(srcText, "(\\s*Subdivide2\\s*[(]\\s*RtContextHandle)") != null) {
            Cutter.setLog("    Debug: DevkitUtils.getDevkitScriptType() - 1 returning PROCEDURAL (found PROCEDURAL2)");
            return 10;
        }
        if (RegExpUtils.split(srcText, "(\\s*export\\s*RtVoid\\s*Subdivide\\s*[(]\\s*RtPointer)") != null) {
            Cutter.setLog("    Debug: DevkitUtils.getDevkitScriptType() - 1 returning PROCEDURAL");
            return 10;
        }
        if (RegExpUtils.split(srcText, "(\\s*PRMANEXPORT\\s*RtVoid\\s*Subdivide\\s*[(]\\s*RtPointer)") != null) {
            Cutter.setLog("    Debug: DevkitUtils.getDevkitScriptType() - 2 returning PROCEDURAL");
            return 10;
        }
        if (RegExpUtils.split(srcText, "(\\s*void\\s*\\w*\\s*::\\s*GradientEval\\s*[(]\\s*RtPoint)") != null) {
            Cutter.setLog("    Debug: DevkitUtils.getDevkitScriptType() - 1 returning IMPLICIT");
            return 11;
        }
        if (RegExpUtils.split(srcText, "(\\s*static\\s*void\\s*determineVoxel\\s*[(]\\s*struct)") != null) {
            Cutter.setLog("    Debug: DevkitUtils.getDevkitScriptType() - 2 returning IMPLICIT");
            return 11;
        }
        if (RegExpUtils.split(srcText, "(\\s*\\w*\\s*=\\s*BkmOpenBrickMapFile\\s*[(])") != null) {
            return 13;
        }
        return NOT_DEVKIT;
    }
}

