/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.KTextWindow;
import java.io.File;
import javax.swing.JOptionPane;

public class DialogUtils {
    public static void showInfoMessage(String title, String[] msg) {
        if (title == null || msg == null || msg.length == 0) {
            return;
        }
        StringBuffer text = new StringBuffer();
        for (int n = 0; n < msg.length; ++n) {
            text.append(msg[n]).append("\n");
        }
        JOptionPane.showMessageDialog(Cutter.desktop, text, title, 1);
    }

    public static void showWarningMessage(String title, String[] msg) {
        if (title == null || msg == null || msg.length == 0) {
            return;
        }
        StringBuffer text = new StringBuffer();
        for (int n = 0; n < msg.length; ++n) {
            text.append(msg[n]).append("\n");
        }
        JOptionPane.showMessageDialog(Cutter.desktop, text, title, 2);
    }

    public static void showErrorMessage(String title, String[] msg) {
        if (title == null || msg == null || msg.length == 0) {
            return;
        }
        StringBuffer text = new StringBuffer();
        for (int n = 0; n < msg.length; ++n) {
            text.append(msg[n]).append("\n");
        }
        JOptionPane.showMessageDialog(Cutter.desktop, text, title, 0);
    }

    public static void showMultiFileMessage(String title, String confirmStr, String[] msgs, File[] files) {
        if (title == null || msgs == null || msgs.length == 0 || files == null) {
            return;
        }
        StringBuffer text = new StringBuffer();
        for (int n = 0; n < msgs.length; ++n) {
            text.append(msgs[n]).append("\n");
        }
        Object[] options = new String[]{"No", confirmStr};
        int response = JOptionPane.showOptionDialog(KAbstractDesktop.desktopPane, text, title, 0, 3, null, options, options[1]);
        switch (response) {
            case 0: {
                break;
            }
            case 1: {
                KTextWindow.addWindows(files);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public static boolean confirm(String title, String confirmButtonStr, String[] msgs) {
        if (title == null || msgs == null || msgs.length == 0 || confirmButtonStr == null) {
            return false;
        }
        StringBuffer text = new StringBuffer();
        for (int n = 0; n < msgs.length; ++n) {
            text.append(msgs[n]).append("\n");
        }
        int response = JOptionPane.showConfirmDialog(KAbstractDesktop.desktopPane, text.toString(), title, 0);
        switch (response) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case -1: {
                return false;
            }
        }
        return false;
    }
}

