/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Comment;
import UI_Script.Python.PythonTokenizer;
import Utilities.DynamicEdit;
import Utilities.VectorUtils;
import java.awt.Color;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public class DocumentUtils {
    public static Segment getSegment(Document document, int begin, int length) {
        Segment s = new Segment();
        begin = Math.abs(begin);
        length = Math.abs(length);
        try {
            document.getText(begin, length, s);
        }
        catch (BadLocationException ex) {
            return null;
        }
        return s;
    }

    public static void getSegment(Document document, int begin, int end, Segment s) {
        try {
            document.getText(begin, end - begin + 1, s);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: DocumentUtils.getSegment(int,int,Segment) error = " + ex);
        }
    }

    public static int getSegment(Document document, DocumentEvent evt, Segment s) {
        Element element = DocumentUtils.getParagraphElement(document, evt.getOffset());
        if (element == null) {
            System.out.println("KTextPane.parse(DocumentEvent) element = null");
            return -1;
        }
        int begin = element.getStartOffset();
        try {
            document.getText(begin, DocumentUtils.getParagraphElement(document, evt.getOffset() + evt.getLength()).getEndOffset() - begin, s);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: DocumentUtils.getSegment(DocumentEvent,Segment) = " + e);
        }
        return begin;
    }

    public static Element getParagraphElement(Document document, int offset) {
        if (document instanceof DefaultStyledDocument) {
            return ((DefaultStyledDocument)document).getParagraphElement(offset);
        }
        return null;
    }

    public static Element[] getElements(Document document, int begin, int end) {
        Element beginElement = DocumentUtils.getParagraphElement(document, begin);
        if (begin == end) {
            Element[] out = new Element[]{beginElement};
            return out;
        }
        Vector<Element> list = new Vector<Element>();
        Element root = document.getDefaultRootElement();
        for (int n = 0; n < root.getElementCount(); ++n) {
            Element child = root.getElement(n);
            int eleBegin = child.getStartOffset();
            int eleEnd = child.getEndOffset();
            if (eleBegin < begin || eleEnd > end) continue;
            list.addElement(child);
        }
        Element[] out = new Element[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (Element)list.elementAt(n);
        }
        return out;
    }

    public static String[] getParagraphs(Document doc) {
        if (doc == null) {
            Cutter.setLog("    Error: DocumentUtils.getParagraphs(Document) - null input");
            return null;
        }
        int len = doc.getLength();
        Segment segment = DocumentUtils.getSegment(doc, 0, len);
        if (segment == null) {
            Cutter.setLog("    Error: DocumentUtils.getParagraphs(Document) - getSegment() return null");
            return null;
        }
        int num = BBxt.countLineBreaks(segment);
        return DocumentUtils.getParagraphs(doc, 1, num);
    }

    public static int countLineBreaks(Segment segment) {
        if (segment == null) {
            Cutter.setLog("DocumentUtils.countLineBreaks() segment is null");
            return -1;
        }
        int line = 0;
        for (int n = 0; n < segment.count; ++n) {
            if (segment.array[segment.offset + n] != '\n') continue;
            ++line;
        }
        return line;
    }

    public static int[] getOffsetsOfLine(Document doc, int lineNumber) {
        Segment segment = DocumentUtils.getSegment(doc, 0, doc.getLength());
        if (segment == null) {
            Cutter.setLog("    Error:DocumentUtils.getOffsetsOfLine() segment is null");
            return null;
        }
        int line = 0;
        for (int n = 0; n < segment.count; ++n) {
            if (segment.array[segment.offset + n] != '\n' || ++line != lineNumber) continue;
            return DocumentUtils.getElementOffsets(doc, n);
        }
        return null;
    }

    public static int[] getLineNumberAt(Document document, int offset) {
        int lineNum = 1;
        Segment segment = DocumentUtils.getSegment(document, 0, offset);
        if (segment == null) {
            return null;
        }
        int charCount = segment.count;
        boolean lineBeginOffset = false;
        for (int n = 0; n < charCount; ++n) {
            if (segment.array[n + segment.offset] != '\n') continue;
            ++lineNum;
        }
        Element element = DocumentUtils.getParagraphElement(document, offset);
        int[] out = new int[]{lineNum, element.getStartOffset(), element.getEndOffset()};
        return out;
    }

    public static int countSpacesAtOffset(Document doc, int offset) {
        Segment segment = DocumentUtils.getSegment(doc, 0, offset);
        if (segment == null) {
            Cutter.setLog("    Error: DocumentUtils.countTabStopsAtOffset(Document) - getSegment() return null");
            return 0;
        }
        int numSpaces = 0;
        if (segment.count - 1 > 0) {
            char c;
            for (int n = segment.count - 1; n > 0 && segment.array[segment.offset + n] != '\n'; --n) {
            }
            for (int i = n; i < segment.count && (c = segment.array[segment.offset + i]) == '\t'; ++i) {
                if (c == ' ') {
                    ++numSpaces;
                }
                if (segment.array[segment.offset + i] >= ' ') break;
            }
        }
        return numSpaces;
    }

    public static int countTabStopsAtOffset(Document doc, int offset) {
        Segment segment = DocumentUtils.getSegment(doc, 0, offset);
        if (segment == null) {
            Cutter.setLog("    Error: DocumentUtils.countTabStopsAtOffset(Document) - getSegment() return null");
            return 0;
        }
        int numTabs = 0;
        if (segment.count - 1 > 0) {
            for (int n = segment.count - 1; n > 0 && segment.array[segment.offset + n] != '\n'; --n) {
            }
            for (int i = n; i < segment.count; ++i) {
                if (segment.array[segment.offset + i] == '\t') {
                    ++numTabs;
                }
                if (segment.array[segment.offset + i] >= ' ') break;
            }
        }
        return numTabs;
    }

    public static String[] getParagraphs(Document doc, int from, int to) {
        return DocumentUtils.getParagraphs(doc, from, to, null);
    }

    public static String[] getParagraphs(Document doc, int from, int to, Vector<int[]> lineOffsets) {
        if (doc == null) {
            return null;
        }
        int len = doc.getLength();
        --to;
        Segment segment = DocumentUtils.getSegment(doc, 0, len);
        int num = DocumentUtils.countLineBreaks(segment);
        from = --from < 0 ? 0 : from;
        from = from > num ? num : from;
        to = to > num ? num : to;
        Vector<String> list = new Vector<String>();
        for (int n = from; n <= to; ++n) {
            Segment s;
            int[] offsets = BBxt.getOffsetsOfLine(segment, n);
            if (offsets == null) continue;
            if (lineOffsets != null) {
                lineOffsets.addElement(offsets);
            }
            if ((s = DocumentUtils.getSegment(doc, offsets[1], offsets[0])) == null) continue;
            list.addElement(s.toString());
        }
        return VectorUtils.toStringArray(list);
    }

    public static Element getCharacterElement(Document document, int offset) {
        if (document instanceof DefaultStyledDocument) {
            return ((DefaultStyledDocument)document).getCharacterElement(offset);
        }
        return null;
    }

    public static AttributeSet getCharacterAttributes(Document document, int offset) {
        Element element = DocumentUtils.getCharacterElement(document, offset);
        if (element == null) {
            return null;
        }
        return element.getAttributes();
    }

    public static String getCharacterStyleName(Document document, int offset) {
        Element element = DocumentUtils.getCharacterElement(document, offset);
        if (element == null) {
            return null;
        }
        return (String)element.getAttributes().getAttribute(AttributeSet.NameAttribute);
    }

    public static Color getCharacterStyleColor(Document document, int offset) {
        if (!(document instanceof DefaultStyledDocument)) {
            return Color.black;
        }
        DefaultStyledDocument dsd = (DefaultStyledDocument)document;
        Element element = DocumentUtils.getCharacterElement(dsd, offset);
        if (element == null) {
            return Color.black;
        }
        AttributeSet attrs = element.getAttributes();
        Color c = dsd.getForeground(attrs);
        return c == null ? Color.black : c;
    }

    public static Segment getSegment(Document document, DocumentEvent evt, int begin) {
        Segment s = new Segment();
        Element element = DocumentUtils.getParagraphElement(document, evt.getOffset());
        if (element == null) {
            System.out.println("KTextPane.parse(DocumentEvent) element = null");
            return null;
        }
        try {
            element = DocumentUtils.getParagraphElement(document, evt.getOffset() + evt.getLength());
            document.getText(begin, element.getEndOffset() - begin, s);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: KTextPane.getSegment(DocumentEvent,int) = " + e);
        }
        return s;
    }

    public static Segment getSegment(Document document, DocumentEvent evt) {
        Segment s = new Segment();
        DocumentUtils.getSegment(document, evt, s);
        return s;
    }

    public static Segment getSegment(Document document, Element element) {
        int begin = element.getStartOffset();
        int end = element.getEndOffset();
        int length = end - begin;
        Segment s = new Segment();
        try {
            document.getText(begin, length, s);
        }
        catch (BadLocationException ex) {
            System.out.println("KTextPane.getSegment(Element) error = " + ex);
            return null;
        }
        return s;
    }

    public static Segment getSegment(Document document, int offset) {
        return DocumentUtils.getSegment(document, DocumentUtils.getParagraphElement(document, offset));
    }

    public static int[] getElementOffsets(Document document, int offset) {
        int[] out = new int[]{0, 0, 0};
        Element element = DocumentUtils.getParagraphElement(document, offset);
        if (element == null) {
            return null;
        }
        out[1] = element.getStartOffset();
        out[2] = element.getEndOffset();
        out[0] = out[2] - out[1];
        return out;
    }

    private void ___COMMENT_PROCESSING_______() {
    }

    private static PlainDocument initDoc(String input) {
        PlainDocument doc = new PlainDocument();
        if (!input.endsWith("\n")) {
            input = input + "\n";
        }
        try {
            doc.insertString(0, input, null);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Exception: DocumentUtils.initDoc()\n" + e.toString());
            return null;
        }
        return doc;
    }

    private static Position initEndMarker(PlainDocument doc) {
        Position endMarker = null;
        try {
            endMarker = doc.createPosition(doc.getLength());
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Exception: DocumentUtils.initEndMarker()\n" + e.toString());
            return null;
        }
        return endMarker;
    }

    public static String removeComments(String input, Comment[] cmnt) {
        String out;
        PlainDocument doc = DocumentUtils.initDoc(input);
        if (doc == null) {
            return input;
        }
        Position endMarker = DocumentUtils.initEndMarker(doc);
        if (endMarker == null) {
            return input;
        }
        int begin = 0;
        for (int n = 0; n < cmnt.length; ++n) {
            DocumentUtils.removeComments(doc, cmnt[n], true, begin, endMarker.getOffset());
        }
        try {
            out = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Exception 3: DocumentUtils.removeComments()\n" + e.toString());
            return input;
        }
        return out;
    }

    public static void removeComments(Document doc, Comment cmnt, boolean allText, int begin, int end) {
        Segment segment = DocumentUtils.getSegment(doc, begin, end - begin);
        Tokenizer tok = new Tokenizer();
        Vector<DynamicEdit> edits = new Vector<DynamicEdit>();
        tok.setBuffer(segment);
        int[] offset = tok.charSearch(cmnt.openStr, true);
        while (offset != null) {
            int cmntBegin = begin + offset[0];
            offset = tok.charSearch(cmnt.closeStr, true);
            int cmntEnd = offset == null ? begin + segment.count : begin + offset[1];
            if (!DocumentUtils.addDynamicEdit(doc, edits, cmntBegin, cmntEnd)) {
                return;
            }
            offset = tok.charSearch(cmnt.openStr, true);
        }
        for (int i = 0; i < edits.size(); ++i) {
            DynamicEdit edit = (DynamicEdit)edits.elementAt(i);
            if (edit == null) continue;
            if (allText) {
                edit.removeText();
                continue;
            }
            edit.removeHeadTail(cmnt.openLen, cmnt.closeLen);
        }
        edits.removeAllElements();
        edits = null;
    }

    public static String swapComments(String input, Comment target, Comment replacement) {
        String out;
        PlainDocument doc = DocumentUtils.initDoc(input);
        if (doc == null) {
            return input;
        }
        Position endMarker = DocumentUtils.initEndMarker(doc);
        if (endMarker == null) {
            return input;
        }
        int begin = 0;
        DocumentUtils.swapComments(doc, target, replacement, begin, endMarker.getOffset());
        try {
            out = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Exception 3: DocumentUtils.removeComments()\n" + e.toString());
            return input;
        }
        return out;
    }

    private static void swapComments(Document doc, Comment target, Comment replacement, int begin, int end) {
        Segment segment = DocumentUtils.getSegment(doc, begin, end - begin);
        Tokenizer tok = new Tokenizer();
        Vector<DynamicEdit> edits = new Vector<DynamicEdit>();
        tok.setBuffer(segment);
        int[] offset = tok.charSearch(target.openStr, true);
        while (offset != null) {
            int cmntBegin = begin + offset[0];
            offset = tok.charSearch(target.closeStr, true);
            int cmntEnd = offset == null ? begin + segment.count : begin + offset[1];
            if (!DocumentUtils.addDynamicEdit(doc, edits, cmntBegin, cmntEnd)) {
                return;
            }
            offset = tok.charSearch(target.openStr, true);
        }
        String tOpenStr = target.openStr;
        String tCloseStr = target.closeStr;
        int tOpenLen = target.openLen;
        int tCloseLen = target.closeLen;
        String rOpenStr = replacement.openStr;
        String rCloseStr = replacement.closeStr;
        int rOpenLen = replacement.openLen;
        int rCloseLen = replacement.closeLen;
        try {
            for (int i = 0; i < edits.size(); ++i) {
                DynamicEdit edit = edits.elementAt(i);
                if (edit == null) continue;
                String text = edit.getText();
                text = text.substring(tOpenLen, text.length() - tCloseLen);
                text = rOpenStr + text + rCloseStr;
                edit.removeText();
                edit = edits.elementAt(i);
                doc.insertString(edit.getBegin(), text, null);
            }
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: DocumentUtils.DynamicEdit.removeText() " + e);
        }
        edits.removeAllElements();
        edits = null;
    }

    private static boolean addDynamicEdit(Document doc, Vector<DynamicEdit> v, int begin, int end) {
        try {
            v.addElement(new DynamicEdit(doc, begin, end));
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: MelListener.removeComments(Comment[]) " + e);
            return false;
        }
        return true;
    }

    public static String[] getTextJoinedBy(Document doc, int absOffset, char[] delims) {
        char c;
        if (doc == null) {
            return null;
        }
        Segment seg = DocumentUtils.getSegment(doc, absOffset);
        if (seg == null) {
            return null;
        }
        int[] d = DocumentUtils.getElementOffsets(doc, absOffset);
        String line = seg.toString();
        int deltaOffset = absOffset - d[1];
        PythonTokenizer tok = new PythonTokenizer();
        tok.setBuffer(line);
        int whiteBegin = tok.peekPrevWhite(deltaOffset);
        whiteBegin = whiteBegin < 0 ? 0 : ++whiteBegin;
        tok.setBufferIndex(whiteBegin);
        String delimStr = new String(delims);
        String terminal = "";
        while ((c = tok.readChar()) != '\u0000') {
            if (Character.isUnicodeIdentifierPart(c) || delimStr.indexOf(c) != -1) continue;
            terminal = "" + c;
            break;
        }
        int end = c == '\u0000' ? line.length() - 1 : tok.getBufferIndex() - 1;
        String[] out = new String[]{line.substring(whiteBegin, end), terminal};
        return out;
    }
}

