/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import UI_Window.KWindow.KAbstractTextWindow;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class DynamicEdit {
    private Position[] p = new Position[2];
    private Document doc = null;
    private KAbstractTextWindow window = null;

    public DynamicEdit(Document doc, int beginOffset, int endOffset) throws BadLocationException {
        this.doc = doc;
        this.p[0] = this.doc.createPosition(beginOffset);
        this.p[1] = this.doc.createPosition(endOffset);
    }

    public DynamicEdit(KAbstractTextWindow window, int beginOffset, int endOffset) throws BadLocationException {
        this.window = window;
        this.p[0] = window.getTextPane().getDocument().createPosition(beginOffset);
        this.p[1] = window.getTextPane().getDocument().createPosition(endOffset);
    }

    public int getBegin() {
        return this.p[0].getOffset();
    }

    public int getEnd() {
        return this.p[1].getOffset();
    }

    public void removeText() {
        try {
            if (this.window != null) {
                this.window.getTextPane().getDocument().remove(this.p[0].getOffset(), this.p[1].getOffset() - this.p[0].getOffset());
            } else {
                this.doc.remove(this.p[0].getOffset(), this.p[1].getOffset() - this.p[0].getOffset());
            }
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: DocumentUtils.DynamicEdit.removeText() " + e);
        }
    }

    public void removeHeadTail(int head, int tail) {
        if (this.p == null) {
            return;
        }
        try {
            int headBegin = this.p[0].getOffset();
            int headEnd = headBegin + head;
            if (this.window != null) {
                this.window.getTextPane().getDocument().remove(headBegin, headEnd - headBegin);
            } else {
                this.doc.remove(headBegin, headEnd - headBegin);
            }
            int tailBegin = this.p[1].getOffset() - tail;
            int tailEnd = this.p[1].getOffset();
            if (this.window != null && !this.window.getTextPane().getDocument().getText(tailEnd - 1, 1).equals("\n")) {
                this.window.getTextPane().getDocument().remove(tailBegin, tailEnd - tailBegin);
            } else if (!this.doc.getText(tailEnd - 1, 1).equals("\n")) {
                this.doc.remove(tailBegin, tailEnd - tailBegin);
            }
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: DocumentUtils.DynamicEdit.removeHeadTail(int,int) " + e);
        }
    }

    public String getText(int head, int tail) {
        try {
            int begin = this.p[0].getOffset() + head;
            int end = this.p[1].getOffset() - tail;
            if (this.window != null) {
                return this.window.getTextPane().getDocument().getText(begin, end - begin);
            }
            return this.doc.getText(begin, end - begin);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: DocumentUtils.DynamicEdit.getText(int,int) " + e);
            return null;
        }
    }

    public String getText() {
        try {
            int begin = this.p[0].getOffset();
            int end = this.p[1].getOffset();
            if (this.window != null) {
                return this.window.getTextPane().getDocument().getText(begin, end - begin);
            }
            return this.doc.getText(begin, end - begin);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: DocumentUtils.DynamicEdit.getText() " + e);
            return null;
        }
    }

    public void insertText(String str) {
        try {
            if (this.window != null) {
                this.window.getTextPane().getDocument().insertString(this.p[0].getOffset(), str, null);
            } else {
                this.doc.insertString(this.p[0].getOffset(), str, null);
            }
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: DocumentUtils.DynamicEdit.insert " + e);
        }
    }

    public String toString() {
        return " " + this.p[0].getOffset() + ", " + this.p[1].getOffset();
    }
}

