/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import ClientServer.ClientServer.client.Client;
import UI_Desktop.Cutter;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.File;

public class EnvUtils {
    private static String cutterUsersDir = "";
    private static String cutterAppDir = "";

    public static boolean isOSXEnvironment() {
        return EnvUtils.getOSName().equals("Mac OS X");
    }

    public static boolean isWinEnvironment() {
        return TextUtils.contains(EnvUtils.getOSName().trim(), "Windows", true);
    }

    public static boolean isLinuxEnvironment() {
        return TextUtils.contains(EnvUtils.getOSName().trim(), "Linux", true);
    }

    public static double getMRJVersion() {
        return EnvUtils.versionAsDouble(System.getProperty("mrj.version"));
    }

    public static String javaVersionAsString() {
        return System.getProperty("java.version");
    }

    public static String getUsersAccountName() {
        return System.getProperty("user.name");
    }

    public static String getUsersHomeDir() {
        String homepath = System.getProperty("user.home");
        String ipAddress = Client.getLocalIP();
        try {
            if (ipAddress.startsWith("10.7.") && EnvUtils.isLinuxEnvironment()) {
                String accName = EnvUtils.getUsersAccountName();
                homepath = "/home/" + accName + "/mount/stuhome";
                if (!new File(homepath).exists() && !new File(homepath = "/home/" + accName + "/mount/fachome").exists()) {
                    homepath = System.getProperty("user.home");
                    return homepath;
                }
            }
        }
        catch (Exception ex) {
            Cutter.setLog("    Warning:getUsersHomeDir() - cannot get the computers local IP address");
            return homepath;
        }
        return homepath;
    }

    public static String getUsersPWD() {
        if (cutterUsersDir.length() > 0) {
            return cutterUsersDir;
        }
        return System.getProperty("user.dir");
    }

    public static String getCutterAppDir() {
        if (cutterAppDir.length() > 0) {
            return cutterAppDir;
        }
        return System.getProperty("user.dir");
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static int javaVersionAsInt() {
        String version = System.getProperty("java.version");
        if (version == null || version.length() == 0) {
            return -1;
        }
        String[] token = TextUtils.tokenize(version, ".");
        if (token != null && token.length >= 2) {
            return Integer.parseInt(token[0] + token[1]);
        }
        return -1;
    }

    public static double versionAsDouble(String version) {
        if (version == null || version.length() == 0) {
            return -1.0;
        }
        String[] token = TextUtils.tokenize(version, "._");
        if (token != null) {
            if (token.length == 1) {
                return Double.valueOf(token[0]);
            }
            if (token.length > 1) {
                StringBuffer fractional = new StringBuffer();
                for (int n = 1; n < token.length; ++n) {
                    fractional.append(token[n]);
                }
                return Double.valueOf(token[0] + "." + fractional.toString());
            }
        }
        return -1.0;
    }

    public static String getEnvVariable(String name) {
        String value = System.getenv(name);
        return value == null ? "" : value;
    }

    public static void checkRMSPROJ() {
        String rmsproj = EnvUtils.getEnvVariable("RMSPROJ");
        if (rmsproj.length() > 0) {
            File rmsprojFile;
            Cutter.setLog("    Debug:EnvUtils.checkRMSPROJ() - the value of the evironment variable \"RMSPROJ\" is \"" + rmsproj + "\"");
            if (rmsproj.endsWith("/rms/default") && (rmsprojFile = new File(rmsproj)) != null && !rmsprojFile.exists()) {
                if (FileUtils.makeDirectories(rmsprojFile)) {
                    Cutter.setLog("A directory for \"RMSPROJ\" did not exist but has now been created.");
                } else {
                    Cutter.setLog("A directory for \"RMSPROJ\" has not been created.");
                }
            }
        } else {
            Cutter.setLog("    Debug:EnvUtils.checkRMSPROJ() - the environment variable \"RMSPROJ\" has not been found.");
        }
    }

    static {
        cutterUsersDir = EnvUtils.getEnvVariable(Cutter.CUTTER_USERS_DIR);
        if (!new File(cutterUsersDir).exists()) {
            cutterUsersDir = "";
        }
        if (!new File(cutterAppDir = EnvUtils.getEnvVariable(Cutter.CUTTER_APP_DIR)).exists()) {
            cutterAppDir = "";
        }
    }
}

