/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class FileSaver
extends Thread {
    private static int OUTBLOCK_SIZE = 1024;
    private static int INBLOCK_SIZE = 51200;
    private static int BUFFERED_READ_SIZE = 51200;
    private File out;
    private ProgressMonitor monitor = null;
    private StringBuffer buff = null;
    private long bytesWritten = 0L;
    public boolean done = false;
    private int reportSize = 128;

    public FileSaver(File outFile, StringBuffer buff) {
        super("FileSaver Thread");
        this.setPriority(4);
        this.out = outFile;
        this.buff = buff;
        this.monitor = new ProgressMonitor(KAbstractDesktop.desktopPane, "Saving File:", outFile.getName(), 0, buff.length() - OUTBLOCK_SIZE);
        this.monitor.setMillisToDecideToPopup(0);
    }

    public void _run() {
        this.done = false;
        try {
            FileWriter fw = new FileWriter(this.out);
            fw.write(this.buff.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("FileSaver IOException = " + e);
        }
        this.done = true;
    }

    @Override
    public void run() {
        this.done = false;
        BufferedWriter fw = null;
        try {
            fw = new BufferedWriter(new FileWriter(this.out.getPath(), false));
            for (int n = 0; n < this.buff.length(); ++n) {
                if (n % OUTBLOCK_SIZE == 0) {
                    this.updateProgressBar(n);
                    try {
                        Thread.currentThread();
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.buff.charAt(n) == '\n') {
                    fw.newLine();
                    continue;
                }
                fw.write(this.buff.charAt(n));
            }
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            Cutter.setLog("    FileSaver.run() - IOException = " + ex);
            return;
        }
        this.monitor.close();
        this.done = true;
    }

    private void updateProgressBar(final int bytes) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileSaver.this.monitor.setProgress(bytes);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

