/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Tools.Zipper.FileQuery;
import Utilities.EnumUtils;
import Utilities.EnvUtils;
import Utilities.RegExpUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {
    private File searchDir;
    private String searchExt;
    private int depth = 1;
    private int maxdepth = 12;
    private static final int DEFAULT_MAX_DEPTH = 12;
    private Vector<String> listOfFilePaths = new Vector();

    public FileUtils() {
        this.listOfFilePaths.clear();
    }

    public static boolean isRMSRibPath(String path) {
        boolean rendermanDirFound = false;
        boolean ribDirFound = false;
        boolean ribFileFound = false;
        if (RegExpUtils.findFirstOccuranceOf(path, "renderman", false, false) != null) {
            rendermanDirFound = true;
        }
        if (RegExpUtils.findFirstOccuranceOf(path, "rib", false, false) != null) {
            ribDirFound = true;
        }
        if (path.endsWith(".rib")) {
            ribFileFound = true;
        }
        return rendermanDirFound && ribDirFound && ribFileFound;
    }

    public static String doubleEscapes(String path) {
        StringBuffer b = new StringBuffer();
        for (int m = 0; m < path.length(); ++m) {
            char c = path.charAt(m);
            if (c == '\\') {
                b.append('\\').append('\\');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String convertToWindowsPathSeparator(String path) {
        StringBuffer b = new StringBuffer();
        for (int m = 0; m < path.length(); ++m) {
            char c = path.charAt(m);
            if (c == '/') {
                b.append('\\');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static boolean rename(File srcfile, File destfile) {
        if (srcfile == null || !srcfile.exists()) {
            Cutter.setLog("FileUtils.rename 1");
            return false;
        }
        if (destfile == null) {
            Cutter.setLog("FileUtils.rename 2");
            return false;
        }
        if (destfile.exists()) {
            destfile.delete();
        }
        boolean result = srcfile.renameTo(destfile);
        return result;
    }

    public static String applyFileSeparator(String input) {
        input = input.replace('/', File.separatorChar);
        input = input.replace('\\', File.separatorChar);
        return input;
    }

    public static File getExistingParent(File dest) {
        if (dest.exists()) {
            return dest;
        }
        for (File parent = dest.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.exists()) continue;
            return parent;
        }
        return dest;
    }

    public static String removeTrailingSeparator(String input, char c, char d) {
        if (input.endsWith("" + c) || input.endsWith("" + d)) {
            return input.substring(0, input.length() - 1);
        }
        return input;
    }

    public static boolean makeDirectory(String dirname) {
        File dir = new File(FileUtils.getPWD(), dirname);
        return FileUtils.makeDirectories(dir);
    }

    public static boolean saveRunCutterScript() {
        File desktopDir = new File(File.pathSeparator, "Desktop");
        return false;
    }

    public static boolean makeDirectories(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.exists()) {
            return true;
        }
        String path = FileUtils.applyFileSeparator(dir.getPath());
        String[] subDir = TextUtils.tokenize(dir.getPath(), "" + File.separatorChar);
        String subPath = "";
        if (dir.getPath().startsWith("" + File.separatorChar)) {
            subPath = subPath + File.separatorChar;
        }
        for (int n = 0; n < subDir.length; ++n) {
            File f = new File(subPath = subPath.length() == 0 ? subDir[n] : subPath + File.separatorChar + subDir[n]);
            if (f.exists()) continue;
            f.mkdir();
            if (f.exists()) continue;
            return false;
        }
        return true;
    }

    public static void deleteAll(File f) {
        if (f == null) {
            return;
        }
        if (f.isFile()) {
            f.delete();
            return;
        }
        String[] child = f.list();
        if (child == null || child.length == 0) {
            f.delete();
            return;
        }
        for (int n = 0; n < child.length; ++n) {
            FileUtils.deleteAll(new File(f, child[n]));
        }
        f.delete();
    }

    public static boolean saveBytesToFile(byte[] data, int len, File outfile) {
        if (len <= 0) {
            System.out.println("FileUtils.saveBytesToFile() no data");
            return false;
        }
        if (!outfile.getParentFile().exists()) {
            FileUtils.makeDirectories(outfile.getParentFile());
        }
        try {
            FileOutputStream outstream = new FileOutputStream(outfile);
            outstream.write(data, 0, len);
            outstream.close();
        }
        catch (Exception e) {
            System.out.println("FileUtils.saveBytesToFile " + e.toString());
            return false;
        }
        return true;
    }

    public static boolean saveInputStreamToFile(InputStream zipInputStream, ZipEntry zipentry, File head, File tail) {
        String[] subs = FileUtils.getSubFilesOf(tail);
        for (int n = 0; n < subs.length; ++n) {
            String name;
            File f = new File(head, subs[n]);
            if (f.getName().equals("Icon") || f.getName().equals(".DS_Store") || (name = f.getName()).indexOf(46) != -1) continue;
            f.mkdir();
        }
        byte[] buffer = new byte[1024];
        try {
            int read;
            File outfile = new File(head.getPath(), tail.getPath());
            if (outfile.exists()) {
                outfile.delete();
            }
            FileOutputStream outstream = new FileOutputStream(outfile);
            while ((read = zipInputStream.read(buffer, 0, buffer.length)) > 0) {
                outstream.write(buffer, 0, read);
            }
            outstream.flush();
            outstream.close();
        }
        catch (IOException e) {
            System.out.println("FileUtils.saveInputStreamToFile - " + e);
            return false;
        }
        return true;
    }

    public static boolean _saveZipEntryToFile(ZipInputStream zipInputStream, ZipEntry zipentry, String fullpath) {
        File outfile = new File(fullpath);
        if (!outfile.getParentFile().exists()) {
            FileUtils.makeDirectories(outfile.getParentFile());
        }
        byte[] buffer = new byte[2048];
        try {
            int read;
            FileOutputStream outstream = new FileOutputStream(outfile);
            int total = 0;
            while ((read = zipInputStream.read(buffer, 0, buffer.length)) > 0) {
                outstream.write(buffer, 0, read);
                total += read;
            }
            System.out.println(zipentry.getName() + " read: " + total);
            outstream.close();
        }
        catch (Exception e) {
            System.out.println("FileUtils.saveZipEntryToFile " + e.toString());
            return false;
        }
        return true;
    }

    public static boolean equal(File a, File b) {
        String bStr;
        String aStr = a.getPath();
        return aStr.equals(bStr = b.getPath());
    }

    public static Vector<File> toVector(File[] items) {
        if (items == null || items.length == 0) {
            return null;
        }
        Vector<File> v = new Vector<File>(items.length);
        for (int n = 0; n < items.length; ++n) {
            v.addElement(items[n]);
        }
        return v;
    }

    public static File[] toFileArray(Vector<File> items) {
        if (items == null || items.size() == 0) {
            return null;
        }
        File[] out = new File[items.size()];
        for (int n = 0; n < items.size(); ++n) {
            out[n] = items.elementAt(n);
        }
        return out;
    }

    public static File[] toFileArray(String[] paths) {
        if (paths == null || paths.length == 0) {
            return null;
        }
        File[] out = new File[paths.length];
        for (int n = 0; n < paths.length; ++n) {
            out[n] = new File(paths[n]);
        }
        return out;
    }

    public static String[] toPathsArray(File[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        String[] out = new String[files.length];
        for (int n = 0; n < files.length; ++n) {
            out[n] = files[n].getPath();
        }
        return out;
    }

    public static String[] toNamesArray(File[] files, boolean removeExtension) {
        if (files == null || files.length == 0) {
            return null;
        }
        String[] out = new String[files.length];
        for (int n = 0; n < files.length; ++n) {
            out[n] = removeExtension ? TextUtils.removeExtension(files[n].getName()) : files[n].getName();
        }
        return out;
    }

    public static String[] toNamesArray(String[] fullPaths, boolean removeExtension) {
        if (fullPaths == null || fullPaths.length == 0) {
            return null;
        }
        String[] out = new String[fullPaths.length];
        for (int n = 0; n < fullPaths.length; ++n) {
            out[n] = new File(fullPaths[n]).getName();
            if (!removeExtension) continue;
            out[n] = TextUtils.removeExtension(out[n]);
        }
        return out;
    }

    public static String read(File file) {
        return FileUtils.read(file.getPath());
    }

    public static byte[] readAsBinary(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            return null;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(filename);
            File f = new File(filename);
            long size = f.length();
            if (size <= 0L) {
                return null;
            }
            byte[] buffer = new byte[(int)size];
            if ((long)stream.read(buffer, 0, buffer.length) != size) {
                stream.close();
                return null;
            }
            stream.close();
            return buffer;
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: FileUtils.readAsBinary() - cannot open file named " + filename);
            Cutter.setLog("         " + e.toString());
            return null;
        }
    }

    public static String __readAsBinary(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            return null;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(filename);
            File f = new File(filename);
            long size = f.length();
            if (size <= 0L) {
                return null;
            }
            char[] buffer = new char[(int)size];
            if ((long)reader.read(buffer, 0, buffer.length) != size) {
                reader.close();
                return null;
            }
            reader.close();
            return new String(buffer);
        }
        catch (IOException e) {
            Cutter.setLog("    Error: FileUtils.readAsBinary() - cannot open file named " + filename);
            return null;
        }
    }

    public static String read(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            Cutter.setLog("    Error:FileUtils.read(String) - filename is null or empty string");
            return null;
        }
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        FileReader reader = null;
        try {
            String str;
            reader = new FileReader(filename);
            LineNumberReader lnr = new LineNumberReader(reader);
            long size = f.length();
            if (size < 0L) {
                lnr.close();
                reader.close();
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:FileUtils.read(String) - \"" + filename + "\" has a size of zero bytes!");
                }
                return null;
            }
            StringBuffer buff = new StringBuffer((int)size);
            while ((str = lnr.readLine()) != null) {
                buff.append(str).append('\n');
            }
            lnr.close();
            reader.close();
            return buff.toString();
        }
        catch (IOException e) {
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:FileUtils.read(String) - " + e.toString());
                Cutter.setLog("    Debug: FileUtils.read(String) - cannot open file named >>" + filename + "<<");
            }
            return null;
        }
    }

    public static String[] readLinesAsArray(String path) {
        Enumeration<String> e = FileUtils.readLines(path);
        if (e == null) {
            Cutter.setLog("    Error: FileUtils.readLinesAsArray() - FileUtils.readLines(this.argfile) returned null.");
            return null;
        }
        String[] lines = EnumUtils.toStringArray(e);
        if (lines == null) {
            Cutter.setLog("    Error: FileUtils.readLinesAsArray() - EnumUtils.toStringArray(e) returned null.");
            return null;
        }
        return lines;
    }

    public static Enumeration<String> readLines(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            return null;
        }
        FileReader reader = null;
        Vector<String> list = new Vector<String>();
        int totalLineCount = 0;
        long byteSize = -1L;
        try {
            String str;
            reader = new FileReader(filename);
            LineNumberReader lnr = new LineNumberReader(reader);
            while ((str = lnr.readLine()) != null) {
                list.addElement(str + '\n');
                ++totalLineCount;
            }
            lnr.close();
            reader.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:FileUtils.readLines() - " + e.toString());
            return null;
        }
        return list.elements();
    }

    public static boolean copy(File src, File dest) {
        String srcStr = FileUtils.read(src.getPath());
        if (srcStr == null) {
            return false;
        }
        try {
            FileWriter out = new FileWriter(dest);
            out.write(srcStr);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:FileUtils.copy() - when copying\n         " + src.getPath() + "\n         to\n         " + dest.getPath());
            Cutter.setLog(e.toString());
            return false;
        }
        return true;
    }

    public static String copyAll(String[] inpaths, String[] outpaths) {
        if (inpaths == null) {
            return "Input paths of files to be copied is null.";
        }
        if (outpaths == null) {
            return "Output paths of files to be copied is null.";
        }
        if (inpaths.length != outpaths.length) {
            return "The number of input files does not match those of the output files.";
        }
        for (int n = 0; n < inpaths.length; ++n) {
            if (inpaths[n].endsWith(".DS_Store")) continue;
            File infile = new File(inpaths[n]);
            File outfile = new File(outpaths[n]);
            if (infile.isDirectory()) {
                outfile.mkdir();
                continue;
            }
            FileUtils.copy(infile, outfile);
        }
        return "";
    }

    public static void __appendFile(File outfile, String data) {
        try {
            FileWriter fw = new FileWriter(outfile, true);
            fw.write(data);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: FileUtils.appendFile()\n" + e.toString());
        }
    }

    public static void appendFile(File outfile, String data) {
        try {
            BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile, true), "UTF-8"));
            fw.write(data);
            ((Writer)fw).flush();
            ((Writer)fw).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeFile(File outfile, String data) {
        try {
            FileWriter fw = new FileWriter(outfile);
            fw.write(data);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: FileUtils.writeFile()\n" + e.toString());
        }
    }

    public static void writeAsBinary(File outfile, byte[] bytes) {
        try {
            FileOutputStream fw = new FileOutputStream(outfile);
            if (fw != null) {
                fw.write(bytes);
                fw.flush();
                fw.close();
            }
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: FileUtils.writeFile()\n" + e.toString());
        }
    }

    public static String getPWD() {
        String pwd = EnvUtils.getUsersPWD();
        if (pwd.charAt(pwd.length() - 1) == File.separatorChar) {
            pwd = pwd.substring(0, pwd.length() - 1);
        }
        return pwd;
    }

    public static File getPWDFile() {
        return new File(FileUtils.getPWD());
    }

    public static File getPWDParentFile() {
        File f = FileUtils.getPWDFile().getParentFile();
        return f == null ? FileUtils.getPWDFile() : f;
    }

    public static void saveAllExcluding(Vector listOfFiles, String prefix) {
    }

    public static String getExtension(File file) {
        return FileUtils.getExtension(file.getPath());
    }

    public static String getExtension(String input) {
        int index = input.lastIndexOf(".");
        if (index != -1) {
            return TextUtils.remove(input.substring(index), '*');
        }
        return null;
    }

    public static String getPaddedInt(int id) {
        if (id < 10) {
            return "000" + id;
        }
        if (id >= 10 && id < 100) {
            return "00" + id;
        }
        if (id >= 100 && id < 1000) {
            return "0" + id;
        }
        if (id >= 1000) {
            return "" + id;
        }
        return null;
    }

    public static String getPaddedInt(int id, int numpad) {
        String intStr = "0000000000" + id;
        int len = intStr.length();
        return intStr.substring(len - numpad);
    }

    public static String addNumericExtension(String path, int num) {
        return FileUtils.addNumericExtension(path, num, ".tif");
    }

    public static String addNumericExtension(String path, int num, String graphicsExt) {
        String filePath = path.replace('\\', '/');
        filePath = TextUtils.trimTrailingChar(filePath, '/');
        String numExt = FileUtils.getPaddedInt(num);
        String fileName = new File(filePath).getName();
        File parentFile = new File(filePath).getParentFile();
        String parentDir = null;
        if (parentFile != null) {
            parentDir = parentFile.getPath();
        }
        fileName = TextUtils.removeExtension(fileName);
        String fullPath = parentDir != null ? new File(parentDir, fileName).getPath() : fileName;
        String out = fullPath + "." + numExt + graphicsExt;
        return out;
    }

    public static File getParentDirFromPath(String path) {
        int end = path.lastIndexOf(47);
        if (end < 2) {
            return new File(path);
        }
        return new File(path.substring(0, end));
    }

    public static String getTail(String path) {
        int end = (path = path.replace('\\', '/')).lastIndexOf(47);
        if (end < 2) {
            return path;
        }
        return path.substring(end + 1);
    }

    public static String removeNameFromPath(String fullpath) {
        if (new File(fullpath).isDirectory()) {
            return fullpath;
        }
        int index = fullpath.lastIndexOf("" + File.separatorChar);
        return fullpath.substring(0, index);
    }

    public static boolean exists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static String[] getPathRelativeTo(String basePath, String[] fullpaths) {
        if (basePath == null || fullpaths == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < fullpaths.length; ++n) {
            String s = FileUtils.getPathRelativeTo(basePath, fullpaths[n]);
            if (s == null) continue;
            v.addElement(s);
        }
        return VectorUtils.toStringArray(v);
    }

    public static String getPathRelativeTo(String basePath, String fullpath) {
        if (basePath == null || fullpath == null) {
            return null;
        }
        if (fullpath.length() < basePath.length()) {
            return null;
        }
        basePath = basePath.replace('\\', '/');
        int[] offsets = RegExpUtils.split(fullpath = fullpath.replace('\\', '/'), basePath, false, true);
        if (offsets == null) {
            Cutter.setLog("    Info:FileUtils.getPathRelativeTo() - base path and full path not similiar:");
            Cutter.setLog("        base path: " + basePath);
            Cutter.setLog("        full path: " + fullpath);
            return null;
        }
        return FileUtils.trimLeft(fullpath.substring(offsets[1]));
    }

    public static String fullToRelative(String basepath, String fullpath, String prefix) {
        if (fullpath.startsWith(basepath) && basepath.length() + 1 > -1) {
            return prefix + "./" + fullpath.substring(basepath.length() + 1);
        }
        String parentpath = new File(basepath).getParent();
        if (parentpath.equals("")) {
            return null;
        }
        if (fullpath.startsWith(parentpath)) {
            return prefix + "../" + fullpath.substring(parentpath.length() + 1);
        }
        return FileUtils.fullToRelative(parentpath, fullpath, "../");
    }

    public static String relativeToFull(String basepath, String relpath) {
        if (relpath.startsWith("./")) {
            return new File(basepath, relpath.substring(2)).getPath();
        }
        if (relpath.startsWith("../")) {
            relpath = relpath.substring(3);
            basepath = new File(basepath).getParent();
            return FileUtils.relativeToFull(basepath, relpath);
        }
        return new File(basepath, relpath).getPath();
    }

    public static String[] join(File parent, String[] filenames) {
        if (parent == null || filenames == null) {
            return null;
        }
        String[] out = new String[filenames.length];
        for (int n = 0; n < filenames.length; ++n) {
            out[n] = new File(parent, filenames[n]).getPath();
        }
        return out;
    }

    public static String[] join(String parent, String[] filenames) {
        if (parent == null || filenames == null) {
            return null;
        }
        String[] out = new String[filenames.length];
        for (int n = 0; n < filenames.length; ++n) {
            out[n] = new File(parent, filenames[n]).getPath();
        }
        return out;
    }

    public static String[] sortByModification(File[] files) {
        Hashtable<Long, File> hashtable = new Hashtable<Long, File>();
        TreeSet<Long> treeset = new TreeSet<Long>();
        try {
            for (int n = 0; n < files.length; ++n) {
                if (files[n] == null) continue;
                Long obj = files[n].lastModified();
                hashtable.put(obj, files[n]);
                treeset.add(obj);
            }
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:FileUtils.sortByModification() " + ex.toString());
        }
        Iterator iter = treeset.iterator();
        Vector<String> list = new Vector<String>();
        while (iter.hasNext()) {
            File file = (File)hashtable.get(iter.next());
            if (file == null) continue;
            list.addElement(file.getPath());
        }
        String[] out = new String[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (String)list.elementAt(n);
        }
        return out;
    }

    public static String[] sortPathsByFileName(String[] paths) {
        File[] files = FileUtils.toFileArray(paths);
        if (files == null) {
            return null;
        }
        File[] sorted_files = FileUtils.sortFilesByName(files);
        return FileUtils.toPathsArray(sorted_files);
    }

    public static Vector<File> sortFilesByName(Vector<File> files) {
        if (files == null || files.size() == 0) {
            return new Vector<File>();
        }
        File[] out = FileUtils.toFileArray(files);
        return FileUtils.toVector(FileUtils.sortFilesByName(out));
    }

    public static File[] sortFilesByName(File[] files) {
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        for (int n = 0; n < files.length; ++n) {
            for (int i = n + 1; i < files.length; ++i) {
                if (collator.compare(files[n].getName(), files[i].getName()) <= 0) continue;
                File tmp = files[n];
                files[n] = files[i];
                files[i] = tmp;
            }
        }
        return files;
    }

    public static String[] getListOfFileNames(File hostDir, String extFilter) {
        if (extFilter == null) {
            return hostDir.list();
        }
        SourceFileFilter filter = new SourceFileFilter(extFilter);
        if (filter == null) {
            return null;
        }
        if (hostDir.list(filter) == null) {
            return null;
        }
        return hostDir.list(filter);
    }

    public static String[] getListOfFileNames(File hostDir, String[] ext) {
        SourceFileFilter filter = null;
        Vector<String> out = new Vector<String>();
        for (int n = 0; n < ext.length; ++n) {
            String[] tmp;
            filter = new SourceFileFilter(ext[n]);
            if (filter == null || (tmp = hostDir.list(filter)) == null) continue;
            for (int i = 0; i < tmp.length; ++i) {
                String name = tmp[i];
                if (name == null) continue;
                out.addElement(name);
            }
        }
        return VectorUtils.toStringArray(out);
    }

    public static String[] getListOfFileNames(File hostDir) {
        String[] raw = hostDir.list();
        if (raw == null) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        for (int n = 0; n < raw.length; ++n) {
            if (!new File(hostDir, raw[n]).isFile()) continue;
            list.addElement(raw[n]);
        }
        return VectorUtils.toStringArray(list);
    }

    public static File[] getListOfSubDirs(File hostDir) {
        if (hostDir == null || !hostDir.exists()) {
            return null;
        }
        String[] raw = hostDir.list();
        if (raw == null) {
            return null;
        }
        Vector<File> list = new Vector<File>();
        for (int n = 0; n < raw.length; ++n) {
            File f = new File(hostDir, raw[n]);
            if (!f.isDirectory()) continue;
            list.addElement(f);
        }
        return VectorUtils.toFileArray(list);
    }

    public static String[] getListOfDirNames(String path) {
        return FileUtils.getListOfDirNames(new File(path));
    }

    public static String[] getListOfDirNames(File hostDir) {
        String[] raw = hostDir.list();
        if (raw == null) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        for (int n = 0; n < raw.length; ++n) {
            if (!new File(hostDir, raw[n]).isDirectory()) continue;
            list.addElement(raw[n]);
        }
        return VectorUtils.toStringArray(list);
    }

    public static String[] getListOfWebDocs(File dir) {
        String[] htmlFiles = FileUtils.getListOfFileNames(dir, ".html");
        String[] htmFiles = FileUtils.getListOfFileNames(dir, ".htm");
        String[] out = VectorUtils.toStringArray(htmlFiles, htmFiles);
        out = FileUtils.join(dir, out);
        return FileUtils.sortPathsByFileName(out);
    }

    public static String[] getListOfFileNames(File hostDir, String extFilter, boolean recurse) {
        if (recurse) {
            FileUtils utils = new FileUtils();
            utils.setSearch(8, hostDir, extFilter);
            utils.doSearch();
            return utils.getSearchResults();
        }
        return FileUtils.getListOfFileNames(hostDir, extFilter);
    }

    public void setSearch(int maxdepth, File searchDir, String searchExt) {
        this.maxdepth = maxdepth;
        this.searchDir = searchDir;
        this.searchExt = searchExt;
        this.listOfFilePaths.clear();
        this.depth = 1;
    }

    public void doSearch() {
        this.depth = 1;
        this.doSearch(this.searchDir);
    }

    private void doSearch(File hostDir) {
        int n;
        if (hostDir == null || this.depth > this.maxdepth) {
            return;
        }
        ++this.depth;
        String[] files = hostDir.list();
        if (files == null) {
            return;
        }
        for (n = 0; n < files.length; ++n) {
            File f = new File(hostDir, files[n]);
            if (!f.isDirectory()) continue;
            this.doSearch(f);
        }
        if (this.searchExt != null) {
            SourceFileFilter filter = new SourceFileFilter(this.searchExt);
            if (filter == null) {
                Cutter.setLog("FileUtils.getListOfFileNames() filter is null");
                --this.depth;
                return;
            }
            String[] farray = hostDir.list(filter);
            if (farray != null) {
                for (n = 0; n < farray.length; ++n) {
                    this.listOfFilePaths.addElement(new File(hostDir, farray[n]).getPath());
                }
            } else {
                Cutter.setLog("FileUtils.doSearch() farray is null");
            }
        } else {
            String[] farray = hostDir.list();
            if (farray != null) {
                for (n = 0; n < farray.length; ++n) {
                    File f = new File(hostDir, farray[n]);
                    if (f.isDirectory()) continue;
                    this.listOfFilePaths.addElement(f.getPath());
                }
            } else {
                Cutter.setLog("FileUtils.doSearch() farray is null");
            }
        }
        --this.depth;
    }

    public String[] getSearchResults() {
        int offset = this.searchDir.getPath().length() + 1;
        String[] out = new String[this.listOfFilePaths.size()];
        for (int n = 0; n < this.listOfFilePaths.size(); ++n) {
            if (this.listOfFilePaths.elementAt(n) == null) continue;
            out[n] = this.listOfFilePaths.elementAt(n).substring(offset);
        }
        return out;
    }

    public static Vector getListOfMatchingFileNames(String target, File hostDir, String extFilter) {
        String[] list = FileUtils.getListOfFileNames(hostDir, extFilter);
        if (list == null) {
            return null;
        }
        Vector<String> temp = new Vector<String>();
        for (int n = 0; n < list.length; ++n) {
            list[n] = TextUtils.removeExtension(list[n]);
            if (!list[n].regionMatches(0, target, 0, target.length())) continue;
            temp.addElement(list[n]);
        }
        return temp;
    }

    public static String getPartialPath(String path, int parents) {
        return FileUtils.getPartialPath(new File(path), parents);
    }

    public static String getPartialPath(File f, int parents) {
        Vector<String> items = new Vector<String>();
        StringBuffer path = new StringBuffer("...");
        File dir = f;
        for (int n = 0; n < parents && dir != null && dir.getName() != null && !dir.getName().equals(""); dir = dir.getParentFile(), ++n) {
            items.addElement(dir.getName());
        }
        for (int i = items.size() - 1; i >= 0; --i) {
            path.append(File.separatorChar).append((String)items.elementAt(i));
        }
        return path.toString();
    }

    public static String getPathFromRoot(String path) {
        return FileUtils.getPathFromRoot(new File(path));
    }

    public static String getPathFromRoot(File f) {
        if (f == null) {
            return null;
        }
        String path = f.getPath();
        int index = path.indexOf(File.separatorChar);
        if (index == -1) {
            return null;
        }
        String pathFromRoot = path.substring(index + 1);
        return pathFromRoot;
    }

    public static String[] getSubFilesOf(File file) {
        String path = file.getPath();
        Vector<String> listOfSubs = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(file.getPath(), "" + File.separatorChar);
        Vector<String> subDir = new Vector<String>();
        while (tok.hasMoreTokens()) {
            subDir.addElement(tok.nextToken());
        }
        String subPath = "";
        for (int n = 0; n < subDir.size(); ++n) {
            subPath = subPath.length() == 0 ? (String)subDir.elementAt(n) : subPath + File.separatorChar + (String)subDir.elementAt(n);
            listOfSubs.addElement(subPath);
        }
        return VectorUtils.toStringArray(listOfSubs);
    }

    public static boolean isaSubDirOf(File parentDir, String subDirName, boolean caseSensitive) {
        if (parentDir == null || subDirName == null) {
            return false;
        }
        String[] subs = TextUtils.tokenize(parentDir.getPath(), "\\/");
        if (subs == null || subs.length == 0) {
            return false;
        }
        for (int n = 0; n < subs.length; ++n) {
            if (subs[n] == null) continue;
            if (caseSensitive && subs[n].equals(subDirName)) {
                return true;
            }
            if (caseSensitive || !subs[n].equalsIgnoreCase(subDirName)) continue;
            return true;
        }
        return false;
    }

    public static String getUniquePaths(String list1, String list2) {
        String[] array1 = TextUtils.tokenize(list1, "\n");
        String[] array2 = TextUtils.tokenize(list2, "\n");
        if (array1 == null && array2 == null) {
            return "";
        }
        if (array1 != null && array2 == null) {
            return FileUtils.toNewlineList(array1);
        }
        if (array1 == null && array2 != null) {
            return FileUtils.toNewlineList(array2);
        }
        Vector<String> outList = VectorUtils.toVector(array1);
        for (int n = 0; n < outList.size(); ++n) {
            String s1 = outList.elementAt(n).trim();
            for (int i = 0; i < array2.length; ++i) {
                String s2 = array2[i].trim();
                if (s2.equals(s1)) continue;
                outList.addElement(s2);
            }
        }
        StringBuffer buff = new StringBuffer();
        for (int n = 0; n < outList.size(); ++n) {
            buff.append(outList.elementAt(n)).append("\n");
        }
        return buff.toString();
    }

    public static String toNewlineList(String[] in) {
        if (in == null || in.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        for (int n = 0; n < in.length; ++n) {
            buff.append(in[n]).append("\n");
        }
        return buff.toString();
    }

    public static int[] getTextBoundedBy(String src, int begin, int end, char tokBegin, char tokEnd, StringBuffer outbuf) {
        int t1 = src.indexOf(tokEnd, end);
        if (t1 == -1) {
            return null;
        }
        String suffix = src.substring(end, t1);
        int t0 = src.substring(0, begin).lastIndexOf(tokBegin);
        if (t0 == -1) {
            return null;
        }
        String prefix = src.substring(++t0, begin);
        outbuf.append(src.substring(t0, t1));
        int[] out = new int[]{t0, t1};
        return out;
    }

    public static int[] getTextBoundedBySpace(String src, int begin, int end, StringBuffer outbuf) {
        int w1;
        int w0;
        int indexOfSpace = src.indexOf(32, end);
        int indexOfTab = src.indexOf(9, end);
        if (indexOfSpace == -1 && indexOfTab != -1) {
            w0 = indexOfTab;
        } else if (indexOfTab == -1 && indexOfSpace != -1) {
            w0 = indexOfSpace;
        } else {
            int n = w0 = indexOfSpace > indexOfTab ? indexOfTab : indexOfSpace;
        }
        if (w0 == -1) {
            w0 = src.length();
        }
        String suffix = "";
        try {
            suffix = src.substring(end, w0);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:FileUtils.getTextBoundedBySpace() 1 end = " + end + " w0 = " + w0 + "\n" + e.toString());
            }
            outbuf.append(src);
            return null;
        }
        indexOfSpace = src.substring(0, begin).lastIndexOf(32);
        indexOfTab = src.substring(0, begin).lastIndexOf(9);
        int n = w1 = indexOfSpace > indexOfTab ? indexOfSpace : indexOfTab;
        w1 = w1 == -1 || w1 > begin ? 0 : ++w1;
        String prefix = "";
        try {
            prefix = src.substring(w1, begin);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:FileUtils.getTextBoundedBySpace() 2 w1 = " + w1 + " begin = " + begin + "\n" + e.toString());
            }
            outbuf.append(src);
            return null;
        }
        String middleStr = "";
        try {
            middleStr = src.substring(begin, end);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:FileUtils.getTextBoundedBySpace() 3 begin = " + begin + " end = " + end + "\n" + e.toString());
            }
            outbuf.append(src);
            return null;
        }
        outbuf.append(prefix + middleStr + suffix);
        int[] out = new int[]{w1, w0};
        return out;
    }

    public static File resolveRelativePath(File baseDir, String relativePath) {
        int n;
        if (relativePath == null || relativePath.trim().length() == 0) {
            return baseDir;
        }
        if (!(relativePath = relativePath.replace('\\', '/')).startsWith(".")) {
            return new File(relativePath);
        }
        if (relativePath.startsWith("./")) {
            relativePath = relativePath.substring(2);
        }
        File dir = baseDir;
        String[] tokens = TextUtils.tokenize(relativePath, "/");
        int up = 0;
        StringBuffer b = new StringBuffer();
        boolean exhaustedLeadingDots = false;
        if (tokens != null) {
            for (n = 0; n < tokens.length; ++n) {
                if (tokens[n].equals("..") && !exhaustedLeadingDots) {
                    ++up;
                    continue;
                }
                b.append(tokens[n]).append(File.separator);
                exhaustedLeadingDots = true;
            }
        }
        for (n = 0; n < up; ++n) {
            dir = dir.getParentFile();
        }
        return new File(dir, b.toString());
    }

    public static String prefStrToFlaggedList(String compilerFlag, int prefID) {
        String prefStr = Preferences.get(prefID).trim();
        if (prefStr.length() == 0) {
            return "";
        }
        String[] items = TextUtils.tokenize(prefStr, ",");
        if (items == null || items.length == 0) {
            return "";
        }
        Vector<String> list = new Vector<String>();
        for (int n = 0; n < items.length; ++n) {
            String path;
            items[n] = items[n].trim();
            String[] parts = TextUtils.tokenize(items[n], "/");
            boolean singleItem = false;
            if (parts.length == 1) {
                singleItem = true;
                path = items[n];
            } else {
                File f = FileUtils.resolveRelativePath(FileUtils.getPWDFile(), items[n]);
                path = f.getPath().replace('\\', '/');
            }
            if (singleItem) {
                list.addElement(path);
                continue;
            }
            list.addElement(compilerFlag + "\"" + path + "\"");
        }
        return list.size() == 0 ? "" : VectorUtils.vectorToSpacedString(list);
    }

    public static long getTotalSize(File dir) {
        if (dir == null || !dir.exists()) {
            return 0L;
        }
        FileQuery query = new FileQuery(dir);
        String[] paths = query.getAllPaths();
        if (paths == null) {
            return 0L;
        }
        long bytes = 0L;
        for (int n = 0; n < paths.length; ++n) {
            File f = new File(paths[n]);
            if (f.isDirectory() || f.getName().equals(".DS_Store") || !f.isFile()) continue;
            bytes += f.length();
        }
        return bytes;
    }

    public static File findInPaths(String[] paths, String tail) {
        File f = new File(tail);
        if (f.exists()) {
            return f;
        }
        if (paths == null) {
            return null;
        }
        for (int n = 0; n < paths.length; ++n) {
            if (f.exists()) {
                return f;
            }
            if (paths[n] == null || paths[n].trim().length() == 0) continue;
            f = FileUtils.resolveRelativePath(new File(paths[n]), tail);
        }
        return null;
    }

    public static String trimRight(String path) {
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String trimLeft(String path) {
        if (path.startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1, path.length());
        }
        return path;
    }

    public static String toUnixPath(String path) {
        if (path == null || path.trim().length() == 0) {
            return "";
        }
        String newPath = FileUtils.trimRight(path.replace('\\', '/')) + "/";
        return newPath;
    }

    public static String[] getFirstLastFileNames(String[] names) {
        int lastIndex = names.length > 1 ? names.length - 1 : 0;
        String[] out = new String[]{TextUtils.removeExtension(names[0]), TextUtils.removeExtension(names[lastIndex])};
        return out;
    }

    public static String[] getFirstLastFileNames(File[] files) {
        if (files == null || files.length == 0) {
            System.out.println("getFirstLastFileNames: files is null");
            return null;
        }
        Vector<File> v = new Vector<File>();
        for (int n = 0; n < files.length; ++n) {
            if (files[n] == null) continue;
            v.addElement(files[n]);
        }
        File[] f = FileUtils.toFileArray(v);
        String[] out = new String[2];
        if (f.length == 1 && f[0] != null) {
            out[0] = TextUtils.removeExtension(f[0].getName());
            out[1] = out[0];
            return out;
        }
        for (int j = 0; j < f.length; ++j) {
            if (j == 0 && f[j] != null) {
                out[0] = TextUtils.removeExtension(f[0].getName());
                out[1] = out[0];
            }
            if (f[j] == null && j > 1) {
                int index = j > 0 ? j - 1 : 0;
                out[1] = TextUtils.removeExtension(f[index].getName());
                return out;
            }
            if (j != f.length - 1) continue;
            out[1] = TextUtils.removeExtension(f[j].getName());
        }
        return out;
    }

    public static synchronized String getNumeric(String name) {
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < name.length(); ++n) {
            if (!Character.isDigit(name.charAt(n))) continue;
            buf.append(name.charAt(n));
        }
        return buf.toString();
    }

    public static boolean exists(File dir, File[] files) {
        if (files == null || dir == null || !dir.exists()) {
            return false;
        }
        for (int n = 0; n < files.length; ++n) {
            File f = files[n];
            if (f == null || (f = new File(dir, f.getName())).exists()) continue;
            return false;
        }
        return true;
    }

    public static boolean containsSubdirNamed(File dir, String targetName) {
        if (dir == null || targetName == null) {
            return false;
        }
        String[] names = FileUtils.getListOfDirNames(dir);
        if (names == null) {
            return false;
        }
        for (int n = 0; n < names.length; ++n) {
            if (!names[n].equals(targetName)) continue;
            return true;
        }
        return false;
    }

    public static boolean exists(File dir, String[] names) {
        if (names == null || dir == null || !dir.exists()) {
            return false;
        }
        for (int n = 0; n < names.length; ++n) {
            File f = new File(dir, names[n]);
            if (f == null || (f = new File(dir, f.getName())).exists()) continue;
            return false;
        }
        return true;
    }

    public static File isRMSRibFile(File file) {
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            Cutter.setLog("    Info:FileUtils.isRMSRibFile() - null parent directory for input file \"" + file + "\"");
            return null;
        }
        if (parentFile.exists()) {
            String name = parentFile.getName();
            if (name == null) {
                return null;
            }
            if (name.length() == 4 && Character.isDigit(name.charAt(0)) && Character.isDigit(name.charAt(1)) && Character.isDigit(name.charAt(2)) && Character.isDigit(name.charAt(3)) && (parentFile = parentFile.getParentFile()).exists() && (name = parentFile.getName()).equals("rib") && (parentFile = parentFile.getParentFile()).exists() && (parentFile = parentFile.getParentFile()).exists() && parentFile.getName().equals("renderman") && (parentFile = parentFile.getParentFile()).exists()) {
                return parentFile;
            }
        }
        return null;
    }

    public static File[] uniquefy(File[] input) {
        Hashtable<String, File> table = new Hashtable<String, File>();
        for (int n = 0; n < input.length; ++n) {
            table.put(input[n].getPath(), input[n]);
        }
        Vector<File> tmp = new Vector<File>();
        Enumeration en = table.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (key == null) continue;
            tmp.addElement((File)table.get(key));
        }
        if (tmp.size() == 0) {
            return null;
        }
        File[] out = new File[tmp.size()];
        for (int n = 0; n < tmp.size(); ++n) {
            out[n] = (File)tmp.elementAt(n);
        }
        return out;
    }

    public static class SourceFileFilter
    implements FilenameFilter {
        private String ext = "";

        public SourceFileFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }
}

