/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Utilities.RegExpUtils;

public class FinderUtils {
    public static FindDB find(String src, String target, int startAt, boolean doIgnoreCase, boolean doWholeWord) {
        String regexp;
        String[] parts = null;
        FindDB db = new FindDB();
        RegExpUtils re = new RegExpUtils();
        db.regexp = regexp = re.encodeAsRE(target, doIgnoreCase, doWholeWord);
        if (!re.checkPattern(regexp)) {
            db.error = "ERROR 1: \"" + regexp + "\"";
            return db;
        }
        int diff = 0;
        try {
            parts = src.substring(startAt).split(regexp, 2);
            if (parts == null || parts.length <= 1) {
                db.error = "ERROR 2: NOT FOUND";
                return db;
            }
            int part0Length = parts[0].length();
            int part1Length = parts[1].length();
            diff = src.substring(startAt).length() - (part0Length + part1Length);
            int beginOffset = parts[0].length();
            db.absBegin = beginOffset + startAt;
            db.absEnd = db.absBegin + diff;
            db.prefix = src.substring(startAt, db.absBegin).trim();
            db.postfix = src.substring(db.absEnd).trim();
        }
        catch (Exception e) {
            db.error = "ERROR 3: " + e.toString();
            return db;
        }
        boolean status = false;
        if (parts != null && parts.length > 1 && diff == 0 && parts[0].length() == 0) {
            db.error = "ERROR 4: NOT FOUND";
            return db;
        }
        db.error = null;
        db.prefix = db.prefix.trim();
        db.postfix = db.postfix.trim();
        return db;
    }

    public static FindDB doFind(String src, String target, int startAt, boolean doIgnoreCase, boolean doWholeWord) {
        String regexp;
        String[] parts = null;
        FindDB db = new FindDB();
        RegExpUtils re = new RegExpUtils();
        db.regexp = regexp = re.encodeAsRE(target, doIgnoreCase, doWholeWord);
        if (!re.checkPattern(regexp)) {
            db.error = "ERROR 1: \"" + regexp + "\"";
            return db;
        }
        int diff = 0;
        try {
            parts = src.split(regexp, 2);
            if (parts == null || parts.length <= 1) {
                db.error = "ERROR 2: NOT FOUND";
                return db;
            }
            int part0Length = parts[0].length();
            int part1Length = parts[1].length();
            diff = src.length() - (part0Length + part1Length);
            int beginOffset = parts[0].length();
            db.absBegin = beginOffset + startAt;
            db.absEnd = db.absBegin + diff;
            db.prefix = src.substring(startAt, db.absBegin).trim();
            db.postfix = src.substring(db.absEnd).trim();
        }
        catch (Exception e) {
            db.error = "ERROR 3: " + e.toString();
            return db;
        }
        boolean status = false;
        if (parts != null && parts.length > 1 && diff == 0 && parts[0].length() == 0) {
            db.error = "ERROR 4: NOT FOUND";
            return db;
        }
        db.error = null;
        db.prefix = db.prefix.trim();
        db.postfix = db.postfix.trim();
        return db;
    }

    public static FindDB findUsing(String src, String regexp, int startAt) {
        String[] parts = null;
        FindDB db = new FindDB();
        int diff = 0;
        try {
            parts = src.split(regexp, 2);
            if (parts == null || parts.length <= 1) {
                db.error = "ERROR 2: NOT FOUND";
                return db;
            }
            int part0Length = parts[0].length();
            int part1Length = parts[1].length();
            diff = src.length() - (part0Length + part1Length);
            int beginOffset = parts[0].length();
            db.absBegin = beginOffset + startAt;
            db.absEnd = db.absBegin + diff;
            db.prefix = src.substring(startAt, db.absBegin).trim();
            db.postfix = src.substring(db.absEnd).trim();
        }
        catch (Exception e) {
            db.error = "ERROR 3: " + e.toString();
            return db;
        }
        boolean status = false;
        if (parts != null && parts.length > 1 && diff == 0 && parts[0].length() == 0) {
            db.error = "ERROR 4: NOT FOUND";
            return db;
        }
        db.error = null;
        db.prefix = db.prefix.trim();
        db.postfix = db.postfix.trim();
        return db;
    }

    public static class FindDB {
        public int absBegin = -1;
        public int absEnd = -1;
        public String prefix = null;
        public String postfix = null;
        public String error = null;
        public String regexp = null;
    }
}

