/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Preferences.Preferences;
import Processes.ProcessManager;
import UI_Desktop.Cutter;
import UI_Tools.Rman.RenderInfo;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class GraphicsFileUtils {
    public static String[] shakeFormats = new String[]{".bmp", ".sgif", ".tif", ".pal", ".nri", ".exr", ".alias", ".tga", ".tiff", ".avi", ".png", ".rpf", ".dpx", ".sgiraw", ".rla", ".iff", ".cineon", ".jpg", ".sgi", ".yuv", ".xpm", ".jpeg", ".pbm"};
    public static Hashtable shakeLUT = new Hashtable();

    public static boolean canOpen(File f) {
        if (GraphicsFileUtils.canQTOpen(f)) {
            return true;
        }
        if (GraphicsFileUtils.canShakeOpen(f)) {
            return true;
        }
        if (GraphicsFileUtils.canShoOpen(f)) {
            return true;
        }
        if (GraphicsFileUtils.canPtviewerOpen(f)) {
            return true;
        }
        if (GraphicsFileUtils.canBrickviewerOpen(f)) {
            return true;
        }
        if (GraphicsFileUtils.canDsviewOpen(f)) {
            return true;
        }
        return GraphicsFileUtils.canPtxviewerOpen(f);
    }

    public static String canOpenUsing(File f) {
        if (GraphicsFileUtils.canQTOpen(f)) {
            return "QTPlayer";
        }
        if (GraphicsFileUtils.canShakeOpen(f)) {
            return "Shake Flipbook";
        }
        if (GraphicsFileUtils.canShoOpen(f)) {
            if (RenderInfo.activeRendererIs("3delight")) {
                return "i-display";
            }
            return "sho";
        }
        if (GraphicsFileUtils.canPtviewerOpen(f)) {
            if (RenderInfo.activeRendererIs("3delight")) {
                return "ptcview";
            }
            return "ptviewer";
        }
        if (GraphicsFileUtils.canBrickviewerOpen(f)) {
            return "brickviewer";
        }
        if (GraphicsFileUtils.canDsviewOpen(f)) {
            return "dsview";
        }
        if (GraphicsFileUtils.canPtxviewerOpen(f)) {
            return "ptxview";
        }
        return null;
    }

    public static void open(File f) {
        if (GraphicsFileUtils.canQTOpen(f)) {
            GraphicsFileUtils.qtOpen(f);
            return;
        }
        if (GraphicsFileUtils.canShoOpen(f)) {
            if (RenderInfo.activeRendererIs("3delight")) {
                GraphicsFileUtils.idisplayOpen(f);
            } else {
                GraphicsFileUtils.shoOpen(f);
            }
            return;
        }
        if (GraphicsFileUtils.canPtviewerOpen(f)) {
            if (RenderInfo.activeRendererIs("3delight")) {
                GraphicsFileUtils.ptcViewOpen(f);
            } else {
                GraphicsFileUtils.ptViewerOpen(f);
            }
            return;
        }
        if (GraphicsFileUtils.canBrickviewerOpen(f)) {
            GraphicsFileUtils.brickViewerOpen(f);
            return;
        }
        if (GraphicsFileUtils.canDsviewOpen(f)) {
            GraphicsFileUtils.dsViewOpen(f);
            return;
        }
        if (GraphicsFileUtils.canPtxviewerOpen(f)) {
            GraphicsFileUtils.ptxViewerOpen(f);
            return;
        }
    }

    public static boolean canQTOpen(File f) {
        if (f == null) {
            return false;
        }
        String ext = FileUtils.getExtension(f);
        if (ext == null || ext.equals("")) {
            return false;
        }
        String ex = ext.toLowerCase();
        return ex.equals(".mov");
    }

    public static void qtOpen(File f) {
        if (!GraphicsFileUtils.canQTOpen(f)) {
            return;
        }
        if (EnvUtils.isWinEnvironment()) {
            String[] items = new String[]{"\"C:\\Program Files\\QuickTime\\quicktimeplayer\"", f.getPath().replace('/', '\\')};
            ProcessManager fp = new ProcessManager("silent");
            fp.launch(items, null, false, null, true);
            return;
        }
        String[] items = new String[]{"open", "-a", "/Applications/QuickTime Player.app", f.getPath()};
        ProcessManager fp = new ProcessManager("silent");
        fp.launch(items, null, false, null, true);
    }

    public static String getRPSBinPath() {
        String path = RenderInfo.get(6);
        if (path == null || path.trim().length() == 0) {
            Cutter.setLog("    Warning:GraphicsFileUtils.getRPSBinPath() - no path set in prefs for \"Rman-System-Resource Directories-bin/exe\"");
            return "";
        }
        path = TextUtils.trimTrailingChar(path, '/');
        if (!new File(path = TextUtils.trimTrailingChar(path, '\\')).exists()) {
            Cutter.setLog("    Warning:GraphicsFileUtils.getRPSBinPath() - the path set in prefs for \"Rman-System-Resource Directories-bin/exe\"\n          \"" + path + "\" does not exist!");
            return "";
        }
        if (Cutter.input.debug) {
            Cutter.setLog("    Debug:GraphicsFileUtils.getRPSBinPath() - using path \"" + path + "\"");
        }
        return FileUtils.toUnixPath(path);
    }

    private static String getRMSBinPath() {
        String path = Preferences.get(Preferences.PATH_PIXAR_RMS);
        if (path == null || path.trim().length() == 0) {
            Cutter.setLog("    Warning:GraphicsFileUtils.getRMSBinPath() - no path set in prefs for \"Rman-Docs-Installation Directories-RMS Root\"");
            return "";
        }
        path = TextUtils.trimTrailingChar(path, '/');
        path = TextUtils.trimTrailingChar(path, '\\');
        if (!new File(path = path + "/bin").exists()) {
            Cutter.setLog("    Warning:GraphicsFileUtils.getRPSBinPath() - the path set in prefs for \"Rman-Docs-Installation Directories-RMS Root\" does not exist");
            return "";
        }
        Cutter.setLog("    Info:GraphicsFileUtils.getRMSBinPath() - using path \"" + path + "\"");
        return FileUtils.toUnixPath(path);
    }

    public static boolean canShoOpen(File f) {
        if (f == null) {
            return false;
        }
        String ext = FileUtils.getExtension(f);
        if (ext == null || ext.equals("")) {
            return false;
        }
        String ex = ext.toLowerCase();
        return ex.equals(".dtex") || ex.equals(".rat") || ex.equals(".tex") || ex.equals(".tx") || ex.equals(".z") || ex.equals(".depth") || ex.equals(".zfile") || ex.equals(".tif") || ex.equals(".tga") || ex.equals(".hdr") || ex.equals(".jpg") || ex.equals(".gif") || ex.equals(".iff");
    }

    public static void shoOpen(File f) {
        if (GraphicsFileUtils.canShoOpen(f)) {
            String path = f.getPath();
            path = path.replace('\\', '/');
            String command = GraphicsFileUtils.getRPSBinPath();
            if (command.equals("")) {
                command = "sho";
            } else {
                command = TextUtils.trimTrailingChar(command, '/');
                command = command + "/sho";
            }
            String[] items = new String[]{command, path};
            ProcessManager fp = new ProcessManager("Sho");
            fp.launch(items, null, false, null, false);
        }
    }

    public static void idisplayOpen(File f) {
        if (GraphicsFileUtils.canShoOpen(f)) {
            String path = f.getPath();
            path = path.replace('\\', '/');
            String command = GraphicsFileUtils.getRPSBinPath();
            if (command.equals("")) {
                command = "i-display";
            } else {
                command = TextUtils.trimTrailingChar(command, '/');
                command = command + "/i-display";
            }
            String[] items = new String[]{command, path};
            ProcessManager fp = new ProcessManager("I-Display");
            fp.launch(items, null, false, null, false);
        }
    }

    public static boolean canBrickviewerOpen(File f) {
        if (f == null) {
            return false;
        }
        String ext = FileUtils.getExtension(f);
        if (ext == null || ext.equals("")) {
            return false;
        }
        String ex = ext.toLowerCase();
        return ex.equals(".bkm");
    }

    public static boolean canPtxviewerOpen(File f) {
        if (f == null) {
            return false;
        }
        String ext = FileUtils.getExtension(f);
        if (ext == null || ext.equals("")) {
            return false;
        }
        String ex = ext.toLowerCase();
        return ex.equals(".ptx");
    }

    public static void brickViewerOpen(File f) {
        if (GraphicsFileUtils.canBrickviewerOpen(f)) {
            String path = f.getPath();
            path = path.replace('\\', '/');
            String command = GraphicsFileUtils.getRPSBinPath();
            command = command.equals("") ? "brickviewer" : command + "/brickviewer";
            String[] items = new String[]{command, path};
            ProcessManager fp = new ProcessManager("Brickviewer");
            fp.launch(items, null, false, null, false);
        }
    }

    public static void ptxViewerOpen(File f) {
        if (GraphicsFileUtils.canPtxviewerOpen(f)) {
            String path = f.getPath();
            path = path.replace('\\', '/');
            String command = GraphicsFileUtils.getRPSBinPath();
            command = command.equals("") ? "ptxview" : command + "/ptxview";
            String[] items = new String[]{command, path};
            ProcessManager fp = new ProcessManager("Ptxview");
            fp.launch(items, null, false, null, false);
        }
    }

    public static boolean canDsviewOpen(File f) {
        if (f == null) {
            return false;
        }
        String ext = FileUtils.getExtension(f);
        if (ext == null || ext.equals("")) {
            return false;
        }
        String ex = ext.toLowerCase();
        return ex.equals(".sm");
    }

    public static void dsViewOpen(File f) {
        if (GraphicsFileUtils.canDsviewOpen(f)) {
            String path = f.getPath();
            path = path.replace('\\', '/');
            String command = GraphicsFileUtils.getRPSBinPath();
            if (command.equals("")) {
                command = "dsview";
            } else {
                command = TextUtils.trimTrailingChar(command, '/');
                command = command + "/dsview";
            }
            String[] items = new String[]{command, path};
            ProcessManager fp = new ProcessManager("Dsview");
            fp.launch(items, null, false, null, false);
        }
    }

    public static boolean canPtviewerOpen(File f) {
        if (f == null) {
            return false;
        }
        String ext = FileUtils.getExtension(f);
        if (ext == null || ext.equals("")) {
            return false;
        }
        String ex = ext.toLowerCase();
        return ex.equals(".ptc") || ex.equals(".optc") || ex.equals(".cpm");
    }

    public static void ptcViewOpen(File f) {
        String path = f.getPath();
        path = path.replace('\\', '/');
        String command = RenderInfo.get(6);
        if (command.equals("")) {
            command = "ptcview";
        } else {
            command = TextUtils.trimTrailingChar(command, '/');
            command = command + "/ptcview";
        }
        String[] items = new String[]{command, path};
        ProcessManager fp = new ProcessManager("ptcview");
        fp.launch(items, null, false, null, false);
    }

    public static void ptViewerOpen(File f) {
        if (GraphicsFileUtils.canPtviewerOpen(f)) {
            String path = f.getPath();
            path = path.replace('\\', '/');
            String command = GraphicsFileUtils.getRPSBinPath();
            if (command.equals("")) {
                command = "ptviewer";
            } else {
                command = TextUtils.trimTrailingChar(command, '/');
                command = command + "/ptviewer";
            }
            String ext = FileUtils.getExtension(f);
            String ex = ext.toLowerCase();
            if (ext.equals(".optc")) {
                command = command + " -info";
            }
            String[] items = new String[]{command, path};
            ProcessManager fp = new ProcessManager("Ptviewer");
            fp.launch(items, null, false, null, false);
        }
    }

    public static boolean canBrickMakeConvert(File f) {
        return GraphicsFileUtils.canPtviewerOpen(f);
    }

    public static void BrickMakeConvert(File f) {
        if (GraphicsFileUtils.canBrickMakeConvert(f)) {
            String brickName = TextUtils.removeExtension(f.getName()) + ".bkm";
            File parent = f.getParentFile();
            String brickpath = parent.getPath();
            brickpath = brickpath.replace('\\', '/');
            brickpath = brickpath + "/" + brickName;
            String ptcpath = f.getPath();
            ptcpath = ptcpath.replace('\\', '/');
            String command = GraphicsFileUtils.getRPSBinPath();
            if (command.equals("")) {
                command = "brickmake";
            } else {
                command = TextUtils.trimTrailingChar(command, '/');
                command = command + "/brickmake";
            }
            String[] items = new String[]{command, ptcpath, brickpath};
            ProcessManager fp = new ProcessManager("Brickmake");
            fp.launch(items, null, false, null, false);
        }
    }

    public static boolean canShakeOpen(File f) {
        if (f == null) {
            return false;
        }
        String ext = FileUtils.getExtension(f);
        if (ext == null || ext.equals("")) {
            return false;
        }
        String ex = ext.toLowerCase();
        String binPath = Preferences.get(Preferences.PATH_SHK_BIN);
        if (binPath == null || binPath.trim().length() == 0) {
            return false;
        }
        if (!new File(binPath).exists()) {
            return false;
        }
        return shakeLUT.get(ex) != null;
    }

    public static String getExtFromDriver(String driver) {
        if (driver == null) {
            return ".tif";
        }
        if (driver.equals("tiff")) {
            return ".tif";
        }
        if (driver.equals("sgif")) {
            return ".sgif";
        }
        if (driver.equals("alias")) {
            return ".alias";
        }
        if (driver.equals("targa")) {
            return ".tga";
        }
        if (driver.equals("cineon")) {
            return ".dpx";
        }
        if (driver.equals("softimage")) {
            return ".pic";
        }
        if (driver.equals("mayaiff")) {
            return ".iff";
        }
        if (driver.equals("z")) {
            return ".z";
        }
        if (driver.equals("zfile")) {
            return ".depth";
        }
        if (driver.equals("deepshad")) {
            return ".sm";
        }
        if (driver.equals("openexr")) {
            return ".exr";
        }
        return ".tif";
    }

    public static BufferedImage readImageFile(File infile) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(infile);
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:GraphicsFileUtils.readImageFile() - " + e.toString());
            return null;
        }
        return img;
    }

    static {
        for (int n = 0; n < shakeFormats.length; ++n) {
            shakeLUT.put(shakeFormats[n], shakeFormats[n]);
        }
    }
}

