/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Html.HtmlTag;
import UI_Script.Html.HtmlTokenizer;
import UI_Text.KTextPane.KTextPane;
import Utilities.DocumentUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;

public class HTMLUtils {
    public static String[] reformat(String src) {
        String[] lines;
        Vector<String> listOfLines = new Vector<String>();
        Vector<String> listOfLineElements = new Vector<String>();
        StringBuffer outBuf = new StringBuffer();
        StringBuffer lineBuf = new StringBuffer();
        HtmlTokenizer tok = new HtmlTokenizer();
        if (src == null || src.trim().length() == 0) {
            return null;
        }
        tok.setBuffer(src);
        String tag = tok.getNextStr();
        int bodyIndex = -1;
        while (!tag.equals("")) {
            String name = HTMLUtils.getTagName(tag);
            if (name != null && name.equals("/head")) {
                bodyIndex = tok.getBufferIndex();
            }
            tag = tok.getNextStr();
        }
        if (bodyIndex != -1) {
            outBuf.append(tok.getBuffer(0, bodyIndex));
            src = new String(tok.getBuffer(bodyIndex));
        }
        if ((lines = src.split("\\n")) == null || lines.length == 0) {
            return null;
        }
        boolean consolidate = false;
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n];
            if (consolidate) {
                if (line.endsWith(">")) {
                    lineBuf.append(line);
                    listOfLines.add(lineBuf.toString());
                    lineBuf.setLength(0);
                    consolidate = false;
                    continue;
                }
                lineBuf.append(line);
                continue;
            }
            if (line.startsWith("<") && !line.endsWith(">")) {
                lineBuf.append(lines[n]);
                consolidate = true;
                continue;
            }
            listOfLines.add(lines[n]);
        }
        lines = VectorUtils.toStringArray(listOfLines);
        listOfLines.clear();
        lineBuf.setLength(0);
        for (int j = 0; j < 5; ++j) {
            lines = HTMLUtils.breakRepeatedDivs(lines);
        }
        Hashtable<String, String> tableOfLineElementNames = new Hashtable<String, String>();
        tok.grabPreformatted = true;
        for (int n = 0; n < lines.length; ++n) {
            listOfLineElements.clear();
            tableOfLineElementNames.clear();
            tok.setBuffer(lines[n]);
            String s = tok.getNextStr();
            String prevCloseTag = "";
            String prevOpenTag = "";
            while (!s.equals("")) {
                if (!s.startsWith("<")) {
                    if (!(!HtmlTag.Style.containsKey(prevCloseTag.toLowerCase()) || s.startsWith(".") || s.startsWith(",") || s.startsWith(":") || s.startsWith(";") || s.startsWith(")") || s.startsWith("]") || s.startsWith("}") || s.startsWith(">"))) {
                        listOfLineElements.add(" " + s);
                    } else {
                        listOfLineElements.add(s);
                    }
                    prevCloseTag = "";
                } else {
                    listOfLineElements.add(s);
                }
                if (s.startsWith("<")) {
                    prevOpenTag = "";
                    prevCloseTag = "";
                    String tname = HTMLUtils.getTagName(s);
                    if (tname != null && !tname.startsWith("/")) {
                        tableOfLineElementNames.put(tname, tname);
                        prevOpenTag = tname;
                    }
                    if (tname != null && tname.startsWith("/")) {
                        prevCloseTag = tname;
                    }
                }
                s = tok.getNextStr();
            }
            lineBuf.setLength(0);
            for (int i = 0; i < listOfLineElements.size(); ++i) {
                String ele = (String)listOfLineElements.elementAt(i);
                if (ele == null || ele.length() == 0) continue;
                if (!ele.startsWith("<")) {
                    lineBuf.append(ele);
                    continue;
                }
                if (HTMLUtils.isBlockBegin(ele)) {
                    lineBuf.append(ele);
                    continue;
                }
                if (HTMLUtils.isBlockEnd(ele)) {
                    String tname;
                    String fullname = HTMLUtils.getTagName(ele);
                    String string = tname = fullname == null ? "" : fullname.substring(1);
                    if (HTMLUtils.isBlockEnd(ele) && tableOfLineElementNames.containsKey(tname)) {
                        tableOfLineElementNames.remove(fullname);
                        lineBuf.append(ele);
                        listOfLines.add(lineBuf.toString());
                        lineBuf.setLength(0);
                        continue;
                    }
                    if (lineBuf.length() > 0) {
                        listOfLines.add(lineBuf.toString());
                    }
                    listOfLines.add(ele);
                    lineBuf.setLength(0);
                    continue;
                }
                lineBuf.append(ele);
            }
            if (lineBuf.length() <= 0) continue;
            listOfLines.add(lineBuf.toString());
        }
        tok.grabPreformatted = false;
        lines = VectorUtils.toStringArray(listOfLines);
        listOfLines.setSize(0);
        int tabcount = 0;
        String tabstr = "";
        String extratabs = "";
        boolean isEnd = false;
        for (int n = 0; n < lines.length; ++n) {
            isEnd = false;
            String line = lines[n];
            if (line.length() == 0) {
                outBuf.append("\n");
                continue;
            }
            if (HTMLUtils.isBlockBegin(line) && HTMLUtils.isBlockEnd(line)) {
                extratabs = "";
            } else if (HTMLUtils.isBlockBegin(line)) {
                extratabs = "";
                ++tabcount;
            } else if (HTMLUtils.isBlockEnd(line)) {
                extratabs = "";
                isEnd = true;
                tabcount = --tabcount < 0 ? 0 : tabcount;
                tabstr = TextUtils.getTabString(tabcount);
            } else {
                tok.setBuffer(line);
                String[] s = TextUtils.tokenize(line);
                if (s == null) continue;
            }
            outBuf.append(tabstr).append(extratabs).append(line).append("\n");
            if (isEnd) continue;
            tabstr = TextUtils.getTabString(tabcount);
        }
        String[] out = new String[]{tabstr, outBuf.toString()};
        return out;
    }

    public static boolean isStyleBeginTagStr(String str) {
        String name = HTMLUtils.getTagName(str);
        if (name == null) {
            return false;
        }
        boolean b = HtmlTag.StyleBegin.containsKey(name);
        return b;
    }

    public static boolean isBeginTagStr(String str) {
        String name = HTMLUtils.getTagName(str);
        if (name == null) {
            return false;
        }
        boolean b = HtmlTag.Open.containsKey(name);
        return b;
    }

    public static String getTagName(String fullTagStr) {
        if (fullTagStr == null || fullTagStr.trim().length() == 0) {
            return null;
        }
        if (!(fullTagStr = fullTagStr.trim()).startsWith("<") && !fullTagStr.endsWith(">")) {
            return "";
        }
        if (!fullTagStr.startsWith("<") || !fullTagStr.endsWith(">")) {
            return null;
        }
        String innerTagStr = fullTagStr.substring(1, fullTagStr.length() - 1);
        String[] tok = TextUtils.tokenize(innerTagStr);
        String out = tok == null || tok.length == 0 ? null : tok[0].toLowerCase();
        return out;
    }

    public static boolean isEndTagStr(String str) {
        String name = HTMLUtils.getTagName(str);
        if (name == null) {
            return false;
        }
        boolean b = HtmlTag.Close.containsKey(name);
        return b;
    }

    private static boolean isBlockBegin(String str) {
        String s = str.trim();
        if (!str.trim().startsWith("<")) {
            return false;
        }
        int firstCloseBracket = s.indexOf(62);
        if (firstCloseBracket == -1) {
            return false;
        }
        String[] tok = TextUtils.tokenize(s = s.substring(1, firstCloseBracket));
        if (tok == null || tok.length == 0) {
            return false;
        }
        s = tok[0];
        boolean b = HtmlTag.BlockBegin.containsKey(s.toLowerCase());
        return b;
    }

    private static boolean isBlockEnd(String str) {
        String s = str.trim();
        if (!s.endsWith(">")) {
            return false;
        }
        int lastOpenBracket = s.lastIndexOf(60);
        if (lastOpenBracket == -1) {
            return false;
        }
        s = s.substring(lastOpenBracket);
        s = s.substring(1, s.length() - 1);
        boolean b = HtmlTag.BlockEnd.containsKey(s.toLowerCase());
        return b;
    }

    public static boolean _isBlockEnd(String str) {
        String tagname;
        if (!str.trim().startsWith("<")) {
            return false;
        }
        String[] tok = TextUtils.tokenize(str);
        if (tok == null || tok.length == 0) {
            return false;
        }
        if (tok.length == 1) {
            tagname = str.substring(1, str.length() - 1);
        } else {
            int firstSpaceIndex = str.indexOf(32);
            tagname = str.substring(1, firstSpaceIndex);
        }
        boolean b = HtmlTag.BlockEnd.containsKey(tagname.toLowerCase());
        return b;
    }

    private static String[] breakRepeatedDivs(String[] lines) {
        HtmlTokenizer tok = new HtmlTokenizer();
        Vector<String> listOfLines = new Vector<String>();
        Vector<String> tokenList = new Vector<String>();
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n].trim();
            tokenList.setSize(0);
            tok.setBuffer(line);
            String t = tok.getNextStr();
            while (!t.equals("")) {
                tokenList.add(t);
                t = tok.getNextStr();
            }
            if (tokenList.size() >= 2) {
                String[] tokens = VectorUtils.toStringArray(tokenList);
                if (tokens != null && tokens.length >= 2) {
                    String t0 = HTMLUtils.getTagName(tokens[0]);
                    String t1 = HTMLUtils.getTagName(tokens[1]);
                    if (t0 != null && t0.equalsIgnoreCase("div") && t1 != null && t1.equalsIgnoreCase("div")) {
                        listOfLines.add(tokens[0]);
                        int len = tokens[0].length();
                        listOfLines.add(line.substring(len));
                        continue;
                    }
                    listOfLines.add(lines[n]);
                    continue;
                }
                listOfLines.add(lines[n]);
                continue;
            }
            listOfLines.add(lines[n]);
        }
        return VectorUtils.toStringArray(listOfLines);
    }

    public static String generateHTML(JEditorPane editor, boolean openInWindow) {
        char c;
        if (editor == null) {
            editor = BBxt.getTextPane();
        }
        if (editor == null || !(editor instanceof KTextPane)) {
            Cutter.setLog("    Error:KAbstractDesktop.ExportHtmlAction - front window editor is not an instance of KTextPane");
            return null;
        }
        KTextPane textpane = (KTextPane)editor;
        Document doc = textpane.getDocument();
        if (doc == null || !(doc instanceof DefaultStyledDocument)) {
            Cutter.setLog("    Error:KAbstractDesktop.ExportHtmlAction - front window text pane is not a styled document");
            return null;
        }
        int begin = BBxt.getSelectionStart();
        if (begin <= 2) {
            begin = 0;
        }
        int end = BBxt.getSelectionEnd();
        if (begin == -1 || end == -1) {
            Cutter.setLog("    Error:KAbstractDesktop.ExportHtmlAction - cannot get start and end offsets of the selection");
            return null;
        }
        if (begin == end) {
            begin = 0;
            end = BBxt.getDocumentLength();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<pre>");
        StringBuffer tag = new StringBuffer();
        Color currColor = null;
        Vector<String> skipped = new Vector<String>();
        for (int n = begin; n < end; ++n) {
            String str;
            c = textpane.getCharAt(n).charAt(0);
            if (Character.isWhitespace(c)) {
                switch (c) {
                    case '\t': {
                        str = "    ";
                        break;
                    }
                    case '<': {
                        str = "&lt;";
                        break;
                    }
                    case '>': {
                        str = "&gt;";
                        break;
                    }
                    default: {
                        str = "" + c;
                    }
                }
            } else {
                currColor = DocumentUtils.getCharacterStyleColor(doc, n);
                break;
            }
            skipped.addElement(str);
        }
        int skipLen = skipped.size();
        for (int n = 0; n < skipLen; ++n) {
            buf.append((String)skipped.elementAt(n));
        }
        skipped.setSize(0);
        buf.append("<font color=\"" + NumberUtils.convertToHex(currColor) + "\">");
        boolean tagOpen = true;
        StringBuffer whiteSpaceBuf = new StringBuffer();
        for (int n = begin + skipLen; n < end; ++n) {
            Color color = DocumentUtils.getCharacterStyleColor(doc, n);
            c = textpane.getCharAt(n).charAt(0);
            if (Character.isWhitespace(c)) {
                if (c == '\t') {
                    whiteSpaceBuf.append("    ");
                    continue;
                }
                if (c == '\n') {
                    if (n - 1 > begin + skipLen && textpane.getCharAt(n - 1).charAt(0) == '\n') {
                        whiteSpaceBuf.append("  \n");
                        continue;
                    }
                    whiteSpaceBuf.append("\n");
                    continue;
                }
                whiteSpaceBuf.append("" + c);
                continue;
            }
            if (!Character.isWhitespace(c) && color != currColor) {
                if (tagOpen) {
                    tag.append("</font>");
                    tag.append(whiteSpaceBuf.toString());
                    whiteSpaceBuf.setLength(0);
                    tagOpen = false;
                }
                if (color != Color.black) {
                    tag.append(whiteSpaceBuf.toString());
                    whiteSpaceBuf.setLength(0);
                    tag.append("<font color=\"").append(NumberUtils.convertToHex(color)).append("\">");
                    tagOpen = true;
                }
                currColor = color;
            }
            switch (c) {
                case '\t': {
                    buf.append("    ");
                    buf.append(tag.toString());
                    break;
                }
                case '\n': {
                    buf.append(" \n");
                    buf.append(tag.toString());
                    break;
                }
                default: {
                    buf.append(whiteSpaceBuf.toString());
                    whiteSpaceBuf.setLength(0);
                    buf.append(tag.toString());
                    if (c == '<') {
                        buf.append("&lt;");
                        break;
                    }
                    if (c == '>') {
                        buf.append("&gt;");
                        break;
                    }
                    buf.append(c);
                }
            }
            tag.setLength(0);
        }
        if (tagOpen) {
            buf.append("</font>");
        }
        if (buf.length() > 0) {
            buf.append(whiteSpaceBuf.toString());
            buf.append("</pre>");
            if (openInWindow) {
                String title = "untitled_" + KAbstractDesktop.getFrameCount() + ".html";
                KAbstractDesktop.incrFrameCount();
                BBxt.newDocument(title, buf);
            }
        }
        return buf.toString();
    }
}

