/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import Utilities.FileUtils;
import Utilities.RayFileUtils;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JTextPane;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;

public class JPEGUtils {
    private BufferedImage iconImage = null;

    public JPEGUtils() {
    }

    public JPEGUtils(int iconWidth) {
        this.iconImage = new BufferedImage(iconWidth, iconWidth, 1);
    }

    private float getScaleFactor(BufferedImage srcImage, int minSide) {
        if (srcImage == null) {
            return 0.0f;
        }
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        return (float)minSide / (float)(width >= height ? height : width);
    }

    public BufferedImage readJPEGFile(File srcJPEGFile) {
        return null;
    }

    public boolean writeJPEGFile(BufferedImage image, File destJPEGFile) {
        return false;
    }

    public static boolean saveJPEGFile(BufferedImage srcImage, File outfile) {
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(1.0f);
            FileImageOutputStream output = new FileImageOutputStream(outfile);
            writer.setOutput(output);
            IIOImage image = new IIOImage(srcImage, null, null);
            writer.write(null, image, iwp);
            writer.dispose();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public BufferedImage saveAsSquareIcon(BufferedImage srcImage, File iconJPEGFile, int iconWidth) {
        BufferedImage image;
        if (srcImage == null || iconJPEGFile == null) {
            return null;
        }
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        int xOffset = (width - height) / 2;
        try {
            image = srcImage.getSubimage(xOffset, 0, height, height);
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:JPEGUtils.saveAsSquareIcon() - " + ex);
            return null;
        }
        float s = this.getScaleFactor(image, iconWidth);
        AffineTransform transformation = new AffineTransform();
        transformation.scale(s, s);
        AffineTransformOp op = new AffineTransformOp(transformation, 1);
        if (this.iconImage == null) {
            this.iconImage = new BufferedImage(iconWidth, iconWidth, 1);
        }
        op.filter(image, this.iconImage);
        this.writeJPEGFile(this.iconImage, iconJPEGFile);
        return this.iconImage;
    }

    public BufferedImage saveAsSquareIcon(File srcJPEGFile, File iconJPEGFile, int iconWidth) {
        if (srcJPEGFile == null || iconJPEGFile == null) {
            return null;
        }
        BufferedImage image = this.readJPEGFile(srcJPEGFile);
        if (image == null) {
            return null;
        }
        float s = this.getScaleFactor(image, iconWidth);
        AffineTransform transformation = new AffineTransform();
        transformation.scale(s, s);
        AffineTransformOp op = new AffineTransformOp(transformation, 1);
        if (this.iconImage == null) {
            this.iconImage = new BufferedImage(iconWidth, iconWidth, 1);
        }
        op.filter(image, this.iconImage);
        this.writeJPEGFile(this.iconImage, iconJPEGFile);
        return this.iconImage;
    }

    public BufferedImage saveAsResizedCopy(File srcJPEGFile, File destJPEGFile, int maxSide) {
        if (srcJPEGFile == null || destJPEGFile == null) {
            return null;
        }
        BufferedImage image = this.readJPEGFile(srcJPEGFile);
        if (image == null) {
            return null;
        }
        float s = this.getScaleFactor(image, maxSide);
        AffineTransform scaleTransform = new AffineTransform();
        scaleTransform.scale(s, s);
        AffineTransformOp op = new AffineTransformOp(scaleTransform, 1);
        BufferedImage destImage = op.filter(image, null);
        this.writeJPEGFile(destImage, destJPEGFile);
        return destImage;
    }

    public static void printDocAsJPEG(JTextPane pane) {
        BufferedImage bufferedImage = new BufferedImage(100, 100, 5);
        Graphics2D g2 = (Graphics2D)bufferedImage.getGraphics();
        g2.setClip(0, 0, 100, 100);
        g2.translate(0, 0);
        View root = pane.getUI().getRootView(pane);
        PrintView pv = new PrintView(pane.getStyledDocument().getDefaultRootElement(), root, 100, 100);
        pv.paintPage(g2);
        RayFileUtils.writeJPEGFile(bufferedImage, new File(FileUtils.getPWD(), "test.jpg"));
    }

    static class PrintView
    extends BoxView {
        public PrintView(Element elem, View root, int w, int h) {
            super(elem, 1);
            this.setParent(root);
            this.setSize(w, h);
            this.layout(w, h);
        }

        public boolean paintPage(Graphics2D g2) {
            int maxY = this.getHeight();
            Rectangle rc = new Rectangle();
            boolean fillCounter = false;
            int Ytotal = 0;
            for (int k = 1; k < 2; ++k) {
                rc.x = 0;
                rc.y = Ytotal;
                rc.width = this.getSpan(0, k);
                rc.height = this.getSpan(1, k);
                if (Ytotal + this.getSpan(1, k) > maxY) break;
                this.paintChild(g2, rc, k);
                Ytotal += this.getSpan(1, k);
            }
            return true;
        }

        private int getTopOfViewIndex(int pageNumber) {
            int pageHeight = this.getHeight() * pageNumber;
            for (int k = 0; k < this.getViewCount(); ++k) {
                if (this.getOffset(1, k) < pageHeight) continue;
                return k;
            }
            return -1;
        }
    }
}

