/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Utilities.MatrixN;
import Utilities.Vector3D;

public class Matrix3D
extends MatrixN {
    public Matrix3D() {
        super(4);
        this.identity();
    }

    public void rotateX(double theta) {
        Matrix3D tmp = new Matrix3D();
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        tmp.set(1, 1, c);
        tmp.set(1, 2, -s);
        tmp.set(2, 1, s);
        tmp.set(2, 2, c);
        this.preMultiply(tmp);
    }

    public void rotateY(double theta) {
        Matrix3D tmp = new Matrix3D();
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        tmp.set(2, 2, c);
        tmp.set(2, 0, -s);
        tmp.set(0, 2, s);
        tmp.set(0, 0, c);
        this.preMultiply(tmp);
    }

    public void rotateZ(double theta) {
        Matrix3D tmp = new Matrix3D();
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        tmp.set(0, 0, c);
        tmp.set(0, 1, -s);
        tmp.set(1, 0, s);
        tmp.set(1, 1, c);
        this.preMultiply(tmp);
    }

    public void translate(double a, double b, double c) {
        Matrix3D tmp = new Matrix3D();
        this.set(3, 0, a);
        this.set(3, 1, b);
        this.set(3, 2, c);
    }

    void translate(Vector3D v) {
        this.translate(v.get(0), v.get(1), v.get(2));
    }

    void scale(double s) {
        Matrix3D tmp = new Matrix3D();
        tmp.set(0, 0, s);
        tmp.set(1, 1, s);
        tmp.set(2, 2, s);
        this.preMultiply(tmp);
    }

    public void scale(double r, double s, double t) {
        Matrix3D tmp = new Matrix3D();
        tmp.set(0, 0, r);
        tmp.set(1, 1, s);
        tmp.set(2, 2, t);
        this.preMultiply(tmp);
    }

    void scale(Vector3D v) {
        this.scale(v.get(0), v.get(1), v.get(2));
    }
}

