/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Utilities.VectorN;

class MatrixN {
    private VectorN[] v;

    MatrixN(int n) {
        this.v = new VectorN[n];
        for (int i = 0; i < n; ++i) {
            this.v[i] = new VectorN(n);
        }
    }

    int size() {
        return this.v.length;
    }

    double get(int i, int j) {
        return this.get(i).get(j);
    }

    void set(int i, int j, double f) {
        this.v[i].set(j, f);
    }

    VectorN get(int i) {
        return this.v[i];
    }

    void set(int i, VectorN vec) {
        this.v[i].set(vec);
    }

    void set(MatrixN mat) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, mat.get(i));
        }
    }

    public String toString() {
        String s = "";
        String row = "";
        boolean col = false;
        for (int i = 0; i < this.size(); ++i) {
            s = s + (i == 0 ? "" : " ") + this.get(i);
        }
        return s + "";
    }

    void identity() {
        for (int j = 0; j < this.size(); ++j) {
            for (int i = 0; i < this.size(); ++i) {
                this.set(i, j, i == j ? 1 : 0);
            }
        }
    }

    void preMultiply(MatrixN mat) {
        MatrixN tmp = new MatrixN(this.size());
        for (int j = 0; j < this.size(); ++j) {
            for (int i = 0; i < this.size(); ++i) {
                double f = 0.0;
                for (int k = 0; k < this.size(); ++k) {
                    f += mat.get(i, k) * this.get(k, j);
                }
                tmp.set(i, j, f);
            }
        }
        this.set(tmp);
    }

    public void postMultiply(MatrixN mat) {
        MatrixN tmp = new MatrixN(this.size());
        for (int j = 0; j < this.size(); ++j) {
            for (int i = 0; i < this.size(); ++i) {
                double f = 0.0;
                for (int k = 0; k < this.size(); ++k) {
                    f += this.get(i, k) * mat.get(k, j);
                }
                tmp.set(i, j, f);
            }
        }
        this.set(tmp);
    }
}

