/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import Utilities.FileUtils;
import Utilities.HashTableUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MayaMtdUtils {
    private String oslCompilerPath = "";
    private String oslSrcPath = "";
    private String oslShdPath = "";
    private static Hashtable<Integer, File> tableOfSortedMtdFiles = new Hashtable();

    public static int[] getNodeIdsInUse() {
        String arnoldCppShdPath;
        File parentCppShdDir;
        File parentDir;
        String[] names;
        Hashtable<String, File> tableOfMtdFiles = new Hashtable<String, File>();
        String arnoldOslShdPath = Preferences.get(Preferences.PATH_USER_ARNOLD_OSL_SHADERS);
        if (!new File(arnoldOslShdPath).exists()) {
            Cutter.setLog("    Warning: MayaMtdUtils.getNodeIdsInUse() - PATH_USER_ARNOLD_OSL_SHADERS\n        \"" + arnoldOslShdPath + "\" is invalid!");
        }
        if ((names = FileUtils.getListOfFileNames(parentDir = new File(arnoldOslShdPath), ".mtd")) != null) {
            for (int n = 0; n < names.length; ++n) {
                tableOfMtdFiles.put(names[n], parentDir);
            }
        }
        if ((parentCppShdDir = new File(arnoldCppShdPath = Preferences.get(Preferences.PATH_ARNOLD_USER_SHADER_DST))).exists() && (names = FileUtils.getListOfFileNames(parentCppShdDir, ".mtd")) != null) {
            for (int n = 0; n < names.length; ++n) {
                tableOfMtdFiles.put(names[n], parentCppShdDir);
            }
        }
        if ((names = HashTableUtils.getAllKeys_Str_File(tableOfMtdFiles)) == null) {
            Cutter.setLog("    Info: MayaMtdUtils.getNodeIdsInUse() - none found.");
            return null;
        }
        Vector<String> listOfNodeids = new Vector<String>();
        tableOfSortedMtdFiles.clear();
        for (int n = 0; n < names.length; ++n) {
            File parent = tableOfMtdFiles.get(names[n]);
            String[] temp = new String[]{names[n]};
            String text = FileUtils.read(new File(parent, names[n]));
            String[] lines = TextUtils.tokenize(text, '\n');
            if (lines == null) continue;
            for (int i = 0; i < lines.length; ++i) {
                String[] t;
                String line = lines[i].trim();
                if (!line.startsWith("maya.id") || (t = TextUtils.tokenize(line)) == null || t.length != 3 || !NumberUtils.isInteger(t[2])) continue;
                listOfNodeids.add(t[2]);
                Integer _int = Integer.valueOf(t[2]);
                tableOfSortedMtdFiles.put(_int, new File(parent, names[n]));
            }
        }
        String[] unsorted = VectorUtils.toStringArray(listOfNodeids);
        int[] sorted = TextUtils.sortIntsAscending(unsorted);
        return sorted;
    }

    public static String writeReport() {
        StringBuffer buf = new StringBuffer();
        StringBuffer header = new StringBuffer();
        int[] ints = MayaMtdUtils.getNodeIdsInUse();
        if (ints == null) {
            header.append("Cannot find any .mtd files in the Arnold compiled shaders path:\n");
            String shdPath = Preferences.get(Preferences.PATH_USER_ARNOLD_OSL_SHADERS);
            header.append("    \"" + shdPath + "\"");
            return header.toString();
        }
        header.append("--------------------------------------------------------------\n");
        header.append("ARNOLD OSL\n");
        header.append("The nodeids for Arnold OSL shaders are assigned using .mtd files.\n");
        header.append("Shaders and their .mtd files must be in a directory pointed to by\n");
        header.append("the Maya environment variabe ARNOLD_PLUGIN_PATH.\n\n");
        header.append("Nodeid's assigned to the users Arnold shaders:\n");
        Integer[] keys = MayaMtdUtils.getAllKeys(tableOfSortedMtdFiles);
        for (int n = 0; n < keys.length; ++n) {
            int keyAsInt = keys[n];
            File f = tableOfSortedMtdFiles.get(keys[n]);
            if (keyAsInt < 100) {
                buf.append(keyAsInt + ":\t\t\"" + f.getPath() + "\"\n");
                continue;
            }
            buf.append(keyAsInt + ":\t\"" + f.getPath() + "\"\n");
        }
        buf.append("\n");
        header.append(buf);
        header.append("--------------------------------------------------------------\n");
        return header.toString();
    }

    private static Integer[] getAllKeys(Hashtable table) {
        Vector<Integer> list = new Vector<Integer>();
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            list.addElement((Integer)e.nextElement());
        }
        if (list.size() == 0) {
            return null;
        }
        Integer[] out = new Integer[list.size()];
        for (int n = 0; n < out.length; ++n) {
            out[n] = (Integer)list.elementAt(n);
        }
        return out;
    }
}

