/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Args.ArgsNodeIdInfo;
import UI_Script.Osl.OslNodeIdInfo;
import UI_Script.Osl.OslShader;
import UI_Tools.Rman.RenderInfo;
import Utilities.ArgsUtils;
import Utilities.DialogUtils;
import Utilities.MayaMtdUtils;
import Utilities.MayaNodeIdUtilsDB;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MayaNodeIdUtils {
    public static int getMinNodeId() {
        String s = Preferences.get(Preferences.HYPERSHADE_NODE_USER_MIN_ID);
        if (s.trim().length() == 0) {
            return 10;
        }
        return NumberUtils.strToInt(s);
    }

    public static int getMaxNodeId() {
        String s = Preferences.get(Preferences.HYPERSHADE_NODE_USER_MAX_ID);
        return NumberUtils.strToInt(s);
    }

    public static int[] sortNodeIds(int[] arr) {
        if (arr == null) {
            return null;
        }
        Arrays.sort(arr);
        return arr;
    }

    public static void updateUsersMinMax() {
    }

    public static int[] getInvalidNodeIds(int[] in_array) {
        if (in_array == null || in_array.length == 0) {
            return null;
        }
        MayaNodeIdUtils.sortNodeIds(in_array);
        int first = in_array[0];
        int last = in_array[in_array.length - 1];
        MayaNodeIdUtils.updateUsersMinMax();
        if (first >= MayaNodeIdUtils.getMinNodeId() && last <= MayaNodeIdUtils.getMaxNodeId()) {
            return null;
        }
        Vector<Integer> listOfInvalids = new Vector<Integer>();
        for (int n = 0; n < in_array.length; ++n) {
            int val = in_array[n];
            if (val >= MayaNodeIdUtils.getMinNodeId() && val <= MayaNodeIdUtils.getMaxNodeId()) continue;
            listOfInvalids.add(val);
        }
        if (listOfInvalids.size() == 0) {
            return null;
        }
        int[] out = new int[listOfInvalids.size()];
        MayaNodeIdUtils.sortNodeIds(out);
        return out;
    }

    public static String intArrayToStr(int[] arr) {
        if (arr == null) {
            return "Empty array";
        }
        StringBuffer b = new StringBuffer();
        for (int n = 0; n < arr.length; ++n) {
            b.append(arr[n]).append("\n");
        }
        return b.toString();
    }

    public static int getFirstAvailable(int[] arr) {
        MayaNodeIdUtils.updateUsersMinMax();
        if (arr == null || arr.length == 0) {
            Cutter.setLog("    Debug:MayaNodeIdUtils.getFirstAvailable() 1 - returning " + MayaNodeIdUtils.getMinNodeId());
            return MayaNodeIdUtils.getMinNodeId();
        }
        MayaNodeIdUtils.sortNodeIds(arr);
        Hashtable<Integer, Integer> fullRange = new Hashtable<Integer, Integer>();
        int minId = MayaNodeIdUtils.getMinNodeId();
        int maxId = MayaNodeIdUtils.getMaxNodeId();
        Cutter.setLog("    Debug:MayaNodeIdUtils.getFirstAvailable() minId = " + minId + " maxId = " + maxId);
        for (int n = minId; n < maxId; ++n) {
            Integer integer = n;
            fullRange.put(integer, integer);
        }
        for (int k = 0; k < arr.length; ++k) {
            Integer _int;
            int val = arr[k];
            if (val < MayaNodeIdUtils.getMinNodeId() || val > MayaNodeIdUtils.getMaxNodeId() || !fullRange.containsKey(_int = Integer.valueOf(val))) continue;
            fullRange.remove(_int);
        }
        if (fullRange.size() == 0) {
            Cutter.setLog("    Error:MayaNodeIdUtils.getFirstAvailable() 2 - returning -1");
            return -1;
        }
        int[] culledIntRange = new int[fullRange.size()];
        int counter = 0;
        Enumeration e = fullRange.keys();
        while (e.hasMoreElements()) {
            Integer _int = (Integer)e.nextElement();
            culledIntRange[counter++] = _int;
        }
        if (culledIntRange.length == 0) {
            Cutter.setLog("    Error:MayaNodeIdUtils.getFirstAvailable() 3 - returning -1");
            return -1;
        }
        MayaNodeIdUtils.sortNodeIds(culledIntRange);
        return culledIntRange[0];
    }

    public static int[] getAllUsedNodeIds() {
        int[] ints;
        String idStr;
        int n;
        Vector<OslShader> listOfShaders = OslNodeIdInfo.getNodeIdsInUse();
        Vector<String> listOfNodeids = new Vector<String>();
        Vector<File> listOfArgsFiles = ArgsNodeIdInfo.getArgsFilesInUse();
        if (listOfArgsFiles != null) {
            for (n = 0; n < listOfArgsFiles.size(); ++n) {
                idStr = ArgsUtils.getNodeidValue(listOfArgsFiles.elementAt(n));
                if (idStr == null) continue;
                listOfNodeids.add(idStr);
            }
        }
        if (listOfShaders != null) {
            for (n = 0; n < listOfShaders.size(); ++n) {
                idStr = listOfShaders.elementAt(n).getNodeIdStr();
                if (idStr == null) continue;
                listOfNodeids.add(idStr);
            }
        }
        if ((ints = MayaMtdUtils.getNodeIdsInUse()) != null) {
            for (int n2 = 0; n2 < ints.length; ++n2) {
                listOfNodeids.add("" + ints[n2]);
            }
        }
        if (listOfNodeids.size() == 0) {
            Cutter.setLog("    Info:MayaNodeIdUtils.getAllUsedNodeIds() - cannot find any nodeid's in use.");
            return null;
        }
        String[] unsorted = VectorUtils.toStringArray(listOfNodeids);
        int[] sorted = TextUtils.sortIntsAscending(unsorted);
        return sorted;
    }

    public static void writeFullReport() {
        int majorVersion;
        MayaNodeIdUtils.updateUsersMinMax();
        MayaNodeIdUtilsDB mayaNodeDB = new MayaNodeIdUtilsDB();
        Vector<File> listOfArgsFiles = ArgsNodeIdInfo.getArgsFilesInUse();
        StringBuffer argsBuf = new StringBuffer();
        String argNodeIDReport = ArgsNodeIdInfo.writeReport(listOfArgsFiles, mayaNodeDB);
        Vector<OslShader> listOfShaders = OslNodeIdInfo.getNodeIdsInUse();
        String oslNodeIDReport = OslNodeIdInfo.writeReport(listOfShaders, mayaNodeDB);
        String oslArnoldIDReport = MayaMtdUtils.writeReport();
        if (argNodeIDReport == null && oslNodeIDReport == null && oslArnoldIDReport == null) {
            String[] msg = new String[]{"No User \"nodeid's\" are currently registered.\n"};
            DialogUtils.showInfoMessage("Nothing To Report", msg);
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Users nodeids are in the range\n");
        buf.append("    Minimum: " + MayaNodeIdUtils.getMinNodeId() + "\n");
        buf.append("    Maximum: " + MayaNodeIdUtils.getMaxNodeId() + "\n");
        buf.append("The Min and Maximum are set in the Prefernces->Rman->User tab.\n");
        if (argNodeIDReport != null) {
            buf.append(argNodeIDReport).append("\n");
        }
        if ((majorVersion = RenderInfo.prmanMajorVersionNumber()) >= 21) {
            buf.append(oslNodeIDReport);
            buf.append(oslArnoldIDReport);
        }
        buf.append(mayaNodeDB.getDuplicateIds());
        BBxt.newDocument("Registered \"nodeid's\"", buf);
    }
}

