/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MayaNodeIdUtilsDB {
    public String errorMsg = null;
    private Vector<MayaNodeIdItem> items = new Vector();

    public String toString() {
        if (this.errorMsg != null) {
            return this.errorMsg;
        }
        StringBuffer b = new StringBuffer();
        for (int n = 0; n < this.items.size(); ++n) {
            MayaNodeIdItem item = this.items.elementAt(n);
            b.append(item.idStr).append(" : ").append(item.dir).append("/").append(item.name).append("\n");
        }
        return b.toString();
    }

    public void addItem(int idInt, String nodeName, String parentDir) {
        MayaNodeIdItem item = new MayaNodeIdItem();
        item.idStr = "" + idInt;
        item.idInt = idInt;
        item.name = nodeName;
        item.fullpath = parentDir;
        item.dir = new File(parentDir).getName();
        this.items.add(item);
    }

    public void addItem(String idIntStr, String nodeName, String parentDir) {
        MayaNodeIdItem item = new MayaNodeIdItem();
        item.idStr = "" + idIntStr;
        try {
            item.idInt = Integer.parseInt(idIntStr.trim());
        }
        catch (Exception e) {
            Cutter.setLog("   Error:MayaNodeIdDB Args file for " + nodeName + "uses non-integer id of " + idIntStr);
        }
        item.name = nodeName;
        item.fullpath = parentDir;
        item.dir = new File(parentDir).getName();
        this.items.add(item);
    }

    public String getDuplicateIds() {
        MayaNodeIdItem node;
        int n;
        Vector<MayaNodeIdItem> duplicates = new Vector<MayaNodeIdItem>();
        Vector<MayaNodeIdItem> possibleDuplicates = new Vector<MayaNodeIdItem>();
        Vector<String> nodeIds = new Vector<String>();
        for (n = 0; n < this.items.size(); ++n) {
            nodeIds.add(this.items.elementAt((int)n).idStr);
        }
        for (n = 0; n < nodeIds.size(); ++n) {
            possibleDuplicates.clear();
            for (int i = 0; i < this.items.size(); ++i) {
                node = this.items.elementAt(i);
                if (!((String)nodeIds.elementAt(n)).equals(node.idStr)) continue;
                possibleDuplicates.add(node);
            }
            if (possibleDuplicates.size() <= 1) continue;
            for (int j = 0; j < possibleDuplicates.size(); ++j) {
                duplicates.add((MayaNodeIdItem)possibleDuplicates.elementAt(j));
            }
        }
        StringBuffer out = new StringBuffer();
        if (duplicates.size() > 0) {
            out.append("Error: The following nodeids are being used more than once:\n");
            Hashtable<MayaNodeIdItem, MayaNodeIdItem> table = new Hashtable<MayaNodeIdItem, MayaNodeIdItem>();
            for (int n2 = 0; n2 < duplicates.size(); ++n2) {
                node = (MayaNodeIdItem)duplicates.elementAt(n2);
                table.put(node, node);
            }
            Vector<MayaNodeIdItem> cleaned = new Vector<MayaNodeIdItem>();
            Enumeration e = table.keys();
            while (e.hasMoreElements()) {
                cleaned.addElement((MayaNodeIdItem)e.nextElement());
            }
            if (cleaned.size() > 0) {
                for (int n3 = 0; n3 < cleaned.size(); ++n3) {
                    out.append("\t").append(((MayaNodeIdItem)cleaned.elementAt(n3)).toString());
                }
                out.append("duplicate nodeids must be resolved manually.\n\n");
            }
            return out.toString();
        }
        return "";
    }

    public class MayaNodeIdItem {
        public String idStr = "-1";
        public int idInt = -1;
        public String name = "";
        public String dir = "";
        public String fullpath = "";

        public String toString() {
            return this.idStr + " : " + this.dir + "/" + this.name + "\n";
        }
    }
}

