/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Components.KMenu;
import UI_CutletScript.receive.CmdHandlers.CmdHandler;
import UI_CutletScript.receive.CmdHandlers.PointRunner;
import UI_Desktop.Cutter;
import Utilities.RegExpUtils;
import Utilities.RobotUtils;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class MenuUtils {
    public static boolean isAltCntrMetaKeyDown(ActionEvent evt) {
        int mod = evt.getModifiers();
        return (mod & 8) != 0 || (mod & 2) != 0 || (mod & 4) != 0;
    }

    public static boolean isShiftKeyDown(ActionEvent evt) {
        int mod = evt.getModifiers();
        return (mod & 1) != 0;
    }

    public static JMenuItem[] toMenuItemArray(Vector v) {
        if (v == null || v.size() == 0) {
            return null;
        }
        JMenuItem[] out = new JMenuItem[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (JMenuItem)v.elementAt(n);
        }
        return out;
    }

    public static JMenuItem getMenuWithName(Component comp, String name) {
        JMenuItem mi;
        Component c;
        int n;
        int count;
        if (comp == null || name == null) {
            return null;
        }
        if (comp instanceof JMenuItem && RegExpUtils.contains(((JMenuItem)comp).getText(), name)) {
            return (JMenuItem)comp;
        }
        if (comp instanceof JInternalFrame) {
            JMenuBar mb = ((JInternalFrame)comp).getJMenuBar();
            return MenuUtils.getMenuWithName(mb, name);
        }
        if (comp instanceof JMenu) {
            count = ((JMenu)comp).getItemCount();
            for (n = 0; n < count; ++n) {
                c = ((JMenu)comp).getMenuComponent(n);
                if (c == null || c instanceof JSeparator || (mi = MenuUtils.getMenuWithName(c, name)) == null) continue;
                return mi;
            }
        }
        if (comp instanceof Container) {
            count = ((Container)comp).getComponentCount();
            for (n = 0; n < count; ++n) {
                c = ((Container)comp).getComponent(n);
                if (c == null || c instanceof JSeparator || (mi = MenuUtils.getMenuWithName(c, name)) == null) continue;
                return mi;
            }
        }
        return null;
    }

    public static void doMouseEventOn(JMenuItem jm, int mode) {
        MenuUtils.doMouseEventOn(jm, 0, mode);
    }

    public static void doMouseEventOn(final JMenuItem jm, final int modifiers, final int mode) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jm.getComponent().dispatchEvent(new MouseEvent(jm.getComponent(), mode, System.currentTimeMillis(), modifiers, 2, 15, 1, false));
                }
            });
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: MenuCmdsHandler.doMouseEventOn()\n\t" + e.toString());
        }
    }

    public static void pressOnMenusInList(Vector list) {
        JMenuItem menuItem = null;
        for (int n = 0; n < list.size(); ++n) {
            menuItem = (JMenuItem)list.elementAt(n);
            MenuUtils.doMouseEventOn(menuItem, 501);
            MenuUtils.doMouseEventOn(menuItem, 506);
            menuItem.setSelected(true);
        }
    }

    public static void doMouseEventOnMenusInList(Vector list, int modifiers, int mode) {
        JMenuItem menuItem = null;
        for (int n = 0; n < list.size(); ++n) {
            menuItem = (JMenuItem)list.elementAt(n);
            MenuUtils.doMouseEventOn(menuItem, modifiers, mode);
        }
    }

    public static void clickOnMenusInList(Vector list, JComponent parent) {
        if (parent == null) {
            return;
        }
        int x = 0;
        int y = 0;
        Rectangle r = parent.getBounds();
        x = r.x;
        y = r.y;
        for (int n = 0; n < list.size(); ++n) {
            JMenuItem menuItem = (JMenuItem)list.elementAt(n);
            Point pnt = SwingUtilities.convertPoint(menuItem, 0, 0, Cutter.desktop);
            RobotUtils.clickRobotAt(new Point(pnt.x + 10, pnt.y + 10), 200);
            if (!(menuItem instanceof JMenu)) continue;
            CmdHandler.sleep(500);
        }
    }

    public static void clickOnMenu(JMenuItem menuItem, int modifiers) {
        if (menuItem == null) {
            return;
        }
        MenuUtils.doMouseEventOn(menuItem, modifiers, 501);
        MenuUtils.doMouseEventOn(menuItem, modifiers, 502);
        MenuUtils.doMouseEventOn(menuItem, modifiers, 500);
        MenuUtils.doMouseEventOn(menuItem, modifiers, 506);
        menuItem.setSelected(true);
    }

    public static Point[] _getLocalOriginsOf(final JMenuItem[] items) {
        PointRunner runner = new PointRunner(){

            @Override
            public void run() {
                int x = 0;
                int y = 0;
                Vector<Point> list = new Vector<Point>();
                for (int n = items.length - 1; n >= 0; --n) {
                    if (items[n] instanceof KMenu && n != items.length - 1) {
                        Point pp = ((KMenu)items[n]).getOrigin();
                        if (pp == null) {
                            return;
                        }
                        x += pp.x;
                        y += pp.y;
                    } else {
                        Rectangle rect = items[n].getBounds();
                        x += rect.x;
                        y += rect.y;
                    }
                    list.addElement(new Point(x, y));
                }
                this.pnts = new Point[list.size()];
                for (int i = 0; i < this.pnts.length; ++i) {
                    this.pnts[i] = (Point)list.elementAt(i);
                }
            }
        };
        CmdHandler.invokeAndWait(runner);
        return runner.pnts;
    }

    public static Vector<JMenuItem> sortMenuItemsByAlpha(Vector<JMenuItem> listOfItems) {
        Hashtable<String, JMenuItem> table = new Hashtable<String, JMenuItem>();
        for (int n = 0; n < listOfItems.size(); ++n) {
            JMenuItem item = listOfItems.elementAt(n);
            String key = item.getText();
            table.put(key, item);
        }
        String[] keys = new String[table.size()];
        Enumeration e = table.keys();
        int n = 0;
        while (e.hasMoreElements()) {
            keys[n] = (String)e.nextElement();
            ++n;
        }
        keys = TextUtils.sortByAlpha(keys);
        Vector<JMenuItem> out = new Vector<JMenuItem>();
        for (n = 0; n < keys.length; ++n) {
            out.addElement((JMenuItem)table.get(keys[n]));
        }
        return out;
    }

    public static boolean itemIsValid(JMenuItem item) {
        if (item == null) {
            return false;
        }
        File f = new File(item.getText());
        return f.exists();
    }
}

