/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Processes.ProcessManager;
import UI_Desktop.Cutter;
import UI_Tools.Rman.RenderInfo;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Vector;

public class MultiRibUtils {
    public static final String CUTR_TEMP_RIBS_NAME = "Cutter_Keyframing";
    public static final File ribsDir = new File(FileUtils.getPWD(), "Cutter_Keyframing");
    public static final String DEFAULT_BATCH_RENDER_NAME = "batch_render";
    public static final String DEFAULT_WIN_BATCH_RENDER_NAME = "batch_render.bat";
    StringBuffer options = new StringBuffer();
    StringBuffer camera = new StringBuffer();
    StringBuffer other = new StringBuffer();
    StringBuffer frame = new StringBuffer();

    public File[] multiFrameRib2MultiRibs(StringBuffer srcBuff, boolean deferRender) {
        if (!ribsDir.exists()) {
            ribsDir.mkdir();
        }
        this.options.setLength(0);
        this.camera.setLength(0);
        this.other.setLength(0);
        this.frame.setLength(0);
        Vector<File> listOfRibs = new Vector<File>();
        LineNumberReader lnr = new LineNumberReader(new StringReader(srcBuff.toString()));
        try {
            String line = lnr.readLine();
            while (line != null && !line.trim().startsWith("FrameBegin")) {
                if (line.startsWith("Option") || line.startsWith("Hider") || line.startsWith("PixelFilter") || line.startsWith("PixelVariance") || line.startsWith("Integrator")) {
                    this.options.append("\t").append(line).append("\n");
                } else if (line.startsWith("IfBegin")) {
                    while (!line.startsWith("IfEnd")) {
                        this.options.append("\t").append(line).append("\n");
                        line = lnr.readLine();
                    }
                    this.options.append("\t").append(line).append("\n");
                } else if (line.startsWith("Format")) {
                    this.camera.append("\t").append(line).append("\n");
                } else if (line.length() != 0 && !line.trim().startsWith("#")) {
                    this.other.append("\t").append(line).append("\n");
                }
                line = lnr.readLine();
            }
            if (line == null) {
                return null;
            }
            int count = 1;
            int tabs = 0;
            String tabStr = "";
            String fname = null;
            while (line != null) {
                tabs = 1;
                tabStr = "\t";
                while (line != null && !line.startsWith("FrameEnd")) {
                    if (line.startsWith("TransformEnd") || line.startsWith("AttributeEnd")) {
                        tabStr = TextUtils.getTabString(--tabs);
                    }
                    if (line.startsWith("FrameBegin")) {
                        this.frame.append(line).append("\n");
                        this.frame.append(this.options.toString());
                    } else if (line.startsWith("Projection")) {
                        this.frame.append(this.camera.toString());
                        this.frame.append("\t").append(line).append("\n");
                        this.frame.append(this.other.toString());
                    } else if (line.startsWith("WorldBegin") || line.startsWith("TransformBegin") || line.startsWith("AttributeBegin")) {
                        this.frame.append(tabStr).append(line.toString()).append("\n");
                        tabStr = TextUtils.getTabString(++tabs);
                    } else if (line.startsWith("WorldEnd")) {
                        this.frame.append("\tWorldEnd\n");
                    } else {
                        this.frame.append(tabStr).append(line.toString()).append("\n");
                    }
                    if (fname == null && line.startsWith("Display")) {
                        fname = MultiRibUtils.getImageName(line);
                    }
                    line = lnr.readLine();
                }
                this.frame.append("FrameEnd\n");
                if (fname == null) {
                    fname = "untitled";
                }
                String outname = fname;
                outname = count < 10 ? outname + ".000" + count + ".rib" : (count < 100 ? outname + ".00" + count + ".rib" : (count < 1000 ? outname + ".0" + count + ".rib" : outname + "." + count + ".rib"));
                File f = new File(ribsDir, outname);
                listOfRibs.addElement(f);
                FileUtils.writeFile(f, this.frame.toString());
                this.frame.setLength(0);
                ++count;
                line = lnr.readLine();
            }
        }
        catch (IOException ex) {
            return null;
        }
        return VectorUtils.toFileArray(listOfRibs);
    }

    public static String getImageName(String displayStatement) {
        int firstDot;
        if (!displayStatement.trim().startsWith("Display")) {
            return null;
        }
        String[] tokens = TextUtils.tokenize(displayStatement, "\"[]");
        if (tokens == null || tokens.length < 2) {
            return null;
        }
        String imageName = tokens[1].replace('\\', '/');
        int lastSlash = imageName.lastIndexOf(47);
        if (lastSlash != -1) {
            imageName = imageName.substring(lastSlash + 1);
        }
        if ((firstDot = imageName.indexOf(46)) != -1) {
            imageName = imageName.substring(0, firstDot);
        }
        if (Cutter.input.debug) {
            Cutter.setLog("    Debug:MultiRibUtils.getImageName() returning >" + imageName + "<");
        }
        return imageName;
    }

    public static File makeBatchRenderFile(String cmd, File[] files, File scriptDir, String scriptName) {
        if (files == null || files.length == 0 || !scriptDir.exists()) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        Vector<String> listOfAllFlags = RenderInfo.getAllFlags(10);
        String flagsStr = VectorUtils.toSpacedString(listOfAllFlags);
        for (int n = 0; n < files.length; ++n) {
            buff.append(cmd + " " + flagsStr + " ").append(files[n].getPath()).append("\n");
        }
        scriptName = files[0].getName();
        scriptName = scriptName.substring(0, scriptName.indexOf(46));
        scriptName = EnvUtils.isWinEnvironment() ? "batch_" + scriptName + ".bat" : "batch_" + scriptName;
        File out = new File(scriptDir, scriptName);
        Cutter.setLog("    Info:MultiRibUtils.makeBatchRenderFile() - created \"" + out.getPath() + "\"");
        FileUtils.writeFile(out, buff.toString());
        if (!EnvUtils.isWinEnvironment()) {
            String[] items = new String[]{"chmod", "777", out.getPath()};
            ProcessManager pm = new ProcessManager("chmod 777 \"" + out.getPath() + "\"");
            pm.launch(items, null, false, null, true);
        }
        return out;
    }

    public static void renderBatch(File script) {
        String[] items = new String[]{script.getPath()};
        ProcessManager pm = new ProcessManager("RIB Renderer");
        pm.ignoreStdOutStream();
        pm.launch(items, null, false, null, false);
    }
}

