/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import java.awt.Color;

public class NumberUtils {
    public static int decimalPlaces = 3;
    public static final double precision = 0.001;

    public static String clip(double value, int places) {
        StringBuffer raw = new StringBuffer(value + "0000000000000");
        int dot = 0;
        for (int n = 0; n < raw.length(); ++n) {
            if (raw.charAt(n) != '.') continue;
            dot = n + 1;
            break;
        }
        if (raw.length() > dot + places) {
            raw.setLength(dot + places);
        }
        return raw.toString();
    }

    public static String clip(double value) {
        StringBuffer raw = new StringBuffer("" + value);
        int dot = 0;
        for (int n = 0; n < raw.length(); ++n) {
            if (raw.charAt(n) != '.') continue;
            dot = n + 1;
            break;
        }
        if (raw.length() > dot + decimalPlaces) {
            raw.setLength(dot + decimalPlaces);
        }
        return raw.toString();
    }

    public static String clip(String value) {
        int n;
        boolean hasTrailingZero = false;
        value = value.trim();
        for (n = value.length() - 1; n >= 0 && value.charAt(n) == '0'; --n) {
            hasTrailingZero = true;
        }
        if (hasTrailingZero) {
            return value.substring(0, n + 2);
        }
        return value;
    }

    public static double strToDouble(String str) throws NumberFormatException {
        Double d = Double.valueOf(str);
        return d;
    }

    public static float strToFloat(String str) throws NumberFormatException {
        Float f = Float.valueOf(str);
        return f.floatValue();
    }

    public static int strToInt(String str) throws NumberFormatException {
        Integer integer = Integer.valueOf(str);
        return integer;
    }

    public static int strToInt(String str, int deflt) {
        try {
            int val = NumberUtils.strToInt(str);
            return val;
        }
        catch (NumberFormatException nfe) {
            return deflt;
        }
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static String doubleToIntStr(double d) {
        d = Math.floor(d);
        String str = "" + d;
        int dot = str.indexOf(46);
        return dot == -1 ? str : str.substring(0, dot);
    }

    public static int isPaddedIntStr(String input) {
        if (input == null || input.trim().length() == 0) {
            return -1;
        }
        input = input.trim();
        for (int n = 0; n < input.length(); ++n) {
            if (Character.isDigit(input.charAt(n))) continue;
            return -1;
        }
        return input.length();
    }

    public static int getIntFromPaddedStr(String input) {
        return Integer.parseInt(input);
    }

    public static String intToPaddedStr(String intStr, int padding) {
        int n;
        String prefix = "";
        for (n = 0; n < padding; ++n) {
            prefix = prefix + "0";
        }
        if (prefix.length() < intStr.length()) {
            Cutter.setLog("    Warning:NumberUtils.intToPaddedStr() - the integer value\n            has more digits than the requested padding length!!");
            prefix = "";
            for (n = 0; n < intStr.length(); ++n) {
                prefix = prefix + "0";
            }
        }
        return prefix.substring(intStr.length()) + intStr;
    }

    public static String intToPaddedStr(int value, int padding) {
        String prefix = "";
        for (int n = 0; n < padding; ++n) {
            prefix = prefix + "0";
        }
        String intStr = value + "";
        if (prefix.length() < intStr.length()) {
            Cutter.setLog("    Warning:NumberUtils.intToPaddedStr() - the integer value\n            has more digits than the requested padding length!!");
            prefix = "";
            for (int n = 0; n < intStr.length(); ++n) {
                prefix = prefix + "0";
            }
        }
        return prefix.substring(intStr.length()) + intStr;
    }

    public static int byteArrayToInt(byte[] b) {
        if (b == null || b.length == 0) {
            return 0;
        }
        return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }

    public static String convertToHex(Color color) {
        if (color == null) {
            return "";
        }
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        red = red.length() == 1 ? "0" + red : red;
        green = green.length() == 1 ? "0" + green : green;
        blue = blue.length() == 1 ? "0" + blue : blue;
        StringBuffer buf = new StringBuffer();
        buf.append("#").append(red).append(green).append(blue);
        return buf.toString();
    }
}

