/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.KTools;
import UI_Tools.Preferences.PrefsTool;
import Utilities.DialogUtils;
import Utilities.DocumentUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.FinderUtils;
import java.io.File;
import javax.swing.text.Document;

public class OslUtils {
    public static boolean envIsPRMan() {
        return Preferences.get(Preferences.OSL_COMPILE_KEYBOARD_SHORTCUT).equalsIgnoreCase("PRMAN");
    }

    public static boolean envIsArnold() {
        return Preferences.get(Preferences.OSL_COMPILE_KEYBOARD_SHORTCUT).equalsIgnoreCase("ARNOLD");
    }

    public static OslTokenizer.ShdTypeName getShaderTypeAndName(File srcFile) {
        String s = FileUtils.read(srcFile);
        if (s == null) {
            Cutter.setLog("    Error:OslUtils.getShaderTypeAndName()\n         \"" + srcFile.getPath() + "\" \n         has no text!");
            return null;
        }
        OslTokenizer tok = new OslTokenizer();
        tok.setBuffer(s);
        OslTokenizer.ShdTypeName stn = tok.getShaderTypeOffsets();
        if (stn == null) {
            Cutter.setLog("    Error:OslCompileManager.doCompile()\n         \"" + srcFile.getPath() + "\" \n         cannot determine the shader type and name!");
            return null;
        }
        return stn;
    }

    public static boolean rmanIsAvailable() {
        String binPath = Preferences.get(Preferences.PATH_OSL_COMPILER_BIN);
        File f = new File(binPath);
        if (f.exists()) {
            return true;
        }
        String rpsRoot = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        f = new File(rpsRoot, "bin");
        return f.exists();
    }

    public static boolean arnoldIsAvailable() {
        String binPath = Preferences.get(Preferences.PATH_ARNOLD_BIN);
        String oslcName = EnvUtils.isWinEnvironment() ? "oslc.exe" : "oslc";
        File f = new File(binPath, oslcName);
        return f.exists();
    }

    public static String getArnoldBin() {
        if (!OslUtils.arnoldIsAvailable()) {
            return null;
        }
        File f = new File(Preferences.get(Preferences.PATH_ARNOLD_BIN));
        if (f.exists()) {
            return f.getPath();
        }
        return null;
    }

    public static String getRmanBin() {
        if (!OslUtils.rmanIsAvailable()) {
            return null;
        }
        File f = new File(Preferences.get(Preferences.PATH_OSL_COMPILER_BIN));
        if (f.exists()) {
            return f.getPath();
        }
        f = new File(Preferences.get(Preferences.PATH_PIXAR_PROSERVER), "bin");
        if (f.exists()) {
            return f.getPath();
        }
        return null;
    }

    public static String getAnyBin() {
        if (OslUtils.arnoldIsAvailable()) {
            return OslUtils.getArnoldBin();
        }
        if (OslUtils.rmanIsAvailable()) {
            return OslUtils.getRmanBin();
        }
        Cutter.setLog("    Error: OslUtils.getAnyBin() - cannot find Arnold or Rman!");
        return null;
    }

    public static void showRmanNoBinMsg() {
        PrefsTool.init();
        KTools tool = KTools.getToolWithName("Preferences Tool");
        if (tool != null && tool instanceof PrefsTool) {
            PrefsTool prefsTool = (PrefsTool)tool;
            prefsTool.setVisible(true);
            prefsTool.selectPanel(PrefsTool.rmanTab, "pixar panel");
            String[] msg = new String[]{"The paths to,", "    RPS root (\"RenderManProServer\")", "    RfM root (\"RenderManForMaya\")", "must be set in Preferences.   "};
            DialogUtils.showInfoMessage("Pixar Paths Not Set", msg);
        }
    }

    public static void showArnoldNoBinMsg() {
        PrefsTool.init();
        KTools tool = KTools.getToolWithName("Preferences Tool");
        if (tool != null && tool instanceof PrefsTool) {
            PrefsTool prefsTool = (PrefsTool)tool;
            prefsTool.setVisible(true);
            prefsTool.selectPanel(PrefsTool.languagesTab, "osl panel");
            String[] msg = new String[]{"The path to the Arnold bin directory must be set. ", "For example, on Windows:", "    C:/solidangle/mtoadeploy/2018/bin", "or,", "    C:/Program Files/maya/arnold/bin"};
            DialogUtils.showInfoMessage("Arnold Bin Path Not Set", msg);
        }
    }

    public static void showRmanNoShaderPathMsg() {
        PrefsTool.init();
        KTools tool = KTools.getToolWithName("Preferences Tool");
        if (tool != null && tool instanceof PrefsTool) {
            PrefsTool prefsTool = (PrefsTool)tool;
            prefsTool.setVisible(true);
            prefsTool.selectPanel(PrefsTool.languagesTab, "osl panel");
            String[] msg = new String[]{"A path to the users Pixar shaders directory must ", "be set.\n"};
            DialogUtils.showInfoMessage("Pixar User Shaders Path Not Set", msg);
        }
    }

    public static void showArnoldNoShaderPathMsg() {
        PrefsTool.init();
        KTools tool = KTools.getToolWithName("Preferences Tool");
        if (tool != null && tool instanceof PrefsTool) {
            PrefsTool prefsTool = (PrefsTool)tool;
            prefsTool.setVisible(true);
            prefsTool.selectPanel(PrefsTool.languagesTab, "osl panel");
            String[] msg = new String[]{"A path to the users Arnold shaders directory must ", "be set. Make sure the Maya.env file has set the ", "following environment variable to the same path.", "For example,\n", "ARNOLD_PLUGIN_PATH=path_to_your_custom_shaders\n"};
            DialogUtils.showInfoMessage("Arnold User Shaders Path Not Set", msg);
        }
    }

    public static void showShaderTypeNameErrorMsg(File srcFile) {
        Cutter.setLog("    Error:OslCompileManager.doCompile()\n         \"" + srcFile.getPath() + "\" \n         cannot determine the shader type and name!");
    }

    public static void adjustDefine(File srcFile, String processName) {
        String replacement;
        File frontWindow = BBxt.getFrontWindowFile();
        if (frontWindow == null) {
            Cutter.setLog("    Error:OslCompilerManager.adjustDefine() - BBxt.getFrontWindowFile() returned null!");
            return;
        }
        if (!srcFile.getPath().equals(frontWindow.getPath())) {
            Cutter.setLog("    Error:OslCompilerManager.adjustDefine() - BBxt.getFrontWindowFile() does not match srcFile!");
            return;
        }
        String text = BBxt.getWindowText();
        if (text == null || text.trim().length() == 0) {
            Cutter.setLog("    Error:OslCompilerManager.adjustDefine() - BBxt.getWindowText() returned null!");
            return;
        }
        KTextPane textpane = (KTextPane)BBxt.getTextPane();
        Document document = textpane.getDocument();
        boolean doFind = true;
        int beginAt = 0;
        int define_arnold_line = -1;
        int define_prman_line = -1;
        boolean doIgnoreCase = false;
        boolean doWholeWord = true;
        int[] arnoldResult = null;
        int[] prmanResult = null;
        FinderUtils.FindDB db = FinderUtils.find(text, "#define ARNOLD", beginAt, doIgnoreCase, doWholeWord);
        if (db.absBegin != -1 && db.absEnd != -1) {
            arnoldResult = DocumentUtils.getLineNumberAt(document, db.absEnd);
        }
        db = FinderUtils.find(text, "#define PRMAN", beginAt, doIgnoreCase, doWholeWord);
        if (db.absBegin != -1 && db.absEnd != -1) {
            prmanResult = DocumentUtils.getLineNumberAt(document, db.absEnd);
        }
        if (arnoldResult != null) {
            replacement = processName.equals("Arnold OSL Compile") ? "#define ARNOLD 1" : "#define ARNOLD 0";
            textpane.setSelectionStart(arnoldResult[1]);
            textpane.setSelectionEnd(arnoldResult[2] - 1);
            textpane.replaceSelection(replacement);
        }
        if (prmanResult != null) {
            replacement = processName.equals("PRMan OSL Compile") ? "#define PRMAN 1" : "#define PRMAN 0";
            textpane.setSelectionStart(prmanResult[1]);
            textpane.setSelectionEnd(prmanResult[2] - 1);
            textpane.replaceSelection(replacement);
        }
        BBxt.save();
    }
}

