/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Script.Args.ArgsTokenizer;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Vector;

public class PluginArgsUtils {
    public static File logfile = null;
    static int logcount = 1;

    public static String[] conformParamTags(String[] lines) {
        Vector<String> v = new Vector<String>();
        for (int j = 0; j < lines.length; ++j) {
            v.add(lines[j]);
            String[] currTokens = TextUtils.tokenize(lines[j], "<>");
            String[] nextTokens = null;
            if (j + 1 < lines.length - 1) {
                nextTokens = TextUtils.tokenize(lines[j + 1], "<>");
            }
            if (currTokens.length <= 0 || !currTokens[0].startsWith("param") || nextTokens == null || nextTokens.length <= 0 || nextTokens[0].startsWith("tags") || nextTokens[0].startsWith("/param")) continue;
            v.add("</param>");
        }
        lines = VectorUtils.toStringArray(v);
        boolean isValid = false;
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n];
            if (!line.startsWith("<") || !line.substring(1).startsWith("param")) continue;
            isValid = true;
        }
        if (isValid) {
            return lines;
        }
        return null;
    }

    public static String[] conformOutputTags(String[] lines) {
        Vector<String> v = new Vector<String>();
        for (int j = 0; j < lines.length; ++j) {
            v.add(lines[j]);
            String[] currTokens = TextUtils.tokenize(lines[j], "<>");
            String[] nextTokens = null;
            if (j + 1 < lines.length - 1) {
                nextTokens = TextUtils.tokenize(lines[j + 1], "<>");
            }
            if (currTokens.length <= 0 || !currTokens[0].startsWith("output") || nextTokens == null || nextTokens.length <= 0 || nextTokens[0].startsWith("tags") || nextTokens[0].startsWith("/output")) continue;
            v.add("</output>");
        }
        lines = VectorUtils.toStringArray(v);
        return lines;
    }

    public static String[] conformHelpTags(String[] lines) {
        int j;
        Vector<String> v = new Vector<String>();
        String helpStr = "";
        int helpBegin = -1;
        int helpEnd = -1;
        for (int j2 = 0; j2 < lines.length; ++j2) {
            String[] currTokens = TextUtils.tokenize(lines[j2], "<>");
            if (currTokens.length > 0 && currTokens[0].startsWith("help")) {
                helpBegin = j2;
            }
            if (currTokens.length > 0 && currTokens[0].startsWith("/help")) {
                helpEnd = j2;
            }
            if (helpBegin != -1 && helpEnd != -1) break;
        }
        if (helpBegin == helpEnd) {
            return lines;
        }
        if (helpBegin == -1 && helpEnd == -1) {
            return lines;
        }
        StringBuffer buf = new StringBuffer();
        String line = lines[helpBegin].trim();
        int offset = line.indexOf(62);
        if (offset != -1 && offset + 1 != line.length()) {
            line = line.substring(offset + 1);
            buf.append(line + " ");
        }
        for (int n = helpBegin + 1; n < helpEnd; ++n) {
            line = lines[n].trim();
            buf.append(line + " ");
        }
        line = lines[helpEnd].trim();
        offset = line.indexOf(60);
        if (offset != -1) {
            line = line.substring(0, offset).trim();
            buf.append(line + " ");
        }
        String assembledHelp = "<_help>" + buf.toString().trim() + "</help_>";
        for (j = 0; j < helpBegin; ++j) {
            v.add(lines[j]);
        }
        v.add(assembledHelp);
        for (j = helpEnd + 1; j < lines.length; ++j) {
            v.add(lines[j]);
        }
        lines = VectorUtils.toStringArray(v);
        return lines;
    }

    public static String[] convertInfoToHelpTags(String[] lines) {
        int j;
        Vector<String> v = new Vector<String>();
        String helpStr = "";
        int helpBegin = -1;
        int helpEnd = -1;
        for (int j2 = 0; j2 < lines.length; ++j2) {
            String[] currTokens = TextUtils.tokenize(lines[j2], "<>");
            if (currTokens.length > 0 && currTokens[0].startsWith("info")) {
                helpBegin = j2;
            }
            if (currTokens.length > 0 && currTokens[0].startsWith("/info")) {
                helpEnd = j2;
            }
            if (helpBegin != -1 && helpEnd != -1) break;
        }
        if (helpBegin == helpEnd) {
            return lines;
        }
        if (helpBegin == -1 && helpEnd == -1) {
            return lines;
        }
        StringBuffer buf = new StringBuffer();
        String line = lines[helpBegin].trim();
        int offset = line.indexOf(62);
        if (offset != -1 && offset + 1 != line.length()) {
            line = line.substring(offset + 1);
            buf.append(line + " ");
        }
        for (int n = helpBegin + 1; n < helpEnd; ++n) {
            line = lines[n].trim();
            buf.append(line + " ");
        }
        line = lines[helpEnd].trim();
        offset = line.indexOf(60);
        if (offset != -1) {
            line = line.substring(0, offset).trim();
            buf.append(line + " ");
        }
        String assembledHelp = "<_help>" + buf.toString().trim() + "</help_>";
        for (j = 0; j < helpBegin; ++j) {
            v.add(lines[j]);
        }
        v.add(assembledHelp);
        for (j = helpEnd + 1; j < lines.length; ++j) {
            v.add(lines[j]);
        }
        lines = VectorUtils.toStringArray(v);
        return lines;
    }

    public static String[] convertTagsToLines(String script) {
        ArgsTokenizer tok = new ArgsTokenizer();
        tok.setDefaultDelimitors();
        tok.setBuffer(script);
        String s = tok.getNextStr();
        Vector<String> lines = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        while (!s.equals("")) {
            String[] parts;
            if (TextUtils.contains(s, '\n') && (parts = TextUtils.tokenize(s, '\n')) != null) {
                buf.setLength(0);
                for (int n = 0; n < parts.length; ++n) {
                    buf.append(parts[n].trim()).append(" ");
                }
                s = buf.toString();
            }
            lines.add(s);
            s = tok.getNextStr();
        }
        return VectorUtils.toStringArray(lines);
    }
}

