/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import Utilities.DialogUtils;
import Utilities.TextUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExpUtils {
    static final String SPACE = "[\\s]*";
    static final String REQUIRED_SPACE = "[\\s]+";
    static final String OPTIONAL_SPACE = "[\\s]*";
    static final String REMAINDER = "((.)*)";
    static final String EQUALS = "[\\s]*=+[\\s]*";
    static final String ARG_NAME = "[\\s]*([_0-9\\w]+)+[\\s]*";
    static final String OPEN_B = "[\\s]*(\\[)[\\s]*";
    static final String CLOSE_B = "[\\s]*(\\])[\\s]*";
    static final String INTEGER = "[\\s]*(-?[0-9]+)[\\s]*";
    static final String DOUBLE = "[\\s]*(-?[0-9]+[e][0-9]+|-?[0-9]+\\.[0-9]*|-?\\.[0-9]+|(-?[0-9]+))[\\s]*";
    static final String TRIPLET = "[\\s]*(-?[0-9]+[e][0-9]+|-?[0-9]+\\.[0-9]*|-?\\.[0-9]+|(-?[0-9]+))[\\s]*,[\\s]*(-?[0-9]+[e][0-9]+|-?[0-9]+\\.[0-9]*|-?\\.[0-9]+|(-?[0-9]+))[\\s]*,[\\s]*(-?[0-9]+[e][0-9]+|-?[0-9]+\\.[0-9]*|-?\\.[0-9]+|(-?[0-9]+))[\\s]*";
    static final String D = "[\\s]*(([^,]+))[\\s]*";
    static final String TUPLE16 = "[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*";
    static final String ARRAY_OPTION = "(\\[[\\s]*(-?[0-9]+)[\\s]*\\])?[\\s]*=+[\\s]*";
    static final String OPEN_C = "([\\s]*\\{[\\s]*)";
    static final String CLOSE_C = "([\\s]*\\}[\\s]*)";
    static final String C_CONTENTS = "([\\s()\\-\",.0-9\\w]+)";
    static final Pattern curlyContentsPattern = Pattern.compile(",?([\\s]*\\{[\\s]*)([\\s()\\-\",.0-9\\w]+)([\\s]*\\}[\\s]*),?((.)*)");
    static final String OPEN_ANGLE = "([\\s]*\\<[\\s]*)";
    static final String CLOSE_ANGLE = "([\\s]*\\>[\\s]*)";
    static final String ANGLE_CONTENTS = "([\\s()\\-\",.0-9\\w/:]+)";
    static final Pattern angleContentsPattern = Pattern.compile("^#include([\\s]*\\<[\\s]*)([\\s()\\-\",.0-9\\w/:]+)([\\s]*\\>[\\s]*),?((.)*)");
    static final String OPTIONAL_STRING = "(\"([^\"]*)\")*[\\s]*";
    static final String OPTIONAL_TEXT = "([\\w\\s]*)";
    static final String OPEN_P = "([\\w\\s]*)(\"([^\"]*)\")*[\\s]*(\\([\\s]*)";
    static final String CLOSE_P = "([\\s]*\\)[\\s]*),*";
    static final String P_CONTENTS = "([\\s,\\-.0-9\\w]+)";
    static final Pattern parenthesisDataPattern = Pattern.compile(",?([\\w\\s]*)(\"([^\"]*)\")*[\\s]*(\\([\\s]*)([\\s,\\-.0-9\\w]+)([\\s]*\\)[\\s]*),*,?((.)*)");
    static final String PRE_UIHINT = "([^\\[]*)\\[";
    static final String UIHINT = "([^\\]]*)";
    static final String POST_UIHINT = "\\]((.*))";
    static final Pattern uiHintPattern = Pattern.compile("([^\\[]*)\\[([^\\]]*)\\]((.*))");
    static final String FLOAT = "float";
    static final String COLOR = "color";
    static final String POINT = "point";
    static final String STRING = "string";
    static final String VECTOR = "vector";
    static final String NORMAL = "normal";
    static final String VOID = "void";
    static final String MATRIX = "matrix";
    static final String SHADER = "shader";
    static final String RSL_TYPE = "[\\s]*(float|color|point|string|vector|normal|void|matrix|shader)[\\s]+";
    static final String UNIFORM = "uniform";
    static final String OUTPUT = "output";
    static final String VARYING = "varying";
    static final String OUTPUT_VARYING = "output[\\s]*varying";
    static final Pattern ipPattern = Pattern.compile("([0-9]+)[.]([0-9]+)[.]([0-9]+)[.]([0-9]+)");
    static Pattern triplePattern = Pattern.compile("[\\s]*(-?[0-9]+[e][0-9]+|-?[0-9]+\\.[0-9]*|-?\\.[0-9]+|(-?[0-9]+))[\\s]*,[\\s]*(-?[0-9]+[e][0-9]+|-?[0-9]+\\.[0-9]*|-?\\.[0-9]+|(-?[0-9]+))[\\s]*,[\\s]*(-?[0-9]+[e][0-9]+|-?[0-9]+\\.[0-9]*|-?\\.[0-9]+|(-?[0-9]+))[\\s]*");
    static Pattern matrixPattern = Pattern.compile("[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*,[\\s]*(([^,]+))[\\s]*");
    static Pattern doublePattern = Pattern.compile("[\\s]*(-?[0-9]+[e][0-9]+|-?[0-9]+\\.[0-9]*|-?\\.[0-9]+|(-?[0-9]+))[\\s]*,?((.)*)");
    static Pattern stringPattern = Pattern.compile("[\\s]*\"([^\"]*)\",?((.)*)");
    static final String RSL_TYPE_MODIFIER = "[\\s]*(output|uniform|varying|output[\\s]*varying)?[\\s]*";
    static final Pattern argTypePattern = Pattern.compile("[\\s]*(output|uniform|varying|output[\\s]*varying)?[\\s]*[\\s]*(float|color|point|string|vector|normal|void|matrix|shader)[\\s]+[\\s]*([_0-9\\w]+)+[\\s]*((.)*)");
    static final Pattern argNamePattern = Pattern.compile(",?[\\s]*([_0-9\\w]+)+[\\s]*(\\[[\\s]*(-?[0-9]+)[\\s]*\\])?[\\s]*=+[\\s]*((.)*)");
    static final String OPEN_C_COMMENT = "[\\s]*/\\*[\\s]*";
    static final String CLOSE_C_COMMENT = "[\\s]*\\*/[\\s]*";
    static final String COMMENT_CONTENTS = "((?:(?!\\*/).)*)";
    static final Pattern commentPattern = Pattern.compile("[\\s]*/\\*[\\s]*((?:(?!\\*/).)*)[\\s]*\\*/[\\s]*((.)*)");
    static final String INCLUDE_CONTENTS = "([^>\"]+)";
    static final Pattern includeContentsPattern = Pattern.compile("((^#include)[\\s]*[<\"]([^>\"]+)[>\"])((.)*)");
    static final String RE_SPECIAL_CHARS = "\\(.)^+?*{$[|";
    static final String WORD_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789";
    static final String RE_IGNORE_CASE = "(?i)";
    static final String NON_CAPTURE_IS_WORD_BOUNDARY = "(?:\\b)";
    static final String NON_CAPTURE_NOT_WORD_BOUNDARY = "(?:\\B)";
    static final String NON_CAPTURE_LEADING_SPACE_PUNCT = "(?:\\B)";
    static final String NON_CAPTURE_TRAILING_SPACE_PUNCT = "(?:\\B)";
    static final String NON_CAPTURE_LEADING_SPACE_LETTER = "(?:\\b)";
    static final String NON_CAPTURE_TRAILING_SPACE_LETTER = "(?:\\b)";

    public static void toConsole(String title, Matcher m) {
        System.out.println(title);
        for (int n = 0; n < m.groupCount(); ++n) {
            System.out.println("    " + n + " " + (m.group(n) == null ? "NULL" : m.group(n).trim()) + "");
        }
    }

    public static void toConsole(String title, String[] input) {
        System.out.println(title);
        for (int n = 0; n < input.length; ++n) {
            System.out.println("    " + n + " " + (input[n] == null ? "NULL" : input[n].trim()) + "");
        }
    }

    public static String[] getCurlyContents(String input) {
        Matcher m = curlyContentsPattern.matcher(input);
        if (m.matches()) {
            String[] out = new String[]{m.group(2).trim(), m.group(4).trim()};
            return out;
        }
        return null;
    }

    public static String[] getParenthesisData(String input) {
        Pattern p = parenthesisDataPattern;
        Matcher m = p.matcher(input);
        if (m.matches()) {
            String[] out = new String[]{m.group(5).trim(), m.group(7).trim(), m.group(1).trim(), m.group(2) != null ? m.group(2).trim() : ""};
            return out;
        }
        return null;
    }

    public static String getDouble(String input) {
        Matcher m = doublePattern.matcher(input);
        if (m.matches()) {
            return m.group(1).trim();
        }
        return null;
    }

    private static String getTriplet(String input) {
        Pattern p = triplePattern;
        Matcher m = p.matcher(input);
        if (m.matches()) {
            return m.group(1).trim() + " " + m.group(3).trim() + " " + m.group(5).trim();
        }
        return null;
    }

    private static String getTuple16(String input) {
        Pattern p = matrixPattern;
        Matcher m = p.matcher(input);
        if (m.matches()) {
            StringBuffer b = new StringBuffer();
            for (int n = 1; n <= 31; n += 2) {
                b.append(m.group(n).trim()).append(" ");
            }
            return b.toString().trim();
        }
        return null;
    }

    public static String[] getTuple16Data(String input) {
        String[] out = new String[4];
        out = RegExpUtils.getParenthesisData(input);
        if (out != null) {
            String tdata = RegExpUtils.getTuple16(out[0]);
            if (tdata != null) {
                out[0] = tdata;
                return out;
            }
            String[] temp = RegExpUtils.getDoubleData(out[0]);
            if (temp != null) {
                out[0] = "1 0 0 0  0 1 0 0  0 0 1 0  0 0 0 1";
                return out;
            }
        }
        out = new String[4];
        out = RegExpUtils.getDoubleData(input);
        if (out != null) {
            out[0] = "1 0 0 0  0 1 0 0  0 0 1 0  0 0 0 1";
            return out;
        }
        return null;
    }

    public static String[] getTripletData(String input) {
        String[] out = new String[4];
        out = RegExpUtils.getParenthesisData(input);
        if (out != null) {
            String tdata = RegExpUtils.getTriplet(out[0]);
            if (tdata != null) {
                out[0] = tdata;
                return out;
            }
            String[] temp = RegExpUtils.getDoubleData(out[0]);
            if (temp != null) {
                out[0] = temp[0];
                return out;
            }
        }
        out = new String[4];
        out = RegExpUtils.getDoubleData(input);
        if (out != null) {
            out[0] = out[0] + " " + out[0] + " " + out[0];
            return out;
        }
        return null;
    }

    public static String[] getDoubleData(String input) {
        String temp;
        String[] out = RegExpUtils.getParenthesisData(input);
        if (out != null && (temp = RegExpUtils.getDouble(out[0])) != null) {
            out[0] = temp;
            return out;
        }
        Matcher m = doublePattern.matcher(input);
        if (m.matches()) {
            out = new String[]{m.group(1).trim(), m.group(3).trim()};
            return out;
        }
        return null;
    }

    public static String[] getStringData(String input) {
        Matcher m = stringPattern.matcher(input);
        if (m.matches()) {
            String[] out = new String[]{m.group(1).trim(), m.group(2).trim()};
            return out;
        }
        return null;
    }

    static void printMatcher(Matcher m) {
        if (m.matches()) {
            System.out.println("        m.groupCount() = " + m.groupCount());
            for (int n = 0; n < m.groupCount(); ++n) {
                System.out.println("        " + n + "  >" + (m.group(n) == null ? "NULL" : m.group(n).trim()) + "<");
            }
        } else {
            System.out.println("        NO match");
        }
    }

    public static String[] getArgType(String input) {
        Matcher m = argTypePattern.matcher(input);
        if (m.matches()) {
            String[] out = new String[]{m.group(1) == null ? UNIFORM : m.group(1).trim(), m.group(2).trim(), (m.group(3) + m.group(4)).trim()};
            return out;
        }
        return null;
    }

    public static String[] getArgName(String input) {
        Matcher m = argNamePattern.matcher(input);
        if (m.matches()) {
            String[] out = new String[]{m.group(1).trim(), m.group(3) == null ? "" : m.group(3).trim(), m.group(4).trim()};
            return out;
        }
        return null;
    }

    public static String[] getComment(String input) {
        Matcher m = commentPattern.matcher(input);
        if (m.matches()) {
            String[] out = new String[]{m.group(1).trim(), m.group(2).trim()};
            return out;
        }
        return null;
    }

    public static String[] getUiHint(String input) {
        Matcher m;
        String[] out = new String[2];
        int firstIndex = input.indexOf(123, 0);
        int lastIndex = input.lastIndexOf(125);
        boolean hasInnerBrackets = false;
        String head = null;
        String inner = null;
        String tail = null;
        if (firstIndex != -1 && lastIndex != -1) {
            head = input.substring(0, firstIndex + 1).trim();
            inner = input.substring(firstIndex + 1, lastIndex).trim();
            tail = input.substring(lastIndex).trim();
            if (Cutter.input.debug) {
                // empty if block
            }
            if (inner.startsWith("[") && inner.endsWith("]")) {
                hasInnerBrackets = true;
                inner = inner.substring(1, inner.length() - 1);
            }
        }
        if ((m = uiHintPattern.matcher(input)).matches()) {
            out[0] = hasInnerBrackets ? head.substring(1) + "[" + inner + "]" + tail.substring(0, tail.length() - 1) : m.group(2).trim();
            out[1] = m.group(1).trim() + " " + m.group(3).trim();
            out[1] = out[1].trim();
            return out;
        }
        out[0] = "";
        out[1] = input.trim();
        return out;
    }

    public static String getHeader(String input) {
        Matcher m = includeContentsPattern.matcher(input);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static boolean isIPAddress(String line) {
        if (line == null || line.trim().length() == 0) {
            return false;
        }
        String[] tokens = TextUtils.tokenize(line.trim(), " ");
        if (tokens == null || tokens.length != 1) {
            return false;
        }
        Matcher m = ipPattern.matcher(tokens[0]);
        return m.matches();
    }

    public static boolean contains(String input, String target) {
        Pattern p = Pattern.compile("\\w*[\\s]*((?i)" + target + ")+[\\s]*\\w*");
        Matcher m = p.matcher(input);
        return m.matches();
    }

    public static String replaceAll(String input, String target, String replacement) {
        Pattern p = Pattern.compile("\\w*[\\s]*((?i)" + target + ")+[\\s]*\\w*");
        Matcher m = p.matcher(input);
        return m.replaceAll(replacement);
    }

    public static String replaceAllUsingRegExp(String input, String regexp_target, String replacement) {
        Pattern p = Pattern.compile(regexp_target);
        Matcher m = p.matcher(input);
        return m.replaceAll(replacement);
    }

    public String encodeAsRE(String input, boolean ignoreCase, boolean wholeWord) {
        StringBuffer re_pattern = new StringBuffer();
        String pre = "";
        String post = "";
        if (ignoreCase) {
            re_pattern.append(RE_IGNORE_CASE);
        }
        if (wholeWord) {
            pre = this.beginsWithWordChar(input) ? "(?:\\b)" : "(?:\\B)";
            post = this.endsWithWordChar(input) ? "(?:\\b)" : "(?:\\B)";
        }
        StringBuffer encodedStr = new StringBuffer();
        encodedStr.append("(");
        for (int i = 0; i < input.length(); ++i) {
            char nextChar;
            char c = input.charAt(i);
            char c2 = nextChar = i + 1 < input.length() ? input.charAt(i + 1) : (char)'\u0000';
            if (c == '\\' && (nextChar == 't' || nextChar == 'n')) {
                encodedStr.append(c).append(nextChar);
                ++i;
                continue;
            }
            if (c == '\\' && nextChar == '\\') {
                encodedStr.append("\\").append("\\").append("{2}");
                ++i;
                continue;
            }
            if (RE_SPECIAL_CHARS.indexOf(c) != -1) {
                encodedStr.append("\\" + c);
                continue;
            }
            encodedStr.append(c);
        }
        encodedStr.append(")");
        re_pattern.append(pre);
        re_pattern.append(encodedStr.toString());
        re_pattern.append(post);
        return re_pattern.toString();
    }

    public boolean beginsWithWordChar(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        return WORD_CHARS.indexOf(c) != -1;
    }

    public boolean endsWithWordChar(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        char c = str.charAt(str.length() - 1);
        return WORD_CHARS.indexOf(c) != -1;
    }

    public String addEscape(String input) {
        if (input == null) {
            return input;
        }
        if (input.length() == 1 && input.charAt(0) == '\\') {
            return "\\\\";
        }
        StringBuffer out = new StringBuffer();
        char nextChar = '\u0000';
        for (int n = 0; n < input.length(); ++n) {
            nextChar = n + 1 < input.length() ? input.charAt(n + 1) : (char)'\u0000';
            char currChar = input.charAt(n);
            if (currChar == '\\') {
                if (nextChar == 'n') {
                    out.append("\\").append("\\").append('n');
                    ++n;
                    continue;
                }
                if (nextChar == 't') {
                    out.append("\\").append("\\").append('t');
                    ++n;
                    continue;
                }
                if (nextChar == '\\') {
                    out.append("\\\\");
                    ++n;
                    continue;
                }
                out.append("\\\\");
                continue;
            }
            out.append(currChar);
        }
        return out.toString();
    }

    public String doEscape(String input) {
        if (input == null) {
            return input;
        }
        if (input.length() == 1 && input.charAt(0) == '\\') {
            return "\\";
        }
        StringBuffer out = new StringBuffer();
        char nextChar = '\u0000';
        for (int n = 0; n < input.length(); ++n) {
            nextChar = n + 1 < input.length() ? input.charAt(n + 1) : (char)'\u0000';
            char currChar = input.charAt(n);
            if (currChar == '\\') {
                if (nextChar == 'n') {
                    out.append("\n");
                    ++n;
                    continue;
                }
                if (nextChar == 't') {
                    out.append("\t");
                    ++n;
                    continue;
                }
                if (nextChar != '\\') continue;
                out.append("\\\\");
                ++n;
                continue;
            }
            out.append(currChar);
        }
        return out.toString();
    }

    public int unEscapedLength(String input) {
        char nextChar = '\u0000';
        int count = 0;
        for (int n = 0; n < input.length(); ++n) {
            nextChar = n + 1 < input.length() ? input.charAt(n + 1) : (char)'\u0000';
            char currChar = input.charAt(n);
            if (currChar == '\\' && (nextChar == 'n' || nextChar == 't')) {
                ++n;
            }
            ++count;
        }
        return count;
    }

    public boolean checkPattern(String regexp) {
        try {
            Pattern.compile(regexp);
        }
        catch (Exception ex) {
            DialogUtils.showWarningMessage("Regular Expression Error", TextUtils.formatAsArray(ex.toString(), 50));
            return false;
        }
        return true;
    }

    public static int[] split(String srcStr, String targetChars, boolean ignoreCase) {
        return RegExpUtils.split(srcStr, targetChars, ignoreCase, true);
    }

    public static int[] split(String srcStr, String targetChars, boolean ignoreCase, boolean wholeWord) {
        RegExpUtils re = new RegExpUtils();
        String regexp = re.encodeAsRE(targetChars, ignoreCase, wholeWord);
        if (!re.checkPattern(regexp)) {
            Cutter.setLog("    Warning: RegExpUtils.split() - re.checkPattern(regexp) returned null for\n          \"" + targetChars + "\"");
            return null;
        }
        String[] parts = null;
        int diff = 0;
        int[] out = null;
        try {
            parts = srcStr.split(regexp, 2);
            if (parts != null && parts.length > 1) {
                int preLength = parts[0].length();
                int postLength = parts[1].length();
                diff = srcStr.length() - (preLength + postLength);
                int absBegin = preLength;
                int absEnd = absBegin + diff;
                out = new int[]{absBegin, absEnd, diff};
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:RegExpUtils.split()\n            " + e.toString());
            out = null;
        }
        return out;
    }

    public static int[] split(String srcStr, String regexp) {
        String[] parts = null;
        int diff = 0;
        int[] out = null;
        try {
            parts = srcStr.split(regexp, 2);
            if (parts != null && parts.length > 1) {
                int preLength = parts[0].length();
                int postLength = parts[1].length();
                diff = srcStr.length() - (preLength + postLength);
                int absBegin = preLength;
                int absEnd = absBegin + diff;
                out = new int[]{absBegin, absEnd, diff};
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:RegExpUtils.split()\n            " + e.toString());
            out = null;
        }
        return out;
    }

    public static int[] findLastOccuranceOf(String srcStr, String targetChars, boolean ignoreCase, boolean wholeWord) {
        RegExpUtils re = new RegExpUtils();
        String regexp = re.encodeAsRE(targetChars, ignoreCase, wholeWord);
        if (!re.checkPattern(regexp)) {
            Cutter.setLog("    Warning: RegExpUtils.findLastOccuranceOf() - re.checkPattern(regexp) returned null for\n          \"" + targetChars + "\"");
            return null;
        }
        int[] result = RegExpUtils.split(srcStr, regexp);
        if (result == null) {
            return null;
        }
        int[] prevResult = new int[]{result[0], result[1]};
        int trimmed = 0;
        while (result != null) {
            prevResult[0] = result[0] + trimmed;
            prevResult[1] = result[1] + trimmed;
            srcStr = srcStr.substring(result[1]);
            trimmed += result[1];
            result = RegExpUtils.split(srcStr, regexp);
        }
        return prevResult;
    }

    public static int[] findFirstOccuranceOf(String srcStr, String targetChars, boolean ignoreCase, boolean wholeWord) {
        RegExpUtils re = new RegExpUtils();
        String regexp = re.encodeAsRE(targetChars, ignoreCase, wholeWord);
        if (!re.checkPattern(regexp)) {
            Cutter.setLog("    Warning: RegExpUtils.findFirstOccuranceOf() - re.checkPattern(regexp) returned null for\n          \"" + targetChars + "\"");
            return null;
        }
        int[] result = RegExpUtils.split(srcStr, regexp);
        if (result == null) {
            return null;
        }
        int[] out = new int[]{result[0], result[1]};
        return out;
    }
}

