/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Script.Help.Url;
import UI_Script.Rib.RibTokenizer;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.Ris21PluginArgsReader;
import java.util.Vector;

public class RibDocsUtils {
    private static String[] integrators = new String[]{"PxrVCM", "PxrPathTracer", "PxrDirectLighting", "PxrDefault", "PxrDebugShadingContext", "PxrValidateBxdf", "PxrVisualizer"};
    private static String[] external_resources = new String[]{"RiSystem", "RiErrorHandler", "RiArchiveRecord", "RiReadArchive", "RiArchiveRecord", "RiProcDelayedReadArchive", "RiArchiveBegin", "RiArchiveEnd", "System", "ErrorHandler", "ArchiveRecord", "ReadArchive", "ArchiveRecord", "ProcDelayedReadArchive", "ArchiveBegin", "ArchiveEnd"};

    private static boolean isExternalResource(String item) {
        for (int n = 0; n < external_resources.length; ++n) {
            if (!item.equals(external_resources[n])) continue;
            return true;
        }
        return false;
    }

    public static String lookupURL(String item) {
        String name;
        int n;
        int lastSlash;
        if (item == null) {
            Cutter.setLog("    Debug:RibHelp.lookup() - been passed item = null");
            return null;
        }
        String docExt = ".html";
        RibTokenizer tok = new RibTokenizer();
        tok.setBuffer(item);
        String rpsDocsRoot = Preferences.get(Preferences.PATH_PIXAR_RENDERMAN_LEGACY_DOCS_INDEX);
        if (rpsDocsRoot.trim().length() == 0) {
            rpsDocsRoot = "https://renderman.pixar.com/resources/RenderMan_20/home.html";
        }
        if ((lastSlash = rpsDocsRoot.lastIndexOf(47)) == -1) {
            rpsDocsRoot = "https://renderman.pixar.com/resources/RenderMan_20";
            rpsDocsRoot = "https://renderman.pixar.com/resources/RenderMan_20";
        } else {
            rpsDocsRoot = rpsDocsRoot.substring(0, lastSlash);
        }
        if (RibDocsUtils.isExternalResource(item)) {
            return rpsDocsRoot + "/usingExternalResources.html";
        }
        if (RenderInfo.prmanMajorVersionNumber() >= 21) {
            String hack = null;
            if (item.startsWith("Pxr")) {
                hack = "https://rmanwiki.pixar.com/display/REN/" + item;
            } else if (item.equals("Light")) {
                hack = "https://rmanwiki.pixar.com/display/REN/Lighting+in+Maya";
            } else if (item.equals("Integrator")) {
                hack = "https://rmanwiki.pixar.com/display/REN/Integrators";
            }
            if (hack != null) {
                return hack;
            }
        }
        if (item.equals("RMSDisplacement") || item.equals("RMSGeoAreaLight")) {
            return Url.join(rpsDocsRoot, item + ".html");
        }
        Vector<Ris21PluginArgsReader.PluginArgsDB> pxrPlugins = new Vector<Ris21PluginArgsReader.PluginArgsDB>();
        pxrPlugins.addAll(Ris21PluginArgsReader.rpsBxdfs);
        pxrPlugins.addAll(Ris21PluginArgsReader.rpsPatts);
        for (n = 0; n < integrators.length; ++n) {
            name = integrators[n];
            if (name == null || !name.equals(item)) continue;
            return Url.join(rpsDocsRoot, item + docExt);
        }
        for (n = 0; n < pxrPlugins.size(); ++n) {
            name = ((Ris21PluginArgsReader.PluginArgsDB)pxrPlugins.elementAt((int)n)).name;
            if (name == null || !name.equals(item)) continue;
            if (item.startsWith("PxrLM")) {
                return Url.join(rpsDocsRoot, "PxrLMMaterials" + docExt);
            }
            return Url.join(rpsDocsRoot, item + docExt);
        }
        if (RibTokenizer.isQuadric(item)) {
            return Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#quadrics");
        }
        if (RibTokenizer.isPolygon(item)) {
            return Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#polygons");
        }
        if (RibTokenizer.isSolids(item)) {
            return Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#solids-and-spatial-set-operations");
        }
        if (RibTokenizer.isPatch(item)) {
            return Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#patches");
        }
        if (RibTokenizer.isProcedural(item)) {
            return Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#procedural-primitives");
        }
        if (item.equals("Blobby")) {
            return Url.join(rpsDocsRoot, "risBlobbies" + docExt);
        }
        if (item.equals("Volume")) {
            return Url.join(rpsDocsRoot, "volume_rendering" + docExt + "#rivolume");
        }
        if (item.equals("Points") || item.equals("Curves")) {
            return Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#point-and-curve-primitives");
        }
        if (item.equals("Geometry")) {
            return Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#implementation-specific-geometric-primitives");
        }
        if (item.equals("ReadArchive")) {
            return Url.join(rpsDocsRoot, "usingExternalResources" + docExt + "#archive-files");
        }
        if (item.equals("ArchiveBegin") || item.equals("ArchiveEnd")) {
            return Url.join(rpsDocsRoot, "usingExternalResources" + docExt + "#inline-archives");
        }
        if (item.equals("IfBegin") || item.equals("IfEnd") || item.equals("Else") || item.equals("ElseIf")) {
            return Url.join(rpsDocsRoot, "usingExternalResources" + docExt + "#conditional-evaluation");
        }
        if (item.equals("DelayedReadArchive")) {
            return Url.join(rpsDocsRoot, "proceduralPrimitives" + docExt + "#delayed-rib-file-reading");
        }
        if (RibTokenizer.isRIS(item)) {
            if (item.equals("Integrator")) {
                return Url.join(rpsDocsRoot, "risIntegrators" + docExt);
            }
            if (item.equals("Bxdf")) {
                return Url.join(rpsDocsRoot, "risShaders" + docExt);
            }
            if (item.equals("Pattern")) {
                return Url.join(rpsDocsRoot, "risPatterns" + docExt);
            }
            String str = "ri" + item.toLowerCase();
            return Url.join(rpsDocsRoot, "risProcedures" + docExt + "#" + str);
        }
        if (item.equals("PxrStdEnvDayLight") || item.equals("PxrStdAreaLight") || item.equals("PxrStdEnvMapLight") || item.equals("PxrLightEmission") || item.equals("PxrAreaLight") || item.equals("RMSDisplacement")) {
            return Url.join(rpsDocsRoot, item + docExt);
        }
        if (item.equals("Attribute")) {
            return "rpsDocsRoot/risAttributes.html";
        }
        if (item.equals("Option")) {
            return "rpsDocsRoot/risOptions.html#index";
        }
        if (RibTokenizer.isAttribute(item)) {
            String str = "ri" + item.toLowerCase();
            return Url.join(rpsDocsRoot, "attributes" + docExt + "#" + str);
        }
        if (RibTokenizer.isGraphicState(item)) {
            String str = "ri" + item.toLowerCase();
            return Url.join(rpsDocsRoot, "graphicsState" + docExt + "#" + str);
        }
        if (RibTokenizer.isOption(item)) {
            String str = "ri" + item.toLowerCase();
            return Url.join(rpsDocsRoot, "options" + docExt + "#" + str);
        }
        return null;
    }
}

