/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import Utilities.FileUtils;
import Utilities.GraphicsFileUtils;
import Utilities.RegExpUtils;
import Utilities.RibInZipListener;
import Utilities.TextUtils;
import Utilities.ZipUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RibInZipUtils
implements ProcListener {
    private boolean openOnDesktop = true;
    private RibInZipListener listener = null;

    public RibInZipUtils() {
    }

    public RibInZipUtils(RibInZipListener listener) {
        this();
        this.listener = listener;
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
    }

    @Override
    public void processFinished(String[] progarray) {
        if (progarray == null || progarray.length < 5) {
            Cutter.setLog("    Error:RibInZipUtils.pixarBinRibToAsciiRib() - cannot convert binary to ascrii rib file.");
            return;
        }
        String cmd = new File(progarray[0]).getName();
        if (cmd.equals("catrib")) {
            Cutter.setLog("    Info:RibInZipUtils.processFinished() - catrib completed.");
            File asciiRibFile = new File(progarray[3]);
            File binaryRibFile = new File(progarray[4]);
            Cutter.setLog("    Info:RibInZipUtils.processFinished() -");
            Cutter.setLog("        renaming \"" + asciiRibFile.getPath() + "\" to \"" + binaryRibFile.getPath() + "\"\n");
            if (!FileUtils.rename(asciiRibFile, binaryRibFile)) {
                Cutter.setLog("    Error:RibInZipUtils.pixarBinRibToAsciiRib()");
                Cutter.setLog("        Cannot rename \"" + asciiRibFile);
                Cutter.setLog("        to \"" + binaryRibFile);
                return;
            }
            if (this.openOnDesktop) {
                BBxt.newDocument(binaryRibFile);
            }
            if (this.listener != null) {
                this.listener.catribFinished(binaryRibFile);
            }
            return;
        }
        Cutter.setLog("    Error:RibInZipUtils.processFinished() - unknown command \"" + cmd + "\" completed.");
    }

    @Override
    public void processSentString(String procName, String output) {
    }

    public File pixarBinRibToAsciiRib(File binfile, boolean openOnDesktop) {
        if (binfile == null || !binfile.exists()) {
            return null;
        }
        this.openOnDesktop = openOnDesktop;
        File parentDir = binfile.getParentFile();
        String binaryRibPath = binfile.getPath();
        binaryRibPath = binaryRibPath.replace('\\', '/');
        File asciiRibFile = new File(parentDir, "ascii.rib");
        String asciiRibPath = asciiRibFile.getPath().replace('\\', '/');
        String command = GraphicsFileUtils.getRPSBinPath();
        if (command.equals("")) {
            command = "catrib";
        } else {
            command = TextUtils.trimTrailingChar(command, '/');
            command = command + "/catrib";
        }
        Cutter.setLog("    Info:RibInZipUtils.pixarBinRibToAsciiRib() -");
        Cutter.setLog("       command         \"" + command + "\"");
        Cutter.setLog("       -o asciiRibPath \"" + asciiRibPath + "\"");
        Cutter.setLog("       binaryRibPath   \"" + binaryRibPath + "\"");
        String[] arr = new String[]{command, "-ascii", "-o", asciiRibPath, binaryRibPath};
        ProcessManager fp = new ProcessManager("catrib");
        fp.launch(arr, null, false, this, true);
        return new File(asciiRibPath);
    }

    public static boolean isPixarRibInZip(File zipfile) {
        String[] entries = ZipUtils.getAllZipEntries(zipfile);
        if (entries == null) {
            return false;
        }
        for (int n = 0; n < entries.length; ++n) {
            if (!FileUtils.isRMSRibPath(entries[n])) continue;
            return true;
        }
        return false;
    }

    public static String[] ribInZipPath(String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        int[] out = RegExpUtils.findFirstOccuranceOf(path, "zip!", false, false);
        if (out == null) {
            return null;
        }
        String zipfilePath = path.substring(0, out[1] - 1);
        String zipEntry = path.substring(out[1]);
        String[] result = new String[]{zipfilePath, zipEntry};
        return result;
    }

    public static File unZipPixarRibInZip(File zipfile, String target) {
        if (zipfile == null) {
            return null;
        }
        if (!zipfile.exists()) {
            Cutter.setLog("ZipUtils.unZipPixarRibInZip() - \"" + zipfile.getPath() + "\" doesn't exist.");
            return null;
        }
        if (!RibInZipUtils.isPixarRibInZip(zipfile)) {
            return null;
        }
        File outfile = null;
        try {
            ZipEntry zipentry;
            FileInputStream stream = new FileInputStream(zipfile);
            ZipInputStream in = new ZipInputStream(stream);
            while ((zipentry = in.getNextEntry()) != null) {
                int read;
                String entrypath = zipentry.getName();
                if (!entrypath.equals(target)) {
                    in.closeEntry();
                    continue;
                }
                String destDirPath = zipfile.getParent();
                String ribname = new File(entrypath).getName();
                outfile = new File(destDirPath, ribname);
                byte[] buffer = new byte[2048];
                FileOutputStream outstream = new FileOutputStream(outfile);
                while ((read = in.read(buffer, 0, buffer.length)) > 0) {
                    outstream.write(buffer, 0, read);
                }
                outstream.close();
                in.closeEntry();
            }
            in.close();
            stream.close();
        }
        catch (Exception e) {
            Cutter.setLog("ZipInput.run() " + e.toString());
            return null;
        }
        return outfile;
    }
}

