/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import UI_Script.Rib.RibParamIterator;
import UI_Script.Rib.RibTokenizer;
import UI_Text.KTextPane.KTextPane;
import Utilities.DocumentUtils;
import Utilities.TextUtils;
import java.util.Hashtable;
import javax.swing.text.Segment;

public class RibUtils {
    static final Hashtable<String, String> BEGIN_LUT = new Hashtable();
    static final Hashtable<String, String> END_LUT = new Hashtable();
    static RibTokenizer rtok;

    public ParamBlock getParamBlock(String src, String statement, int begin) {
        ParamBlock out = new ParamBlock();
        out.currStatment = statement;
        out.paramBeginOffset = begin;
        out.paramEndOffset = src.length();
        RibParamIterator iter = new RibParamIterator(statement, src.substring(begin));
        out.params = iter.getParams();
        out.numNewlines = TextUtils.countOccurancesOf(src.substring(begin), '\n');
        out.leadingTabs = 0;
        out.leadingSpaces = 0;
        return out;
    }

    public ParamBlock getParamBlock(KTextPane textpane, String statement, int begin) {
        ParamBlock out = new ParamBlock();
        out.currStatment = statement;
        out.paramBeginOffset = begin;
        int len = textpane.getDocument().getLength() - begin;
        Segment seg = DocumentUtils.getSegment(textpane.getDocument(), begin, len);
        if (seg == null) {
            Cutter.setLog("    Error:RibUtils.getParamBlock() - no text after offset " + begin);
            return null;
        }
        RibTokenizer ribtok = new RibTokenizer();
        ribtok.removeDelimitor("]]");
        RibTokenizer.statements.put("]]", "]]");
        ribtok.setBuffer(seg);
        out.nextStatment = ribtok.getNextRibStatement(null, false);
        out.nextStatmentBeginOffset = ribtok.getBufferIndex();
        if (out.nextStatmentBeginOffset == -1) {
            Cutter.setLog("    Error:RibUtils.getParamBlock() - cannot find the offset of the next RIB statement.");
            return null;
        }
        char[] chars = ribtok.getBuffer(0, ribtok.getBufferIndex());
        if (chars == null) {
            Cutter.setLog("    Error:RibUtils.getParamBlock() - cannot find the block of text up to the next RIB statement.");
            return null;
        }
        String paramtext = new String(chars);
        out.paramEndOffset = RibUtils.indexOfLastWhiteSpace(paramtext);
        if (out.paramEndOffset < 0) {
            Cutter.setLog("    Error:RibUtils.getParamBlock() - indexOfLastWhiteSpace() returned -1 for paramtext:\n         \"" + paramtext + "\"\n");
            return null;
        }
        paramtext = paramtext.substring(0, out.paramEndOffset);
        out.paramsEndChar = paramtext.charAt(paramtext.length() - 1);
        out.paramEndOffset += begin;
        RibParamIterator iter = new RibParamIterator(statement, paramtext);
        out.params = iter.getParams();
        out.numNewlines = TextUtils.countOccurancesOf(paramtext, '\n');
        out.leadingTabs = DocumentUtils.countTabStopsAtOffset(textpane.getDocument(), begin);
        int[] offsets = DocumentUtils.getLineNumberAt(textpane.getDocument(), begin);
        if (offsets != null) {
            int length = begin - offsets[1];
            Segment segment = DocumentUtils.getSegment(textpane.getDocument(), offsets[1], length -= statement.length());
            if (segment != null) {
                for (int n = 0; n < segment.length(); ++n) {
                    if (segment.charAt(n) != ' ') continue;
                    ++out.leadingSpaces;
                }
            }
        }
        return out;
    }

    public static boolean canReformatParams(String sel) {
        return sel.equals("Surface") || sel.equals("Displacement") || sel.equals("Attribute") || sel.equals("LightSource") || sel.equals("Shader") || sel.equals("Imager") || sel.equals("Volume") || sel.equals("Procedural") || sel.equals("Display") || sel.equals("Option") || sel.equals("ConcatTransform") || sel.equals("Transform") || sel.equals("Pattern") || sel.equals("Bxdf") || sel.equals("Hider") || sel.equals("Integrator");
    }

    public static int indexOfLastWhiteSpace(String str) {
        int offset;
        int lastCmnt = RibUtils.indexOfLastComment(str);
        int n = offset = lastCmnt == -1 ? str.length() - 1 : lastCmnt;
        while (offset != 1) {
            if (!Character.isWhitespace(str.charAt(offset))) {
                return offset + 1;
            }
            --offset;
        }
        return -1;
    }

    public static int indexOfLastWhiteSpace(String str, int from) {
        int offset;
        int n = offset = from == -1 ? str.length() - 1 : from;
        while (offset != 1) {
            if (!Character.isWhitespace(str.charAt(offset))) {
                return offset + 1;
            }
            --offset;
        }
        return -1;
    }

    public static int indexOfLastComment(String str) {
        int offset = str.lastIndexOf(35);
        if (offset == -1) {
            return -1;
        }
        while (offset != 0 && str.charAt(offset) == '#') {
            --offset;
        }
        return offset;
    }

    public static boolean isBegin(String str) {
        String[] tok = TextUtils.tokenize(str);
        if (tok == null || tok.length == 0) {
            return false;
        }
        return BEGIN_LUT.containsKey(tok[0]);
    }

    public static boolean isEnd(String str) {
        String[] tok = TextUtils.tokenize(str);
        if (tok == null || tok.length == 0) {
            return false;
        }
        return END_LUT.containsKey(tok[0]);
    }

    public static boolean beginsWithStatement(String line) {
        if (line == null || line.trim().length() == 0) {
            return false;
        }
        String[] tokens = TextUtils.tokenize(line, " ");
        if (tokens == null || tokens.length == 0) {
            return false;
        }
        return rtok.isRibStatement(tokens[0]);
    }

    public static String[] reformat(String src) {
        if (src == null || src.trim().length() == 0) {
            return null;
        }
        String[] lines = src.split("\\n");
        if (lines == null || lines.length == 0) {
            return null;
        }
        for (int n = 0; n < lines.length; ++n) {
            lines[n] = lines[n].trim();
        }
        int tabcount = 0;
        String tabstr = "";
        String extratabs = "";
        StringBuffer buf = new StringBuffer();
        boolean isEnd = false;
        RibTokenizer ribtok = new RibTokenizer();
        for (int n = 0; n < lines.length; ++n) {
            isEnd = false;
            String line = lines[n];
            if (line.length() == 0) {
                buf.append("\n");
                continue;
            }
            if (RibUtils.isBegin(line)) {
                extratabs = "";
                ++tabcount;
            } else if (RibUtils.isEnd(line)) {
                isEnd = true;
                tabstr = TextUtils.getTabString(--tabcount);
                extratabs = "";
            } else {
                ribtok.setBuffer(line);
                String[] s = TextUtils.tokenize(line);
                if (s == null) continue;
                extratabs = !ribtok.isRibStatement(s[0]) && !ribtok.isComment(line) ? "\t\t" : "";
            }
            buf.append(tabstr).append(extratabs).append(line).append("\n");
            if (isEnd) continue;
            tabstr = TextUtils.getTabString(tabcount);
        }
        String[] out = new String[]{tabstr, buf.toString()};
        return out;
    }

    static {
        BEGIN_LUT.put("ArchiveBegin", "ArchiveBegin");
        BEGIN_LUT.put("AttributeBegin", "AttributeBegin");
        BEGIN_LUT.put("EditBegin", "EditBegin");
        BEGIN_LUT.put("FrameBegin", "FrameBegin");
        BEGIN_LUT.put("IfBegin", "IfBegin");
        BEGIN_LUT.put("MotionBegin", "MotionBegin");
        BEGIN_LUT.put("ObjectBegin", "ObjectBegin");
        BEGIN_LUT.put("ResourceBegin", "ResourceBegin");
        BEGIN_LUT.put("SolidBegin", "SolidBegin");
        BEGIN_LUT.put("TransformBegin", "TransformBegin");
        BEGIN_LUT.put("WorldBegin", "WorldBegin");
        END_LUT.put("ArchiveEnd", "ArchiveEnd");
        END_LUT.put("AttributeEnd", "AttributeEnd");
        END_LUT.put("EditEnd", "EditEnd");
        END_LUT.put("FrameEnd", "FrameEnd");
        END_LUT.put("IfEnd", "IfEnd");
        END_LUT.put("MotionEnd", "MotionEnd");
        END_LUT.put("ObjectEnd", "ObjectEnd");
        END_LUT.put("ResourceEnd", "ResourceEnd");
        END_LUT.put("SolidEnd", "SolidEnd");
        END_LUT.put("TransformEnd", "TransformEnd");
        END_LUT.put("WorldEnd", "WorldEnd");
        rtok = new RibTokenizer();
    }

    public class ParamBlock {
        public String currStatment;
        public String[] params;
        public int paramBeginOffset;
        public int paramEndOffset;
        public char paramsEndChar = '\u0000';
        public String nextStatment;
        public int nextStatmentBeginOffset;
        public int numNewlines;
        public int leadingTabs = 0;
        public int leadingSpaces = 0;

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("currStatment \"").append(this.currStatment).append("\"\n");
            buf.append("paramBeginOffset ").append(this.paramBeginOffset).append('\n');
            buf.append("paramEndOffset ").append(this.paramEndOffset).append('\n');
            if (this.params != null) {
                buf.append("params:").append('\n');
                for (int n = 0; n < this.params.length; ++n) {
                    buf.append(this.params[n]).append('\n');
                }
            } else {
                buf.append("params: no params").append('\n');
            }
            buf.append("nextStatment \"").append(this.nextStatment).append("\"\n");
            buf.append("nextStatmentBeginOffset ").append(this.nextStatmentBeginOffset).append('\n');
            buf.append("numNewlines ").append(this.numNewlines).append('\n');
            return buf.toString();
        }

        public String getParamsAsPlainStr() {
            if (this.params == null || this.params.length == 0) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            for (int n = 0; n < this.params.length; ++n) {
                String str = this.params[n].trim();
                buf.append(str).append(" ");
            }
            return buf.toString().trim();
        }

        public String getParamesAsIndentedBlock(int extraTabs, int extraSpaces) {
            int n;
            if (this.params == null || this.params.length == 0) {
                Cutter.setLog("getParamesAsIndentedBlock - no params");
                return "";
            }
            StringBuffer b = new StringBuffer();
            for (n = 0; n < this.leadingTabs + extraTabs; ++n) {
                b.append('\t');
            }
            for (n = 0; n < this.leadingSpaces + extraSpaces; ++n) {
                b.append(" ");
            }
            String indent = b.toString();
            b.setLength(0);
            for (int n2 = 0; n2 < this.params.length; ++n2) {
                b.append(indent).append(this.params[n2]);
                if (n2 >= this.params.length - 1) continue;
                b.append('\n');
            }
            return b.toString();
        }

        public String getParamsAsMatrixStr() {
            if (this.params == null || this.params.length == 0) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            for (int n = 0; n < this.params.length; ++n) {
                buf.append(this.params[n]).append(" ");
            }
            String[] tokens = TextUtils.tokenize(buf.toString());
            buf = new StringBuffer();
            for (int n = 0; n < tokens.length; ++n) {
                buf.append(tokens[n]).append(" ");
            }
            return "[" + buf.toString().trim() + "]";
        }
    }
}

