/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Script.Rlf.RlfXMLTokenizer;
import Utilities.TextUtils;
import java.util.Vector;

public class RlfUtils {
    static final Vector<String> listOfBeginnings = new Vector();
    static final Vector<String> listOfEndings = new Vector();

    public static boolean isBegin(String str) {
        for (int n = 0; n < listOfBeginnings.size(); ++n) {
            if (!str.startsWith(listOfBeginnings.elementAt(n))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnd(String str) {
        for (int n = 0; n < listOfEndings.size(); ++n) {
            if (!str.endsWith(listOfEndings.elementAt(n))) continue;
            return true;
        }
        return false;
    }

    public static String[] reformat(String src) {
        if (src == null || src.trim().length() == 0) {
            return null;
        }
        String[] lines = src.split("\\n");
        if (lines == null || lines.length == 0) {
            return null;
        }
        for (int n = 0; n < lines.length; ++n) {
            lines[n] = lines[n].trim();
        }
        int tabcount = 0;
        String tabstr = "";
        String extratabs = "";
        StringBuffer buf = new StringBuffer();
        boolean isEnd = false;
        RlfXMLTokenizer ribtok = new RlfXMLTokenizer();
        for (int n = 0; n < lines.length; ++n) {
            isEnd = false;
            String line = lines[n];
            if (line.length() == 0) continue;
            if (RlfUtils.isBegin(line)) {
                extratabs = "";
                ++tabcount;
            } else if (RlfUtils.isEnd(line)) {
                isEnd = true;
                tabstr = TextUtils.getTabString(--tabcount);
                extratabs = "";
            }
            buf.append(tabstr).append(extratabs).append(line).append("\n");
            if (isEnd) continue;
            tabstr = TextUtils.getTabString(tabcount);
        }
        String[] out = new String[]{tabstr, buf.toString()};
        return out;
    }

    static {
        listOfBeginnings.add("<RenderManLookFile");
        listOfBeginnings.add("<InjectablePayloads");
        listOfBeginnings.add("<Payload");
        listOfBeginnings.add("<TightBindings");
        listOfBeginnings.add("ArchiveBegin");
        listOfBeginnings.add("IfBegin");
        listOfEndings.add("ArchiveEnd");
        listOfEndings.add("</Payload>");
        listOfEndings.add("</InjectablePayloads>");
        listOfEndings.add("</TightBindings>");
        listOfEndings.add("</RenderManLookFile>");
        listOfEndings.add("IfEnd");
    }
}

