/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_CutletScript.receive.CmdHandlers.CmdHandler;
import UI_Desktop.Cutter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;

public class RobotUtils {
    static Robot robot = null;

    public static void rollRobotOverItems(int x, int y, final JMenuItem menuItem) {
        JPopupMenu parentPopup = null;
        Point itemOrigin = new Point(x, y);
        Point popupOrigin = new Point(x, y);
        if (menuItem instanceof JMenuItem) {
            Container c = menuItem.getParent();
            if (c instanceof JPopupMenu) {
                parentPopup = (JPopupMenu)c;
                int index = parentPopup.getComponentIndex(menuItem);
                int horizontalOffset = 15;
                popupOrigin = new Point(itemOrigin.x + horizontalOffset, itemOrigin.y - index * menuItem.getBounds().height);
                Component comp = parentPopup.getInvoker();
                if (comp instanceof JMenu) {
                    final JMenu parentMenu = (JMenu)comp;
                    if (!parentPopup.isVisible()) {
                        CmdHandler.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                parentMenu.doClick();
                            }
                        });
                        try {
                            Thread.currentThread();
                            Thread.sleep(200L);
                        }
                        catch (Exception e) {
                            Cutter.setLog("    Exception: RobotUtils.rollRobotOverItems()\n\t" + e.toString());
                        }
                    }
                } else {
                    Cutter.setLog("    Info: MenuCmdsHandler.rollRobotOverItems()\n          getInvoker() didn't return JMenu got this class instead " + parentPopup.getInvoker().getClass().getName());
                }
            } else if (c instanceof JMenuBar) {
                CmdHandler.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        menuItem.doClick();
                    }
                });
            } else {
                Cutter.setLog("No rollover, its a root menu. Parent class is " + c.getClass().getName());
                return;
            }
        }
        if (parentPopup == null) {
            return;
        }
        MenuElement[] ele = parentPopup.getSubElements();
        try {
            Point p = new Point(popupOrigin.x, popupOrigin.y);
            for (int n = 1; n < ele.length; ++n) {
                if (ele[n] instanceof JMenu) continue;
                if (ele[n].equals(menuItem)) {
                    return;
                }
                Rectangle rect = ((JMenuItem)ele[n]).getBounds();
                RobotUtils.moveRobotTo(new Point(p.x + rect.x, p.y + rect.y), 75);
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: MenuCmdsHandler.moveRobotOver()\n\t" + e.toString());
        }
    }

    public static void moveRobotTo(final Point pnt, int wait) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Point p = new Point(pnt.x, pnt.y);
                    SwingUtilities.convertPointToScreen(p, Cutter.desktop);
                    robot.mouseMove(p.x, p.y);
                }
            });
            Thread.currentThread();
            Thread.sleep(wait);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: MenuCmdsHandler.moveRobotTo()\n\t" + e.toString());
        }
    }

    public static void clickOff(int millis) {
        Rectangle rect = Cutter.desktop.getBounds();
        RobotUtils.clickRobotAt(new Point(5, rect.height - 43), millis);
    }

    public static void clickRobotAt(final Point pnt, int wait) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Point p = new Point(pnt.x, pnt.y);
                    SwingUtilities.convertPointToScreen(p, Cutter.desktop);
                    robot.mouseMove(p.x, p.y);
                    robot.mousePress(1024);
                    robot.mouseRelease(1024);
                }
            });
            if (wait > 0) {
                Thread.currentThread();
                Thread.sleep(wait);
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: MenuCmdsHandler.moveRobotTo()\n\t" + e.toString());
        }
    }

    static {
        try {
            robot = new Robot();
        }
        catch (Exception e) {
            System.out.println("    Exception: RobotUtils.static - cannot get a robot\n\t" + e.toString());
        }
    }
}

