/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import javax.swing.text.Segment;

public class SegmentUtils {
    public static String toString(Segment segment, int index, int len) {
        if (segment == null || segment.array == null) {
            return null;
        }
        if (segment.offset + index + len > segment.array.length) {
            return null;
        }
        if (len > segment.count || len < 0) {
            return null;
        }
        char[] subArray = new char[len];
        try {
            System.arraycopy(segment.array, segment.offset + index, subArray, 0, len);
        }
        catch (IndexOutOfBoundsException e) {
            Cutter.setLog("    Warning: SegmentUtils.toString(Segment,int,int)\n            " + e.toString());
            return null;
        }
        return subArray == null ? null : new String(subArray);
    }

    public static String toNonNullString(Segment segment, int index, int len) {
        if (segment == null || segment.array == null) {
            return "";
        }
        if (segment.offset + index + len > segment.array.length) {
            return "";
        }
        if (len > segment.count || len < 0) {
            return "";
        }
        char[] subArray = new char[len];
        try {
            System.arraycopy(segment.array, segment.offset + index, subArray, 0, len);
        }
        catch (IndexOutOfBoundsException e) {
            Cutter.setLog("    Warning: SegmentUtils.toString(Segment,int,int)\n            " + e.toString());
            return "";
        }
        return subArray == null ? "" : new String(subArray).trim();
    }

    public static Segment toSegment(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        return new Segment(str.toCharArray(), 0, str.length());
    }

    public static int numEscapesBackFrom(Segment segment, int offset) {
        if (offset > segment.count) {
            return -1;
        }
        int num = 0;
        for (int n = offset; n > 0; --n) {
            char c = segment.array[n + segment.offset];
            if (c == '\\') {
                ++num;
                continue;
            }
            return num;
        }
        return 0;
    }

    public static int[] getOslMetaDataSpan(int from, Segment segment) {
        char c;
        int j;
        int seg_offset = segment.offset;
        CharData spanBegin = null;
        CharData spanEnd = null;
        int[] out = new int[]{from, segment.count};
        for (j = from; j > 0; --j) {
            c = segment.array[j + seg_offset];
            if (c != '[') continue;
            spanBegin = SegmentUtils.prevNonWhiteChar(j, segment);
            break;
        }
        if (spanBegin == null || spanBegin.offset == -1 || spanBegin.c != '[') {
            return out;
        }
        out[0] = spanBegin.offset;
        for (j = spanBegin.offset; j < segment.count; ++j) {
            c = segment.array[j + seg_offset];
            if (c != ']') continue;
            spanEnd = SegmentUtils.nextNonWhiteChar(j + 1, segment);
            if (spanEnd.c == ']') break;
        }
        if (spanEnd == null || spanEnd.offset == -1 || spanEnd.c != ']') {
            return out;
        }
        out[1] = spanEnd.offset + 1;
        return out;
    }

    public static CharData prevNonWhiteChar(int from, Segment segment) {
        char c0;
        int seg_offset = segment.offset;
        for (int j = from - 1; j > 0; --j) {
            c0 = segment.array[j + seg_offset];
            if (Character.isWhitespace(c0)) continue;
            return new CharData(j, c0);
        }
        c0 = '\u0000';
        return new CharData(-1, c0);
    }

    public static CharData nextNonWhiteChar(int from, Segment segment) {
        char c0;
        int seg_offset = segment.offset;
        for (int j = from; j < segment.count; ++j) {
            c0 = segment.array[j + seg_offset];
            if (Character.isWhitespace(c0)) continue;
            return new CharData(j, c0);
        }
        c0 = '\u0000';
        return new CharData(-1, c0);
    }

    public static class CharData {
        public int offset = -1;
        public char c = '\u0000';

        CharData(int index, char charr) {
            this.offset = index;
            this.c = charr;
        }
    }
}

